/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grid.scripting.impl;

import com.intellij.database.DataGridBundle;
import com.intellij.grid.scripting.impl.DataLoaderPluginsManager;
import com.intellij.grid.scripting.impl.ScriptedTableFileEditorProvider;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u0000 \u00062\u00020\u0001:\u0003\u0004\u0005\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lcom/intellij/grid/scripting/impl/DataLoaderPluginsManager;", "", "<init>", "()V", "DataLoaderPlugin", "AvailableFileExtension", "Companion", "intellij.grid.scripting.impl"})
public final class DataLoaderPluginsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final NotificationAction REJECT_ACTION;

    static {
        String string = DataGridBundle.message((String)"notification.install.plugin.no", (Object[])new Object[0]);
        REJECT_ACTION = new NotificationAction(string){

            public void actionPerformed(AnActionEvent e, Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                com.intellij.grid.scripting.impl.DataLoaderPluginsManager$Companion.access$resetInvocations(DataLoaderPluginsManager.Companion);
                notification.expire();
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0082\u0081\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000e"}, d2={"Lcom/intellij/grid/scripting/impl/DataLoaderPluginsManager$AvailableFileExtension;", "", "extension", "", "plugin", "Lcom/intellij/grid/scripting/impl/DataLoaderPluginsManager$DataLoaderPlugin;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Lcom/intellij/grid/scripting/impl/DataLoaderPluginsManager$DataLoaderPlugin;)V", "PARQUET", "JSON", "XLS", "XLSX", "SHP", "Companion", "intellij.grid.scripting.impl"})
    @SourceDebugExtension(value={"SMAP\nDataLoaderPluginsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataLoaderPluginsManager.kt\ncom/intellij/grid/scripting/impl/DataLoaderPluginsManager$AvailableFileExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,123:1\n1504#2:124\n1534#2,3:125\n1537#2,3:135\n1252#2,4:140\n382#3,7:128\n463#3:138\n413#3:139\n*S KotlinDebug\n*F\n+ 1 DataLoaderPluginsManager.kt\ncom/intellij/grid/scripting/impl/DataLoaderPluginsManager$AvailableFileExtension\n*L\n51#1:124\n51#1:125,3\n51#1:135,3\n51#1:140,4\n51#1:128,7\n51#1:138\n51#1:139\n*E\n"})
    private static final class AvailableFileExtension
    extends Enum<AvailableFileExtension> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String extension;
        @NotNull
        private final DataLoaderPlugin plugin;
        @NotNull
        private static final Map<String, DataLoaderPlugin> EXTENSION_TO_PLUGIN_ID;
        @NotNull
        private static final List<String> OPEN_TABLES_ALL_EXTENSIONS;
        @NotNull
        private static final List<String> TABLE_FIRST_ALL_EXTENSIONS;
        public static final /* enum */ AvailableFileExtension PARQUET;
        public static final /* enum */ AvailableFileExtension JSON;
        public static final /* enum */ AvailableFileExtension XLS;
        public static final /* enum */ AvailableFileExtension XLSX;
        public static final /* enum */ AvailableFileExtension SHP;
        private static final /* synthetic */ AvailableFileExtension[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private AvailableFileExtension(String extension, DataLoaderPlugin plugin) {
            this.extension = extension;
            this.plugin = plugin;
        }

        public static AvailableFileExtension[] values() {
            return (AvailableFileExtension[])$VALUES.clone();
        }

        public static AvailableFileExtension valueOf(String value) {
            return Enum.valueOf(AvailableFileExtension.class, value);
        }

        @NotNull
        public static EnumEntries<AvailableFileExtension> getEntries() {
            return $ENTRIES;
        }

        private static final String OPEN_TABLES_ALL_EXTENSIONS$lambda$3(AvailableFileExtension it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            return it.extension;
        }

        private static final String TABLE_FIRST_ALL_EXTENSIONS$lambda$4(AvailableFileExtension it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            return it.extension;
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$mapValuesTo$iv$iv;
            Object object;
            Object value$iv$iv$iv;
            Object key$iv$iv;
            Map $this$groupByTo$iv$iv;
            PARQUET = new AvailableFileExtension("parquet", DataLoaderPlugin.PARQUET);
            JSON = new AvailableFileExtension("json", DataLoaderPlugin.JSON);
            XLS = new AvailableFileExtension("xls", DataLoaderPlugin.XLS);
            XLSX = new AvailableFileExtension("xlsx", DataLoaderPlugin.XLS);
            SHP = new AvailableFileExtension("shp", DataLoaderPlugin.SHP);
            $VALUES = availableFileExtensionArray = new AvailableFileExtension[]{AvailableFileExtension.PARQUET, AvailableFileExtension.JSON, AvailableFileExtension.XLS, AvailableFileExtension.XLSX, AvailableFileExtension.SHP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Iterable $this$groupBy$iv = (Iterable)AvailableFileExtension.getEntries();
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator iterator = $this$groupByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object object2;
                Object element$iv$iv = iterator.next();
                AvailableFileExtension it2 = (AvailableFileExtension)((Object)element$iv$iv);
                boolean $i$a$-groupBy-DataLoaderPluginsManager$AvailableFileExtension$Companion$EXTENSION_TO_PLUGIN_ID$32 = false;
                key$iv$iv = it2.extension;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                AvailableFileExtension $i$a$-groupBy-DataLoaderPluginsManager$AvailableFileExtension$Companion$EXTENSION_TO_PLUGIN_ID$32 = (AvailableFileExtension)((Object)element$iv$iv);
                object = list$iv$iv;
                boolean bl = false;
                object.add(it.plugin);
            }
            Map $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object = map;
                boolean bl2 = false;
                DataLoaderPlugin dataLoaderPlugin = (DataLoaderPlugin)((Object)CollectionsKt.first((List)((List)it.getValue())));
                object.put(k, dataLoaderPlugin);
            }
            EXTENSION_TO_PLUGIN_ID = destination$iv$iv;
            AvailableFileExtension[] availableFileExtensionArray = new AvailableFileExtension[]{PARQUET, JSON, XLS, XLSX, SHP};
            OPEN_TABLES_ALL_EXTENSIONS = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])availableFileExtensionArray), AvailableFileExtension::OPEN_TABLES_ALL_EXTENSIONS$lambda$3));
            availableFileExtensionArray = new AvailableFileExtension[]{PARQUET, XLS, XLSX, SHP};
            TABLE_FIRST_ALL_EXTENSIONS = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])availableFileExtensionArray), AvailableFileExtension::TABLE_FIRST_ALL_EXTENSIONS$lambda$4));
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u0006J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u000e\u001a\u00020\u000fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/grid/scripting/impl/DataLoaderPluginsManager$AvailableFileExtension$Companion;", "", "<init>", "()V", "EXTENSION_TO_PLUGIN_ID", "", "", "Lcom/intellij/grid/scripting/impl/DataLoaderPluginsManager$DataLoaderPlugin;", "OPEN_TABLES_ALL_EXTENSIONS", "", "TABLE_FIRST_ALL_EXTENSIONS", "getPluginIdByExtension", "extension", "getDefaultExtensions", "setting", "Lcom/intellij/grid/scripting/impl/ScriptedTableFileEditorProvider$OpenDetectedTables;", "intellij.grid.scripting.impl"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final DataLoaderPlugin getPluginIdByExtension(@Nullable String extension) {
                return EXTENSION_TO_PLUGIN_ID.getOrDefault(extension, null);
            }

            @NotNull
            public final List<String> getDefaultExtensions(@NotNull ScriptedTableFileEditorProvider.OpenDetectedTables setting) {
                Intrinsics.checkNotNullParameter((Object)((Object)setting), (String)"setting");
                return switch (WhenMappings.$EnumSwitchMapping$0[setting.ordinal()]) {
                    case 1 -> OPEN_TABLES_ALL_EXTENSIONS;
                    case 2 -> TABLE_FIRST_ALL_EXTENSIONS;
                    case 3 -> CollectionsKt.emptyList();
                    default -> throw new NoWhenBranchMatchedException();
                };
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[ScriptedTableFileEditorProvider.OpenDetectedTables.values().length];
                    try {
                        nArray[ScriptedTableFileEditorProvider.OpenDetectedTables.ALL.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[ScriptedTableFileEditorProvider.OpenDetectedTables.TABLE_FIRST_FORMATS.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[ScriptedTableFileEditorProvider.OpenDetectedTables.NONE.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0005H\u0002J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/grid/scripting/impl/DataLoaderPluginsManager$Companion;", "", "<init>", "()V", "showAdIfNeeded", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getDefaultExtensions", "", "", "setting", "Lcom/intellij/grid/scripting/impl/ScriptedTableFileEditorProvider$OpenDetectedTables;", "getNumberOfInstalledPlugins", "", "resetInvocations", "getAd", "plugin", "Lcom/intellij/grid/scripting/impl/DataLoaderPluginsManager$DataLoaderPlugin;", "fileName", "getInstallAction", "Lcom/intellij/notification/NotificationAction;", "REJECT_ACTION", "intellij.grid.scripting.impl"})
    @SourceDebugExtension(value={"SMAP\nDataLoaderPluginsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataLoaderPluginsManager.kt\ncom/intellij/grid/scripting/impl/DataLoaderPluginsManager$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n774#2:124\n865#2,2:125\n1563#2:127\n1634#2,3:128\n*S KotlinDebug\n*F\n+ 1 DataLoaderPluginsManager.kt\ncom/intellij/grid/scripting/impl/DataLoaderPluginsManager$Companion\n*L\n89#1:124\n89#1:125,2\n89#1:127\n89#1:128,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void showAdIfNeeded(@NotNull VirtualFile file, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            DataLoaderPlugin plugin = AvailableFileExtension.Companion.getPluginIdByExtension(file.getExtension());
            if (plugin == null || PluginManagerCore.isPluginInstalled((PluginId)PluginId.Companion.getId(plugin.getPluginId()))) {
                return;
            }
            int numberOfInvocations = PropertiesComponent.getInstance().getInt("Data.Loaders.Plugin.Ad.Shown", 5);
            if (numberOfInvocations < 5) {
                PropertiesComponent.getInstance().setValue("Data.Loaders.Plugin.Ad.Shown", String.valueOf(numberOfInvocations + 1));
                return;
            }
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.getAd(project, plugin, string);
        }

        @NotNull
        public final List<String> getDefaultExtensions(@NotNull ScriptedTableFileEditorProvider.OpenDetectedTables setting) {
            Intrinsics.checkNotNullParameter((Object)((Object)setting), (String)"setting");
            return AvailableFileExtension.Companion.getDefaultExtensions(setting);
        }

        /*
         * WARNING - void declaration
         */
        public final int getNumberOfInstalledPlugins() {
            void $this$mapTo$iv$iv;
            DataLoaderPlugin it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)DataLoaderPlugin.getEntries();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (DataLoaderPlugin)((Object)element$iv$iv);
                boolean bl = false;
                if (!PluginManager.isPluginInstalled((PluginId)PluginId.Companion.getId(it.getPluginId()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (DataLoaderPlugin)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPluginId());
            }
            return ((Collection)((List)destination$iv$iv)).size();
        }

        private final void resetInvocations() {
            PropertiesComponent.getInstance().setValue("Data.Loaders.Plugin.Ad.Shown", "0");
        }

        private final void getAd(Project project, DataLoaderPlugin plugin, String fileName) {
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Extractors");
            Object[] objectArray = new Object[]{fileName};
            String string = DataGridBundle.message((String)"data.loaders.plugin.ad.notification", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            notificationGroup.createNotification(string, NotificationType.INFORMATION).setTitle(DataGridBundle.message((String)"notification.plugin.suggestion", (Object[])new Object[0])).addAction((AnAction)this.getInstallAction(plugin)).addAction((AnAction)REJECT_ACTION).setSuggestionType(true).setDisplayId("Add loader plugin").notify(project);
        }

        private final NotificationAction getInstallAction(DataLoaderPlugin plugin) {
            Object[] objectArray = new Object[]{plugin.getPluginName()};
            String string = DataGridBundle.message((String)"notification.install.plugin.with.name", (Object[])objectArray);
            return new NotificationAction(plugin, string){
                final /* synthetic */ DataLoaderPlugin $plugin;
                {
                    this.$plugin = $plugin;
                    super($super_call_param$1);
                }

                public void actionPerformed(AnActionEvent e, Notification notification) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    Project project = e.getProject();
                    PluginsAdvertiser.installAndEnable$default((Project)project, (Set)SetsKt.setOf((Object)PluginId.Companion.getId(this.$plugin.getPluginId())), (boolean)false, (boolean)false, null, () -> getInstallAction.1.actionPerformed$lambda$0(notification), (int)28, null);
                }

                private static final void actionPerformed$lambda$0(Notification $notification) {
                    $notification.expire();
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ void access$resetInvocations(Companion $this) {
            $this.resetInvocations();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/grid/scripting/impl/DataLoaderPluginsManager$DataLoaderPlugin;", "", "pluginId", "", "pluginName", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getPluginId", "()Ljava/lang/String;", "getPluginName", "JSON", "PARQUET", "SHP", "XLS", "intellij.grid.scripting.impl"})
    private static final class DataLoaderPlugin
    extends Enum<DataLoaderPlugin> {
        @NotNull
        private final String pluginId;
        @NotNull
        private final String pluginName;
        public static final /* enum */ DataLoaderPlugin JSON = new DataLoaderPlugin("intellij.grid.loader.json", "Json Loader");
        public static final /* enum */ DataLoaderPlugin PARQUET = new DataLoaderPlugin("intellij.grid.loader.parquet", "Parquet Loader");
        public static final /* enum */ DataLoaderPlugin SHP = new DataLoaderPlugin("intellij.grid.loader.shp", "SHP Loader");
        public static final /* enum */ DataLoaderPlugin XLS = new DataLoaderPlugin("intellij.grid.loader.xls", "XLS Loader");
        private static final /* synthetic */ DataLoaderPlugin[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DataLoaderPlugin(String pluginId, String pluginName) {
            this.pluginId = pluginId;
            this.pluginName = pluginName;
        }

        @NotNull
        public final String getPluginId() {
            return this.pluginId;
        }

        @NotNull
        public final String getPluginName() {
            return this.pluginName;
        }

        public static DataLoaderPlugin[] values() {
            return (DataLoaderPlugin[])$VALUES.clone();
        }

        public static DataLoaderPlugin valueOf(String value) {
            return Enum.valueOf(DataLoaderPlugin.class, value);
        }

        @NotNull
        public static EnumEntries<DataLoaderPlugin> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = dataLoaderPluginArray = new DataLoaderPlugin[]{DataLoaderPlugin.JSON, DataLoaderPlugin.PARQUET, DataLoaderPlugin.SHP, DataLoaderPlugin.XLS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

