/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.messages;

import com.intellij.editorconfig.common.EditorConfigBundle;
import com.intellij.editorconfig.common.plugin.EditorConfigFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ArrayUtil;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J,\u0010\u0005\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0007\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J2\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J0\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R!\u0010\u001c\u001a\u0015\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e0\u001d\u00a2\u0006\u0002\b X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/editorconfig/language/messages/EditorConfigWrongFileEncodingNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createNotificationPanel", "Lcom/intellij/ui/EditorNotificationPanel;", "fileEditor", "isSafeToConvert", "Lcom/intellij/openapi/vfs/encoding/EncodingUtil$Magic8;", "isSafeToReload", "buildPanel", "editor", "Lcom/intellij/openapi/editor/Editor;", "update", "", "isSafeToReloadIn", "text", "", "isSafeToConvertTo", "HIDDEN_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.editorconfig.backend"})
public final class EditorConfigWrongFileEncodingNotificationProvider
implements EditorNotificationProvider,
DumbAware {
    @NotNull
    private final Key<Boolean> HIDDEN_KEY;

    public EditorConfigWrongFileEncodingNotificationProvider() {
        Key key = Key.create((String)"editorconfig.wrong.encoding.notification.hidden");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.HIDDEN_KEY = key;
    }

    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (PropertiesComponent.getInstance().isTrueValue("editorconfig.wrong.encoding.notification.disabled")) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)file.getExtension(), (Object)EditorConfigFileType.INSTANCE.getFileExtension())) {
            return null;
        }
        if (Intrinsics.areEqual((Object)file.getCharset(), (Object)Charsets.UTF_8)) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return null;
        }
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        EncodingUtil.Magic8 isSafeToConvert = this.isSafeToConvertTo(file, text);
        EncodingUtil.Magic8 isSafeToReload = this.isSafeToReloadIn(file, text);
        return arg_0 -> EditorConfigWrongFileEncodingNotificationProvider.collectNotificationData$lambda$0(this, file, project, isSafeToConvert, isSafeToReload, arg_0);
    }

    private final EditorNotificationPanel createNotificationPanel(VirtualFile file, FileEditor fileEditor, Project project, EncodingUtil.Magic8 isSafeToConvert, EncodingUtil.Magic8 isSafeToReload) {
        if (!(fileEditor instanceof TextEditor)) {
            return null;
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        if (editor2.getUserData(this.HIDDEN_KEY) != null) {
            return null;
        }
        return this.buildPanel(project, editor2, file, isSafeToConvert, isSafeToReload);
    }

    private final EditorNotificationPanel buildPanel(Project project, Editor editor, VirtualFile file, EncodingUtil.Magic8 isSafeToConvert, EncodingUtil.Magic8 isSafeToReload) {
        EditorNotificationPanel result2 = new EditorNotificationPanel(editor, null, null, EditorNotificationPanel.Status.Warning);
        result2.text(EditorConfigBundle.INSTANCE.get("notification.encoding.message", new Object[0]));
        String convert = EditorConfigBundle.INSTANCE.get("notification.action.convert", new Object[0]);
        result2.createActionLabel(convert, () -> EditorConfigWrongFileEncodingNotificationProvider.buildPanel$lambda$1(project, editor, file, isSafeToConvert, isSafeToReload));
        String hide = EditorConfigBundle.INSTANCE.get("notification.action.hide.once", new Object[0]);
        result2.createActionLabel(hide, () -> EditorConfigWrongFileEncodingNotificationProvider.buildPanel$lambda$2(editor, this, file, project));
        String hideForever = EditorConfigBundle.INSTANCE.get("notification.action.hide.forever", new Object[0]);
        result2.createActionLabel(hideForever, () -> EditorConfigWrongFileEncodingNotificationProvider.buildPanel$lambda$3(this, file, project));
        return result2;
    }

    private final void update(VirtualFile file, Project project) {
        EditorNotifications.getInstance((Project)project).updateNotifications(file);
    }

    private final EncodingUtil.Magic8 isSafeToReloadIn(VirtualFile file, CharSequence text) {
        byte[] byArray;
        byte[] byArray2 = file.contentsToByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"contentsToByteArray(...)");
        byte[] bytes = byArray2;
        byte[] bom = file.getBOM();
        if (bom != null && !CharsetToolkit.canHaveBom((Charset)Charsets.UTF_8, (byte[])bom)) {
            return EncodingUtil.Magic8.NO_WAY;
        }
        byte[] mandatoryBom = CharsetToolkit.getMandatoryBom((Charset)Charsets.UTF_8);
        if (mandatoryBom != null && !ArrayUtil.startsWith((byte[])bytes, (byte[])mandatoryBom)) {
            return EncodingUtil.Magic8.NO_WAY;
        }
        String loaded = ((Object)LoadTextUtil.getTextByBinaryPresentation((byte[])bytes, (Charset)Charsets.UTF_8)).toString();
        try {
            String string = FileDocumentManager.getInstance().getLineSeparator(file, null);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLineSeparator(...)");
            String separator = string;
            String string2 = StringUtil.convertLineSeparators((String)loaded, (String)separator);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"convertLineSeparators(...)");
            String string3 = string2;
            byte[] byArray3 = string3.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
            byArray = byArray3;
        }
        catch (UnsupportedOperationException e) {
            return EncodingUtil.Magic8.NO_WAY;
        }
        catch (NullPointerException e) {
            return EncodingUtil.Magic8.NO_WAY;
        }
        byte[] bytesToSave = byArray;
        if (bom != null && !ArrayUtil.startsWith((byte[])bytesToSave, (byte[])bom)) {
            byte[] byArray4 = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytesToSave);
            Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"mergeArrays(...)");
            bytesToSave = byArray4;
        }
        return !Arrays.equals(bytesToSave, bytes) ? EncodingUtil.Magic8.NO_WAY : (StringUtil.equals((CharSequence)loaded, (CharSequence)text) ? EncodingUtil.Magic8.ABSOLUTELY : EncodingUtil.Magic8.WELL_IF_YOU_INSIST);
    }

    private final EncodingUtil.Magic8 isSafeToConvertTo(VirtualFile file, CharSequence text) {
        EncodingUtil.Magic8 magic8;
        try {
            CharSequence charSequence;
            byte[] byArray = file.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
            byte[] bytesOnDisk = byArray;
            String string = FileDocumentManager.getInstance().getLineSeparator(file, null);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLineSeparator(...)");
            String lineSeparator = string;
            if (Intrinsics.areEqual((Object)lineSeparator, (Object)"\n")) {
                charSequence = text;
            } else {
                CharSequence charSequence2 = StringUtilRt.convertLineSeparators((CharSequence)text, (String)lineSeparator);
                charSequence = charSequence2;
                Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"convertLineSeparators(...)");
            }
            CharSequence textToSave = charSequence;
            byte[] saved = (byte[])LoadTextUtil.chooseMostlyHarmlessCharset((Charset)file.getCharset(), (Charset)Charsets.UTF_8, (String)((Object)textToSave).toString()).second;
            CharSequence charSequence3 = LoadTextUtil.getTextByBinaryPresentation((byte[])saved, (Charset)Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence3, (String)"getTextByBinaryPresentation(...)");
            CharSequence textLoadedBack = charSequence3;
            magic8 = !StringUtil.equals((CharSequence)text, (CharSequence)textLoadedBack) ? EncodingUtil.Magic8.NO_WAY : (Arrays.equals(saved, bytesOnDisk) ? EncodingUtil.Magic8.ABSOLUTELY : EncodingUtil.Magic8.WELL_IF_YOU_INSIST);
        }
        catch (UnsupportedOperationException e) {
            magic8 = EncodingUtil.Magic8.NO_WAY;
        }
        return magic8;
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$0(EditorConfigWrongFileEncodingNotificationProvider this$0, VirtualFile $file, Project $project, EncodingUtil.Magic8 $isSafeToConvert, EncodingUtil.Magic8 $isSafeToReload, FileEditor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createNotificationPanel($file, it, $project, $isSafeToConvert, $isSafeToReload);
    }

    private static final void buildPanel$lambda$1(Project $project, Editor $editor, VirtualFile $file, EncodingUtil.Magic8 $isSafeToConvert, EncodingUtil.Magic8 $isSafeToReload) {
        ChangeFileEncodingAction.changeTo((Project)$project, (Document)$editor.getDocument(), (Editor)$editor, (VirtualFile)$file, (Charset)Charsets.UTF_8, (EncodingUtil.Magic8)$isSafeToConvert, (EncodingUtil.Magic8)$isSafeToReload);
    }

    private static final void buildPanel$lambda$2(Editor $editor, EditorConfigWrongFileEncodingNotificationProvider this$0, VirtualFile $file, Project $project) {
        $editor.putUserData(this$0.HIDDEN_KEY, (Object)true);
        this$0.update($file, $project);
    }

    private static final void buildPanel$lambda$3(EditorConfigWrongFileEncodingNotificationProvider this$0, VirtualFile $file, Project $project) {
        PropertiesComponent.getInstance().setValue("editorconfig.wrong.encoding.notification.disabled", true);
        this$0.update($file, $project);
    }
}

