/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.distance.FacetSequence;

public class FacetSequenceTreeBuilder {
    private static final int FACET_SEQUENCE_SIZE = 6;
    private static final int STR_TREE_NODE_CAPACITY = 4;

    public static STRtree build(Geometry g) {
        STRtree tree2 = new STRtree(4);
        List sections = FacetSequenceTreeBuilder.computeFacetSequences(g);
        for (FacetSequence section : sections) {
            tree2.insert(section.getEnvelope(), (Object)section);
        }
        tree2.build();
        return tree2;
    }

    private static List computeFacetSequences(Geometry g) {
        final ArrayList sections = new ArrayList();
        g.apply(new GeometryComponentFilter(){

            @Override
            public void filter(Geometry geom) {
                CoordinateSequence seq = null;
                if (geom instanceof LineString) {
                    seq = ((LineString)geom).getCoordinateSequence();
                    FacetSequenceTreeBuilder.addFacetSequences(geom, seq, sections);
                } else if (geom instanceof Point) {
                    seq = ((Point)geom).getCoordinateSequence();
                    FacetSequenceTreeBuilder.addFacetSequences(geom, seq, sections);
                }
            }
        });
        return sections;
    }

    private static void addFacetSequences(Geometry geom, CoordinateSequence pts, List sections) {
        int size = pts.size();
        for (int i2 = 0; i2 <= size - 1; i2 += 6) {
            int end = i2 + 6 + 1;
            if (end >= size - 1) {
                end = size;
            }
            FacetSequence sect = new FacetSequence(geom, pts, i2, end);
            sections.add(sect);
        }
    }
}

