/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.generic;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.generic.GenericDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlDialectErrorFilter
extends HighlightErrorFilter
implements HighlightInfoFilter {
    @NotNull
    private static SqlLanguageDialect getSqlDialectSafe(@Nullable PsiElement element) {
        SqlLanguageDialect sqlLanguageDialect = (SqlLanguageDialect)ObjectUtils.notNull((Object)DbSqlUtilCore.getSqlDialect(element), (Object)GenericDialect.INSTANCE);
        if (sqlLanguageDialect == null) {
            SqlDialectErrorFilter.$$$reportNull$$$0(0);
        }
        return sqlLanguageDialect;
    }

    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        if (element == null) {
            SqlDialectErrorFilter.$$$reportNull$$$0(1);
        }
        if (!(element.getContainingFile() instanceof SqlFile)) {
            return true;
        }
        return SqlDialectErrorFilter.getSqlDialectSafe((PsiElement)element).supportsErrorHighlighting();
    }

    public boolean accept(@NotNull HighlightInfo highlightInfo, @Nullable PsiFile psiFile) {
        if (highlightInfo == null) {
            SqlDialectErrorFilter.$$$reportNull$$$0(2);
        }
        if (UpdateHighlightersUtil.isFileLevelOrGutterAnnotation((HighlightInfo)highlightInfo)) {
            return true;
        }
        if (!(psiFile instanceof SqlFile) || DbSqlUtilCore.getSqlDialect((PsiElement)psiFile) != GenericDialect.INSTANCE) {
            return true;
        }
        return highlightInfo.getSeverity().compareTo(HighlightSeverity.WARNING) < 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/generic/SqlDialectErrorFilter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialectSafe";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/generic/SqlDialectErrorFilter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldHighlightErrorElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

