/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.dateTime;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.FlexLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.dateTime.psi.SqlDtCompositeElementType;
import com.intellij.sql.dialects.dateTime.psi.SqlDtReference;
import com.intellij.sql.dialects.dateTime.psi.SqlDtTemporalElement;
import com.intellij.sql.dialects.dateTime.psi.values.SqlTemporalValue;
import com.intellij.sql.dialects.dateTime.psi.values.SqlTemporalValueKt;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.impl.SqlTimeAndDateLiteralExpressionImpl;
import java.time.chrono.IsoChronology;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u0014H\u0005J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J&\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010 \u001a\u0004\u0018\u00010\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0017\u00a8\u0006!"}, d2={"Lcom/intellij/sql/dialects/dateTime/SqlDateTimeLanguageHelper;", "", "<init>", "()V", "getRootElementType", "Lcom/intellij/sql/dialects/dateTime/psi/SqlDtCompositeElementType;", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "createLexer", "Lcom/intellij/lexer/FlexLexer;", "createParser", "Lcom/intellij/lang/PsiParser;", "resolveReference", "Lcom/intellij/psi/PsiElement;", "ref", "Lcom/intellij/sql/dialects/dateTime/psi/SqlDtReference;", "validateInterval", "", "temporal", "Lcom/intellij/sql/dialects/dateTime/psi/values/SqlTemporalValue;", "", "min", "max", "getMaxDayOfMonth", "dayPsi", "Lcom/intellij/sql/dialects/dateTime/psi/SqlDtTemporalElement;", "inspectTemporalValue", "Lcom/intellij/codeInspection/ProblemDescriptor;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "validateTemporalValue", "intellij.database.sql.core.impl"})
public abstract class SqlDateTimeLanguageHelper {
    @Nullable
    public SqlDtCompositeElementType getRootElementType(@NotNull PsiLanguageInjectionHost host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        PsiElement psiElement = host.getParent();
        SqlTimeAndDateLiteralExpressionImpl sqlTimeAndDateLiteralExpressionImpl = psiElement instanceof SqlTimeAndDateLiteralExpressionImpl ? (SqlTimeAndDateLiteralExpressionImpl)psiElement : null;
        if (sqlTimeAndDateLiteralExpressionImpl == null) {
            return null;
        }
        SqlTimeAndDateLiteralExpressionImpl dateTimeLiteral = sqlTimeAndDateLiteralExpressionImpl;
        IElementType iElementType = dateTimeLiteral.getElementType();
        return Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_DATE_LITERAL)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.ODBC_DATE)) ? SqlDtCompositeElementType.Companion.getDATE() : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_TIME_LITERAL)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.ODBC_TIME)) ? SqlDtCompositeElementType.Companion.getTIME() : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_TIMESTAMP_LITERAL)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_DATETIME_LITERAL)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.ODBC_TIMESTAMP)) ? SqlDtCompositeElementType.Companion.getTIMESTAMP() : null));
    }

    @NotNull
    public abstract FlexLexer createLexer(@NotNull PsiLanguageInjectionHost var1);

    @NotNull
    public abstract PsiParser createParser(@NotNull PsiLanguageInjectionHost var1);

    @Nullable
    public PsiElement resolveReference(@NotNull SqlDtReference ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        return null;
    }

    @InspectionMessage
    @Nullable
    protected final String validateInterval(@NotNull SqlTemporalValue<Integer> temporal, int min, int max) {
        String string;
        Intrinsics.checkNotNullParameter(temporal, (String)"temporal");
        String string2 = temporal.getName();
        if (string2 == null) {
            return null;
        }
        String name2 = string2;
        Object[] objectArray = new IntRange(min, max);
        Integer n = temporal.getValue();
        if (n != null && objectArray.contains(n.intValue())) {
            string = null;
        } else {
            objectArray = new Object[]{StringUtil.toTitleCase((String)name2), min, max};
            string = SqlBundle.message("inspection.message.field.must.be.between", objectArray);
        }
        return string;
    }

    public static /* synthetic */ String validateInterval$default(SqlDateTimeLanguageHelper sqlDateTimeLanguageHelper, SqlTemporalValue sqlTemporalValue, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: validateInterval");
        }
        if ((n3 & 2) != 0) {
            n = Integer.MIN_VALUE;
        }
        if ((n3 & 4) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        return sqlDateTimeLanguageHelper.validateInterval(sqlTemporalValue, n, n2);
    }

    private final int getMaxDayOfMonth(SqlDtTemporalElement dayPsi) {
        PsiElement psiElement = dayPsi.getParent();
        SqlDtTemporalElement sqlDtTemporalElement = psiElement instanceof SqlDtTemporalElement ? (SqlDtTemporalElement)psiElement : null;
        if (sqlDtTemporalElement == null) {
            return 31;
        }
        SqlDtTemporalElement parent = sqlDtTemporalElement;
        SqlTemporalValue<?> sqlTemporalValue = parent.evaluate();
        SqlTemporalValue.Date date = sqlTemporalValue instanceof SqlTemporalValue.Date ? (SqlTemporalValue.Date)sqlTemporalValue : null;
        if (date == null) {
            return 31;
        }
        SqlTemporalValue.Date date2 = date;
        Object object = date2.getYear();
        if (object == null || (object = ((SqlTemporalValue.Year)object).getValue()) == null) {
            return 31;
        }
        int year = (Integer)object;
        Object object2 = date2.getMonth();
        if (object2 == null || (object2 = ((SqlTemporalValue.Month)object2).getValue()) == null) {
            return 31;
        }
        int month = (Integer)object2;
        return switch (month) {
            case 2 -> {
                if (IsoChronology.INSTANCE.isLeapYear(year)) {
                    yield 29;
                }
                yield 28;
            }
            case 4, 6, 9, 11 -> 30;
            default -> 31;
        };
    }

    @Nullable
    public ProblemDescriptor inspectTemporalValue(@NotNull SqlTemporalValue<?> temporal, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter(temporal, (String)"temporal");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        String string = this.validateTemporalValue(temporal);
        if (string == null) {
            return null;
        }
        String message = string;
        return manager.createProblemDescriptor((PsiElement)temporal.getPsi(), SqlTemporalValueKt.getRangeInElement(temporal), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]);
    }

    @InspectionMessage
    @Nullable
    public String validateTemporalValue(@NotNull SqlTemporalValue<?> temporal) {
        Intrinsics.checkNotNullParameter(temporal, (String)"temporal");
        SqlTemporalValue<Integer> sqlTemporalValue = temporal;
        return sqlTemporalValue instanceof SqlTemporalValue.Month ? this.validateInterval(temporal, 1, 12) : (sqlTemporalValue instanceof SqlTemporalValue.DayOfMonth ? this.validateInterval(temporal, 1, this.getMaxDayOfMonth(((SqlTemporalValue.DayOfMonth)temporal).getPsi())) : (sqlTemporalValue instanceof SqlTemporalValue.Hour ? this.validateInterval(temporal, 0, 23) : (sqlTemporalValue instanceof SqlTemporalValue.Minute ? this.validateInterval(temporal, 0, 59) : (sqlTemporalValue instanceof SqlTemporalValue.Second ? this.validateInterval(temporal, 0, 59) : (sqlTemporalValue instanceof SqlTemporalValue.SecondFraction ? this.validateInterval(temporal, 0, 999999999) : (sqlTemporalValue instanceof SqlTemporalValue.Invalid ? ((SqlTemporalValue.Invalid)temporal).getError() : null))))));
    }
}

