/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.dialects.base.BaseExecutionEnvironmentHelper;
import com.intellij.sql.psi.SqlElement;
import org.jetbrains.annotations.NotNull;

final class OraExecutionEnvironmentHelper
extends BaseExecutionEnvironmentHelper {
    OraExecutionEnvironmentHelper() {
    }

    @Override
    @NotNull
    protected String generateSelectStatement(@NotNull String text2, @NotNull SqlElement sqlElement) {
        if (text2 == null) {
            OraExecutionEnvironmentHelper.$$$reportNull$$$0(0);
        }
        if (sqlElement == null) {
            OraExecutionEnvironmentHelper.$$$reportNull$$$0(1);
        }
        String string = String.format("SELECT %s FROM dual", text2);
        if (string == null) {
            OraExecutionEnvironmentHelper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public ExecutionEnvironmentHelper.TimeZoneManager getTimeZoneManager() {
        ExecutionEnvironmentHelper.TimeZoneManager timeZoneManager = OraTimeZoneManager.INSTANCE;
        if (timeZoneManager == null) {
            OraExecutionEnvironmentHelper.$$$reportNull$$$0(3);
        }
        return timeZoneManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/OraExecutionEnvironmentHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/OraExecutionEnvironmentHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSelectStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeZoneManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateSelectStatement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static final class OraTimeZoneManager
    implements ExecutionEnvironmentHelper.TimeZoneManager {
        private static final ExecutionEnvironmentHelper.TimeZoneManager INSTANCE = new OraTimeZoneManager();

        private OraTimeZoneManager() {
        }

        @Override
        public boolean canChange() {
            return true;
        }

        @Override
        public void changeTimeZone(@NotNull DatabaseConnectionCore connection, @NotNull String timeZone) {
            if (connection == null) {
                OraTimeZoneManager.$$$reportNull$$$0(0);
            }
            if (timeZone == null) {
                OraTimeZoneManager.$$$reportNull$$$0(1);
            }
            SmartStatementFactoryService.getInstance().poweredBy(connection).simple(Configuration.sourced(SmartStatementSource.SYSTEM)).barren().quiet().execute(String.format("alter session set time_zone = '%s'", timeZone));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "timeZone";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/oracle/OraExecutionEnvironmentHelper$OraTimeZoneManager";
            objectArray[2] = "changeTimeZone";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

