/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.producers;

import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\"\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000b0\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a*\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a*\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0002\u001a\u001c\u0010\u0016\u001a\u00020\u00042\u0014\u0010\u0017\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00140\u0018\u001a9\u0010\u0019\u001a\u00020\u001a2\u0014\u0010\u0017\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00140\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001d2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\u001f\u001a\u0017\u0010 \u001a\u00020\u001a*\b\u0012\u0004\u0012\u00020\u001a0\u001dH\u0002\u00a2\u0006\u0002\u0010!\"E\u0010\u0007\u001a9\u00120\u0012.\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000b \f*\u0016\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000b\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"getPrevColumn", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "col", "hasExistingColumnAfter", "", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "UNSORTED_COLUMNS", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/database/model/basic/BasicLikeTable;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getUnsortedColumns", "srcTable", "tgtTable", "getUnsortedHolder", "computeUnsorted", "findAlteration", "Lcom/intellij/database/model/ElementAlteration;", "srcCol", "nullizeSorted", "columns", "", "findSortedPrefix", "", "", "lens", "", "end", "(Ljava/util/List;[Ljava/lang/Integer;I)I", "indexOfMax", "([Ljava/lang/Integer;)I", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nLikeColumnProducers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LikeColumnProducers.kt\ncom/intellij/database/dialects/base/generator/producers/LikeColumnProducersKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,314:1\n382#2,7:315\n1011#3,2:322\n1625#3:324\n1869#3:325\n1870#3:327\n1626#3:328\n1878#3,3:330\n1#4:326\n1#4:329\n13537#5,3:333\n*S KotlinDebug\n*F\n+ 1 LikeColumnProducers.kt\ncom/intellij/database/dialects/base/generator/producers/LikeColumnProducersKt\n*L\n244#1:315,7\n260#1:322,2\n262#1:324\n262#1:325\n262#1:327\n262#1:328\n272#1:330,3\n262#1:326\n307#1:333,3\n*E\n"})
public final class LikeColumnProducersKt {
    @NotNull
    private static final Key<Map<BasicLikeTable, Set<BasicLikeColumn>>> UNSORTED_COLUMNS;

    @Nullable
    public static final BasicLikeColumn getPrevColumn(@NotNull BasicLikeColumn col) {
        Intrinsics.checkNotNullParameter((Object)col, (String)"col");
        short pos = col.getPosition();
        if (pos == 1) {
            return null;
        }
        BasicNode basicNode = col.getLikeTable();
        if (basicNode == null || (basicNode = basicNode.getColumns()) == null) {
            return null;
        }
        BasicNode columns = basicNode;
        short maxPos = 0;
        BasicLikeColumn maxCol = null;
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            BasicLikeColumn cur = (BasicLikeColumn)iterator.next();
            short curPos = cur.getPosition();
            if (curPos >= pos || curPos <= maxPos) continue;
            maxPos = curPos;
            maxCol = cur;
        }
        return maxCol;
    }

    public static final boolean hasExistingColumnAfter(@NotNull BasicLikeColumn col, @NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)col, (String)"col");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getByTarget().isEmpty()) {
            return false;
        }
        short pos = col.getPosition();
        BasicNode basicNode = col.getLikeTable();
        if (basicNode == null || (basicNode = basicNode.getColumns()) == null) {
            return false;
        }
        BasicNode columns = basicNode;
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            BasicLikeColumn cur = (BasicLikeColumn)iterator.next();
            if (cur.getPosition() <= pos) continue;
            ElementDelta<?> elementDelta = context.getByTarget().get(cur);
            if ((elementDelta != null ? elementDelta.getSourceElement() : null) == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<BasicLikeColumn> getUnsortedColumns(BasicLikeTable srcTable, BasicLikeTable tgtTable, ScriptingContext context) {
        Object object;
        void $this$getOrPut$iv;
        Map<BasicLikeTable, Set<BasicLikeColumn>> map = LikeColumnProducersKt.getUnsortedHolder(context);
        BasicLikeTable key$iv = srcTable;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Set<BasicLikeColumn> set = LikeColumnProducersKt.computeUnsorted(srcTable, tgtTable, context);
            if (set == null) {
                Set set2 = Collections.emptySet();
                set = set2;
                Intrinsics.checkNotNullExpressionValue(set2, (String)"emptySet(...)");
            }
            Set<BasicLikeColumn> answer$iv = set;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Set)object;
    }

    private static final Map<BasicLikeTable, Set<BasicLikeColumn>> getUnsortedHolder(ScriptingContext context) {
        Map map = context.getSharedData().computeIfAbsent(UNSORTED_COLUMNS, arg_0 -> LikeColumnProducersKt.getUnsortedHolder$lambda$2(LikeColumnProducersKt::getUnsortedHolder$lambda$1, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"computeIfAbsent(...)");
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<BasicLikeColumn> computeUnsorted(BasicLikeTable srcTable, BasicLikeTable tgtTable, ScriptingContext context) {
        void $this$mapNotNullTo$iv;
        List columns = new ArrayList();
        for (BasicLikeColumn basicLikeColumn : srcTable.getColumns()) {
            ElementAlteration<BasicLikeColumn> it;
            Intrinsics.checkNotNull((Object)basicLikeColumn);
            if (LikeColumnProducersKt.findAlteration(basicLikeColumn, context, tgtTable) == null) continue;
            boolean bl = false;
            if (it.getTargetElement() == basicLikeColumn) continue;
            columns.add(it);
        }
        if (columns.isEmpty()) {
            return null;
        }
        Iterable $this$sortBy$iv = columns;
        boolean bl = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ElementAlteration it = (ElementAlteration)a;
                    boolean bl = false;
                    ElementAlteration elementAlteration = it;
                    Intrinsics.checkNotNull((Object)elementAlteration);
                    it = (ElementAlteration)b;
                    Comparable comparable = Short.valueOf(((BasicLikeColumn)elementAlteration.getSourceElement()).getPosition());
                    bl = false;
                    ElementAlteration elementAlteration2 = it;
                    Intrinsics.checkNotNull((Object)elementAlteration2);
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Short.valueOf(((BasicLikeColumn)elementAlteration2.getSourceElement()).getPosition()));
                }
            });
        }
        if (!LikeColumnProducersKt.nullizeSorted(columns)) {
            return null;
        }
        $this$sortBy$iv = columns;
        Collection collection = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            BasicLikeColumn it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl2 = false;
            ElementAlteration it = (ElementAlteration)element$iv;
            boolean bl22 = false;
            ElementAlteration elementAlteration = it;
            if ((elementAlteration != null ? (BasicLikeColumn)elementAlteration.getSourceElement() : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            collection.add(it$iv);
        }
        return (Set)collection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final ElementAlteration<BasicLikeColumn> findAlteration(BasicLikeColumn srcCol, ScriptingContext context, BasicLikeTable tgtTable) {
        BasicNode basicNode;
        ElementDelta<?> elementDelta = context.getBySource().get(srcCol);
        ElementAlteration elementAlteration = elementDelta instanceof ElementAlteration ? (ElementAlteration)elementDelta : null;
        ElementAlteration elementAlteration2 = elementAlteration;
        if (elementAlteration != null) return elementAlteration2;
        BasicLikeTable basicLikeTable = tgtTable;
        BasicNode basicNode2 = basicLikeTable;
        if (basicLikeTable == null) return null;
        PositioningNamingFamily<? extends BasicLikeColumn> positioningNamingFamily = basicNode2.getColumns();
        basicNode2 = positioningNamingFamily;
        if (positioningNamingFamily == null) return null;
        BasicLikeColumn basicLikeColumn = (BasicLikeColumn)basicNode2.get(srcCol.getName());
        basicNode2 = basicLikeColumn;
        if (basicLikeColumn == null) return null;
        BasicNode it = basicNode = basicNode2;
        boolean bl = false;
        if (context.getByTarget().get(it) != null) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        BasicNode basicNode3 = basicNode;
        basicNode2 = basicNode3;
        if (basicNode3 == null) return null;
        it = basicNode2;
        boolean bl3 = false;
        elementAlteration2 = new ElementAlteration<BasicElement>(srcCol, (BasicElement)it);
        return elementAlteration2;
    }

    public static final boolean nullizeSorted(@NotNull List<ElementAlteration<BasicLikeColumn>> columns) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        int n = 0;
        int n2 = columns.size();
        Integer[] integerArray = new Integer[n2];
        while (n < n2) {
            int n3 = n++;
            integerArray[n3] = 0;
        }
        Integer[] lens = integerArray;
        n2 = 0;
        int n4 = columns.size();
        Integer[] integerArray2 = new Integer[n4];
        while (n2 < n4) {
            int n5 = n2++;
            integerArray2[n5] = -1;
        }
        Integer[] backRefs = integerArray2;
        Iterable $this$forEachIndexed$iv = columns;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n6;
            if ((n6 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ElementAlteration cfr_ignored_0 = (ElementAlteration)item$iv;
            int i2 = n6;
            boolean bl = false;
            int maxi = LikeColumnProducersKt.findSortedPrefix(columns, lens, i2);
            backRefs[i2] = maxi;
            lens[i2] = maxi == -1 ? 1 : lens[maxi] + 1;
        }
        int idx = LikeColumnProducersKt.indexOfMax(lens);
        if (lens[idx].intValue() == columns.size()) {
            return false;
        }
        while (idx != -1) {
            columns.set(idx, null);
            idx = backRefs[idx];
        }
        return true;
    }

    private static final int findSortedPrefix(List<? extends ElementAlteration<? extends BasicLikeColumn>> columns, Integer[] lens, int end) {
        ElementAlteration<? extends BasicLikeColumn> elementAlteration = columns.get(end);
        Intrinsics.checkNotNull(elementAlteration);
        short pos = elementAlteration.getTargetElement().getPosition();
        int max = 0;
        int maxi = -1;
        int k = end - 1;
        while (k >= 0) {
            int kk = k--;
            ElementAlteration<? extends BasicLikeColumn> prev = columns.get(kk);
            int cur = lens[kk] + 1;
            if (cur <= max) continue;
            ElementAlteration<? extends BasicLikeColumn> elementAlteration2 = prev;
            Intrinsics.checkNotNull(elementAlteration2);
            if (pos <= elementAlteration2.getTargetElement().getPosition()) continue;
            max = cur;
            maxi = kk;
            if (max != kk + 1) continue;
            return maxi;
        }
        return maxi;
    }

    /*
     * WARNING - void declaration
     */
    private static final int indexOfMax(Integer[] $this$indexOfMax) {
        int maxi = 0;
        int max = 0;
        max = $this$indexOfMax[0];
        Integer[] $this$forEachIndexed$iv = $this$indexOfMax;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Integer item$iv : $this$forEachIndexed$iv) {
            void v;
            int n = index$iv++;
            int n2 = ((Number)item$iv).intValue();
            int i2 = n;
            boolean bl = false;
            if (max >= v) continue;
            max = v;
            maxi = i2;
        }
        return maxi;
    }

    private static final Map getUnsortedHolder$lambda$1(Key it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HashMap();
    }

    private static final Map getUnsortedHolder$lambda$2(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Set access$getUnsortedColumns(BasicLikeTable srcTable, BasicLikeTable tgtTable, ScriptingContext context) {
        return LikeColumnProducersKt.getUnsortedColumns(srcTable, tgtTable, context);
    }

    static {
        Key key2 = Key.create((String)"UNSORTED_COLUMNS");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        UNSORTED_COLUMNS = key2;
    }
}

