/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.dialects.base.generator.AbstractCodeGenerator;
import com.intellij.database.dialects.base.generator.EffectType;
import com.intellij.database.dialects.base.generator.Node;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.OperationType;
import com.intellij.database.dialects.base.generator.Producer;
import com.intellij.database.dialects.base.generator.RequiredEffect;
import com.intellij.database.dialects.base.generator.ScenarioOperations;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.TruncateProducer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0006\b\u0016\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\bH\u0017J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0010\u00a2\u0006\u0002\b\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0014J\u0016\u0010\u0016\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0002J\b\u0010\u0017\u001a\u00020\u000fH\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\bH\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u001bH\u0002J$\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u001e\u001a\u00020\u0014H\u0016J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\tH\u0016R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/base/generator/BaseTruncateGenerator;", "Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "<init>", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;)V", "prepared", "", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/dialects/base/generator/Operation;", "getPrepared", "()Ljava/util/Map;", "makeOperation", "element", "prepareScenario", "", "preparedOperations", "", "preparedOperations$intellij_database_dialects_base", "breakCycle", "", "cycle", "breakByJoinedTruncate", "fillDependencies", "fillTruncateDependants", "e", "elements", "", "prepareElement", "root", "forceRoot", "makeTruncateOperation", "Companion", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nBaseTruncateGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseTruncateGenerator.kt\ncom/intellij/database/dialects/base/generator/BaseTruncateGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1869#2,2:73\n774#2:75\n865#2,2:76\n1869#2,2:78\n1869#2,2:80\n1869#2,2:82\n1#3:84\n*S KotlinDebug\n*F\n+ 1 BaseTruncateGenerator.kt\ncom/intellij/database/dialects/base/generator/BaseTruncateGenerator\n*L\n20#1:73,2\n42#1:75\n42#1:76,2\n42#1:78,2\n50#1:80,2\n54#1:82,2\n*E\n"})
public class BaseTruncateGenerator
extends AbstractCodeGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<BasicElement, Operation> prepared;
    @NotNull
    private static final OperationType TRUNCATE = new OperationType("truncate");

    public BaseTruncateGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, null, 2, null);
        this.prepared = new LinkedHashMap();
    }

    @NotNull
    public final Map<BasicElement, Operation> getPrepared() {
        return this.prepared;
    }

    @Override
    @TestOnly
    @Nullable
    public Operation makeOperation(@NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.makeTruncateOperation(element, this.getScenario().getRoot());
    }

    @Override
    public void prepareScenario() {
        Iterable $this$forEach$iv = this.elements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicElement it = (BasicElement)element$iv;
            boolean bl = false;
            this.makeTruncateOperation(it, this.getScenario().getRoot());
        }
        this.fillDependencies();
    }

    @Override
    @NotNull
    public List<Operation> preparedOperations$intellij_database_dialects_base() {
        return CollectionsKt.toList((Iterable)this.prepared.values());
    }

    @Override
    protected boolean breakCycle(@NotNull List<Operation> cycle) {
        Intrinsics.checkNotNullParameter(cycle, (String)"cycle");
        if (this.breakByJoinedTruncate(cycle)) {
            return true;
        }
        return super.breakCycle(cycle);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean breakByJoinedTruncate(List<Operation> cycle) {
        for (Operation op : cycle) {
            if (op.getProducer() instanceof TruncateProducer) continue;
            return false;
        }
        Operation root = (Operation)CollectionsKt.first(cycle);
        Producer producer = root.getProducer();
        Intrinsics.checkNotNull((Object)producer, (String)"null cannot be cast to non-null type com.intellij.database.dialects.base.generator.producers.TruncateProducer<*>");
        if (!((TruncateProducer)producer).canGroup()) {
            return false;
        }
        for (Operation op : cycle) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            if (Intrinsics.areEqual((Object)op, (Object)root)) continue;
            op.setParent((Node)root);
            Iterable $this$filter$iv = op.getNestedOperations();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Operation it = (Operation)element$iv$iv;
                boolean bl = false;
                if (!(it.getProducer() instanceof TruncateProducer)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Operation it = (Operation)element$iv;
                boolean bl = false;
                it.setParent((Node)root);
            }
        }
        return true;
    }

    private final void fillDependencies() {
        Iterable $this$forEach$iv = this.prepared.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicElement it = (BasicElement)element$iv;
            boolean bl = false;
            this.fillTruncateDependants(it);
        }
    }

    private final void fillTruncateDependants(BasicElement e) {
        block1: {
            Family<? extends BasicElement> family = e.familyOf(ObjectKind.FOREIGN_KEY);
            if (family == null) break block1;
            Iterable $this$forEach$iv = family;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BasicElement it = (BasicElement)element$iv;
                boolean bl = false;
                BasicNamedElement basicNamedElement = it instanceof BasicForeignKey ? (BasicForeignKey)it : null;
                if (basicNamedElement == null || (basicNamedElement = basicNamedElement.getRefTable()) == null) continue;
                BasicNamedElement tab = basicNamedElement;
                Operation operation = this.prepared.get(tab);
                if (operation == null) continue;
                RequiredEffect[] requiredEffectArray = new RequiredEffect[]{ScenarioOperations.matches$default(EffectType.NoData, e, null, 2, null)};
                ScenarioOperations.requires(operation, requiredEffectArray);
            }
        }
    }

    private final Collection<BasicElement> elements() {
        ScriptingTask scriptingTask = this.getContext().getTask();
        Object object = scriptingTask instanceof ScriptingSingleModelTask ? (ScriptingSingleModelTask)scriptingTask : null;
        if (object == null || (object = ((ScriptingSingleModelTask)object).getElements()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public Operation prepareElement(@NotNull BasicElement element, @NotNull Operation root, boolean forceRoot) {
        Operation operation;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Operation operation2 = this.prepared.get(element);
        if (operation2 != null) {
            Operation operation3;
            Operation $this$prepareElement_u24lambda_u245 = operation3 = operation2;
            boolean bl = false;
            if (forceRoot) {
                $this$prepareElement_u24lambda_u245.setParent((Node)root);
            }
            operation = operation3;
        } else {
            operation = this.makeTruncateOperation(element, root);
        }
        return operation;
    }

    public static /* synthetic */ Operation prepareElement$default(BaseTruncateGenerator baseTruncateGenerator, BasicElement basicElement, Operation operation, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareElement");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return baseTruncateGenerator.prepareElement(basicElement, operation, bl);
    }

    @NotNull
    public Operation makeTruncateOperation(@NotNull BasicElement element, @NotNull Operation root) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return this.getContext().getHelper().createTruncateProducer(this.getContext(), element).register(this, root);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/base/generator/BaseTruncateGenerator$Companion;", "", "<init>", "()V", "TRUNCATE", "Lcom/intellij/database/dialects/base/generator/OperationType;", "getTRUNCATE", "()Lcom/intellij/database/dialects/base/generator/OperationType;", "intellij.database.dialects.base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OperationType getTRUNCATE() {
            return TRUNCATE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

