/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.ui.AuthWidgetBuilder;
import com.intellij.database.dataSource.url.template.MutableParametersHolder;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.database.model.DasDataSource;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.coroutines.Continuation;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\bg\u0018\u0000 .2\u00020\u0001:\u0003,-.J\r\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H&J\r\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006H&J&\u0010\u0007\u001a\u00020\b*\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J$\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001e\u001a\u00020\u0013H\u0016J,\u0010\u001f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010 \u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0013H\u0016J\u001a\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0003H\u0016J.\u0010%\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020*H\u0096@\u00a2\u0006\u0002\u0010+J$\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006/\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor;", "getId", "", "Lorg/jetbrains/annotations/NonNls;", "getDisplayName", "Lorg/jetbrains/annotations/Nls;", "configureWidget", "", "Lcom/intellij/database/dataSource/ui/AuthWidgetBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "createWidget", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$AuthWidget;", "isApplicable", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "level", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel;", "getApplicability", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel$Result;", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "loadAuthConfig", "", "external", "saveAuthConfig", "data", "setNewPassword", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "newPass", "handleConnectionFailure", "e", "", "silent", "attempt", "", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;Ljava/lang/Throwable;ZILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ApplicabilityLevel", "AuthWidget", "Companion", "intellij.database.core.impl"})
@ApiStatus.Experimental
public interface DatabaseAuthProvider
extends DatabaseConnectionInterceptor {
    @NotNull
    public static final Companion Companion = com.intellij.database.dataSource.DatabaseAuthProvider$Companion.$$INSTANCE;

    @NotNull
    public String getId();

    @NotNull
    public String getDisplayName();

    default public void configureWidget(@NotNull AuthWidgetBuilder $this$configureWidget, @Nullable Project project, @NotNull DatabaseCredentials credentials, @NotNull DatabaseConnectionConfig config) {
        Intrinsics.checkNotNullParameter((Object)$this$configureWidget, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
    }

    @Deprecated(message="Use configureWidget() instead")
    @ApiStatus.ScheduledForRemoval
    @Nullable
    default public AuthWidget createWidget(@Nullable Project project, @NotNull DatabaseCredentials credentials, @NotNull DatabaseConnectionConfig config) {
        AuthWidget authWidget;
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (config instanceof LocalDataSource) {
            LocalDataSource localDataSource = ((LocalDataSource)config).getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            authWidget = this.createWidget(project, credentials, localDataSource);
        } else {
            authWidget = null;
        }
        return authWidget;
    }

    @Deprecated(message="Anti misuse: wrong implementation returned preferred for all data sources, causing switch suggestions.", replaceWith=@ReplaceWith(expression="com.intellij.database.dataSource.DatabaseAuthProvider#getApplicability", imports={}))
    @ApiStatus.ScheduledForRemoval
    default public boolean isApplicable(@NotNull LocalDataSource dataSource, @NotNull ApplicabilityLevel level) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return false;
    }

    @NotNull
    default public ApplicabilityLevel.Result getApplicability(@NotNull DatabaseConnectionPoint point, @NotNull ApplicabilityLevel level) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        LocalDataSource localDataSource = point.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
        if (!this.isApplicable(localDataSource, level)) {
            return ApplicabilityLevel.Result.NOT_APPLICABLE;
        }
        return level == ApplicabilityLevel.DEFAULT ? ApplicabilityLevel.Result.DEFAULT : ApplicabilityLevel.Result.APPLICABLE;
    }

    @Nullable
    default public Object loadAuthConfig(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials, boolean external) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return null;
    }

    default public void saveAuthConfig(@NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials, @Nullable Object data, boolean external) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
    }

    default public void setNewPassword(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, @Nullable String newPass) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
    }

    @Override
    @Nullable
    default public Object handleConnectionFailure(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, @NotNull Throwable e, boolean silent, int attempt, @NotNull Continuation<? super Boolean> $completion) {
        return DatabaseConnectionInterceptor.DatabaseAuthProvider.super.handleConnectionFailure(proto, e, silent, attempt, $completion);
    }

    @Deprecated(message="Use DatabaseConnectionConfig overload", replaceWith=@ReplaceWith(expression="createWidget", imports={}))
    @ApiStatus.ScheduledForRemoval
    @Nullable
    default public AuthWidget createWidget(@Nullable Project project, @NotNull DatabaseCredentials credentials, @NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return null;
    }

    @JvmStatic
    public static void copyAllCredentials(@NotNull DatabaseConnectionPoint from, @NotNull DatabaseCredentials fromStorage, @NotNull DatabaseConnectionConfig to, @NotNull DatabaseCredentials toStorage) {
        Companion.copyAllCredentials(from, fromStorage, to, toStorage);
    }

    @JvmStatic
    @NotNull
    public static List<DatabaseAuthProvider> getApplicable(@NotNull DatabaseConnectionPoint point) {
        return Companion.getApplicable(point);
    }

    @JvmStatic
    public static boolean isApplicable(@Nullable DatabaseAuthProvider ap, @NotNull DatabaseConnectionPoint point) {
        return Companion.isApplicable(ap, point);
    }

    @JvmStatic
    public static boolean isPreferred(@Nullable DatabaseAuthProvider ap, @NotNull DatabaseConnectionPoint point) {
        return Companion.isPreferred(ap, point);
    }

    @JvmStatic
    @Nullable
    public static DatabaseAuthProvider getPreferred(@NotNull DatabaseConnectionPoint point) {
        return Companion.getPreferred(point);
    }

    @JvmStatic
    @NotNull
    public static DatabaseAuthProvider getDefault(@NotNull DatabaseConnectionPoint point) {
        return Companion.getDefault(point);
    }

    @JvmStatic
    @Nullable
    public static DatabaseAuthProvider get(@NotNull String id) {
        return Companion.get(id);
    }

    @JvmStatic
    @NotNull
    public static DatabaseAuthProvider get(@NotNull DatabaseConnectionPoint point) {
        return Companion.get(point);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\bB\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel;", "", "", "<init>", "(Ljava/lang/String;I)V", "APPLICABLE", "DEFAULT", "PREFERRED", "Result", "intellij.database.core.impl"})
    public static final class ApplicabilityLevel
    extends Enum<ApplicabilityLevel>
    implements Comparable<ApplicabilityLevel> {
        public static final /* enum */ ApplicabilityLevel APPLICABLE = new ApplicabilityLevel();
        public static final /* enum */ ApplicabilityLevel DEFAULT = new ApplicabilityLevel();
        public static final /* enum */ ApplicabilityLevel PREFERRED = new ApplicabilityLevel();
        private static final /* synthetic */ ApplicabilityLevel[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ApplicabilityLevel[] values() {
            return (ApplicabilityLevel[])$VALUES.clone();
        }

        public static ApplicabilityLevel valueOf(String value) {
            return Enum.valueOf(ApplicabilityLevel.class, value);
        }

        @NotNull
        public static EnumEntries<ApplicabilityLevel> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = applicabilityLevelArray = new ApplicabilityLevel[]{ApplicabilityLevel.APPLICABLE, ApplicabilityLevel.DEFAULT, ApplicabilityLevel.PREFERRED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0010\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0002j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel$Result;", "", "", "<init>", "(Ljava/lang/String;I)V", "NOT_APPLICABLE", "APPLICABLE", "DEFAULT", "PREFERRED", "clamp", "level", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel;", "maxSupport", "intellij.database.core.impl"})
        public static final class Result
        extends Enum<Result>
        implements Comparable<Result> {
            public static final /* enum */ Result NOT_APPLICABLE = new Result();
            public static final /* enum */ Result APPLICABLE = new Result();
            public static final /* enum */ Result DEFAULT = new Result();
            public static final /* enum */ Result PREFERRED = new Result();
            private static final /* synthetic */ Result[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            @NotNull
            public final Result clamp(@NotNull ApplicabilityLevel level) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Result support = this.maxSupport(level);
                return this.compareTo((Enum)support) <= 0 ? this : support;
            }

            private final Result maxSupport(ApplicabilityLevel level) {
                return switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                    case 1 -> APPLICABLE;
                    case 2 -> DEFAULT;
                    case 3 -> PREFERRED;
                    default -> throw new NoWhenBranchMatchedException();
                };
            }

            public static Result[] values() {
                return (Result[])$VALUES.clone();
            }

            public static Result valueOf(String value) {
                return Enum.valueOf(Result.class, value);
            }

            @NotNull
            public static EnumEntries<Result> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = resultArray = new Result[]{Result.NOT_APPLICABLE, Result.APPLICABLE, Result.DEFAULT, Result.PREFERRED};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[ApplicabilityLevel.values().length];
                    try {
                        nArray[ApplicabilityLevel.APPLICABLE.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[ApplicabilityLevel.DEFAULT.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[ApplicabilityLevel.PREFERRED.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\nH&J\b\u0010\u0010\u001a\u00020\u0003H&J\b\u0010\u0011\u001a\u00020\u0003H&J\b\u0010\u0012\u001a\u00020\u0013H&J\b\u0010\u0014\u001a\u00020\u0013H&J\b\u0010\u0015\u001a\u00020\u0003H&J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H&J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH&J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\nH\u0017\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001e\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dataSource/DatabaseAuthProvider$AuthWidget;", "", "onChanged", "", "r", "Ljava/lang/Runnable;", "save", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "copyCredentials", "", "reset", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "resetCredentials", "isPasswordChanged", "hidePassword", "reloadCredentials", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "forceSave", "updateFromUrl", "holder", "Lcom/intellij/database/dataSource/url/template/ParametersHolder;", "updateUrl", "model", "Lcom/intellij/database/dataSource/url/template/MutableParametersHolder;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "intellij.database.core.impl"})
    public static interface AuthWidget {
        public void onChanged(@NotNull Runnable var1);

        default public void save(@NotNull DatabaseConnectionConfig config, boolean copyCredentials) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            if (config instanceof LocalDataSource) {
                LocalDataSource localDataSource = ((LocalDataSource)config).getDataSource();
                Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
                this.save(localDataSource, copyCredentials);
            }
        }

        default public void reset(@NotNull DatabaseConnectionPoint point, boolean resetCredentials) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            if (point instanceof LocalDataSource) {
                LocalDataSource localDataSource = ((LocalDataSource)point).getDataSource();
                Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
                this.reset(localDataSource, resetCredentials);
            }
        }

        public boolean isPasswordChanged();

        public void hidePassword();

        public void reloadCredentials();

        @NotNull
        public JComponent getComponent();

        @NotNull
        public JComponent getPreferredFocusedComponent();

        public void forceSave();

        public void updateFromUrl(@NotNull ParametersHolder var1);

        public void updateUrl(@NotNull MutableParametersHolder var1);

        @Deprecated(message="Use DatabaseConnectionConfig overload")
        @ApiStatus.ScheduledForRemoval
        default public void save(@NotNull LocalDataSource dataSource, boolean copyCredentials) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        }

        @Deprecated(message="Use DatabaseConnectionConfig overload")
        @ApiStatus.ScheduledForRemoval
        default public void reset(@NotNull LocalDataSource dataSource, boolean resetCredentials) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0007J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0007H\u0007J\u001a\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0007J\u001a\u0010\u0014\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0007J\u0018\u0010\u0015\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0007J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0007J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0007J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0007\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dataSource/DatabaseAuthProvider$Companion;", "", "<init>", "()V", "copyAllCredentials", "", "from", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "fromStorage", "Lcom/intellij/database/access/DatabaseCredentials;", "to", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "toStorage", "getApplicable", "", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "point", "isApplicable", "", "ap", "isPreferred", "isDefault", "getPreferred", "getDefault", "get", "id", "", "intellij.database.core.impl"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        public final void copyAllCredentials(@NotNull DatabaseConnectionPoint from, @NotNull DatabaseCredentials fromStorage, @NotNull DatabaseConnectionConfig to, @NotNull DatabaseCredentials toStorage) {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)fromStorage, (String)"fromStorage");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            Intrinsics.checkNotNullParameter((Object)toStorage, (String)"toStorage");
            DatabaseAuthProvider provider = this.get(from);
            Object c2 = provider.loadAuthConfig(from, fromStorage, true);
            provider.saveAuthConfig(to, toStorage, c2, true);
            LocalDataSource localDataSource = to.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            DasDataSource dasDataSource = localDataSource;
            LocalDataSource localDataSource2 = from.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource2, (String)"getDataSource(...)");
            toStorage.setSslPassphrase(dasDataSource, fromStorage.getSslPassphrase(localDataSource2));
        }

        @JvmStatic
        @NotNull
        public final List<DatabaseAuthProvider> getApplicable(@NotNull DatabaseConnectionPoint point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            List list = JBIterable.from((Iterable)DatabaseConnectionInterceptor.Companion.getEP_NAME().getExtensionsIfPointIsRegistered()).filter(DatabaseAuthProvider.class).filter(arg_0 -> Companion.getApplicable$lambda$0(point, arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
            return list;
        }

        @JvmStatic
        public final boolean isApplicable(@Nullable DatabaseAuthProvider ap, @NotNull DatabaseConnectionPoint point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            return ap != null && ap.getApplicability(point, ApplicabilityLevel.APPLICABLE) != ApplicabilityLevel.Result.NOT_APPLICABLE;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean isPreferred(@Nullable DatabaseAuthProvider ap, @NotNull DatabaseConnectionPoint point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            if (ap == null) return false;
            if (ap.getApplicability(point, ApplicabilityLevel.PREFERRED).compareTo((Enum)ApplicabilityLevel.Result.PREFERRED) < 0) return false;
            return true;
        }

        public final boolean isDefault(@Nullable DatabaseAuthProvider ap, @NotNull DatabaseConnectionPoint point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            return ap != null && ap.getApplicability(point, ApplicabilityLevel.DEFAULT).compareTo((Enum)ApplicabilityLevel.Result.DEFAULT) >= 0;
        }

        @JvmStatic
        @Nullable
        public final DatabaseAuthProvider getPreferred(@NotNull DatabaseConnectionPoint point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            return (DatabaseAuthProvider)DatabaseConnectionInterceptor.Companion.getEP_NAME().findFirstSafe(arg_0 -> Companion.getPreferred$lambda$1(point, arg_0));
        }

        @JvmStatic
        @NotNull
        public final DatabaseAuthProvider getDefault(@NotNull DatabaseConnectionPoint point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Object object = DatabaseConnectionInterceptor.Companion.getEP_NAME().findFirstSafe(arg_0 -> Companion.getDefault$lambda$3(arg_0 -> Companion.getDefault$lambda$2(point, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.database.dataSource.DatabaseAuthProvider");
            return (DatabaseAuthProvider)object;
        }

        @JvmStatic
        @Nullable
        public final DatabaseAuthProvider get(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return (DatabaseAuthProvider)DatabaseConnectionInterceptor.Companion.getEP_NAME().findFirstSafe(arg_0 -> Companion.get$lambda$5(arg_0 -> Companion.get$lambda$4(id, arg_0), arg_0));
        }

        @JvmStatic
        @NotNull
        public final DatabaseAuthProvider get(@NotNull DatabaseConnectionPoint point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            String string = point.getAuthProviderId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAuthProviderId(...)");
            DatabaseAuthProvider provider = this.get(string);
            if (provider != null) {
                return provider;
            }
            LocalDataSource localDataSource = point.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            LocalDataSource dataSource = localDataSource;
            DatabaseAuthProvider preferred = this.getPreferred(dataSource);
            DatabaseAuthProvider databaseAuthProvider = preferred;
            if (databaseAuthProvider == null) {
                databaseAuthProvider = this.getDefault(dataSource);
            }
            return databaseAuthProvider;
        }

        private static final boolean getApplicable$lambda$0(DatabaseConnectionPoint $point, DatabaseAuthProvider ap) {
            return $$INSTANCE.isApplicable(ap, $point);
        }

        private static final boolean getPreferred$lambda$1(DatabaseConnectionPoint $point, DatabaseConnectionInterceptor e) {
            return e instanceof DatabaseAuthProvider && $$INSTANCE.isPreferred((DatabaseAuthProvider)e, $point);
        }

        private static final boolean getDefault$lambda$2(DatabaseConnectionPoint $point, DatabaseConnectionInterceptor it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof DatabaseAuthProvider && $$INSTANCE.isDefault((DatabaseAuthProvider)it, $point);
        }

        private static final boolean getDefault$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean get$lambda$4(String $id, DatabaseConnectionInterceptor it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof DatabaseAuthProvider && Intrinsics.areEqual((Object)((DatabaseAuthProvider)it).getId(), (Object)$id);
        }

        private static final boolean get$lambda$5(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

