/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.lang.javascript.JSLexerUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.JSTagOrGenericsFlowHelper;
import com.intellij.lexer.FlexLexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003-./B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J3\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0015\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J1\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00052\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0015\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u001aJ1\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00052\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0015\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u001aJ<\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\u001e\u001a\u00020\u00052\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0007J.\u0010!\u001a\u00020\"2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010#\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010$\u001a\u00020\bH\u0007J>\u0010!\u001a\u00020\"2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010#\u001a\u0004\u0018\u00010\u001d2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0007J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\"\u0010'\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010(\u001a\u00020\u0005H\u0007J\u0018\u0010)\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0010\u0010*\u001a\u00020\b2\b\u0010+\u001a\u0004\u0018\u00010\u0010J\u0018\u0010,\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/lang/javascript/parsing/JSTagOrGenericUtil;", "", "<init>", "()V", "MAX_RECURSION_LEVEL", "", "CLOSING_TAG_LOOKAHEAD", "recursion_guard_", "", "state", "Lcom/intellij/lang/javascript/parsing/JSTagOrGenericUtil$State;", "level", "funcName", "", "nextTokenIs", "token", "Lcom/intellij/psi/tree/IElementType;", "tokenSet", "Lcom/intellij/psi/tree/TokenSet;", "frameName", "tokens", "", "(Lcom/intellij/lang/javascript/parsing/JSTagOrGenericUtil$State;Ljava/lang/String;[Ljava/lang/Object;)Z", "consumeToken", "parseTokens", "pin", "(Lcom/intellij/lang/javascript/parsing/JSTagOrGenericUtil$State;I[Ljava/lang/Object;)Z", "consumeTokens", "enter_section_", "Lcom/intellij/lang/javascript/parsing/JSTagOrGenericUtil$Marker;", "modifiers", "elementType", "Lcom/intellij/lang/javascript/parsing/JSTagOrGenericUtil$ElementType;", "exit_section_", "", "marker", "result", "pinned", "current_position_", "empty_element_parsed_guard_", "pos", "parseFlowParameterList", "startsWithDiv", "next", "parseContentAndClosingTag", "State", "Marker", "ElementType", "intellij.javascript.parser"})
@SourceDebugExtension(value={"SMAP\nJSTagOrGenericUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSTagOrGenericUtil.kt\ncom/intellij/lang/javascript/parsing/JSTagOrGenericUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,301:1\n14#2:302\n*S KotlinDebug\n*F\n+ 1 JSTagOrGenericUtil.kt\ncom/intellij/lang/javascript/parsing/JSTagOrGenericUtil\n*L\n24#1:302\n*E\n"})
public final class JSTagOrGenericUtil {
    @NotNull
    public static final JSTagOrGenericUtil INSTANCE = new JSTagOrGenericUtil();
    private static final int MAX_RECURSION_LEVEL = 1000;
    private static final int CLOSING_TAG_LOOKAHEAD = 20;

    private JSTagOrGenericUtil() {
    }

    @JvmStatic
    public static final boolean recursion_guard_(@Nullable State state, int level, @Nullable String funcName) {
        if (level > 1000) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(JSTagOrGenericUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            Object[] objectArray = new Object[]{1000, funcName};
            logger.warn(AnalysisBundle.message((String)"parsing.error.maximum.recursion.level.reached.in", (Object[])objectArray));
            return false;
        }
        return true;
    }

    public final boolean nextTokenIs(@NotNull State state, @NotNull IElementType token) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return state.nextTokenIs(token);
    }

    @JvmStatic
    public static final boolean nextTokenIs(@NotNull State state, @NotNull TokenSet tokenSet) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)tokenSet, (String)"tokenSet");
        return state.nextTokenIs(tokenSet);
    }

    @JvmStatic
    public static final boolean nextTokenIs(@NotNull State state, @Nullable String frameName, Object ... tokens) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        for (Object token : tokens) {
            if (token instanceof IElementType) {
                if (!state.nextTokenIs((IElementType)token)) continue;
                return true;
            }
            Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type com.intellij.psi.tree.TokenSet");
            if (!state.nextTokenIs((TokenSet)token)) continue;
            return true;
        }
        return false;
    }

    @JvmStatic
    public static final boolean consumeToken(@NotNull State state, @NotNull IElementType token) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        if (state.nextTokenIs(token)) {
            state.advanceLexer();
            return true;
        }
        return false;
    }

    @JvmStatic
    public static final boolean consumeToken(@NotNull State state, @NotNull TokenSet tokenSet) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)tokenSet, (String)"tokenSet");
        if (state.nextTokenIs(tokenSet)) {
            state.advanceLexer();
            return true;
        }
        return false;
    }

    @JvmStatic
    public static final boolean parseTokens(@NotNull State state, int pin, Object ... tokens) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Marker mark = state.mark(null);
        boolean result = JSTagOrGenericUtil.consumeTokens(state, pin, Arrays.copyOf(tokens, tokens.length));
        if (result) {
            mark.drop();
        } else {
            mark.rollbackTo();
        }
        return result;
    }

    @JvmStatic
    public static final boolean consumeTokens(@NotNull State state, int pin, Object ... tokens) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        for (Object token : tokens) {
            if (token instanceof IElementType) {
                if (JSTagOrGenericUtil.consumeToken(state, (IElementType)token)) continue;
                return false;
            }
            Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type com.intellij.psi.tree.TokenSet");
            if (JSTagOrGenericUtil.consumeToken(state, (TokenSet)token)) continue;
            return false;
        }
        return true;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Marker enter_section_(@NotNull State state, int level, int modifiers, @Nullable ElementType elementType, @Nullable String frameName) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return state.mark(elementType);
    }

    public static /* synthetic */ Marker enter_section_$default(State state, int n, int n2, ElementType elementType, String string, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = -1;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        if ((n3 & 8) != 0) {
            elementType = null;
        }
        if ((n3 & 0x10) != 0) {
            string = "";
        }
        return JSTagOrGenericUtil.enter_section_(state, n, n2, elementType, string);
    }

    @JvmStatic
    public static final void exit_section_(@Nullable State state, @Nullable Marker marker, @Nullable ElementType elementType, boolean result) {
        JSTagOrGenericUtil.exit_section_(state, -1, marker, result, false, elementType);
    }

    @JvmStatic
    public static final void exit_section_(@Nullable State state, int level, @Nullable Marker marker, boolean result, boolean pinned, @Nullable ElementType elementType) {
        if (marker == null) {
            return;
        }
        if (result) {
            marker.done(elementType);
        } else {
            marker.rollbackTo();
        }
    }

    @JvmStatic
    public static final int current_position_(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return state.getOffset();
    }

    @JvmStatic
    public static final boolean empty_element_parsed_guard_(@NotNull State state, @Nullable String funcName, int pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return pos != JSTagOrGenericUtil.current_position_(state);
    }

    @JvmStatic
    public static final boolean parseFlowParameterList(@NotNull State state, int level) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return JSTagOrGenericsFlowHelper.parseFlowParameterList(state);
    }

    public final boolean startsWithDiv(@Nullable IElementType next) {
        return next == JSTokenTypes.REGEXP_LITERAL || next == JSTokenTypes.DIV;
    }

    @JvmStatic
    public static final boolean parseContentAndClosingTag(@NotNull State state, int level) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        boolean wasLt = false;
        for (int i = 0; i < 20; ++i) {
            IElementType token = state.getCurrentToken();
            if (token == JSTokenTypes.XML_END_TAG_START) {
                return true;
            }
            if (token == JSTokenTypes.LT) {
                wasLt = true;
            } else if (INSTANCE.startsWithDiv(token)) {
                if (wasLt) {
                    return true;
                }
            } else {
                wasLt = false;
            }
            state.advanceLexer();
        }
        return false;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Marker enter_section_(@NotNull State state, int level, int modifiers, @Nullable ElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return JSTagOrGenericUtil.enter_section_$default(state, level, modifiers, elementType, null, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Marker enter_section_(@NotNull State state, int level, int modifiers) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return JSTagOrGenericUtil.enter_section_$default(state, level, modifiers, null, null, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Marker enter_section_(@NotNull State state, int level) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return JSTagOrGenericUtil.enter_section_$default(state, level, 0, null, null, 28, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Marker enter_section_(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return JSTagOrGenericUtil.enter_section_$default(state, 0, 0, null, null, 30, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/lang/javascript/parsing/JSTagOrGenericUtil$ElementType;", "", "<init>", "(Ljava/lang/String;I)V", "GENERICS", "TAG_OR_GENERICS", "intellij.javascript.parser"})
    public static final class ElementType
    extends Enum<ElementType> {
        public static final /* enum */ ElementType GENERICS = new ElementType();
        public static final /* enum */ ElementType TAG_OR_GENERICS = new ElementType();
        private static final /* synthetic */ ElementType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ElementType[] values() {
            return (ElementType[])$VALUES.clone();
        }

        public static ElementType valueOf(String value) {
            return Enum.valueOf(ElementType.class, value);
        }

        @NotNull
        public static EnumEntries<ElementType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = elementTypeArray = new ElementType[]{ElementType.GENERICS, ElementType.TAG_OR_GENERICS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/javascript/parsing/JSTagOrGenericUtil$Marker;", "", "state", "Lcom/intellij/lang/javascript/parsing/JSTagOrGenericUtil$State;", "elementType", "Lcom/intellij/lang/javascript/parsing/JSTagOrGenericUtil$ElementType;", "<init>", "(Lcom/intellij/lang/javascript/parsing/JSTagOrGenericUtil$State;Lcom/intellij/lang/javascript/parsing/JSTagOrGenericUtil$ElementType;)V", "offset", "", "drop", "", "rollbackTo", "done", "type", "intellij.javascript.parser"})
    public static final class Marker {
        @NotNull
        private final State state;
        @Nullable
        private final ElementType elementType;
        private final int offset;

        public Marker(@NotNull State state, @Nullable ElementType elementType) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.state = state;
            this.elementType = elementType;
            this.offset = this.state.getOffset();
        }

        public final void drop() {
        }

        public final void rollbackTo() {
            this.state.setOffset(this.offset);
        }

        public final void done(@Nullable ElementType type) {
            ElementType elementType = type;
            if (elementType == null && (elementType = this.elementType) == null) {
                return;
            }
            ElementType lastElementType = elementType;
            this.state.setLastElementType(lastElementType);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0013\u0010 \u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/intellij/lang/javascript/parsing/JSTagOrGenericUtil$State;", "", "lexer", "Lcom/intellij/lexer/FlexLexer;", "<init>", "(Lcom/intellij/lexer/FlexLexer;)V", "tokens", "", "Lcom/intellij/psi/tree/IElementType;", "offset", "", "getOffset", "()I", "setOffset", "(I)V", "lastElementType", "Lcom/intellij/lang/javascript/parsing/JSTagOrGenericUtil$ElementType;", "getLastElementType", "()Lcom/intellij/lang/javascript/parsing/JSTagOrGenericUtil$ElementType;", "setLastElementType", "(Lcom/intellij/lang/javascript/parsing/JSTagOrGenericUtil$ElementType;)V", "mark", "Lcom/intellij/lang/javascript/parsing/JSTagOrGenericUtil$Marker;", "elementType", "nextTokenIs", "", "token", "tokenSet", "Lcom/intellij/psi/tree/TokenSet;", "advanceLexer", "", "prepareNextToken", "currentToken", "getCurrentToken", "()Lcom/intellij/psi/tree/IElementType;", "intellij.javascript.parser"})
    public static final class State {
        @NotNull
        private final FlexLexer lexer;
        @NotNull
        private final List<IElementType> tokens;
        private int offset;
        @Nullable
        private ElementType lastElementType;

        public State(@NotNull FlexLexer lexer) {
            Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
            this.lexer = lexer;
            this.tokens = new ArrayList();
        }

        public final int getOffset() {
            return this.offset;
        }

        public final void setOffset(int n) {
            this.offset = n;
        }

        @Nullable
        public final ElementType getLastElementType() {
            return this.lastElementType;
        }

        public final void setLastElementType(@Nullable ElementType elementType) {
            this.lastElementType = elementType;
        }

        @NotNull
        public final Marker mark(@Nullable ElementType elementType) {
            return new Marker(this, elementType);
        }

        public final boolean nextTokenIs(@NotNull IElementType token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            this.prepareNextToken();
            return this.tokens.get(this.offset) == token;
        }

        public final boolean nextTokenIs(@NotNull TokenSet tokenSet) {
            Intrinsics.checkNotNullParameter((Object)tokenSet, (String)"tokenSet");
            this.prepareNextToken();
            return tokenSet.contains(this.tokens.get(this.offset));
        }

        public final void advanceLexer() {
            this.prepareNextToken();
            int n = this.offset;
            this.offset = n + 1;
        }

        private final void prepareNextToken() {
            if (this.offset == this.tokens.size()) {
                try {
                    IElementType type = JSLexerUtil.skipCommentsAndWhitespaces(this.lexer);
                    this.tokens.add(type);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Nullable
        public final IElementType getCurrentToken() {
            this.prepareNextToken();
            return this.tokens.get(this.offset);
        }
    }
}

