/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.psi;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6ExpressionParser;
import com.intellij.lang.javascript.BasicJavaScriptStubElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptPsiTypeParser;
import com.intellij.lang.javascript.ecmascript6.parsing.jsx.JSXExpressionParser;
import com.intellij.lang.javascript.ecmascript6.parsing.jsx.JSXParser;
import com.intellij.lang.javascript.flow.psi.FlowJSParser;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0014J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u001e\u0010\u0015\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\fH\u0014J\b\u0010\u001a\u001a\u00020\u0014H\u0016R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u001b\u001a\u00020\u001c8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/lang/javascript/flow/psi/FlowJSExpressionParser;", "Lcom/intellij/lang/javascript/ecmascript6/parsing/jsx/JSXExpressionParser;", "Lcom/intellij/lang/javascript/flow/psi/FlowJSParser;", "parser", "<init>", "(Lcom/intellij/lang/javascript/flow/psi/FlowJSParser;)V", "value", "", "parenthesizedLevel", "getParenthesizedLevel", "()I", "parseUnaryExpression", "", "getCurrentBinarySignPriority", "allowIn", "advance", "isFunctionPropertyStart", "builder", "Lcom/intellij/lang/PsiBuilder;", "parseDestructuringArrayElement", "", "parseDialectSpecificMemberExpressionPart", "markerRef", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/lang/PsiBuilder$Marker;", "isInExtendsOrImplementsList", "parseParenthesizedExpression", "functionPropertyElementType", "Lcom/intellij/psi/tree/IElementType;", "getFunctionPropertyElementType", "()Lcom/intellij/psi/tree/IElementType;", "intellij.javascript.parser"})
public final class FlowJSExpressionParser
extends JSXExpressionParser<FlowJSParser> {
    private int parenthesizedLevel;

    public FlowJSExpressionParser(@NotNull FlowJSParser parser) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        super((JSXParser)parser);
    }

    public final int getParenthesizedLevel() {
        return this.parenthesizedLevel;
    }

    @Override
    protected boolean parseUnaryExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.LT && ((FlowJSParser)this.parser).getFunctionParser().parseArrowFunction()) {
            return true;
        }
        return super.parseUnaryExpression();
    }

    @Override
    protected int getCurrentBinarySignPriority(boolean allowIn, boolean advance) {
        int x = ES6ExpressionParser.Companion.collapseGtAndGetPriority(advance, this.builder);
        if (x > 0) {
            return x;
        }
        return super.getCurrentBinarySignPriority(allowIn, advance);
    }

    @Override
    protected boolean isFunctionPropertyStart(@NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return JSKeywordSets.PROPERTY_NAMES.contains(builder.getTokenType()) && builder.lookAhead(1) == JSTokenTypes.LT || super.isFunctionPropertyStart(builder);
    }

    @Override
    protected void parseDestructuringArrayElement() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker arrayElement = marker;
        if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
            this.parseDestructuringRestElementNoMarker(true);
            arrayElement.done(BasicJavaScriptStubElementTypes.DESTRUCTURING_ARRAY_REST);
            return;
        }
        arrayElement.done(this.parseDestructuringElementNoMarker(true, false));
    }

    @Override
    protected boolean parseDialectSpecificMemberExpressionPart(@NotNull Ref<PsiBuilder.Marker> markerRef, boolean isInExtendsOrImplementsList) {
        Intrinsics.checkNotNullParameter(markerRef, (String)"markerRef");
        if (((TypeScriptPsiTypeParser)((FlowJSParser)this.parser).getTypeParser()).parseOptionalTypeArgumentListInExpression()) {
            return true;
        }
        return super.parseDialectSpecificMemberExpressionPart(markerRef, isInExtendsOrImplementsList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseParenthesizedExpression() {
        int n;
        try {
            n = this.parenthesizedLevel;
            this.parenthesizedLevel = n + 1;
            super.parseParenthesizedExpression();
        }
        finally {
            n = this.parenthesizedLevel;
            this.parenthesizedLevel = n + -1;
        }
    }

    @Override
    @NotNull
    protected IElementType getFunctionPropertyElementType() {
        return BasicJavaScriptStubElementTypes.TYPESCRIPT_FUNCTION_PROPERTY;
    }
}

