/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.impl.JsonRecursiveElementVisitor;
import com.intellij.jsonpath.JsonPathBundle;
import com.intellij.jsonpath.psi.JsonPathId;
import com.intellij.jsonpath.psi.JsonPathIdSegment;
import com.intellij.jsonpath.psi.JsonPathVisitor;
import com.intellij.jsonpath.ui.JsonPathEvaluateManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

final class JsonPathEvaluateUnknownKeyInspection
extends LocalInspectionTool {
    JsonPathEvaluateUnknownKeyInspection() {
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Supplier jsonFileSupplier;
        JsonFile sourceFile;
        if (holder == null) {
            JsonPathEvaluateUnknownKeyInspection.$$$reportNull$$$0(0);
        }
        JsonFile jsonFile = sourceFile = (jsonFileSupplier = (Supplier)holder.getFile().getUserData(JsonPathEvaluateManager.JSON_PATH_EVALUATE_SOURCE_KEY)) != null ? (JsonFile)jsonFileSupplier.get() : null;
        if (sourceFile == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JsonPathEvaluateUnknownKeyInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        final NotNullLazyValue allKeys = NotNullLazyValue.lazy(() -> this.collectAllKeysFromFile(sourceFile));
        return new JsonPathVisitor(){

            @Override
            public void visitIdSegment(@NotNull JsonPathIdSegment segment) {
                if (segment == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitIdSegment(segment);
                JsonPathId identifier = segment.getId();
                String idString = identifier.getText();
                if (StringUtil.isNotEmpty((String)idString) && !((Set)allKeys.getValue()).contains(idString)) {
                    holder.registerProblem((PsiElement)identifier, null, JsonPathBundle.message("inspection.message.jsonpath.unknown.key", idString), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segment", "com/intellij/jsonpath/inspections/JsonPathEvaluateUnknownKeyInspection$1", "visitIdSegment"));
            }
        };
    }

    private Set<String> collectAllKeysFromFile(JsonFile file) {
        final HashSet<String> propertyNames = new HashSet<String>();
        file.accept((PsiElementVisitor)new JsonRecursiveElementVisitor(){

            public void visitProperty(@NotNull JsonProperty o) {
                if (o == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitProperty(o);
                propertyNames.add(o.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jsonpath/inspections/JsonPathEvaluateUnknownKeyInspection$2", "visitProperty"));
            }
        });
        return propertyNames;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsonpath/inspections/JsonPathEvaluateUnknownKeyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsonpath/inspections/JsonPathEvaluateUnknownKeyInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

