/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.postman.converter;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.postman.converter.HttpClientPostmanComponentBrowseButton;
import com.intellij.httpClient.postman.converter.PostmanConvertDialogKt;
import com.intellij.httpClient.postman.converter.PostmanFile;
import com.intellij.httpClient.postman.converter.PostmanFileCheckerKt;
import com.intellij.httpClient.postman.converter.action.ConvertPostmanCollectionService;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicateKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/httpClient/postman/converter/PostmanConvertDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "projectPostmanFiles", "", "Lcom/intellij/httpClient/postman/converter/PostmanFile;", "collectionVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/vfs/VirtualFile;)V", "postmanFilePathField", "Lcom/intellij/httpClient/postman/converter/HttpClientPostmanComponentBrowseButton;", "postmanEnvFilePathField", "envCheckbox", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/ui/components/JBCheckBox;", "possibleCollectionFiles", "doOKAction", "", "createCenterPanel", "Ljavax/swing/JComponent;", "findMostSuitableEnv", "history", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "getHelpId", "", "setHelpTooltip", "helpButton", "Ljavax/swing/JButton;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nPostmanConvertDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostmanConvertDialog.kt\ncom/intellij/httpClient/postman/converter/PostmanConvertDialog\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,315:1\n30#2,2:316\n295#3,2:318\n295#3,2:320\n774#3:322\n865#3,2:323\n774#3:326\n865#3,2:327\n1#4:325\n*S KotlinDebug\n*F\n+ 1 PostmanConvertDialog.kt\ncom/intellij/httpClient/postman/converter/PostmanConvertDialog\n*L\n97#1:316,2\n137#1:318,2\n145#1:320,2\n108#1:322\n108#1:323,2\n124#1:326\n124#1:327,2\n*E\n"})
final class PostmanConvertDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @Nullable
    private final VirtualFile collectionVirtualFile;
    private HttpClientPostmanComponentBrowseButton postmanFilePathField;
    private HttpClientPostmanComponentBrowseButton postmanEnvFilePathField;
    private Cell<? extends JBCheckBox> envCheckbox;
    @NotNull
    private final List<PostmanFile> possibleCollectionFiles;

    public PostmanConvertDialog(@NotNull Project project, @NotNull List<PostmanFile> projectPostmanFiles, @Nullable VirtualFile collectionVirtualFile) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(projectPostmanFiles, (String)"projectPostmanFiles");
        super(project);
        this.project = project;
        this.collectionVirtualFile = collectionVirtualFile;
        PostmanConvertDialog postmanConvertDialog = this;
        Collection collection2 = projectPostmanFiles;
        if (collection2.isEmpty()) {
            PostmanConvertDialog postmanConvertDialog2 = postmanConvertDialog;
            boolean bl = false;
            VirtualFile rootDir = this.project.getProjectFile();
            String view = this.project.getBasePath();
            collection = rootDir == null || view == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new PostmanFile(rootDir, view, this.project));
            postmanConvertDialog = postmanConvertDialog2;
        } else {
            collection = collection2;
        }
        postmanConvertDialog.possibleCollectionFiles = (List)collection;
        this.setOKButtonText(RestClientBundle.message("http.client.postman.converter.convert.dialog.button.text", new Object[0]));
        this.setTitle(RestClientBundle.message("http.client.postman.converter.convert.dialog.title", new Object[0]));
        super.init();
    }

    public /* synthetic */ PostmanConvertDialog(Project project, List list2, VirtualFile virtualFile, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            virtualFile = null;
        }
        this(project, list2, virtualFile);
    }

    protected void doOKAction() {
        PostmanFile postmanFile;
        HttpClientPostmanComponentBrowseButton httpClientPostmanComponentBrowseButton;
        VirtualFile environmentFile;
        Cell<? extends JBCheckBox> cell = this.envCheckbox;
        if (cell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"envCheckbox");
            cell = null;
        }
        if (((JBCheckBox)cell.getComponent()).isSelected()) {
            HttpClientPostmanComponentBrowseButton httpClientPostmanComponentBrowseButton2 = this.postmanEnvFilePathField;
            if (httpClientPostmanComponentBrowseButton2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"postmanEnvFilePathField");
                httpClientPostmanComponentBrowseButton2 = null;
            }
            PostmanFile postmanFile2 = httpClientPostmanComponentBrowseButton2.getSelectedPath();
            v3 = postmanFile2 != null ? postmanFile2.getVirtualFile() : null;
        } else {
            v3 = environmentFile = null;
        }
        if ((httpClientPostmanComponentBrowseButton = this.postmanFilePathField) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"postmanFilePathField");
            httpClientPostmanComponentBrowseButton = null;
        }
        if ((postmanFile = httpClientPostmanComponentBrowseButton.getSelectedPath()) != null && (postmanFile = postmanFile.getVirtualFile()) != null) {
            PostmanFile it = postmanFile;
            boolean bl = false;
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<ConvertPostmanCollectionService> serviceClass$iv = ConvertPostmanCollectionService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((ConvertPostmanCollectionService)object).convert((VirtualFile)it, environmentFile);
        }
        super.doOKAction();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JBPanel jBPanel = ((DialogPanel)BuilderKt.panel(arg_0 -> PostmanConvertDialog.createCenterPanel$lambda$11(this, arg_0)).withPreferredWidth(600)).withMinimumWidth(20);
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel, (String)"withMinimumWidth(...)");
        return (JComponent)jBPanel;
    }

    private final PostmanFile findMostSuitableEnv(VirtualFile collectionVirtualFile, List<PostmanFile> history) {
        PostmanFile postmanFile;
        block13: {
            block12: {
                Object v8;
                block11: {
                    PostmanFile selectedPath;
                    PostmanFile collectionFileEnv;
                    PostmanFile postmanFile2;
                    VirtualFile virtualFile = collectionVirtualFile;
                    if (virtualFile != null) {
                        Object v3;
                        block10: {
                            VirtualFile collectionFile = virtualFile;
                            boolean bl = false;
                            String string = collectionFile.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                            String collectionName = StringsKt.substringBefore$default((String)string, (String)".postman_collection", null, (int)2, null);
                            Iterable $this$firstOrNull$iv = history;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                PostmanFile envFile = (PostmanFile)element$iv;
                                boolean bl2 = false;
                                String string2 = envFile.getVirtualFile().getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                                if (!StringsKt.startsWith$default((String)string2, (String)collectionName, (boolean)false, (int)2, null)) continue;
                                v3 = element$iv;
                                break block10;
                            }
                            v3 = null;
                        }
                        postmanFile2 = v3;
                    } else {
                        postmanFile2 = null;
                    }
                    PostmanFile postmanFile3 = collectionFileEnv = postmanFile2;
                    if (postmanFile3 != null) {
                        return postmanFile3;
                    }
                    HttpClientPostmanComponentBrowseButton httpClientPostmanComponentBrowseButton = this.postmanFilePathField;
                    if (httpClientPostmanComponentBrowseButton == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"postmanFilePathField");
                        httpClientPostmanComponentBrowseButton = null;
                    }
                    if ((postmanFile = (selectedPath = httpClientPostmanComponentBrowseButton.getSelectedPath())) == null) break block12;
                    PostmanFile it = postmanFile;
                    boolean bl = false;
                    VirtualFile directory = it.getVirtualFile().getParent();
                    Iterable $this$firstOrNull$iv = history;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PostmanFile history2 = (PostmanFile)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)history2.getVirtualFile().getParent(), (Object)directory)) continue;
                        v8 = element$iv;
                        break block11;
                    }
                    v8 = null;
                }
                PostmanFile postmanFile4 = v8;
                postmanFile = postmanFile4;
                if (postmanFile4 != null) break block13;
            }
            postmanFile = (PostmanFile)CollectionsKt.firstOrNull(history);
        }
        return postmanFile;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        PostmanFile postmanFile;
        HttpClientPostmanComponentBrowseButton httpClientPostmanComponentBrowseButton = this.postmanFilePathField;
        if (httpClientPostmanComponentBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"postmanFilePathField");
            httpClientPostmanComponentBrowseButton = null;
        }
        if ((postmanFile = httpClientPostmanComponentBrowseButton.getSelectedPath()) == null || (postmanFile = postmanFile.getVirtualFile()) == null) {
            return null;
        }
        PostmanFile virtualFile = postmanFile;
        if (!PostmanFileCheckerKt.isPostmanFile(this.project, (VirtualFile)virtualFile)) {
            Object[] objectArray = new Object[]{virtualFile};
            return new ValidationInfo(RestClientBundle.message("http.client.postman.converter.convert.dialog.validation.error.invalid.collection.file.text", objectArray));
        }
        Cell<? extends JBCheckBox> cell = this.envCheckbox;
        if (cell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"envCheckbox");
            cell = null;
        }
        if (((JBCheckBox)cell.getComponent()).isSelected()) {
            VirtualFile envFile;
            HttpClientPostmanComponentBrowseButton httpClientPostmanComponentBrowseButton2 = this.postmanEnvFilePathField;
            if (httpClientPostmanComponentBrowseButton2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"postmanEnvFilePathField");
                httpClientPostmanComponentBrowseButton2 = null;
            }
            PostmanFile postmanFile2 = httpClientPostmanComponentBrowseButton2.getSelectedPath();
            Object object = envFile = postmanFile2 != null ? postmanFile2.getVirtualFile() : null;
            if (envFile != null && !PostmanFileCheckerKt.isPostmanEnvironmentFile(this.project, envFile)) {
                Object[] objectArray = new Object[]{envFile};
                return new ValidationInfo(RestClientBundle.message("http.client.postman.converter.convert.dialog.validation.error.invalid.environment.file.text", objectArray));
            }
        }
        return super.doValidate();
    }

    @NotNull
    protected String getHelpId() {
        return "Postman.Import.getting-started#exporting-collections-from-postman";
    }

    protected void setHelpTooltip(@NotNull JButton helpButton) {
        Intrinsics.checkNotNullParameter((Object)helpButton, (String)"helpButton");
        helpButton.setToolTipText(RestClientBundle.message("http.client.postman.converter.dialog.help.tooltip", new Object[0]));
    }

    private static final Unit createCenterPanel$lambda$11$lambda$2(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = RestClientBundle.message("http.client.postman.converter.convert.dialog.label.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$11$lambda$6(PostmanConvertDialog this$0, Row $this$row) {
        HttpClientPostmanComponentBrowseButton httpClientPostmanComponentBrowseButton;
        PostmanFile selectedPath;
        PostmanFile postmanFile;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.postmanFilePathField = new HttpClientPostmanComponentBrowseButton(this$0.project, true);
        Iterable $this$filter$iv = this$0.possibleCollectionFiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PostmanFile it = (PostmanFile)element$iv$iv;
            boolean bl = false;
            if (!PostmanFileCheckerKt.isPostmanCollectionFile(this$0.project, it.getVirtualFile())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List history = (List)destination$iv$iv;
        VirtualFile virtualFile = this$0.collectionVirtualFile;
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            String string = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            postmanFile = new PostmanFile(it, PostmanConvertDialogKt.access$toView(string, this$0.project.getBasePath()), this$0.project);
        } else {
            postmanFile = (PostmanFile)CollectionsKt.firstOrNull((List)history);
        }
        PostmanFile postmanFile2 = selectedPath = postmanFile;
        if (postmanFile2 != null) {
            PostmanFile it = postmanFile2;
            boolean bl = false;
            HttpClientPostmanComponentBrowseButton httpClientPostmanComponentBrowseButton2 = this$0.postmanFilePathField;
            if (httpClientPostmanComponentBrowseButton2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"postmanFilePathField");
                httpClientPostmanComponentBrowseButton2 = null;
            }
            httpClientPostmanComponentBrowseButton2.setSelectedPath(it);
        }
        if ((httpClientPostmanComponentBrowseButton = this$0.postmanFilePathField) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"postmanFilePathField");
            httpClientPostmanComponentBrowseButton = null;
        }
        httpClientPostmanComponentBrowseButton.setHistory(history);
        HttpClientPostmanComponentBrowseButton httpClientPostmanComponentBrowseButton3 = this$0.postmanFilePathField;
        if (httpClientPostmanComponentBrowseButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"postmanFilePathField");
            httpClientPostmanComponentBrowseButton3 = null;
        }
        $this$row.cell((JComponent)((Object)httpClientPostmanComponentBrowseButton3)).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$11$lambda$7(PostmanConvertDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = RestClientBundle.message("http.client.postman.converter.convert.dialog.checkbox.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.envCheckbox = $this$row.checkBox(string);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$11$lambda$10(PostmanConvertDialog this$0, Row $this$row) {
        HttpClientPostmanComponentBrowseButton httpClientPostmanComponentBrowseButton;
        PostmanFile suitableEnv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.postmanEnvFilePathField = new HttpClientPostmanComponentBrowseButton(this$0.project, false);
        Iterable $this$filter$iv = this$0.possibleCollectionFiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PostmanFile it = (PostmanFile)element$iv$iv;
            boolean bl = false;
            if (!PostmanFileCheckerKt.isPostmanEnvironmentFile(this$0.project, it.getVirtualFile())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List history = (List)destination$iv$iv;
        PostmanFile postmanFile = suitableEnv = this$0.findMostSuitableEnv(this$0.collectionVirtualFile, history);
        if (postmanFile != null) {
            PostmanFile it = postmanFile;
            boolean bl = false;
            HttpClientPostmanComponentBrowseButton httpClientPostmanComponentBrowseButton2 = this$0.postmanEnvFilePathField;
            if (httpClientPostmanComponentBrowseButton2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"postmanEnvFilePathField");
                httpClientPostmanComponentBrowseButton2 = null;
            }
            httpClientPostmanComponentBrowseButton2.setSelectedPath(it);
        }
        if ((httpClientPostmanComponentBrowseButton = this$0.postmanEnvFilePathField) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"postmanEnvFilePathField");
            httpClientPostmanComponentBrowseButton = null;
        }
        httpClientPostmanComponentBrowseButton.setHistory(history);
        HttpClientPostmanComponentBrowseButton httpClientPostmanComponentBrowseButton3 = this$0.postmanEnvFilePathField;
        if (httpClientPostmanComponentBrowseButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"postmanEnvFilePathField");
            httpClientPostmanComponentBrowseButton3 = null;
        }
        $this$row.cell((JComponent)((Object)httpClientPostmanComponentBrowseButton3)).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$11(PostmanConvertDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, PostmanConvertDialog::createCenterPanel$lambda$11$lambda$2, (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PostmanConvertDialog.createCenterPanel$lambda$11$lambda$6(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PostmanConvertDialog.createCenterPanel$lambda$11$lambda$7(this$0, arg_0), (int)1, null);
        Row row = Panel.row$default((Panel)$this$panel, null, arg_0 -> PostmanConvertDialog.createCenterPanel$lambda$11$lambda$10(this$0, arg_0), (int)1, null);
        Cell<? extends JBCheckBox> cell = this$0.envCheckbox;
        if (cell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"envCheckbox");
            cell = null;
        }
        row.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)cell.getComponent())));
        return Unit.INSTANCE;
    }
}

