/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.ssl;

import com.intellij.httpClient.execution.HttpClientExecutorBundle;
import com.intellij.httpClient.execution.ssl.HttpRequestSslConfigurationException;
import com.intellij.httpClient.execution.ssl.PemHelper;
import com.intellij.httpClient.execution.ssl.SslCertStore;
import com.intellij.httpClient.execution.ssl.SslConfigurationContext;
import com.intellij.httpClient.execution.ssl.SslErrorDescriptor;
import com.intellij.httpClient.execution.ssl.SslFilesFormatGuessStrategy;
import com.intellij.util.containers.UtilKt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH \u00a2\u0006\u0002\b\u000fj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/httpClient/execution/ssl/CertificateFormat;", "", "<init>", "(Ljava/lang/String;I)V", "PEM", "P12", "DER", "readToStore", "Lcom/intellij/httpClient/execution/ssl/SslCertStore;", "path", "Ljava/nio/file/Path;", "context", "Lcom/intellij/httpClient/execution/ssl/SslConfigurationContext;", "passphrase", "", "readToStore$intellij_httpClient_executor", "Companion", "intellij.httpClient.executor"})
public abstract class CertificateFormat
extends Enum<CertificateFormat> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final String guessExplanation;
    @NotNull
    private static final String CERTIFICATE_TYPE = "X.509";
    @NotNull
    private static final String PKCS_12_STORE = "PKCS12";
    public static final /* enum */ CertificateFormat PEM;
    public static final /* enum */ CertificateFormat P12;
    public static final /* enum */ CertificateFormat DER;
    private static final /* synthetic */ CertificateFormat[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private CertificateFormat() {
    }

    @NotNull
    public abstract SslCertStore readToStore$intellij_httpClient_executor(@NotNull Path var1, @NotNull SslConfigurationContext var2, @Nullable String var3) throws HttpRequestSslConfigurationException;

    public static CertificateFormat[] values() {
        return (CertificateFormat[])$VALUES.clone();
    }

    public static CertificateFormat valueOf(String value2) {
        return Enum.valueOf(CertificateFormat.class, value2);
    }

    @NotNull
    public static EnumEntries<CertificateFormat> getEntries() {
        return $ENTRIES;
    }

    @JvmStatic
    @Nullable
    public static CertificateFormat guessFormat(@NotNull Path path) {
        return Companion.guessFormat(path);
    }

    public /* synthetic */ CertificateFormat(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        PEM = new PEM("PEM", 0);
        P12 = new P12("P12", 1);
        DER = new DER("DER", 2);
        $VALUES = certificateFormatArray = new CertificateFormat[]{CertificateFormat.PEM, CertificateFormat.P12, CertificateFormat.DER};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        guessExplanation = ".p12, .pkcs12, .pfx -> P12; .pem, .crt -> PEM; .der, .cer -> DER";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/httpClient/execution/ssl/CertificateFormat$Companion;", "Lcom/intellij/httpClient/execution/ssl/SslFilesFormatGuessStrategy;", "Lcom/intellij/httpClient/execution/ssl/CertificateFormat;", "<init>", "()V", "guessFormat", "path", "Ljava/nio/file/Path;", "guessExplanation", "", "getGuessExplanation", "()Ljava/lang/String;", "CERTIFICATE_TYPE", "PKCS_12_STORE", "readCertificate", "Ljava/security/cert/Certificate;", "inputStream", "Ljava/io/InputStream;", "intellij.httpClient.executor"})
    public static final class Companion
    implements SslFilesFormatGuessStrategy<CertificateFormat> {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @JvmStatic
        @Nullable
        public CertificateFormat guessFormat(@NotNull Path path) {
            block14: {
                block13: {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    var2_2 = PathsKt.getExtension((Path)path);
                    switch (var2_2.hashCode()) {
                        case 109201: {
                            if (!var2_2.equals("p12")) {
                                ** break;
                            }
                            ** GOTO lbl28
                        }
                        case 99345: {
                            if (!var2_2.equals("der")) {
                                ** break;
                            }
                            break block13;
                        }
                        case 98384: {
                            if (!var2_2.equals("cer")) {
                                ** break;
                            }
                            break block13;
                        }
                        case 110914: {
                            if (!var2_2.equals("pfx")) {
                                ** break;
                            }
                            ** GOTO lbl28
                        }
                        case 98789: {
                            if (var2_2.equals("crt")) break;
                            ** break;
                        }
                        case 110872: {
                            if (var2_2.equals("pem")) break;
                            ** break;
                        }
                        case -986624244: {
                            if (!var2_2.equals("pkcs12")) ** break;
lbl28:
                            // 3 sources

                            v0 = CertificateFormat.P12;
                            break block14;
                        }
                    }
                    v0 = CertificateFormat.PEM;
                    break block14;
                }
                v0 = CertificateFormat.DER;
                break block14;
lbl35:
                // 8 sources

                v0 = null;
            }
            return v0;
        }

        @Override
        @NotNull
        public String getGuessExplanation() {
            return guessExplanation;
        }

        private final Certificate readCertificate(InputStream inputStream) {
            Certificate certificate = CertificateFactory.getInstance(CertificateFormat.CERTIFICATE_TYPE).generateCertificate(inputStream);
            Intrinsics.checkNotNullExpressionValue((Object)certificate, (String)"generateCertificate(...)");
            return certificate;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J'\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0010\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"com/intellij/httpClient/execution/ssl/CertificateFormat.DER", "Lcom/intellij/httpClient/execution/ssl/CertificateFormat;", "readToStore", "Lcom/intellij/httpClient/execution/ssl/SslCertStore;", "path", "Ljava/nio/file/Path;", "context", "Lcom/intellij/httpClient/execution/ssl/SslConfigurationContext;", "passphrase", "", "readToStore$intellij_httpClient_executor", "intellij.httpClient.executor"})
    @SourceDebugExtension(value={"SMAP\nsslFormats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 sslFormats.kt\ncom/intellij/httpClient/execution/ssl/CertificateFormat$DER\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 sslErrors.kt\ncom/intellij/httpClient/execution/ssl/SslErrorsKt\n*L\n1#1,160:1\n1#2:161\n24#3,4:162\n*S KotlinDebug\n*F\n+ 1 sslFormats.kt\ncom/intellij/httpClient/execution/ssl/CertificateFormat$DER\n*L\n83#1:162,4\n*E\n"})
    static final class DER
    extends CertificateFormat {
        /*
         * WARNING - void declaration
         */
        DER() {
            void var1_1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public SslCertStore readToStore$intellij_httpClient_executor(@NotNull Path path, @NotNull SslConfigurationContext context2, @Nullable String passphrase) throws HttpRequestSslConfigurationException {
            void $this$getOrRethrowSslException$iv;
            Object $i$a$-runCatching-CertificateFormat$DER$readToStore$22;
            Throwable throwable;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            try {
                Object stream2;
                boolean $i$a$-runCatching-CertificateFormat$DER$readToStore$22 = false;
                Closeable closeable = new FileInputStream(path.toFile());
                throwable = null;
                try {
                    SslCertStore.Raw raw;
                    stream2 = (FileInputStream)closeable;
                    boolean bl = false;
                    Certificate certificate = Companion.readCertificate((InputStream)stream2);
                    SslCertStore.Raw it = raw = new SslCertStore.Raw();
                    boolean bl2 = false;
                    it.addCertificate(certificate);
                    stream2 = raw;
                }
                catch (Throwable bl) {
                    throwable = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                $i$a$-runCatching-CertificateFormat$DER$readToStore$22 = Result.constructor-impl((Object)stream2);
            }
            catch (Throwable throwable2) {
                $i$a$-runCatching-CertificateFormat$DER$readToStore$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            boolean $i$f$getOrRethrowSslException = false;
            throwable = $this$getOrRethrowSslException$iv;
            Throwable throwable3 = Result.exceptionOrNull-impl(throwable);
            if (throwable3 != null) {
                HttpRequestSslConfigurationException httpRequestSslConfigurationException;
                Throwable it$iv = throwable3;
                boolean bl = false;
                if (it$iv instanceof HttpRequestSslConfigurationException) {
                    httpRequestSslConfigurationException = (HttpRequestSslConfigurationException)it$iv;
                } else {
                    Throwable it = it$iv;
                    boolean bl3 = false;
                    Object[] objectArray = new Object[]{it.getLocalizedMessage()};
                    Throwable throwable4 = it$iv;
                    String string = context2.getErrorMessage(SslErrorDescriptor.CERTIFICATE, HttpClientExecutorBundle.message("http.request.ssl.cannot.read.certificate.error", objectArray));
                    httpRequestSslConfigurationException = new HttpRequestSslConfigurationException(string, throwable4);
                }
                HttpRequestSslConfigurationException exception$iv = httpRequestSslConfigurationException;
                throw exception$iv;
            }
            return (SslCertStore)((Object)throwable);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J'\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0010\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"com/intellij/httpClient/execution/ssl/CertificateFormat.P12", "Lcom/intellij/httpClient/execution/ssl/CertificateFormat;", "readToStore", "Lcom/intellij/httpClient/execution/ssl/SslCertStore;", "path", "Ljava/nio/file/Path;", "context", "Lcom/intellij/httpClient/execution/ssl/SslConfigurationContext;", "passphrase", "", "readToStore$intellij_httpClient_executor", "intellij.httpClient.executor"})
    @SourceDebugExtension(value={"SMAP\nsslFormats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 sslFormats.kt\ncom/intellij/httpClient/execution/ssl/CertificateFormat$P12\n+ 2 sslErrors.kt\ncom/intellij/httpClient/execution/ssl/SslErrorsKt\n*L\n1#1,160:1\n24#2,4:161\n*S KotlinDebug\n*F\n+ 1 sslFormats.kt\ncom/intellij/httpClient/execution/ssl/CertificateFormat$P12\n*L\n67#1:161,4\n*E\n"})
    static final class P12
    extends CertificateFormat {
        /*
         * WARNING - void declaration
         */
        P12() {
            void var1_1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public SslCertStore readToStore$intellij_httpClient_executor(@NotNull Path path, @NotNull SslConfigurationContext context2, @Nullable String passphrase) throws HttpRequestSslConfigurationException {
            void $this$getOrRethrowSslException$iv;
            Object $i$a$-runCatching-CertificateFormat$P12$readToStore$22;
            Closeable closeable;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            try {
                Object stream2;
                boolean $i$a$-runCatching-CertificateFormat$P12$readToStore$22 = false;
                KeyStore keyStore = KeyStore.getInstance(CertificateFormat.PKCS_12_STORE);
                closeable = new FileInputStream(path.toFile());
                Throwable throwable = null;
                try {
                    stream2 = (FileInputStream)closeable;
                    boolean bl = false;
                    InputStream inputStream = (InputStream)stream2;
                    String string = passphrase;
                    if (string == null) {
                        string = "";
                    }
                    char[] cArray = string.toCharArray();
                    Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                    keyStore.load(inputStream, cArray);
                    Intrinsics.checkNotNull((Object)keyStore);
                    stream2 = new SslCertStore.Ready(keyStore);
                }
                catch (Throwable bl) {
                    throwable = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                $i$a$-runCatching-CertificateFormat$P12$readToStore$22 = Result.constructor-impl((Object)stream2);
            }
            catch (Throwable keyStore) {
                $i$a$-runCatching-CertificateFormat$P12$readToStore$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)keyStore));
            }
            boolean $i$f$getOrRethrowSslException = false;
            closeable = $this$getOrRethrowSslException$iv;
            Throwable throwable = Result.exceptionOrNull-impl((Object)closeable);
            if (throwable != null) {
                HttpRequestSslConfigurationException httpRequestSslConfigurationException;
                Throwable it$iv = throwable;
                boolean bl = false;
                if (it$iv instanceof HttpRequestSslConfigurationException) {
                    httpRequestSslConfigurationException = (HttpRequestSslConfigurationException)it$iv;
                } else {
                    Throwable it = it$iv;
                    boolean bl2 = false;
                    Object[] objectArray = new Object[]{it.getLocalizedMessage()};
                    Throwable throwable2 = it$iv;
                    String string = context2.getErrorMessage(SslErrorDescriptor.CERTIFICATE, HttpClientExecutorBundle.message("http.request.ssl.cannot.read.p12.key.store.error", objectArray));
                    httpRequestSslConfigurationException = new HttpRequestSslConfigurationException(string, throwable2);
                }
                HttpRequestSslConfigurationException exception$iv = httpRequestSslConfigurationException;
                throw exception$iv;
            }
            return (SslCertStore)((Object)closeable);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J'\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0010\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"com/intellij/httpClient/execution/ssl/CertificateFormat.PEM", "Lcom/intellij/httpClient/execution/ssl/CertificateFormat;", "readToStore", "Lcom/intellij/httpClient/execution/ssl/SslCertStore;", "path", "Ljava/nio/file/Path;", "context", "Lcom/intellij/httpClient/execution/ssl/SslConfigurationContext;", "passphrase", "", "readToStore$intellij_httpClient_executor", "intellij.httpClient.executor"})
    @SourceDebugExtension(value={"SMAP\nsslFormats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 sslFormats.kt\ncom/intellij/httpClient/execution/ssl/CertificateFormat$PEM\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 sslErrors.kt\ncom/intellij/httpClient/execution/ssl/SslErrorsKt\n*L\n1#1,160:1\n808#2,11:161\n808#2,11:172\n1#3:183\n24#4,4:184\n*S KotlinDebug\n*F\n+ 1 sslFormats.kt\ncom/intellij/httpClient/execution/ssl/CertificateFormat$PEM\n*L\n35#1:161,11\n36#1:172,11\n50#1:184,4\n*E\n"})
    static final class PEM
    extends CertificateFormat {
        /*
         * WARNING - void declaration
         */
        PEM() {
            void var1_1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public SslCertStore readToStore$intellij_httpClient_executor(@NotNull Path path, @NotNull SslConfigurationContext context2, @Nullable String passphrase) throws HttpRequestSslConfigurationException {
            void $this$getOrRethrowSslException$iv;
            Object $i$a$-runCatching-CertificateFormat$PEM$readToStore$22;
            Throwable throwable;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            try {
                Object pemParser;
                boolean $i$a$-runCatching-CertificateFormat$PEM$readToStore$22 = false;
                Closeable closeable = (Closeable)new PEMParser((Reader)new FileReader(path.toFile()));
                throwable = null;
                try {
                    void $this$filterIsInstanceTo$iv$iv;
                    void $this$filterIsInstanceTo$iv$iv2;
                    pemParser = (PEMParser)closeable;
                    boolean bl = false;
                    List sslObjects = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence(() -> PEM.readToStore$lambda$4$lambda$3$lambda$0((PEMParser)pemParser)), arg_0 -> PEM.readToStore$lambda$4$lambda$3$lambda$1(passphrase, arg_0)));
                    Iterable $this$filterIsInstance$iv = sslObjects;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Iterable destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                        if (!(element$iv$iv instanceof PrivateKey)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    PrivateKey key = (PrivateKey)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                    Iterable $this$filterIsInstance$iv2 = sslObjects;
                    boolean $i$f$filterIsInstance22 = false;
                    destination$iv$iv = $this$filterIsInstance$iv2;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterIsInstanceTo2 = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof Certificate)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List certificates = (List)destination$iv$iv2;
                    SslCertStore.Raw certStore = new SslCertStore.Raw();
                    Pair pair = UtilKt.headTailOrNull((List)certificates);
                    if (pair == null) {
                        throw new HttpRequestSslConfigurationException(context2.getErrorMessage(SslErrorDescriptor.CERTIFICATE, HttpClientExecutorBundle.message("http.request.ssl.no.cert.in.file.error", new Object[0])), null, 2, null);
                    }
                    Pair $i$f$filterIsInstance22 = pair;
                    Certificate certificate = (Certificate)$i$f$filterIsInstance22.component1();
                    List intermediates = (List)$i$f$filterIsInstance22.component2();
                    certStore.addCertificate(certificate);
                    certStore.addIntermediates(intermediates);
                    PrivateKey privateKey = key;
                    if (privateKey != null) {
                        PrivateKey it = privateKey;
                        boolean bl2 = false;
                        certStore.addPrivateKey(key, passphrase);
                    }
                    pemParser = certStore;
                }
                catch (Throwable bl) {
                    throwable = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                $i$a$-runCatching-CertificateFormat$PEM$readToStore$22 = Result.constructor-impl((Object)pemParser);
            }
            catch (Throwable throwable2) {
                $i$a$-runCatching-CertificateFormat$PEM$readToStore$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            boolean $i$f$getOrRethrowSslException = false;
            throwable = $this$getOrRethrowSslException$iv;
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)throwable);
            if (throwable3 != null) {
                HttpRequestSslConfigurationException httpRequestSslConfigurationException;
                Throwable it$iv = throwable3;
                boolean bl = false;
                if (it$iv instanceof HttpRequestSslConfigurationException) {
                    httpRequestSslConfigurationException = (HttpRequestSslConfigurationException)it$iv;
                } else {
                    Throwable it = it$iv;
                    boolean bl3 = false;
                    Object[] objectArray = new Object[]{it.getLocalizedMessage()};
                    Throwable throwable4 = it$iv;
                    String string = context2.getErrorMessage(SslErrorDescriptor.CERTIFICATE, HttpClientExecutorBundle.message("http.request.ssl.cannot.read.certificate.error", objectArray));
                    httpRequestSslConfigurationException = new HttpRequestSslConfigurationException(string, throwable4);
                }
                HttpRequestSslConfigurationException exception$iv = httpRequestSslConfigurationException;
                throw exception$iv;
            }
            return (SslCertStore)((Object)throwable);
        }

        private static final Object readToStore$lambda$4$lambda$3$lambda$0(PEMParser $pemParser) {
            return $pemParser.readObject();
        }

        private static final Serializable readToStore$lambda$4$lambda$3$lambda$1(String $passphrase, Object obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            return obj instanceof X509CertificateHolder ? (Serializable)Companion.readCertificate(new ByteArrayInputStream(((X509CertificateHolder)obj).getEncoded())) : (PemHelper.INSTANCE.isKey(obj) ? (Serializable)new JcaPEMKeyConverter().getPrivateKey(PemHelper.INSTANCE.readKey(obj, $passphrase)) : null);
        }
    }
}

