/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.actions;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.platform.commercial.dependencies.StationDependenciesDownloader;
import com.intellij.util.SystemProperties;
import com.intellij.util.system.OS;
import com.jetbrains.gateway.actions.InstallToolboxActionKt;
import com.jetbrains.gateway.actions.ToolboxDiscovery;
import com.jetbrains.gateway.welcomeScreen.toolbox.ToolboxStatus;
import com.jetbrains.gateway.welcomeScreen.toolbox.ToolboxStatusService;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.KnownFolders;
import com.sun.jna.platform.win32.Shell32Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;
import org.jetbrains.intellij.build.dependencies.JdkDownloader;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\u0007H\u0002J\r\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0010\u0010\u000f\u001a\u00020\rH\u0080@\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\rH\u0080@\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u0016\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u000e\u0010\u001d\u001a\u00020\tH\u0082@\u00a2\u0006\u0002\u0010\u0011J\u000f\u0010\u001e\u001a\u0004\u0018\u00010\u0005H\u0000\u00a2\u0006\u0002\b\u001fJ\b\u0010 \u001a\u00020\u0007H\u0002J\n\u0010!\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\"\u001a\u00020\u0007H\u0002J\n\u0010#\u001a\u0004\u0018\u00010$H\u0002\u00a8\u0006%"}, d2={"Lcom/jetbrains/gateway/actions/ToolboxDiscovery;", "", "<init>", "()V", "discoverFreshToolboxInstallerNumber", "Lcom/intellij/openapi/util/BuildNumber;", "findOrDownloadFreshToolboxInstaller", "Ljava/nio/file/Path;", "allowDownload", "", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "discoverToolboxInstallerPath", "openToolboxSafe", "", "openToolboxSafe$intellij_gateway_core", "findOrInstallToolboxSafe", "findOrInstallToolboxSafe$intellij_gateway_core", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "installOrUpdate", "installOrUpdate$intellij_gateway_core", "installToolbox", "dist", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "copyPreservingSymlinks", "source", "target", "listRunningToolboxProcesses", "", "Lcom/intellij/execution/process/ProcessInfo;", "killAllToolboxProcesses", "getInstalledBuild", "getInstalledBuild$intellij_gateway_core", "discoverToolboxBinaryDir", "discoverToolboxExecutablePath", "discoverToolboxAppOnMacOS", "createLaunchToolboxCommand", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nInstallToolboxAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallToolboxAction.kt\ncom/jetbrains/gateway/actions/ToolboxDiscovery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,420:1\n827#2:421\n855#2,2:422\n3829#3:424\n4344#3,2:425\n1#4:427\n*S KotlinDebug\n*F\n+ 1 InstallToolboxAction.kt\ncom/jetbrains/gateway/actions/ToolboxDiscovery\n*L\n85#1:421\n85#1:422,2\n286#1:424\n286#1:425,2\n*E\n"})
public final class ToolboxDiscovery {
    @NotNull
    public static final ToolboxDiscovery INSTANCE = new ToolboxDiscovery();

    private ToolboxDiscovery() {
    }

    @NotNull
    public final BuildNumber discoverFreshToolboxInstallerNumber() {
        BuildNumber buildNumber;
        Path toolbox = this.discoverToolboxInstallerPath();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(toolbox, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            List files = PathsKt.listDirectoryEntries$default((Path)toolbox, null, (int)1, null);
            if (!(files.size() == 2)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Path path = toolbox.resolve("build.txt");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            String version = PathsKt.readText$default((Path)path, null, (int)1, null);
            buildNumber = BuildNumber.fromString((String)version);
            if (buildNumber == null) {
                throw new IllegalStateException(("Invalid version: " + version).toString());
            }
        } else {
            if (!(PluginManagerCore.isRunningFromSources() || AppMode.isDevServer())) {
                String version = "Failed requirement.";
                throw new IllegalArgumentException(version.toString());
            }
            Path path = Path.of(PathManager.getCommunityHomePath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            BuildDependenciesCommunityRoot communityRoot = new BuildDependenciesCommunityRoot(path);
            String version = StationDependenciesDownloader.INSTANCE.getToolboxBuildNumber(communityRoot);
            buildNumber = BuildNumber.fromString((String)version);
            if (buildNumber == null) {
                throw new IllegalStateException(("Invalid version: " + version).toString());
            }
        }
        return buildNumber;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object findOrDownloadFreshToolboxInstaller(boolean allowDownload, @NotNull Continuation<? super Path> $completion) {
        if (!($completion instanceof findOrDownloadFreshToolboxInstaller.1)) ** GOTO lbl-1000
        var16_3 = $completion;
        if ((var16_3.label & -2147483648) != 0) {
            var16_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                boolean Z$0;
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ToolboxDiscovery this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.findOrDownloadFreshToolboxInstaller(false, (Continuation<? super Path>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var17_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                toolbox = this.discoverToolboxInstallerPath();
                v0 = new LinkOption[]{};
                if (!Files.isDirectory(toolbox, Arrays.copyOf(v0, v0.length))) ** GOTO lbl33
                files = PathsKt.listDirectoryEntries$default((Path)toolbox, null, (int)1, null);
                if (!(files.size() == 2)) {
                    var6_11 = "Failed requirement.";
                    throw new IllegalArgumentException(var6_11.toString());
                }
                $this$filterNot$iv = files;
                $i$f$filterNot = false;
                var8_14 = $this$filterNot$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterNotTo = false;
                for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                    it = (Path)element$iv$iv;
                    $i$a$-filterNot-ToolboxDiscovery$findOrDownloadFreshToolboxInstaller$dist$1 = false;
                    if (Intrinsics.areEqual((Object)it.getFileName().toString(), (Object)"build.txt")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                v1 = dist = (Path)CollectionsKt.single((List)((List)destination$iv$iv));
                ** GOTO lbl58
lbl33:
                // 1 sources

                if (!allowDownload) {
                    InstallToolboxActionKt.access$getLOG().debug("Toolbox discovery is not allowed to download its distribution");
                    return null;
                }
                if (!(PluginManagerCore.isRunningFromSources() != false || AppMode.isDevServer() != false)) {
                    dist = "Failed requirement.";
                    throw new IllegalArgumentException(dist.toString());
                }
                v2 = Path.of(PathManager.getCommunityHomePath(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"of(...)");
                communityRoot = new BuildDependenciesCommunityRoot(v2);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)toolbox);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)communityRoot);
                $continuation.Z$0 = allowDownload;
                $continuation.label = 1;
                v3 = StationDependenciesDownloader.INSTANCE.downloadToolbox(communityRoot, JdkDownloader.OS.Companion.getCurrent(), JdkDownloader.Arch.Companion.getCurrent(), (Continuation)$continuation);
                if (v3 == var17_5) {
                    return var17_5;
                }
                ** GOTO lbl56
            }
            case 1: {
                allowDownload = $continuation.Z$0;
                communityRoot = (BuildDependenciesCommunityRoot)$continuation.L$1;
                toolbox = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl56:
                // 2 sources

                downloaded = (StationDependenciesDownloader.ToolboxDownloadResult)v3;
                v1 = downloaded.getSource();
lbl58:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Path discoverToolboxInstallerPath() {
        String[] stringArray = new String[]{"com.jetbrains.station"};
        PluginId pluginId = PluginId.Companion.findId(stringArray);
        if (!(pluginId != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        IdeaPluginDescriptor plugin = PluginManager.getInstance().findEnabledPlugin(pluginId);
        if (!(plugin != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Path pluginPath = plugin.getPluginPath();
        if (!(pluginPath != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Path toolbox = pluginPath.resolve("toolbox");
        Intrinsics.checkNotNull((Object)toolbox);
        return toolbox;
    }

    public final void openToolboxSafe$intellij_gateway_core() {
        GeneralCommandLine launchToolboxCommand = this.createLaunchToolboxCommand();
        if (launchToolboxCommand != null) {
            InstallToolboxActionKt.access$getLOG().warn("Launching toolbox command: " + launchToolboxCommand.getCommandLineString());
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)launchToolboxCommand);
            if (output.getExitCode() == 0) {
                String string = output.getStderr();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
                if (((CharSequence)string).length() == 0) {
                    ToolboxStatusService.Companion.getInstance().rememberAboutInstallationAttempt();
                }
            }
            InstallToolboxActionKt.access$getLOG().warn("Output of the toolbox command: exit code " + output.getExitCode() + ", stderr: " + output.getStderr());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object findOrInstallToolboxSafe$intellij_gateway_core(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof findOrInstallToolboxSafe.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ ToolboxDiscovery this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.findOrInstallToolboxSafe$intellij_gateway_core((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (ToolboxStatusService.Companion.getInstance().getToolboxStatus().getValue() == ToolboxStatus.Installing) {
                    InstallToolboxActionKt.access$getLOG().debug("Toolbox is already being installed. Skipping another attempt");
                    return Unit.INSTANCE;
                }
                ToolboxStatusService.Companion.getInstance().getToolboxStatus().setValue((Object)ToolboxStatus.Installing);
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                    int label;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = ToolboxDiscovery.INSTANCE.installOrUpdate$intellij_gateway_core((Continuation<? super Unit>)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var5_4) goto lbl22
lbl21:
                // 1 sources

                return var5_4;
lbl22:
                // 1 sources

                ** GOTO lbl28
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (IllegalStateException e) {
                    InstallToolboxActionKt.access$getLOG().debug("Toolbox installation failed with internal error", (Throwable)e);
                }
                catch (IOException e) {
                    InstallToolboxActionKt.access$getLOG().debug("Toolbox installation failed, IO", (Throwable)e);
                    {
                        catch (Throwable var2_7) {
                            throw var2_7;
                        }
                    }
                }
lbl28:
                // 2 sources

                ToolboxStatusService.Companion.getInstance().updateToolboxStatusSafe();
                ** GOTO lbl45
            }
            {
                finally {
                    ToolboxStatusService.Companion.getInstance().updateToolboxStatusSafe();
                }
            }
lbl45:
            // 3 sources

            return Unit.INSTANCE;
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object installOrUpdate$intellij_gateway_core(@NotNull Continuation<? super Unit> $completion) {
        block12: {
            block13: {
                if (!($completion instanceof installOrUpdate.1)) ** GOTO lbl-1000
                var6_2 = $completion;
                if ((var6_2.label & -2147483648) != 0) {
                    var6_2.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        /* synthetic */ Object result;
                        final /* synthetic */ ToolboxDiscovery this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.installOrUpdate$intellij_gateway_core((Continuation<? super Unit>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $continuation.label = 1;
                        v0 = this.findOrDownloadFreshToolboxInstaller(true, (Continuation<? super Path>)$continuation);
                        if (v0 == var7_4) {
                            return var7_4;
                        }
                        ** GOTO lbl20
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl20:
                        // 2 sources

                        dist = (Path)v0;
                        distVersion = this.discoverFreshToolboxInstallerNumber();
                        installedBuild = this.getInstalledBuild$intellij_gateway_core();
                        if (dist == null) {
                            InstallToolboxActionKt.access$getLOG().debug("Toolbox installer distribution was not found. Abort process");
                            return Unit.INSTANCE;
                        }
                        if (installedBuild != null) break;
                        InstallToolboxActionKt.access$getLOG().debug("No Toolbox installation found, will install v" + distVersion + " from " + dist);
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)dist);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)distVersion);
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)installedBuild);
                        $continuation.label = 2;
                        v1 = this.installToolbox(dist, (Continuation<? super Unit>)$continuation);
                        if (v1 == var7_4) {
                            return var7_4;
                        }
                        ** GOTO lbl42
                    }
                    case 2: {
                        installedBuild = (BuildNumber)$continuation.L$2;
                        distVersion = (BuildNumber)$continuation.L$1;
                        dist = (Path)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl42:
                        // 2 sources

                        InstallToolboxActionKt.access$getLOG().debug("Toolbox installation completed");
                        break block12;
                    }
                }
                if (installedBuild.compareTo(distVersion) >= 0) break block13;
                InstallToolboxActionKt.access$getLOG().debug("Found toolbox v" + installedBuild + ", will update to v" + distVersion + " from " + dist);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)dist);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)distVersion);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)installedBuild);
                $continuation.label = 3;
                v2 = this.installToolbox(dist, (Continuation<? super Unit>)$continuation);
                if (v2 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl60
                {
                    case 3: {
                        installedBuild = (BuildNumber)$continuation.L$2;
                        distVersion = (BuildNumber)$continuation.L$1;
                        dist = (Path)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl60:
                        // 2 sources

                        InstallToolboxActionKt.access$getLOG().debug("Toolbox update completed");
                        break block12;
                    }
                }
            }
            InstallToolboxActionKt.access$getLOG().debug("Toolbox v" + installedBuild + " is already installed");
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object installToolbox(@NotNull Path dist, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof installToolbox.1)) ** GOTO lbl-1000
        var14_3 = $completion;
        if ((var14_3.label & -2147483648) != 0) {
            var14_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ToolboxDiscovery this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.installToolbox(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = dist;
                $continuation.label = 1;
                v0 = this.killAllToolboxProcesses((Continuation<? super Boolean>)$continuation);
                if (v0 == var15_5) {
                    return var15_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                dist = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    return Unit.INSTANCE;
                }
                InstallToolboxActionKt.access$getLOG().debug("Installing Toolbox from " + dist);
                v1 = OS.CURRENT;
                switch (v1 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v1.ordinal()]) {
                    case 1: {
                        var4_6 = new String[]{dist.toString(), "/headless"};
                        gcl = new GeneralCommandLine(var4_6);
                        installerProcess = gcl.toProcessBuilder().start();
                        installerProcess.waitFor(60L, TimeUnit.SECONDS);
                        if (!(installerProcess.isAlive() == false)) {
                            var6_11 = "Failed requirement.";
                            throw new IllegalArgumentException(var6_11.toString());
                        }
                        if (!(installerProcess.exitValue() == 0)) {
                            $i$a$-require-ToolboxDiscovery$installToolbox$2 = false;
                            v2 = installerProcess.getErrorStream();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getErrorStream(...)");
                            var7_16 = v2;
                            var8_23 = Charsets.UTF_8;
                            var9_29 = new InputStreamReader(var7_16, var8_23);
                            var10_33 = 8192;
                            $i$a$-require-ToolboxDiscovery$installToolbox$2 = "Failed to install " + dist + ": " + TextStreamsKt.readText((Reader)(var9_29 instanceof BufferedReader != false ? (BufferedReader)var9_29 : new BufferedReader(var9_29, var10_33)));
                            throw new IllegalArgumentException($i$a$-require-ToolboxDiscovery$installToolbox$2.toString());
                        }
                        InstallToolboxActionKt.access$getLOG().debug(gcl.getPreparedCommandLine() + " returner 0 in time");
                        break;
                    }
                    case 2: {
                        mountPoint = Files.createTempDirectory("mount-", new FileAttribute[0]);
                        try {
                            InstallToolboxActionKt.access$getLOG().debug("Mounting " + dist + " as " + mountPoint);
                            var5_37 = new String[9];
                            var5_37[0] = "hdiutil";
                            var5_37[1] = "attach";
                            var5_37[2] = "-readonly";
                            var5_37[3] = "-noautoopen";
                            var5_37[4] = "-noautofsck";
                            var5_37[5] = "-nobrowse";
                            var5_37[6] = "-mountpoint";
                            Intrinsics.checkNotNull((Object)mountPoint);
                            var5_37[7] = mountPoint.toAbsolutePath().toString();
                            var5_37[8] = dist.toAbsolutePath().toString();
                            gcl = new GeneralCommandLine(var5_37);
                            process = gcl.toProcessBuilder().start();
                            process.waitFor(60L, TimeUnit.SECONDS);
                            if (!(process.isAlive() == false)) {
                                var7_17 = "Failed requirement.";
                                throw new IllegalArgumentException(var7_17.toString());
                            }
                            if (!(process.exitValue() == 0)) {
                                $i$a$-require-ToolboxDiscovery$installToolbox$3 = false;
                                v3 = process.getErrorStream();
                                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getErrorStream(...)");
                                var8_24 = v3;
                                var9_30 = Charsets.UTF_8;
                                var10_34 = new InputStreamReader(var8_24, var9_30);
                                var11_39 = 8192;
                                $i$a$-require-ToolboxDiscovery$installToolbox$3 = "Failed to mount " + dist + ": " + TextStreamsKt.readText((Reader)(var10_34 instanceof BufferedReader != false ? (BufferedReader)var10_34 : new BufferedReader(var10_34, var11_39)));
                                throw new IllegalArgumentException($i$a$-require-ToolboxDiscovery$installToolbox$3.toString());
                            }
                            InstallToolboxActionKt.access$getLOG().debug("Mounted " + dist + " as " + mountPoint);
                            target = Path.of("/Applications/JetBrains Toolbox.app", new String[0]);
                            v4 = mountPoint.resolve("JetBrains Toolbox.app");
                            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"resolve(...)");
                            source = v4;
                            InstallToolboxActionKt.access$getLOG().debug("Copying " + (Path)source + " to " + target);
                            Intrinsics.checkNotNull((Object)target);
                            this.copyPreservingSymlinks((Path)source, target);
                        }
                        catch (Throwable var4_8) {
                            InstallToolboxActionKt.access$getLOG().debug("Un-mounting " + dist);
                            target = new String[4];
                            target[0] = "hdiutil";
                            target[1] = "detach";
                            target[2] = "-force";
                            Intrinsics.checkNotNull((Object)mountPoint);
                            target[3] = mountPoint.toAbsolutePath().toString();
                            gcl = new GeneralCommandLine(target);
                            process = gcl.toProcessBuilder().start();
                            process.waitFor(60L, TimeUnit.SECONDS);
                            if (!(process.isAlive() == false)) {
                                var8_26 = "Failed requirement.";
                                throw new IllegalArgumentException(var8_26.toString());
                            }
                            if (!(process.exitValue() == 0)) {
                                $i$a$-require-ToolboxDiscovery$installToolbox$4 = false;
                                v5 = process.getErrorStream();
                                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getErrorStream(...)");
                                var9_32 = v5;
                                var10_36 = Charsets.UTF_8;
                                var11_41 = new InputStreamReader(var9_32, var10_36);
                                var12_42 = 8192;
                                var8_28 = "Failed to un-mount " + dist + ": " + TextStreamsKt.readText((Reader)(var11_41 instanceof BufferedReader != false ? (BufferedReader)var11_41 : new BufferedReader(var11_41, var12_42)));
                                throw new IllegalArgumentException(var8_28.toString());
                            }
                            InstallToolboxActionKt.access$getLOG().debug("Un-mounted " + dist);
                            throw var4_8;
                        }
                        InstallToolboxActionKt.access$getLOG().debug("Un-mounting " + dist);
                        process = new String[]{"hdiutil", "detach", "-force", mountPoint.toAbsolutePath().toString()};
                        gcl = new GeneralCommandLine((String[])process);
                        process = gcl.toProcessBuilder().start();
                        process.waitFor(60L, TimeUnit.SECONDS);
                        if (!(process.isAlive() == false)) {
                            source = "Failed requirement.";
                            throw new IllegalArgumentException(source.toString());
                        }
                        if (!(process.exitValue() == 0)) {
                            $i$a$-require-ToolboxDiscovery$installToolbox$4 = false;
                            v6 = process.getErrorStream();
                            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getErrorStream(...)");
                            var8_25 = v6;
                            var9_31 = Charsets.UTF_8;
                            var10_35 = new InputStreamReader(var8_25, var9_31);
                            var11_40 = 8192;
                            var7_22 = "Failed to un-mount " + dist + ": " + TextStreamsKt.readText((Reader)(var10_35 instanceof BufferedReader != false ? (BufferedReader)var10_35 : new BufferedReader(var10_35, var11_40)));
                            throw new IllegalArgumentException(var7_22.toString());
                        }
                        InstallToolboxActionKt.access$getLOG().debug("Un-mounted " + dist);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(("Not supported: " + OS.CURRENT).toString());
                    }
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void copyPreservingSymlinks(Path source, Path target) {
        InstallToolboxActionKt.access$getLOG().debug("Deleting " + target);
        FileUtil.deleteRecursively((Path)target);
        File file = target.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        FilesKt.deleteRecursively((File)file);
        if (!Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(source, target){
            final /* synthetic */ Path $source;
            final /* synthetic */ Path $target;
            {
                this.$source = $source;
                this.$target = $target;
            }

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                Path relativePath = this.$source.relativize(dir);
                Path targetDir = this.$target.resolve(relativePath);
                if (!Files.exists(targetDir, new LinkOption[0])) {
                    Files.createDirectories(targetDir, new FileAttribute[0]);
                }
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                Path relativePath = this.$source.relativize(file);
                Path targetFile = this.$target.resolve(relativePath);
                try {
                    if (Files.isSymbolicLink(file)) {
                        Path linkTarget = Files.readSymbolicLink(file);
                        v0 = Files.createSymbolicLink(targetFile, linkTarget, new FileAttribute[0]);
                    } else {
                        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                        v0 = Files.copy(file, targetFile, copyOptionArray);
                    }
                }
                catch (IOException e) {
                    throw new IOException("Error copying file " + file, e);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ProcessInfo> listRunningToolboxProcesses() {
        void $this$filterTo$iv$iv;
        ProcessInfo[] processInfoArray = OSProcessUtil.getProcessList();
        Intrinsics.checkNotNullExpressionValue((Object)processInfoArray, (String)"getProcessList(...)");
        Object[] $this$filter$iv = processInfoArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            ProcessInfo it = (ProcessInfo)element$iv$iv;
            boolean bl = false;
            String string = it.getExecutableDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExecutableDisplayName(...)");
            if (!StringsKt.endsWith$default((String)string, (String)"jetbrains-toolbox", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object killAllToolboxProcesses(Continuation<? super Boolean> $completion) {
        if (!($completion instanceof killAllToolboxProcesses.1)) ** GOTO lbl-1000
        var11_2 = $completion;
        if ((var11_2.label & -2147483648) != 0) {
            var11_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ ToolboxDiscovery this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ToolboxDiscovery.access$killAllToolboxProcesses(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                try {
                    processes = this.listRunningToolboxProcesses();
                    var3_6 = processes.iterator();
                }
                catch (Throwable e) {
                    InstallToolboxActionKt.access$getLOG().warn("Failed to kill all toolbox processes", e);
                    return Boxing.boxBoolean((boolean)false);
                }
lbl20:
                // 2 sources

                while (var3_6.hasNext()) {
                    process = (ProcessInfo)var3_6.next();
                    v0 = ProcessHandle.of(process.getPid());
                    Intrinsics.checkNotNullExpressionValue(v0, (String)"of(...)");
                    if ((ProcessHandle)OptionalsKt.getOrNull(v0) == null) {
                        $this$killAllToolboxProcesses_u24lambda_u245 = this;
                        $i$a$-run-ToolboxDiscovery$killAllToolboxProcesses$handle$1 = false;
                        InstallToolboxActionKt.access$getLOG().debug("Failed to get handle for " + process + ", can't check if it's alive");
                        return Boxing.boxBoolean((boolean)false);
                    }
                    InstallToolboxActionKt.access$getLOG().debug("Terminating process " + process);
                    try {
                        OSProcessUtil.terminateProcessGracefully((int)process.getPid());
                        InstallToolboxActionKt.access$getLOG().debug("Process " + process + " was gracefully terminated");
                    }
                    catch (UnsupportedOperationException <unused var>) {
                        InstallToolboxActionKt.access$getLOG().debug("Failed to gracefully terminate process " + process + ", killing it");
                        OSProcessUtil.killProcess((int)process.getPid());
                    }
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)processes);
                    $continuation.L$1 = var3_6;
                    $continuation.L$2 = process;
                    $continuation.L$3 = handle;
                    $continuation.label = 1;
                    v1 = TimeoutKt.withTimeout((long)5000L, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(handle, null){
                        int label;
                        final /* synthetic */ ProcessHandle $handle;
                        {
                            this.$handle = $handle;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object $result) {
                            var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
lbl5:
                                    // 3 sources

                                    while (this.$handle.isAlive()) {
                                        this.label = 1;
                                        v0 = DelayKt.delay((long)100L, (Continuation)((Continuation)this));
                                        if (v0 != var2_2) continue;
                                        return var2_2;
                                    }
                                    break;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
                                    ** GOTO lbl5
                                }
                            }
                            return Unit.INSTANCE;
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v1 == var12_4) {
                        return var12_4;
                    }
                    ** GOTO lbl56
                }
                return Boxing.boxBoolean((boolean)true);
            }
            case 1: {
                handle = (ProcessHandle)$continuation.L$3;
                process = (ProcessInfo)$continuation.L$2;
                var3_6 = (Iterator)$continuation.L$1;
                processes = (List)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl56:
                    // 2 sources

                    if (!(handle.isAlive() == false)) {
                        $i$a$-require-ToolboxDiscovery$killAllToolboxProcesses$4 = false;
                        var7_14 = "Failed to kill process " + process;
                        throw new IllegalArgumentException(var7_14.toString());
                    }
                    InstallToolboxActionKt.access$getLOG().debug("Process " + process + " was terminated");
                    ** GOTO lbl20
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final BuildNumber getInstalledBuild$intellij_gateway_core() {
        if (!(OS.CURRENT != OS.Linux)) {
            boolean $i$a$-require-ToolboxDiscovery$getInstalledBuild$32 = false;
            String $i$a$-require-ToolboxDiscovery$getInstalledBuild$32 = "No able do determine the installed version yet, see TBX-14069";
            throw new IllegalArgumentException($i$a$-require-ToolboxDiscovery$getInstalledBuild$32.toString());
        }
        Path binDir = this.discoverToolboxBinaryDir();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(binDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            InstallToolboxActionKt.access$getLOG().debug(binDir + " directory not found, assuming no Toolbox installation");
            return null;
        }
        InstallToolboxActionKt.access$getLOG().debug("Toolbox installation detected at " + binDir);
        BuildNumber buildNumber = BuildNumber.fromString((String)"2.6.0.34345");
        Intrinsics.checkNotNull((Object)buildNumber);
        BuildNumber lastVersionWithNoBuildNumber = buildNumber;
        Path path = binDir.resolve("build.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path buildTxt = path;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isRegularFile(buildTxt, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            InstallToolboxActionKt.access$getLOG().debug(buildTxt + " file not found, assuming " + lastVersionWithNoBuildNumber + " or earlier");
            return lastVersionWithNoBuildNumber;
        }
        String buildTxtContents = PathsKt.readText$default((Path)buildTxt, null, (int)1, null);
        BuildNumber buildNumber2 = BuildNumber.fromString((String)buildTxtContents);
        if (buildNumber2 == null) {
            throw new IllegalStateException(("Invalid build number: " + buildTxtContents).toString());
        }
        BuildNumber buildNumber3 = buildNumber2;
        if (!(buildNumber3.compareTo(lastVersionWithNoBuildNumber) > 0)) {
            boolean bl = false;
            String string = buildTxt + " contains " + buildNumber3 + ", but it can only be present after " + lastVersionWithNoBuildNumber;
            throw new IllegalArgumentException(string.toString());
        }
        return buildNumber3;
    }

    private final Path discoverToolboxBinaryDir() {
        Path path;
        String string = SystemProperties.getUserHome();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
        Path path2 = NioPathUtil.toNioPathOrNull((String)string);
        Intrinsics.checkNotNull((Object)path2);
        Path userHome = path2;
        OS oS = OS.CURRENT;
        switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 1: {
                String string2 = Shell32Util.getKnownFolderPath((Guid.GUID)KnownFolders.FOLDERID_LocalAppData);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKnownFolderPath(...)");
                Path path3 = NioPathUtil.toNioPathOrNull((String)string2);
                if (path3 == null) {
                    Path path4 = userHome.resolve("AppData");
                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
                    Path path5 = path4.resolve("Local");
                    path3 = path5;
                    Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
                }
                Path localAppData = path3;
                Path path6 = localAppData.resolve("JetBrains");
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
                Path path7 = path6.resolve("Toolbox");
                Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"resolve(...)");
                Path path8 = path7.resolve("bin");
                path = path8;
                Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"resolve(...)");
                break;
            }
            case 2: {
                Path path9 = this.discoverToolboxAppOnMacOS().resolve("Contents");
                path = path9;
                Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"resolve(...)");
                break;
            }
            case 3: {
                Path path10 = userHome;
                Path path11 = Path.of("/.local/share/JetBrains/Toolbox/bin", new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path11, (String)"of(...)");
                Path path12 = path10.resolve(path11);
                path = path12;
                Intrinsics.checkNotNullExpressionValue((Object)path12, (String)"resolve(...)");
                break;
            }
            default: {
                throw new IllegalStateException(("Not supported: " + OS.CURRENT).toString());
            }
        }
        return path;
    }

    private final Path discoverToolboxExecutablePath() {
        Path path;
        OS oS = OS.CURRENT;
        switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 1: {
                Path path2 = this.discoverToolboxBinaryDir().resolve("jetbrains-toolbox");
                path = path2;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                break;
            }
            case 3: {
                Path path3 = this.discoverToolboxBinaryDir().resolve("jetbrains-toolbox");
                path = path3;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
                break;
            }
            case 2: {
                path = this.discoverToolboxAppOnMacOS();
                break;
            }
            default: {
                InstallToolboxActionKt.access$getLOG().debug("Toolbox executable is not available on " + OS.CURRENT);
                path = null;
            }
        }
        return path;
    }

    private final Path discoverToolboxAppOnMacOS() {
        Path fallbackPath = Path.of("/Applications/JetBrains Toolbox.app", new String[0]);
        try {
            Object object;
            block6: {
                block5: {
                    String string;
                    String[] stringArray = new String[]{"mdfind", "kMDItemCFBundleIdentifier=\"com.jetbrains.toolbox\""};
                    GeneralCommandLine searchForInstallationDirectoryCommand = new GeneralCommandLine(stringArray);
                    ProcessOutput result2 = ExecUtil.execAndGetOutput((GeneralCommandLine)searchForInstallationDirectoryCommand);
                    List list = result2.getStdoutLines();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStdoutLines(...)");
                    String stdoutLine = (String)CollectionsKt.firstOrNull((List)list);
                    InstallToolboxActionKt.access$getLOG().debug("Toolbox installation directory: " + stdoutLine);
                    object = stdoutLine;
                    if (object == null) break block5;
                    String it = string = object;
                    boolean bl = false;
                    object = ((CharSequence)it).length() > 0 ? string : null;
                    if (object != null && (object = NioPathUtil.toNioPathOrNull((String)object)) != null) break block6;
                }
                Intrinsics.checkNotNull((Object)fallbackPath);
                object = fallbackPath;
            }
            return object;
        }
        catch (IOException exception) {
            InstallToolboxActionKt.access$getLOG().warn("Failed to discover Toolbox app on macOS. Falling back to the default path", (Throwable)exception);
            Intrinsics.checkNotNull((Object)fallbackPath);
            return fallbackPath;
        }
    }

    private final GeneralCommandLine createLaunchToolboxCommand() {
        Object object = this.discoverToolboxExecutablePath();
        if (object == null || (object = ((Object)object.toAbsolutePath()).toString()) == null) {
            return null;
        }
        Object exePath = object;
        OS oS = OS.CURRENT;
        return switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 1 -> {
                String[] var2_2 = new String[]{(String)exePath + ".exe"};
                GeneralCommandLine v2 = new GeneralCommandLine(var2_2);
                yield v2;
            }
            case 3 -> {
                String[] var2_3 = new String[]{exePath};
                GeneralCommandLine v4 = new GeneralCommandLine(var2_3);
                yield v4;
            }
            case 2 -> {
                String[] var2_4 = new String[]{"open", exePath};
                GeneralCommandLine v5 = new GeneralCommandLine(var2_4);
                yield v5;
            }
            default -> {
                InstallToolboxActionKt.access$getLOG().debug("Toolbox is not possible to launch on " + OS.CURRENT);
                yield null;
            }
        };
    }

    public static final /* synthetic */ Object access$killAllToolboxProcesses(ToolboxDiscovery $this, Continuation $completion) {
        return $this.killAllToolboxProcesses((Continuation<? super Boolean>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.macOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Linux.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

