/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.google.gson.JsonElement;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.service.JSLanguageServiceTracerUtilKt;
import com.intellij.lang.javascript.service.JSLanguageServiceUsagesCollector;
import com.intellij.lang.javascript.service.JSLanguageServiceUtilKt;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.typescript.compiler.PrioritySuspendingTaskQueue;
import com.intellij.lang.typescript.compiler.PrioritySuspendingTaskQueueFactory;
import com.intellij.lang.typescript.compiler.TypeScriptLanguageServiceAnnotatorCheckerProvider;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.compiler.TypeScriptServiceEvaluationSupport;
import com.intellij.lang.typescript.compiler.TypeScriptServiceQueueCommand;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptMessageBus;
import com.intellij.lang.typescript.compiler.languageService.ide.TypeScriptServiceCompletionContributorKt;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptQuickInfoResponse;
import com.intellij.lang.typescript.documentation.TypeScriptServiceQuickInfoFetcherKt;
import com.intellij.lang.typescript.lsp.BaseLspTypeScriptService;
import com.intellij.lang.typescript.lsp.BaseLspTypeScriptServiceCompletionSupport;
import com.intellij.lang.typescript.lsp.JSFrameworkLspServerDescriptor;
import com.intellij.lang.typescript.lsp.JSNodeLspServerDescriptor;
import com.intellij.lang.typescript.lsp.LspAnnotationError;
import com.intellij.lang.typescript.lsp.LspAnnotationErrorFilter;
import com.intellij.lang.typescript.lsp.LspCompletionEntry;
import com.intellij.lang.typescript.lsp.LspTypeScriptCompilerServiceCustomRequest;
import com.intellij.lang.typescript.tsc.TypeScriptServiceEvaluationSupportBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerManager;
import com.intellij.platform.lsp.api.LspServerSupportProvider;
import com.intellij.platform.lsp.api.customization.LspCompletionCustomizer;
import com.intellij.platform.lsp.api.customization.LspCompletionSupport;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.TextRangeAndMarkupContent;
import com.intellij.platform.lsp.impl.completion.LspCompletionContributorKt;
import com.intellij.platform.lsp.impl.documentation.LspDocumentationData;
import com.intellij.platform.lsp.impl.documentation.LspDocumentationDataKt;
import com.intellij.platform.lsp.impl.highlighting.DiagnosticAndQuickFixes;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.text.SemVer;
import io.opentelemetry.api.trace.Span;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.future.FutureKt;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00fa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0001oB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0004J\u0006\u0010#\u001a\u00020\u0017J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010.\u001a\u00020\u0017H\u0016J\u0006\u0010/\u001a\u00020)J\u0010\u00100\u001a\u00020)2\u0006\u00101\u001a\u00020&H\u0016J\u0010\u00102\u001a\u00020)2\u0006\u00101\u001a\u00020&H\u0016J \u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00101\u001a\u0002072\u0006\u0010%\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u00172\u0006\u00101\u001a\u000207H\u0016J6\u0010:\u001a\n\u0012\u0004\u0012\u00020<\u0018\u00010;2\u0006\u0010=\u001a\u00020&2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u00105\u001a\u000206H\u0096@\u00a2\u0006\u0002\u0010BJ.\u0010C\u001a\u00020)2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010D\u001a\u00020E2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020<0;H\u0016J\b\u0010G\u001a\u00020\u0017H\u0014J#\u0010H\u001a\b\u0012\u0004\u0012\u0002080I2\u0006\u0010>\u001a\u00020?2\u0006\u0010J\u001a\u000208H\u0016\u00a2\u0006\u0002\u0010KJ(\u0010L\u001a\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020O\u0018\u00010N\u0018\u00010M2\u0006\u00101\u001a\u0002072\u0006\u0010@\u001a\u00020AH\u0016J \u0010P\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010R0Q2\u0006\u0010S\u001a\u0002082\u0006\u0010T\u001a\u00020&H\u0017J\u0010\u0010U\u001a\u00020R2\u0006\u0010V\u001a\u00020WH\u0015J\u001e\u0010X\u001a\n\u0012\u0004\u0012\u00020Y\u0018\u00010;2\u0006\u00101\u001a\u000207H\u0096@\u00a2\u0006\u0002\u0010ZJ0\u0010[\u001a\u0004\u0018\u0001H\\\"\b\b\u0000\u0010\\*\u00020]2\u0014\u0010^\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020`\u0012\u0004\u0012\u0002H\\0_H\u0084@\u00a2\u0006\u0002\u0010aJ\u0018\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020e2\u0006\u0010=\u001a\u00020&H\u0002J\b\u0010f\u001a\u00020gH\u0014J(\u0010h\u001a\u0004\u0018\u00010i2\u0006\u0010j\u001a\u00020\u00112\u0006\u0010k\u001a\u00020`2\u0006\u0010l\u001a\u00020\u0017H\u0097@\u00a2\u0006\u0002\u0010mJ\b\u0010n\u001a\u00020)H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR!\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b*\u0010+\u00a8\u0006p"}, d2={"Lcom/intellij/lang/typescript/lsp/BaseLspTypeScriptService;", "Lcom/intellij/lang/typescript/compiler/TypeScriptService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "providerClass", "Ljava/lang/Class;", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Class;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "myLifecycleSpan", "Lio/opentelemetry/api/trace/Span;", "getMyLifecycleSpan", "()Lio/opentelemetry/api/trace/Span;", "prefix", "", "getPrefix", "()Ljava/lang/String;", "requestQueue", "Lcom/intellij/lang/typescript/compiler/PrioritySuspendingTaskQueue;", "isTypeEvaluationEnabled", "", "fallbackToBuiltInTypeEngine", "getFallbackToBuiltInTypeEngine", "()Z", "typeEvaluationSupport", "Lcom/intellij/lang/typescript/compiler/TypeScriptServiceEvaluationSupport;", "getTypeEvaluationSupport", "()Lcom/intellij/lang/typescript/compiler/TypeScriptServiceEvaluationSupport;", "getServiceVersion", "Lcom/intellij/util/text/SemVer;", "getServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "isTargetRunInitialized", "isDisabledByContext", "context", "Lcom/intellij/openapi/vfs/VirtualFile;", "lazyInit", "Lkotlin/Function0;", "", "getLazyInit", "()Lkotlin/jvm/functions/Function0;", "lazyInit$delegate", "Lkotlin/Lazy;", "isServiceCreated", "restart", "openEditor", "file", "closeLastEditor", "getCompletionMergeStrategy", "Lcom/intellij/lang/typescript/compiler/TypeScriptService$CompletionMergeStrategy;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/psi/PsiElement;", "canHighlight", "getCompletionItemsSuspending", "", "Lcom/intellij/lang/typescript/compiler/TypeScriptService$CompletionEntry;", "virtualFile", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/Document;ILcom/intellij/codeInsight/completion/CompletionParameters;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processCompletionEntries", "resultSet", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "completionEntries", "isServiceNavigationEnabled", "getNavigationFor", "", "sourceElement", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiElement;", "getSignatureHelp", "Ljava/util/concurrent/Future;", "Ljava/util/stream/Stream;", "Lcom/intellij/lang/javascript/psi/JSFunctionType;", "getQuickInfoAt", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptQuickInfoResponse;", "usageElement", "originalFile", "createQuickInfoResponse", "markupContent", "Lorg/eclipse/lsp4j/MarkupContent;", "highlightSuspending", "Lcom/intellij/lang/javascript/integration/JSAnnotationError;", "(Lcom/intellij/psi/PsiFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeCustomTsCommandOnRequestQueue", "T", "", "command", "Lcom/intellij/lang/typescript/compiler/TypeScriptServiceQueueCommand;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceObject;", "(Lcom/intellij/lang/typescript/compiler/TypeScriptServiceQueueCommand;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createAnnotationError", "Lcom/intellij/lang/typescript/lsp/LspAnnotationError;", "diagnosticAndQuickFixes", "Lcom/intellij/platform/lsp/impl/highlighting/DiagnosticAndQuickFixes;", "createAnnotationErrorFilter", "Lcom/intellij/lang/typescript/lsp/LspAnnotationErrorFilter;", "handleCustomTsServerCommand", "Lcom/google/gson/JsonElement;", "commandName", "args", "requiresNewEval", "(Ljava/lang/String;Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceObject;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "BaseLspTypeScriptServiceEvaluationSupport", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nBaseLspTypeScriptService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseLspTypeScriptService.kt\ncom/intellij/lang/typescript/lsp/BaseLspTypeScriptService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 7 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n*L\n1#1,330:1\n30#2,2:331\n1#3:333\n1#3:351\n24#4:334\n24#4:335\n24#4:336\n24#4:358\n24#4:359\n1563#5:337\n1634#5,3:338\n1617#5,9:341\n1869#5:350\n1870#5:352\n1626#5:353\n1563#5:360\n1634#5,3:361\n37#6:354\n36#6,3:355\n374#7:364\n*S KotlinDebug\n*F\n+ 1 BaseLspTypeScriptService.kt\ncom/intellij/lang/typescript/lsp/BaseLspTypeScriptService\n*L\n76#1:331,2\n174#1:351\n110#1:334\n112#1:335\n141#1:336\n211#1:358\n214#1:359\n148#1:337\n148#1:338,3\n174#1:341,9\n174#1:350\n174#1:352\n174#1:353\n226#1:360\n226#1:361,3\n187#1:354\n187#1:355,3\n233#1:364\n*E\n"})
public abstract class BaseLspTypeScriptService
implements TypeScriptService,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Class<? extends LspServerSupportProvider> providerClass;
    @Nullable
    private final Span myLifecycleSpan;
    @NotNull
    private final PrioritySuspendingTaskQueue requestQueue;
    @NotNull
    private final TypeScriptServiceEvaluationSupport typeEvaluationSupport;
    @NotNull
    private final Lazy lazyInit$delegate;

    public BaseLspTypeScriptService(@NotNull Project project, @NotNull Class<? extends LspServerSupportProvider> providerClass) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(providerClass, (String)"providerClass");
        this.project = project;
        this.providerClass = providerClass;
        this.myLifecycleSpan = JSLanguageServiceTracerUtilKt.createServerLifecycleSpanIfNeeded(this.getClass(), "LSP Server Lifecycle");
        ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
        boolean $i$f$service = false;
        Class<PrioritySuspendingTaskQueueFactory> serviceClass$iv = PrioritySuspendingTaskQueueFactory.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.requestQueue = ((PrioritySuspendingTaskQueueFactory)object).createQueue();
        this.typeEvaluationSupport = new BaseLspTypeScriptServiceEvaluationSupport(this.project);
        this.lazyInit$delegate = LazyKt.lazy(() -> BaseLspTypeScriptService.lazyInit_delegate$lambda$3(this));
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @Nullable
    protected final Span getMyLifecycleSpan() {
        return this.myLifecycleSpan;
    }

    @NotNull
    public String getPrefix() {
        return this.getName();
    }

    @Override
    public boolean isTypeEvaluationEnabled() {
        return false;
    }

    public boolean getFallbackToBuiltInTypeEngine() {
        return true;
    }

    @Override
    @NotNull
    public TypeScriptServiceEvaluationSupport getTypeEvaluationSupport() {
        return this.typeEvaluationSupport;
    }

    @Override
    @Nullable
    public SemVer getServiceVersion() {
        LspServerImpl lspServerImpl = this.getServer();
        LspServerDescriptor lspServerDescriptor = lspServerImpl != null ? lspServerImpl.getDescriptor() : null;
        JSFrameworkLspServerDescriptor jSFrameworkLspServerDescriptor = lspServerDescriptor instanceof JSFrameworkLspServerDescriptor ? (JSFrameworkLspServerDescriptor)lspServerDescriptor : null;
        return jSFrameworkLspServerDescriptor != null ? jSFrameworkLspServerDescriptor.getVersion() : null;
    }

    @Nullable
    protected final LspServerImpl getServer() {
        LspServerImpl lspServerImpl;
        LspServer it = (LspServer)CollectionsKt.firstOrNull((Iterable)LspServerManager.Companion.getInstance(this.project).getServersForProvider(this.providerClass));
        boolean bl = false;
        LspServerImpl lspServerImpl2 = it instanceof LspServerImpl ? (LspServerImpl)it : null;
        if (lspServerImpl2 != null) {
            LspServerImpl lspServerImpl3 = lspServerImpl2;
            it = lspServerImpl3;
            boolean bl2 = false;
            this.getLazyInit().invoke();
            lspServerImpl = lspServerImpl3;
        } else {
            lspServerImpl = null;
        }
        return lspServerImpl;
    }

    public final boolean isTargetRunInitialized() {
        LspServerImpl lspServerImpl = this.getServer();
        if (lspServerImpl == null || (lspServerImpl = lspServerImpl.getDescriptor()) == null) {
            return false;
        }
        LspServerImpl descriptor = lspServerImpl;
        return descriptor instanceof JSNodeLspServerDescriptor ? ((JSNodeLspServerDescriptor)descriptor).isTargetRunInitialized() : true;
    }

    @Override
    public boolean isDisabledByContext(@NotNull VirtualFile context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return false;
    }

    @NotNull
    public final Function0<Unit> getLazyInit() {
        Lazy lazy = this.lazyInit$delegate;
        return (Function0)lazy.getValue();
    }

    @Override
    public boolean isServiceCreated() {
        return this.getServer() != null;
    }

    @Override
    public final void restart() {
        BaseLspTypeScriptService $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(BaseLspTypeScriptService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        if (logger.isDebugEnabled()) {
            String string = "Restart language service %s.";
            Object[] objectArray = new Object[]{this.getName()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String message = string2;
            BaseLspTypeScriptService $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger2 = false;
            Logger logger2 = Logger.getInstance(BaseLspTypeScriptService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.debug(message, new Throwable());
        }
        LspServerManager.Companion.getInstance(this.project).stopAndRestartIfNeeded(this.providerClass);
        TypeScriptMessageBus.get(this.project).changed();
        this.getTypeEvaluationSupport().dropCaches();
        this.requestQueue.dropCaches();
    }

    @Override
    public void openEditor(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
    }

    @Override
    public void closeLastEditor(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
    }

    @Override
    @NotNull
    public TypeScriptService.CompletionMergeStrategy getCompletionMergeStrategy(@NotNull CompletionParameters parameters2, @NotNull PsiFile file, @NotNull PsiElement context2) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        TypeScriptService.CompletionMergeStrategy completionMergeStrategy = TypeScriptLanguageServiceUtil.getCompletionMergeStrategy(parameters2, file, context2);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)completionMergeStrategy), (String)"getCompletionMergeStrategy(...)");
        return completionMergeStrategy;
    }

    @Override
    public boolean canHighlight(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        TypeScriptAnnotatorCheckerProvider typeScriptAnnotatorCheckerProvider = TypeScriptAnnotatorCheckerProvider.getCheckerProvider((PsiElement)file);
        Intrinsics.checkNotNullExpressionValue((Object)typeScriptAnnotatorCheckerProvider, (String)"getCheckerProvider(...)");
        TypeScriptAnnotatorCheckerProvider provider = typeScriptAnnotatorCheckerProvider;
        return provider instanceof TypeScriptLanguageServiceAnnotatorCheckerProvider;
    }

    @Override
    @Nullable
    public Object getCompletionItemsSuspending(@NotNull VirtualFile virtualFile, @NotNull Document document, int offset, @NotNull CompletionParameters parameters2, @NotNull Continuation<? super List<? extends TypeScriptService.CompletionEntry>> $completion) {
        return BaseLspTypeScriptService.getCompletionItemsSuspending$suspendImpl(this, virtualFile, document, offset, parameters2, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object getCompletionItemsSuspending$suspendImpl(BaseLspTypeScriptService $this, VirtualFile virtualFile, Document document, int offset, CompletionParameters parameters, Continuation<? super List<? extends TypeScriptService.CompletionEntry>> $completion) {
        if (!($completion instanceof getCompletionItemsSuspending.1)) ** GOTO lbl-1000
        var24_6 = $completion;
        if ((var24_6.label & -2147483648) != 0) {
            var24_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ BaseLspTypeScriptService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BaseLspTypeScriptService.getCompletionItemsSuspending$suspendImpl(this.this$0, null, null, 0, null, (Continuation<? super List<? extends TypeScriptService.CompletionEntry>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var25_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $this.getServer();
                if (v0 == null) {
                    return null;
                }
                server = v0;
                completionCustomizer = server.getDescriptor().getLspCustomization().getCompletionCustomizer();
                if (!(completionCustomizer instanceof BaseLspTypeScriptServiceCompletionSupport)) {
                    $this$thisLogger$iv = $this;
                    $i$f$thisLogger = false;
                    v1 = Logger.getInstance(BaseLspTypeScriptService.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                    v1.warn("Unsupported LspCompletionCustomizer instance. Make sure that your LspServerDescriptor uses BaseLspTypeScriptServiceCompletionSupport.");
                    return null;
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)virtualFile);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)document);
                $continuation.L$3 = parameters;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)server);
                $continuation.L$5 = completionCustomizer;
                $continuation.I$0 = offset;
                $continuation.label = 1;
                v2 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getCompletionItemsSuspending$lambda$4(com.intellij.platform.lsp.impl.LspServerImpl com.intellij.openapi.vfs.VirtualFile int com.intellij.codeInsight.completion.CompletionParameters ), ()Ljava/util/concurrent/CompletableFuture;)((LspServerImpl)server, (VirtualFile)virtualFile, (int)offset, (CompletionParameters)parameters), (Continuation)$continuation);
                if (v2 == var25_8) {
                    return var25_8;
                }
                ** GOTO lbl46
            }
            case 1: {
                offset = $continuation.I$0;
                completionCustomizer = (LspCompletionCustomizer)$continuation.L$5;
                server = (LspServerImpl)$continuation.L$4;
                parameters = (CompletionParameters)$continuation.L$3;
                document = (Document)$continuation.L$2;
                virtualFile = (VirtualFile)$continuation.L$1;
                $this = (BaseLspTypeScriptService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl46:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)virtualFile);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)document);
                $continuation.L$3 = parameters;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)server);
                $continuation.L$5 = completionCustomizer;
                $continuation.I$0 = offset;
                $continuation.label = 2;
                v3 = FutureKt.await((CompletionStage)((CompletionStage)v2), (Continuation)$continuation);
                if (v3 == var25_8) {
                    return var25_8;
                }
                ** GOTO lbl68
            }
            case 2: {
                offset = $continuation.I$0;
                completionCustomizer = (LspCompletionCustomizer)$continuation.L$5;
                server = (LspServerImpl)$continuation.L$4;
                parameters = (CompletionParameters)$continuation.L$3;
                document = (Document)$continuation.L$2;
                virtualFile = (VirtualFile)$continuation.L$1;
                $this = (BaseLspTypeScriptService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl68:
                // 2 sources

                if ((var8_12 = (CompletionList)v3) != null) {
                    it = var8_12;
                    $i$a$-let-BaseLspTypeScriptService$getCompletionItemsSuspending$3 = false;
                    var12_16 = it.getItems();
                    if (var12_16 != null) {
                        var13_17 = var12_16;
                        $i$f$map = false;
                        var15_19 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var20_24 = (CompletionItem)item$iv$iv;
                            var21_25 = destination$iv$iv;
                            $i$a$-map-BaseLspTypeScriptService$getCompletionItemsSuspending$3$1 = false;
                            v4 = (LspCompletionSupport)completionCustomizer;
                            Intrinsics.checkNotNull((Object)it);
                            var21_25.add(new LspCompletionEntry(v4, parameters, (CompletionItem)it));
                        }
                        v5 = (List)destination$iv$iv;
                    } else {
                        v5 = CollectionsKt.emptyList();
                    }
                } else {
                    v5 = null;
                }
                return v5;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void processCompletionEntries(@NotNull Document document, int offset, @NotNull CompletionResultSet resultSet, @NotNull List<? extends TypeScriptService.CompletionEntry> completionEntries) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter(completionEntries, (String)"completionEntries");
        LspServerImpl lspServerImpl = this.getServer();
        if (lspServerImpl == null) {
            return;
        }
        LspServerImpl server = lspServerImpl;
        LspCompletionContributorKt.processCompletionItemsImpl((LspServerImpl)server, (Document)document, (int)offset, (CompletionResultSet)resultSet, completionEntries, BaseLspTypeScriptService::processCompletionEntries$lambda$7);
    }

    protected boolean isServiceNavigationEnabled() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PsiElement[] getNavigationFor(@NotNull Document document, @NotNull PsiElement sourceElement) {
        void $this$toTypedArray$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
        if (!this.isServiceNavigationEnabled()) {
            return new PsiElement[0];
        }
        LspServerImpl lspServerImpl = this.getServer();
        if (lspServerImpl == null) {
            return new PsiElement[0];
        }
        LspServerImpl server = lspServerImpl;
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return new PsiElement[0];
        }
        VirtualFile file = virtualFile;
        List raw = server.getRequestExecutor().getElementDefinitions(file, sourceElement.getTextOffset());
        Iterable $this$mapNotNull$iv = raw;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PsiFile targetPsiFile;
            VirtualFile targetFile;
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            LocationLink locationLink = (LocationLink)element$iv$iv;
            boolean bl2 = false;
            LspServerDescriptor lspServerDescriptor = server.getDescriptor();
            String string = locationLink.getTargetUri();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTargetUri(...)");
            if (lspServerDescriptor.findFileByUri(string) == null) {
                object = null;
            } else if (PsiManager.getInstance((Project)this.project).findFile(targetFile) == null) {
                object = null;
            } else if (PsiDocumentManager.getInstance((Project)this.project).getDocument(targetPsiFile) == null) {
                object = null;
            } else {
                PsiElement leaf;
                Document targetDocument;
                Position position = locationLink.getTargetSelectionRange().getStart();
                Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
                Integer offset = Lsp4jUtilKt.getOffsetInDocument((Document)targetDocument, (Position)position);
                object = offset != null ? (Intrinsics.areEqual((Object)(leaf = targetPsiFile.findElementAt(offset.intValue())), (Object)sourceElement) ? null : JSDocumentationUtils.getOriginalElementOrParentIfLeaf(leaf)) : (PsiElement)targetPsiFile;
            }
            if (object == null) continue;
            PsiElement it$iv$iv = object;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiElement[0]);
    }

    @Override
    @Nullable
    public Future<Stream<JSFunctionType>> getSignatureHelp(@NotNull PsiFile file, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return null;
    }

    @RequiresReadLock
    @NotNull
    public CompletableFuture<TypeScriptQuickInfoResponse> getQuickInfoAt(@NotNull PsiElement usageElement, @NotNull VirtualFile originalFile) {
        Intrinsics.checkNotNullParameter((Object)usageElement, (String)"usageElement");
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        LspServerImpl lspServerImpl = this.getServer();
        if (lspServerImpl == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        LspServerImpl server = lspServerImpl;
        PsiElement adjustedElement = JSLanguageServiceUtilKt.adjustIntoIdentifier(usageElement);
        TextRange textRange = adjustedElement.getTextRange();
        if (textRange == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        int localOffset = textRange.getStartOffset();
        int offset = InjectedLanguageManager.getInstance((Project)this.project).injectedToHost(usageElement, localOffset);
        TextRangeAndMarkupContent textRangeAndMarkupContent = server.getRequestExecutor().getHoverInformation(originalFile, offset, (int)TypeScriptServiceQuickInfoFetcherKt.getQuickInfoTimeout());
        if (textRangeAndMarkupContent == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        TextRangeAndMarkupContent hoverInfo = textRangeAndMarkupContent;
        TypeScriptQuickInfoResponse response2 = this.createQuickInfoResponse(hoverInfo.getMarkupContent());
        CompletableFuture<TypeScriptQuickInfoResponse> completableFuture = CompletableFuture.completedFuture(response2);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @RequiresReadLock
    @NotNull
    protected TypeScriptQuickInfoResponse createQuickInfoResponse(@NotNull MarkupContent markupContent) {
        boolean $i$f$thisLogger;
        TypeScriptQuickInfoResponse $this$thisLogger$iv;
        TypeScriptQuickInfoResponse typeScriptQuickInfoResponse;
        Intrinsics.checkNotNullParameter((Object)markupContent, (String)"markupContent");
        TypeScriptQuickInfoResponse $this$createQuickInfoResponse_u24lambda_u249 = typeScriptQuickInfoResponse = new TypeScriptQuickInfoResponse();
        boolean bl = false;
        LspDocumentationData lspDocumentationData = LspDocumentationDataKt.createLspDocumentationData((MarkupContent)markupContent);
        if (!Intrinsics.areEqual((Object)lspDocumentationData.getDefinitionLanguage(), (Object)"typescript")) {
            $this$thisLogger$iv = $this$createQuickInfoResponse_u24lambda_u249;
            $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(TypeScriptQuickInfoResponse.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unexpected definition language: " + lspDocumentationData.getDefinitionLanguage() + ", treating as TypeScript");
        }
        if (lspDocumentationData.getDescriptionMarkup() != LspDocumentationData.DescriptionMarkup.MARKDOWN) {
            $this$thisLogger$iv = $this$createQuickInfoResponse_u24lambda_u249;
            $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(TypeScriptQuickInfoResponse.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unexpected description markup: " + lspDocumentationData.getDescriptionMarkup() + ", treating as Markdown");
        }
        $this$createQuickInfoResponse_u24lambda_u249.displayString = lspDocumentationData.getDefinitionCodeBlock();
        $this$createQuickInfoResponse_u24lambda_u249.documentation = lspDocumentationData.getDescription();
        return typeScriptQuickInfoResponse;
    }

    @Override
    @Nullable
    public Object highlightSuspending(@NotNull PsiFile file, @NotNull Continuation<? super List<? extends JSAnnotationError>> $completion) {
        return BaseLspTypeScriptService.highlightSuspending$suspendImpl(this, file, $completion);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object highlightSuspending$suspendImpl(BaseLspTypeScriptService $this, PsiFile file, Continuation<? super List<? extends JSAnnotationError>> $completion) {
        void $this$mapTo$iv$iv;
        if (TypeScriptLanguageServiceUtil.saveChangedConfigs(file)) {
            return null;
        }
        LspServerImpl lspServerImpl = $this.getServer();
        if (lspServerImpl == null) {
            return null;
        }
        LspServerImpl server = lspServerImpl;
        VirtualFile virtualFile = file.getVirtualFile();
        Intrinsics.checkNotNull((Object)virtualFile);
        Iterable $this$map$iv = server.getDiagnosticsAndQuickFixes(virtualFile);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DiagnosticAndQuickFixes diagnosticAndQuickFixes = (DiagnosticAndQuickFixes)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add($this.createAnnotationError((DiagnosticAndQuickFixes)it, virtualFile));
        }
        List errors = (List)destination$iv$iv;
        return errors;
    }

    @Nullable
    protected final <T> Object executeCustomTsCommandOnRequestQueue(@NotNull TypeScriptServiceQueueCommand<? extends JSLanguageServiceObject, T> command, @NotNull Continuation<? super T> $completion) {
        boolean $i$f$currentCoroutineContext = false;
        CoroutineContext coroutineContext = $completion.getContext();
        return this.requestQueue.request((PrioritySuspendingTaskQueue.Task)new LspTypeScriptCompilerServiceCustomRequest<JSLanguageServiceObject, T>(command, this, this.project, coroutineContext), $completion);
    }

    private final LspAnnotationError createAnnotationError(DiagnosticAndQuickFixes diagnosticAndQuickFixes, VirtualFile virtualFile) {
        LspAnnotationErrorFilter filter2 = this.createAnnotationErrorFilter();
        return new LspAnnotationError(this.project, diagnosticAndQuickFixes, virtualFile.getCanonicalPath(), this.getPrefix(), filter2);
    }

    @NotNull
    protected LspAnnotationErrorFilter createAnnotationErrorFilter() {
        return new LspAnnotationErrorFilter(this.project);
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    @Nullable
    public Object handleCustomTsServerCommand(@NotNull String commandName, @NotNull JSLanguageServiceObject args, boolean requiresNewEval, @NotNull Continuation<? super JsonElement> $completion) {
        return BaseLspTypeScriptService.handleCustomTsServerCommand$suspendImpl(this, commandName, args, requiresNewEval, $completion);
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    static /* synthetic */ Object handleCustomTsServerCommand$suspendImpl(BaseLspTypeScriptService $this, String commandName, JSLanguageServiceObject args, boolean requiresNewEval, Continuation<? super JsonElement> $completion) {
        return null;
    }

    public void dispose() {
    }

    private static final Unit lazyInit_delegate$lambda$3$lambda$2() {
        return Unit.INSTANCE;
    }

    private static final Function0 lazyInit_delegate$lambda$3(BaseLspTypeScriptService this$0) {
        JSLanguageServiceUsagesCollector.triggerServiceFirstStart(this$0.project, this$0.getClass());
        return BaseLspTypeScriptService::lazyInit_delegate$lambda$3$lambda$2;
    }

    private static final CompletableFuture getCompletionItemsSuspending$lambda$4(LspServerImpl $server, VirtualFile $virtualFile, int $offset, CompletionParameters $parameters) {
        return $server.getRequestExecutor().getCompletionListAsync($virtualFile, $offset, $parameters.isAutoPopup());
    }

    private static final LookupElement processCompletionEntries$lambda$7(TypeScriptService.CompletionEntry completionEntry) {
        Intrinsics.checkNotNullParameter((Object)completionEntry, (String)"completionEntry");
        return TypeScriptServiceCompletionContributorKt.decorateTypeScriptServiceLookupElement(completionEntry.createLookupElement());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016J0\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\b\b\u0000\u0010\u0018*\u00020\u00192\u0014\u0010\u001a\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u001c\u0012\u0004\u0012\u0002H\u00180\u001bH\u0094@\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001f2\u0006\u0010!\u001a\u00020\"H\u0016J\u001f\u0010#\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\"\u0018\u00010\u001f2\u0006\u0010$\u001a\u00020 H\u0010\u00a2\u0006\u0002\b%R\u0014\u0010\u0006\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006&"}, d2={"Lcom/intellij/lang/typescript/lsp/BaseLspTypeScriptService$BaseLspTypeScriptServiceEvaluationSupport;", "Lcom/intellij/lang/typescript/tsc/TypeScriptServiceEvaluationSupportBase;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/lang/typescript/lsp/BaseLspTypeScriptService;Lcom/intellij/openapi/project/Project;)V", "service", "Lcom/intellij/lang/typescript/compiler/TypeScriptService;", "getService", "()Lcom/intellij/lang/typescript/compiler/TypeScriptService;", "serviceLifespan", "Lio/opentelemetry/api/trace/Span;", "getServiceLifespan", "()Lio/opentelemetry/api/trace/Span;", "fallbackToBuiltInTypeEngine", "", "getFallbackToBuiltInTypeEngine", "()Z", "commitDocuments", "", "updateContext", "Lcom/intellij/lang/typescript/compiler/TypeScriptServiceEvaluationSupport$UpdateContextInfo;", "(Lcom/intellij/lang/typescript/compiler/TypeScriptServiceEvaluationSupport$UpdateContextInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeCommandOnRequestQueue", "T", "", "command", "Lcom/intellij/lang/typescript/compiler/TypeScriptServiceQueueCommand;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceObject;", "(Lcom/intellij/lang/typescript/compiler/TypeScriptServiceQueueCommand;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFilePath", "Ljava/util/concurrent/CompletableFuture;", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findLocalFileByPath", "path", "findLocalFileByPath$intellij_javascript_impl", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nBaseLspTypeScriptService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseLspTypeScriptService.kt\ncom/intellij/lang/typescript/lsp/BaseLspTypeScriptService$BaseLspTypeScriptServiceEvaluationSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,330:1\n1#2:331\n*E\n"})
    private final class BaseLspTypeScriptServiceEvaluationSupport
    extends TypeScriptServiceEvaluationSupportBase {
        public BaseLspTypeScriptServiceEvaluationSupport(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project);
        }

        @Override
        @NotNull
        protected TypeScriptService getService() {
            return BaseLspTypeScriptService.this;
        }

        @Override
        @Nullable
        protected Span getServiceLifespan() {
            return BaseLspTypeScriptService.this.getMyLifecycleSpan();
        }

        @Override
        public boolean getFallbackToBuiltInTypeEngine() {
            return BaseLspTypeScriptService.this.getFallbackToBuiltInTypeEngine();
        }

        @Override
        @Nullable
        public Object commitDocuments(@NotNull TypeScriptServiceEvaluationSupport.UpdateContextInfo updateContext, @NotNull Continuation<? super Unit> $completion) {
            return Unit.INSTANCE;
        }

        @Override
        @Nullable
        protected <T> Object executeCommandOnRequestQueue(@NotNull TypeScriptServiceQueueCommand<? extends JSLanguageServiceObject, T> command, @NotNull Continuation<? super T> $completion) {
            return BaseLspTypeScriptService.this.executeCustomTsCommandOnRequestQueue(command, $completion);
        }

        @Override
        @Nullable
        public CompletableFuture<String> getFilePath(@NotNull VirtualFile virtualFile) {
            String fileUri;
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            LspServerImpl lspServerImpl = BaseLspTypeScriptService.this.getServer();
            String string = lspServerImpl != null && (lspServerImpl = lspServerImpl.getDescriptor()) != null ? lspServerImpl.getFileUri(virtualFile) : (fileUri = null);
            if (fileUri == null) {
                CompletableFuture<String> completableFuture;
                String string2 = JSLanguageServiceUtilKt.normalizedNameAndPath(virtualFile);
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    completableFuture = CompletableFuture.completedFuture(it);
                } else {
                    completableFuture = null;
                }
                return completableFuture;
            }
            return CompletableFuture.completedFuture(fileUri);
        }

        @Override
        @Nullable
        public CompletableFuture<VirtualFile> findLocalFileByPath$intellij_javascript_impl(@NotNull String path2) {
            CompletableFuture<VirtualFile> localPathPromise;
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            LspServerImpl lspServerImpl = BaseLspTypeScriptService.this.getServer();
            LspServerDescriptor lspServerDescriptor = lspServerImpl != null ? lspServerImpl.getDescriptor() : null;
            JSNodeLspServerDescriptor jSNodeLspServerDescriptor = lspServerDescriptor instanceof JSNodeLspServerDescriptor ? (JSNodeLspServerDescriptor)lspServerDescriptor : null;
            CompletableFuture<Object> completableFuture = localPathPromise = jSNodeLspServerDescriptor != null ? jSNodeLspServerDescriptor.findLocalFileByPathAsync(path2) : null;
            if (localPathPromise == null) {
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path2);
                if (virtualFile == null) {
                    return null;
                }
                VirtualFile virtualFile2 = virtualFile;
                return CompletableFuture.completedFuture(virtualFile2);
            }
            return localPathPromise;
        }
    }
}

