/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSFunctionCollector {
    private final Map<String, Object> functions = new LinkedHashMap<String, Object>();

    @NotNull
    public static JSFunctionCollector collectAllVisibleClassFunctions(@NotNull JSClass jsClass, @Nullable JSFunctionCollector _functions, final @Nullable Predicate<? super JSFunction> filter2) {
        if (jsClass == null) {
            JSFunctionCollector.$$$reportNull$$$0(0);
        }
        final JSFunctionCollector functions = _functions != null ? _functions : new JSFunctionCollector();
        jsClass.processDeclarations(new ResolveProcessor(null){
            {
                super(name);
                this.setToProcessHierarchy(true);
                this.setLocalResolve(true);
                this.setToProcessActionScriptImplicits(false);
            }

            public boolean execute(@NotNull PsiElement element2, @NotNull ResolveState state) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element2 instanceof JSFunction) {
                    JSFunction function = (JSFunction)element2;
                    if (function.isConstructor()) {
                        return true;
                    }
                    if (filter2 != null && !filter2.test(function)) {
                        return true;
                    }
                    if (function instanceof TypeScriptFunction && ((TypeScriptFunction)function).isOverloadDeclaration()) {
                        return true;
                    }
                    functions.add(function);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/validation/JSFunctionCollector$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, ResolveState.initial(), jsClass, jsClass);
        JSFunctionCollector jSFunctionCollector = functions;
        if (jSFunctionCollector == null) {
            JSFunctionCollector.$$$reportNull$$$0(1);
        }
        return jSFunctionCollector;
    }

    @Nullable
    public JSFunction findFunctionWithTheSameKind(String name, JSFunction.FunctionKind kind) {
        Object candidate = this.functions.get(name);
        if (candidate instanceof JSFunction) {
            return ((JSFunction)candidate).getKind() == kind ? (JSFunction)candidate : null;
        }
        if (candidate instanceof JSFunction[]) {
            JSFunction[] jsFunctions;
            for (JSFunction fun : jsFunctions = (JSFunction[])candidate) {
                if (fun.getKind() != kind) continue;
                return fun;
            }
        }
        return null;
    }

    public void add(@NotNull JSFunction function) {
        String s;
        Object functionValue;
        if (function == null) {
            JSFunctionCollector.$$$reportNull$$$0(2);
        }
        if ((functionValue = this.functions.get(s = function.getName())) == null) {
            this.functions.put(s, function);
        } else if (functionValue instanceof JSFunction) {
            JSFunction oldFunction = (JSFunction)functionValue;
            if (this.findFunctionWithTheSameKind(s, function.getKind()) == null) {
                this.functions.put(s, new JSFunction[]{oldFunction, function});
            }
        }
    }

    public void removeFunctionByNameAndKind(String name, JSFunction.FunctionKind kind) {
        JSFunction fn;
        Object o = this.functions.get(name);
        if (o instanceof JSFunction && (fn = (JSFunction)o).getKind() == kind) {
            this.functions.remove(name);
        } else if (o instanceof JSFunction[]) {
            JSFunction[] fns = (JSFunction[])o;
            this.functions.put(name, fns[0].getKind() == kind ? fns[1] : fns[0]);
        }
    }

    @NotNull
    public Collection<JSFunction> getFunctions() {
        ArrayList<JSFunction> result2 = new ArrayList<JSFunction>();
        for (Map.Entry<String, Object> entry : this.functions.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof JSFunction[]) {
                ContainerUtil.addAll(result2, (Object[])((JSFunction[])value));
                continue;
            }
            result2.add((JSFunction)value);
        }
        ArrayList<JSFunction> arrayList = result2;
        if (arrayList == null) {
            JSFunctionCollector.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public boolean hasFunctionWithTheSameKind(String name, JSFunction.FunctionKind kind) {
        return this.findFunctionWithTheSameKind(name, kind) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/JSFunctionCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSFunctionCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllVisibleClassFunctions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectAllVisibleClassFunctions";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

