/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.protocol;

import com.intellij.util.PlatformUtils;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "", "path", "", "<init>", "(Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.javascript.impl"})
public final class LocalFilePath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String path;

    private LocalFilePath(String path2) {
        this.path = path2;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        LocalFilePath path2 = (LocalFilePath)other;
        return Intrinsics.areEqual((Object)this.path, (Object)path2.path);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.path};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return this.path;
    }

    @JvmStatic
    @NotNull
    public static final LocalFilePath asLocalFilePath$intellij_javascript_impl(@NotNull String $this$asLocalFilePath_u24intellij_javascript_impl) {
        return Companion.asLocalFilePath$intellij_javascript_impl($this$asLocalFilePath_u24intellij_javascript_impl);
    }

    @JvmStatic
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static final LocalFilePath create(@Nullable String path2) {
        return Companion.create(path2);
    }

    @JvmStatic
    @JvmName(name="createNotNull")
    @NotNull
    public static final LocalFilePath createNotNull(@NotNull String path2) {
        return Companion.createNotNull(path2);
    }

    @JvmStatic
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static final String getPath(@Nullable LocalFilePath filePath) {
        return Companion.getPath(filePath);
    }

    @JvmStatic
    @Nullable
    public static final Path getNioPath(@Nullable LocalFilePath filePath) {
        return Companion.getNioPath(filePath);
    }

    @JvmStatic
    @NotNull
    public static final String asLocalFilePath(@NotNull Path $this$asLocalFilePath) {
        return Companion.asLocalFilePath($this$asLocalFilePath);
    }

    @JvmStatic
    @NotNull
    public static final String stripRemoteProtocol(@NotNull String path2) {
        return Companion.stripRemoteProtocol(path2);
    }

    public /* synthetic */ LocalFilePath(String path2, DefaultConstructorMarker $constructor_marker) {
        this(path2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0001\u00a2\u0006\u0002\b\u0007J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0007J\u0015\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\b\nJ\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0007J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0007J\f\u0010\u0004\u001a\u00020\u0006*\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/javascript/service/protocol/LocalFilePath$Companion;", "", "<init>", "()V", "asLocalFilePath", "Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "", "asLocalFilePath$intellij_javascript_impl", "create", "path", "createNotNull", "getPath", "filePath", "getNioPath", "Ljava/nio/file/Path;", "stripRemoteProtocol", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LocalFilePath asLocalFilePath$intellij_javascript_impl(@NotNull String $this$asLocalFilePath) {
            Intrinsics.checkNotNullParameter((Object)$this$asLocalFilePath, (String)"<this>");
            return new LocalFilePath($this$asLocalFilePath, null);
        }

        @JvmStatic
        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public final LocalFilePath create(@Nullable String path2) {
            return path2 != null ? new LocalFilePath(path2, null) : null;
        }

        @JvmStatic
        @JvmName(name="createNotNull")
        @NotNull
        public final LocalFilePath createNotNull(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return new LocalFilePath(path2, null);
        }

        @JvmStatic
        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public final String getPath(@Nullable LocalFilePath filePath) {
            LocalFilePath localFilePath = filePath;
            return localFilePath != null ? localFilePath.getPath() : null;
        }

        @JvmStatic
        @Nullable
        public final Path getNioPath(@Nullable LocalFilePath filePath) {
            LocalFilePath localFilePath = filePath;
            String pathStr = localFilePath != null ? localFilePath.getPath() : null;
            Object object = pathStr;
            if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
                try {
                    object = Path.of(pathStr, new String[0]);
                }
                catch (InvalidPathException e) {
                    object = null;
                }
                return object;
            }
            return null;
        }

        @JvmStatic
        @NotNull
        public final String asLocalFilePath(@NotNull Path $this$asLocalFilePath) {
            Intrinsics.checkNotNullParameter((Object)$this$asLocalFilePath, (String)"<this>");
            String string = $this$asLocalFilePath.toFile().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            return string;
        }

        @JvmStatic
        @NotNull
        public final String stripRemoteProtocol(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            if (PlatformUtils.isFleetBackend() && StringsKt.startsWith$default((String)path2, (String)"/fsd:", (boolean)false, (int)2, null)) {
                Path path3 = Path.of(path2, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"of(...)");
                return this.asLocalFilePath(path3);
            }
            return path2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

