/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.google.common.collect.ImmutableMap;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.jshint.JSHintUtil;
import com.intellij.lang.javascript.linter.option.Option;
import com.intellij.lang.javascript.linter.option.OptionType;
import com.intellij.lang.javascript.linter.option.OptionTypes;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JSHintOption implements Option
{
    BITWISE(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.bitwise.description.short", new Object[0])),
    CAMELCASE(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.camelcase.description.short", new Object[0])),
    CURLY(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.curly.description.short", new Object[0])),
    ENFORCEALL(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.enforceall.description.short", new Object[0])),
    EQEQEQ(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.eqeqeq.description.short", new Object[0])),
    ES3(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.es3.description.short", new Object[0])),
    ES5(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.es5.description.short", new Object[0])),
    FORIN(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.forin.description.short", new Object[0])),
    FREEZE(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.freeze.description.short", new Object[0])),
    IMMED(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.immed.description.short", new Object[0])),
    NEWCAP(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.newcap.description.short", new Object[0])),
    NOARG(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.noarg.description.short", new Object[0])),
    NOCOMMA(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.nocomma.description.short", new Object[0])),
    NOEMPTY(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.noempty.description.short", new Object[0])),
    NONBSP(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.nonbsp.description.short", new Object[0])),
    NONEW(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.nonew.description.short", new Object[0])),
    PLUSPLUS(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.plusplus.description.short", new Object[0])),
    UNDEF(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.undef.description.short", new Object[0])),
    VARSTMT(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.varstmt.description.short", new Object[0])),
    ESVERSION(OptionTypes.INTEGER, null, JavaScriptBundle.messagePointer("jshint.option.esversion.description.short", new Object[0])),
    STRICT(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.strict.description.short", new Object[0])),
    TRAILING(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.trailing.description.short", new Object[0])),
    LATEDEF(JSHintUtil.LATEDEF_TYPE, (Object)false, JavaScriptBundle.messagePointer("jshint.option.latedef.description.short", new Object[0])),
    UNUSED(JSHintUtil.UNUSED_TYPE, (Object)false, JavaScriptBundle.messagePointer("jshint.option.unused.description.short", new Object[0])),
    INDENT(OptionTypes.INTEGER, null, JavaScriptBundle.messagePointer("jshint.option.indent.description.short", new Object[0])),
    QUOTMARK(JSHintUtil.QUOTMARK_TYPE, (Object)false, JavaScriptBundle.messagePointer("jshint.option.quotmark.description.short", new Object[0])),
    MAXPARAMS(OptionTypes.INTEGER, null, JavaScriptBundle.messagePointer("jshint.option.maxparams.description.short", new Object[0])),
    MAXDEPTH(OptionTypes.INTEGER, null, JavaScriptBundle.messagePointer("jshint.option.maxdepth.description.short", new Object[0])),
    MAXSTATEMENTS(OptionTypes.INTEGER, null, JavaScriptBundle.messagePointer("jshint.option.maxstatements.description.short", new Object[0])),
    MAXCOMPLEXITY(OptionTypes.INTEGER, null, JavaScriptBundle.messagePointer("jshint.option.maxcomplexity.description.short", new Object[0])),
    MAXLEN(OptionTypes.INTEGER, null, JavaScriptBundle.messagePointer("jshint.option.maxlen.description.short", new Object[0])),
    ASI(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.asi.description.short", new Object[0])),
    BOSS(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.boss.description.short", new Object[0])),
    DEBUG(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.debug.description.short", new Object[0])),
    ELISION(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.elision.description.short", new Object[0])),
    EQNULL(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.eqnull.description.short", new Object[0])),
    ESNEXT(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.esnext.description.short", new Object[0])),
    EVIL(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.evil.description.short", new Object[0])),
    EXPR(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.expr.description.short", new Object[0])),
    FUNCSCOPE(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.funcscope.description.short", new Object[0])),
    FUTUREHOSTILE(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.futurehostile.description.short", new Object[0])),
    GCL(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.gcl.description.short", new Object[0])),
    GLOBALSTRICT(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.globalstrict.description.short", new Object[0])),
    ITERATOR(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.iterator.description.short", new Object[0])),
    LASTSEMIC(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.lastsemic.description.short", new Object[0])),
    LAXBREAK(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.laxbreak.description.short", new Object[0])),
    LAXCOMMA(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.laxcomma.description.short", new Object[0])),
    LOOPFUNC(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.loopfunc.description.short", new Object[0])),
    MOZ(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.moz.description.short", new Object[0])),
    MULTISTR(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.multistr.description.short", new Object[0])),
    NOTYPEOF(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.notypeof.description.short", new Object[0])),
    PROTO(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.proto.description.short", new Object[0])),
    SCRIPTURL(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.scripturl.description.short", new Object[0])),
    SMARTTABS(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.smarttabs.description.short", new Object[0])),
    SHADOW(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.shadow.description.short", new Object[0])),
    SINGLEGROUPS("singleGroups", OptionTypes.BOOLEAN, false, JavaScriptBundle.messagePointer("jshint.option.singlegroups.description.short", new Object[0])),
    SUB(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.sub.description.short", new Object[0])),
    SUPERNEW(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.supernew.description.short", new Object[0])),
    VALIDTHIS(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.validthis.description.short", new Object[0])),
    WITHSTMT(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.withstmt.description.short", new Object[0])),
    NOYIELD(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.noyield.description.short", new Object[0])),
    BROWSER(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.browser.description.short", new Object[0])),
    BROWSERIFY(OptionTypes.BOOLEAN, (Object)false, "Browserify"),
    COUCH(OptionTypes.BOOLEAN, (Object)false, "CouchDB"),
    DEVEL(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.devel.description.short", new Object[0])),
    DOJO(OptionTypes.BOOLEAN, (Object)false, "Dojo Toolkit"),
    JASMINE(OptionTypes.BOOLEAN, (Object)false, "Jasmine"),
    JQUERY(OptionTypes.BOOLEAN, (Object)false, "jQuery"),
    MOCHA(OptionTypes.BOOLEAN, (Object)false, "Mocha"),
    MODULE(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.module.description.short", new Object[0])),
    MOOTOOLS(OptionTypes.BOOLEAN, (Object)false, "MooTools"),
    NODE(OptionTypes.BOOLEAN, (Object)false, "Node.js"),
    NONSTANDARD(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.nonstandard.description.short", new Object[0])),
    PHANTOM(OptionTypes.BOOLEAN, (Object)false, "PhantomJS"),
    PROTOTYPEJS(OptionTypes.BOOLEAN, (Object)false, "Prototype"),
    QUNIT(OptionTypes.BOOLEAN, (Object)false, "QUnit"),
    RHINO(OptionTypes.BOOLEAN, (Object)false, "Rhino"),
    SHELLJS(OptionTypes.BOOLEAN, (Object)false, "ShellJS"),
    TYPED(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.typed.description.short", new Object[0])),
    WORKER(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.worker.description.short", new Object[0])),
    WSH(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.wsh.description.short", new Object[0])),
    YUI(OptionTypes.BOOLEAN, (Object)false, "YUI"),
    NOMEN(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.nomen.description.short", new Object[0])),
    ONEVAR(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.onevar.description.short", new Object[0])),
    PASSFAIL(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.passfail.description.short", new Object[0])),
    WHITE(OptionTypes.BOOLEAN, (Object)false, JavaScriptBundle.messagePointer("jshint.option.white.description.short", new Object[0])),
    MAXERR(OptionTypes.INTEGER, (Object)50, JavaScriptBundle.messagePointer("jshint.option.maxerr.description.short", new Object[0])),
    PREDEF(OptionTypes.STRING, null, JavaScriptBundle.messagePointer("jshint.option.predef.description.short", new Object[0]), "globals");

    private static final ImmutableMap<String, JSHintOption> OPTION_BY_KEY_MAP;
    private final OptionType<Object> myType;
    private final Object myDefaultValue;
    private final String myKey;
    private final Supplier<@NlsContexts.DetailedDescription String> myRawShortDescription;
    private final String myKeyAlias;

    private JSHintOption(@NlsContexts.DetailedDescription OptionType<?> type2, Object defaultValue, String rawShortDescription) {
        if (type2 == null) {
            JSHintOption.$$$reportNull$$$0(0);
        }
        this(type2, defaultValue, () -> rawShortDescription, null);
    }

    private JSHintOption(@NotNull OptionType<@NlsContexts.DetailedDescription ?> type2, Object defaultValue, Supplier<String> rawShortDescription) {
        if (type2 == null) {
            JSHintOption.$$$reportNull$$$0(1);
        }
        if (rawShortDescription == null) {
            JSHintOption.$$$reportNull$$$0(2);
        }
        this(type2, defaultValue, rawShortDescription, null);
    }

    private JSHintOption(@Nullable String key, @NotNull OptionType<@NlsContexts.DetailedDescription ?> type2, Object defaultValue, Supplier<String> rawShortDescription) {
        if (key == null) {
            JSHintOption.$$$reportNull$$$0(3);
        }
        if (type2 == null) {
            JSHintOption.$$$reportNull$$$0(4);
        }
        if (rawShortDescription == null) {
            JSHintOption.$$$reportNull$$$0(5);
        }
        this(key, type2, defaultValue, rawShortDescription, null);
    }

    private JSHintOption(@NotNull OptionType<@NlsContexts.DetailedDescription ?> type2, @Nullable Object defaultValue, Supplier<String> rawShortDescription, String keyAlias) {
        if (type2 == null) {
            JSHintOption.$$$reportNull$$$0(6);
        }
        if (rawShortDescription == null) {
            JSHintOption.$$$reportNull$$$0(7);
        }
        this(null, type2, defaultValue, rawShortDescription, keyAlias);
    }

    private JSHintOption(@Nullable String key, @NotNull OptionType<@NlsContexts.DetailedDescription ?> type2, @Nullable Object defaultValue, Supplier<String> rawShortDescription, String keyAlias) {
        if (type2 == null) {
            JSHintOption.$$$reportNull$$$0(8);
        }
        if (rawShortDescription == null) {
            JSHintOption.$$$reportNull$$$0(9);
        }
        this.myType = type2;
        this.myDefaultValue = defaultValue;
        this.myKey = key != null ? key : StringUtil.toLowerCase((String)this.name());
        this.myKeyAlias = keyAlias;
        this.myRawShortDescription = rawShortDescription;
        if (defaultValue != null && !this.myType.isValidValue(defaultValue)) {
            throw new RuntimeException("Illegal default value '" + String.valueOf(defaultValue) + "' for key '" + this.myKey + "'");
        }
    }

    @Override
    @NotNull
    @NlsSafe
    public String getKey() {
        String string = this.myKey;
        if (string == null) {
            JSHintOption.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public OptionType<Object> getType() {
        OptionType<Object> optionType = this.myType;
        if (optionType == null) {
            JSHintOption.$$$reportNull$$$0(11);
        }
        return optionType;
    }

    @Nullable
    public Object fromString(@Nullable String valueStr) {
        Object parsed = null;
        if (valueStr != null) {
            parsed = this.myType.fromString(valueStr);
        }
        return parsed != null ? parsed : this.myDefaultValue;
    }

    @NlsContexts.DetailedDescription
    @NotNull
    public String getShortDescription() {
        String string = JSHintOption.join(this.getShortDescriptionFragments());
        if (string == null) {
            JSHintOption.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public String getKeyAlias() {
        return this.myKeyAlias;
    }

    @NotNull
    public List<Fragment> getShortDescriptionFragments() {
        return JSHintOption.parseTextFragments(this.myRawShortDescription.get());
    }

    @Nullable
    public static JSHintOption findByName(@NotNull String optionName) {
        if (optionName == null) {
            JSHintOption.$$$reportNull$$$0(13);
        }
        return (JSHintOption)OPTION_BY_KEY_MAP.get((Object)optionName);
    }

    public String toString() {
        return this.name() + ", type: " + String.valueOf(this.getType());
    }

    @Nullable
    public Object getDefaultValue() {
        return this.myDefaultValue;
    }

    @NotNull
    private static List<Fragment> parseTextFragments(@NlsContexts.DetailedDescription @NotNull String text) {
        if (text == null) {
            JSHintOption.$$$reportNull$$$0(14);
        }
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        int unprocessedIndex = 0;
        String startTag = "<code>";
        String endTag = "</code>";
        while (unprocessedIndex < text.length()) {
            int endIndex;
            int startIndex = text.indexOf(startTag, unprocessedIndex);
            boolean hasCodeFragment = false;
            if (startIndex >= 0 && (endIndex = text.indexOf(endTag, startIndex)) >= 0) {
                fragments.add(new Fragment(text.substring(unprocessedIndex, startIndex), false));
                fragments.add(new Fragment(text.substring(startIndex + startTag.length(), endIndex), true));
                unprocessedIndex = endIndex + endTag.length();
                hasCodeFragment = true;
            }
            if (hasCodeFragment) continue;
            fragments.add(new Fragment(text.substring(unprocessedIndex), false));
            unprocessedIndex = text.length();
        }
        ArrayList<Fragment> arrayList = fragments;
        if (arrayList == null) {
            JSHintOption.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Nls
    private static String join(@NotNull List<Fragment> fragments) {
        if (fragments == null) {
            JSHintOption.$$$reportNull$$$0(16);
        }
        @Nls StringBuilder out = new StringBuilder();
        for (Fragment fragment : fragments) {
            out.append(fragment.getText());
        }
        return out.toString();
    }

    static {
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        for (JSHintOption option : JSHintOption.values()) {
            builder2.put((Object)option.getKey(), (Object)option);
            String keyAlias = option.getKeyAlias();
            if (keyAlias == null) continue;
            builder2.put((Object)keyAlias, (Object)option);
        }
        OPTION_BY_KEY_MAP = builder2.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawShortDescription";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/JSHintOption";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintOption";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortDescription";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTextFragments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseTextFragments";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 15 -> new IllegalStateException(string);
        };
    }

    public static final class Fragment {
        @Nls
        private final String myText;
        private final boolean myCode;

        private Fragment(@Nls @NotNull String text, boolean code) {
            if (text == null) {
                Fragment.$$$reportNull$$$0(0);
            }
            this.myText = text;
            this.myCode = code;
        }

        @NotNull
        @Nls
        public String getText() {
            String string = this.myText;
            if (string == null) {
                Fragment.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isCode() {
            return this.myCode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/JSHintOption$Fragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintOption$Fragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

