/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.lsp;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.net.URI;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.Position;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0000\u00a8\u0006\r"}, d2={"getPositionByOffset", "Lorg/eclipse/lsp4j/Position;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "toURI", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "canonicalizePath", "uri", "toPath", "intellij.javascript.impl"})
public final class FlowJSLspServiceKt {
    @NotNull
    public static final Position getPositionByOffset(@NotNull Document document, int offset) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        int lineNumber = document.getLineNumber(offset);
        return new Position(lineNumber, offset - document.getLineStartOffset(lineNumber));
    }

    @NotNull
    public static final String toURI(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Object path2 = FlowJSLspServiceKt.canonicalizePath(string);
        if (!StringsKt.startsWith$default((String)path2, (String)"/", (boolean)false, (int)2, null)) {
            path2 = "/" + (String)path2;
        }
        return "file://" + (String)path2;
    }

    @NotNull
    public static final String canonicalizePath(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = PathUtil.driveLetterToLowerCase((String)StringsKt.replace$default((String)uri, (char)'\\', (char)'/', (boolean)false, (int)4, null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"driveLetterToLowerCase(...)");
        return string;
    }

    @NotNull
    public static final String toPath(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = FilesKt.normalize((File)new File(new URI(uri))).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }
}

