/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.CallSite;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class PackageJsonUtil {
    private static final Logger LOG = Logger.getInstance(PackageJsonUtil.class);
    @NlsSafe
    public static final String FILE_NAME = "package.json";
    public static final String DEPENDENCIES = "dependencies";
    public static final String DEV_DEPENDENCIES = "devDependencies";
    public static final List<String> PROD_DEV_DEPENDENCIES = List.of("dependencies", "devDependencies");
    private static final List<String> ALL_DEPENDENCIES = List.of("dependencies", "devDependencies", "optionalDependencies", "peerDependencies", "bundledDependencies", "bundleDependencies");

    private PackageJsonUtil() {
    }

    public static boolean isInsidePackageJsonFile(@NotNull PsiElement element2) {
        if (element2 == null) {
            PackageJsonUtil.$$$reportNull$$$0(0);
        }
        return PackageJsonUtil.getContainingPackageJsonFile(element2) != null;
    }

    @Nullable
    public static JsonFile getContainingPackageJsonFile(@NotNull PsiElement element2) {
        if (element2 == null) {
            PackageJsonUtil.$$$reportNull$$$0(1);
        }
        PsiFile file = element2.getContainingFile();
        return PackageJsonUtil.asPackageJsonFile(file);
    }

    @Contract(value="null -> null")
    @Nullable
    public static JsonFile asPackageJsonFile(@Nullable PsiFile file) {
        return PackageJsonUtil.isPackageJsonFile(file) ? (JsonFile)file : null;
    }

    @Contract(value="null -> false")
    public static boolean isPackageJsonFile(@Nullable PsiFile file) {
        return file instanceof JsonFile && FILE_NAME.equals(file.getName());
    }

    @Contract(value="null -> false")
    public static boolean isPackageJsonFile(@Nullable VirtualFile file) {
        return file != null && !file.isDirectory() && StringUtil.equals((CharSequence)FILE_NAME, (CharSequence)file.getNameSequence());
    }

    @Contract(value="null -> false")
    public static boolean isPackageJsonFileName(@Nullable CharSequence fileName) {
        return StringUtil.equals((CharSequence)FILE_NAME, (CharSequence)fileName);
    }

    public static boolean isTopLevelProperty(@NotNull JsonProperty property) {
        PsiElement parent;
        if (property == null) {
            PackageJsonUtil.$$$reportNull$$$0(2);
        }
        return (parent = property.getParent()) != null && parent.getParent() instanceof JsonFile;
    }

    @Nullable
    public static JsonProperty findContainingProperty(@NotNull PsiElement element2) {
        if (element2 == null) {
            PackageJsonUtil.$$$reportNull$$$0(3);
        }
        if (PackageJsonUtil.isInsidePackageJsonFile(element2)) {
            return (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element2, JsonProperty.class, (boolean)false);
        }
        return null;
    }

    @Nullable
    public static JsonProperty findContainingTopLevelProperty(@Nullable PsiElement element2) {
        if (element2 == null || !PackageJsonUtil.isInsidePackageJsonFile(element2)) {
            return null;
        }
        JsonProperty property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element2, JsonProperty.class, (boolean)false);
        while (property != null && !PackageJsonUtil.isTopLevelProperty(property)) {
            property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)property, JsonProperty.class, (boolean)true);
        }
        return property;
    }

    public static boolean isPackageDependencyProperty(@NotNull JsonProperty property) {
        JsonObject obj;
        if (property == null) {
            PackageJsonUtil.$$$reportNull$$$0(4);
        }
        if ((obj = (JsonObject)ObjectUtils.tryCast((Object)property.getParent(), JsonObject.class)) != null) {
            JsonProperty dependenciesProperty = (JsonProperty)ObjectUtils.tryCast((Object)obj.getParent(), JsonProperty.class);
            return dependenciesProperty != null && ALL_DEPENDENCIES.contains(dependenciesProperty.getName()) && PackageJsonUtil.isTopLevelProperty(dependenciesProperty);
        }
        return false;
    }

    public static boolean isPackageDependenciesProperty(@Nullable JsonProperty property) {
        return property != null && ALL_DEPENDENCIES.contains(property.getName());
    }

    public static void processUpPackageJsonFiles(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull Processor<? super VirtualFile> processor) {
        if (project == null) {
            PackageJsonUtil.$$$reportNull$$$0(5);
        }
        if (fileOrDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            PackageJsonUtil.$$$reportNull$$$0(7);
        }
        JSProjectUtil.processDirectoriesUpToContentRoot(project, fileOrDir, (Processor<? super VirtualFile>)((Processor)directory -> {
            VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(directory);
            return packageJson == null || processor.process((Object)packageJson);
        }));
    }

    @Nullable
    public static <T> T processUpPackageJsonFilesAndFindFirst(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull Function<? super VirtualFile, T> packageJsonProcessor) {
        if (project == null) {
            PackageJsonUtil.$$$reportNull$$$0(8);
        }
        if (fileOrDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(9);
        }
        if (packageJsonProcessor == null) {
            PackageJsonUtil.$$$reportNull$$$0(10);
        }
        Ref result2 = Ref.create();
        PackageJsonUtil.processUpPackageJsonFiles(project, fileOrDir, (Processor<? super VirtualFile>)((Processor)packageJson -> {
            result2.set(packageJsonProcessor.fun(packageJson));
            return result2.isNull();
        }));
        return (T)result2.get();
    }

    @Nullable
    public static VirtualFile findUpPackageJson(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(11);
        }
        Ref ref2 = Ref.create();
        PackageJsonUtil.processUpPackageJsonFilesInAllScope(fileOrDir, (Processor<? super VirtualFile>)((Processor)file -> {
            ref2.set(file);
            return false;
        }));
        return (VirtualFile)ref2.get();
    }

    public static void processUpPackageJsonFilesInAllScope(@NotNull VirtualFile fileOrDir, @NotNull Processor<? super VirtualFile> processor) {
        VirtualFile dir;
        if (fileOrDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            PackageJsonUtil.$$$reportNull$$$0(13);
        }
        VirtualFile virtualFile = dir = fileOrDir.isDirectory() ? fileOrDir : fileOrDir.getParent();
        if (dir == null) {
            return;
        }
        while (dir != null) {
            VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(dir);
            if (packageJson != null && !processor.process((Object)packageJson)) {
                return;
            }
            dir = dir.getParent();
        }
    }

    @NotNull
    public static List<JsonProperty> getAllDependencies(@NotNull JsonFile packageJson) {
        if (packageJson == null) {
            PackageJsonUtil.$$$reportNull$$$0(14);
        }
        return PackageJsonUtil.getDependencies(packageJson, ALL_DEPENDENCIES);
    }

    @NotNull
    public static List<JsonProperty> getDependencies(@NotNull JsonFile packageJson, @NotNull Collection<String> enclosingParentAttributes) {
        if (packageJson == null) {
            PackageJsonUtil.$$$reportNull$$$0(15);
        }
        if (enclosingParentAttributes == null) {
            PackageJsonUtil.$$$reportNull$$$0(16);
        }
        JsonObject obj = (JsonObject)ObjectUtils.tryCast((Object)packageJson.getTopLevelValue(), JsonObject.class);
        ArrayList<JsonProperty> result2 = new ArrayList<JsonProperty>();
        if (obj != null) {
            for (JsonProperty property : obj.getPropertyList()) {
                JsonObject depObj;
                if (!enclosingParentAttributes.contains(property.getName()) || (depObj = (JsonObject)ObjectUtils.tryCast((Object)property.getValue(), JsonObject.class)) == null) continue;
                result2.addAll(depObj.getPropertyList());
            }
        }
        ArrayList<JsonProperty> arrayList = result2;
        if (arrayList == null) {
            PackageJsonUtil.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @Nullable
    public static JsonProperty findDependencyByName(@NotNull JsonFile packageJson, @NotNull String dependencyName) {
        JsonObject obj;
        if (packageJson == null) {
            PackageJsonUtil.$$$reportNull$$$0(18);
        }
        if (dependencyName == null) {
            PackageJsonUtil.$$$reportNull$$$0(19);
        }
        if ((obj = (JsonObject)ObjectUtils.tryCast((Object)packageJson.getTopLevelValue(), JsonObject.class)) != null) {
            for (JsonProperty property : obj.getPropertyList()) {
                JsonProperty dependencyProperty;
                JsonObject depObj;
                if (!ALL_DEPENDENCIES.contains(property.getName()) || (depObj = (JsonObject)ObjectUtils.tryCast((Object)property.getValue(), JsonObject.class)) == null || (dependencyProperty = depObj.findProperty(dependencyName)) == null) continue;
                return dependencyProperty;
            }
        }
        return null;
    }

    @Nullable
    public static JsonProperty findProdDependencyByName(@NotNull JsonFile packageJson, @NotNull String dependencyName) {
        JsonObject rootObj;
        if (packageJson == null) {
            PackageJsonUtil.$$$reportNull$$$0(20);
        }
        if (dependencyName == null) {
            PackageJsonUtil.$$$reportNull$$$0(21);
        }
        if ((rootObj = (JsonObject)ObjectUtils.tryCast((Object)packageJson.getTopLevelValue(), JsonObject.class)) == null) {
            return null;
        }
        JsonProperty depProperty = rootObj.findProperty(DEPENDENCIES);
        if (depProperty == null) {
            return null;
        }
        JsonObject depObj = (JsonObject)ObjectUtils.tryCast((Object)depProperty.getValue(), JsonObject.class);
        if (depObj == null) {
            return null;
        }
        return depObj.findProperty(dependencyName);
    }

    public static boolean isPackageJsonWithTopLevelProperty(@NotNull VirtualFile packageJson, String property) {
        if (packageJson == null) {
            PackageJsonUtil.$$$reportNull$$$0(22);
        }
        return PackageJsonUtil.isPackageJsonFile(packageJson) && PackageJsonData.getOrCreate(packageJson).getTopLevelProperties().contains(property);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static PackageJsonData getOrCreateData(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonUtil.$$$reportNull$$$0(23);
        }
        PackageJsonData packageJsonData = PackageJsonData.getOrCreate(packageJson);
        if (packageJsonData == null) {
            PackageJsonUtil.$$$reportNull$$$0(24);
        }
        return packageJsonData;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static PackageJsonData getTopLevelPackageJsonData(@NotNull Project project) {
        if (project == null) {
            PackageJsonUtil.$$$reportNull$$$0(25);
        }
        if (project.isDefault() || project.getBaseDir() == null || project.isDisposed()) {
            return null;
        }
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(project.getBaseDir());
        return packageJson == null ? null : PackageJsonData.getOrCreate(packageJson);
    }

    public static ThreeState isVersionGreaterOrEqualMajor(@NotNull String versionText, int major) {
        if (versionText == null) {
            PackageJsonUtil.$$$reportNull$$$0(26);
        }
        if ("latest".equals(versionText)) {
            return ThreeState.YES;
        }
        String[] parts = versionText.split("\\s-\\s");
        if (parts.length == 2) {
            String part = parts[1];
            if (PackageJsonUtil.isAny((part = StringUtil.trimStart((String)part, (String)"v")).charAt(0))) {
                return ThreeState.YES;
            }
            int parsedMajor = PackageJsonUtil.getMajorVersion(part);
            if (parsedMajor >= 0) {
                return parsedMajor >= major ? ThreeState.YES : ThreeState.NO;
            }
            return ThreeState.UNSURE;
        }
        ArrayList<Pair> versionWords = new ArrayList<Pair>();
        StringBuilder sb = new StringBuilder();
        StringBuilder prefixBuilder = new StringBuilder();
        for (int i = 0; i < versionText.length(); ++i) {
            char ch = versionText.charAt(i);
            if (Character.isDigit(ch) || '.' == ch || '*' == ch || 'v' == ch || 'x' == ch || 'X' == ch) {
                sb.append(ch);
                continue;
            }
            if (!sb.isEmpty()) {
                versionWords.add(Pair.create((Object)prefixBuilder.toString(), (Object)sb.toString()));
                sb.setLength(0);
                prefixBuilder.setLength(0);
            }
            prefixBuilder.append(ch);
        }
        if (!sb.isEmpty()) {
            versionWords.add(Pair.create((Object)prefixBuilder.toString(), (Object)sb.toString()));
        }
        if (versionWords.isEmpty()) {
            return ThreeState.UNSURE;
        }
        boolean greaterThanLess = false;
        boolean lessThanGreater = false;
        for (Pair pair : versionWords) {
            int parsedMajor;
            String word = (String)pair.getSecond();
            word = StringUtil.trimStart((String)word, (String)"v");
            String prefix = (String)pair.getFirst();
            if (!PackageJsonUtil.isPrefixValid(prefix)) {
                return ThreeState.UNSURE;
            }
            if (word.isEmpty()) continue;
            if (PackageJsonUtil.isAny(word.charAt(0))) {
                lessThanGreater = true;
            }
            if ((parsedMajor = PackageJsonUtil.getMajorVersion(word)) < 0) continue;
            if (parsedMajor >= major) {
                char before;
                if (parsedMajor == major && (before = PackageJsonUtil.getVersionComparator(prefix)) == '<') {
                    return ThreeState.NO;
                }
                lessThanGreater = true;
                continue;
            }
            if (PackageJsonUtil.getVersionComparator(prefix) != '>') continue;
            greaterThanLess = true;
        }
        if (greaterThanLess || lessThanGreater) {
            return ThreeState.YES;
        }
        return ThreeState.NO;
    }

    private static int getMajorVersion(@NotNull String version2) {
        int idx;
        if (version2 == null) {
            PackageJsonUtil.$$$reportNull$$$0(27);
        }
        if ((idx = version2.indexOf(".")) < 0) {
            return StringUtil.parseInt((String)version2, (int)-1);
        }
        return StringUtil.parseInt((String)version2.substring(0, idx), (int)-1);
    }

    private static boolean isPrefixValid(@NotNull String prefix) {
        if (prefix == null) {
            PackageJsonUtil.$$$reportNull$$$0(28);
        }
        if (prefix.isEmpty()) {
            return true;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            char ch = prefix.charAt(i);
            if (Character.isWhitespace(ch) || ch == '<' || ch == '>' || ch == '=' || ch == '~' || ch == '^' || ch == '|') continue;
            return false;
        }
        return true;
    }

    private static boolean isAny(char first) {
        return first == '*' || first == 'x' || first == 'X';
    }

    private static char getVersionComparator(@NotNull String prefix) {
        if (prefix == null) {
            PackageJsonUtil.$$$reportNull$$$0(29);
        }
        for (int i = prefix.length() - 1; i >= 0; --i) {
            char ch = prefix.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (ch == '=' && i > 0) {
                return prefix.charAt(i - 1);
            }
            return ch;
        }
        return ' ';
    }

    @Contract(value="null -> null")
    @Nullable
    public static VirtualFile findChildPackageJsonFile(@Nullable VirtualFile dir) {
        VirtualFile packageJson;
        if (dir != null && dir.isValid() && (packageJson = dir.findChild(FILE_NAME)) != null && packageJson.isValid() && !packageJson.isDirectory()) {
            return packageJson;
        }
        return null;
    }

    @NotNull
    public static String guessDefaultBinaryNameOfDependency(@NotNull NodePackage pkg) {
        if (pkg == null) {
            PackageJsonUtil.$$$reportNull$$$0(30);
        }
        Path pathToPachageJson = null;
        try {
            pathToPachageJson = Path.of(pkg.getSystemDependentPath(), FILE_NAME);
        }
        catch (InvalidPathException ignored) {
            LOG.debug("Cannot guess default binary name of dependency for '" + pkg.getName() + "' because of invalid path: '" + pkg.getSystemDependentPath() + "'");
        }
        VirtualFile packageJson = null;
        if (pathToPachageJson != null) {
            packageJson = LocalFileSystem.getInstance().findFileByNioFile(pathToPachageJson);
        }
        return PackageJsonUtil.guessDefaultBinaryNameOfDependency(packageJson, pkg.getName());
    }

    @NotNull
    public static String guessDefaultBinaryNameOfDependency(@Nullable VirtualFile dependencyPackageJson, @NotNull String dependencyName) {
        if (dependencyName == null) {
            PackageJsonUtil.$$$reportNull$$$0(31);
        }
        List<String> declaredBinaryNames = PackageJsonUtil.getDeclaredBinaryNames(dependencyPackageJson);
        List<String> candidateBinaryNames = PackageJsonUtil.getCandidateBinaryNames(dependencyName);
        for (String candidateBinaryName : candidateBinaryNames) {
            if (!declaredBinaryNames.contains(candidateBinaryName)) continue;
            String string = candidateBinaryName;
            if (string == null) {
                PackageJsonUtil.$$$reportNull$$$0(32);
            }
            return string;
        }
        if (declaredBinaryNames.size() == 1) {
            String string = Objects.requireNonNull((String)ContainerUtil.getFirstItem(declaredBinaryNames));
            if (string == null) {
                PackageJsonUtil.$$$reportNull$$$0(33);
            }
            return string;
        }
        String string = Objects.requireNonNull((String)ContainerUtil.getFirstItem(candidateBinaryNames));
        if (string == null) {
            PackageJsonUtil.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    private static @Unmodifiable List<String> getDeclaredBinaryNames(@Nullable VirtualFile packageJson) {
        if (packageJson == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PackageJsonUtil.$$$reportNull$$$0(35);
            }
            return list;
        }
        PackageJsonData data2 = PackageJsonData.getOrCreate(packageJson);
        List list = ContainerUtil.filter(data2.getBinaryNameToPathMap().keySet(), Objects::nonNull);
        if (list == null) {
            PackageJsonUtil.$$$reportNull$$$0(36);
        }
        return list;
    }

    @NotNull
    private static List<String> getCandidateBinaryNames(@NotNull String dependencyName) {
        if (dependencyName == null) {
            PackageJsonUtil.$$$reportNull$$$0(37);
        }
        if (!NodeModuleSearchUtil.isScopedPackageName(dependencyName)) {
            List<String> list = Collections.singletonList(dependencyName);
            if (list == null) {
                PackageJsonUtil.$$$reportNull$$$0(38);
            }
            return list;
        }
        String scope2 = Objects.requireNonNull(NodeModuleSearchUtil.getScopeByScopedPackageName(dependencyName));
        String name = Objects.requireNonNull(NodeModuleSearchUtil.getNameByScopedPackageName(dependencyName));
        List<CallSite> list = List.of(name, scope2 + "-" + name);
        if (list == null) {
            PackageJsonUtil.$$$reportNull$$$0(39);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 24, 32, 33, 34, 35, 36, 38, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 5: 
            case 8: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonProcessor";
                break;
            }
            case 14: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingParentAttributes";
                break;
            }
            case 17: 
            case 24: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil";
                break;
            }
            case 19: 
            case 21: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionText";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateData";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "guessDefaultBinaryNameOfDependency";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredBinaryNames";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidateBinaryNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInsidePackageJsonFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getContainingPackageJsonFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelProperty";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findContainingProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPackageDependencyProperty";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processUpPackageJsonFiles";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processUpPackageJsonFilesAndFindFirst";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findUpPackageJson";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processUpPackageJsonFilesInAllScope";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAllDependencies";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 17: 
            case 24: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findDependencyByName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findProdDependencyByName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isPackageJsonWithTopLevelProperty";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateData";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelPackageJsonData";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isVersionGreaterOrEqualMajor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getMajorVersion";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isPrefixValid";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getVersionComparator";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "guessDefaultBinaryNameOfDependency";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getCandidateBinaryNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 24, 32, 33, 34, 35, 36, 38, 39 -> new IllegalStateException(string);
        };
    }
}

