/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.javascript.nodejs.execution.NodeProgressUtil;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.boilerplate.InstallDependenciesProjectGeneratorStep;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunProfileState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0002J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/lang/javascript/boilerplate/InstallDependenciesProjectGeneratorStep;", "", "<init>", "()V", "startNpmInstallProcess", "Lcom/intellij/execution/process/ProcessHandler;", "project", "Lcom/intellij/openapi/project/Project;", "projectDir", "Ljava/io/File;", "findConsole", "Lcom/intellij/terminal/TerminalExecutionConsole;", "processHandler", "npmInstall", "", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "generatorProcessHandler", "onDone", "Lkotlin/Function0;", "intellij.javascript.impl"})
public final class InstallDependenciesProjectGeneratorStep {
    @NotNull
    public static final InstallDependenciesProjectGeneratorStep INSTANCE = new InstallDependenciesProjectGeneratorStep();

    private InstallDependenciesProjectGeneratorStep() {
    }

    private final ProcessHandler startNpmInstallProcess(Project project, File projectDir) {
        NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterManager.getInstance(project).getInterpreterRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreterRef, (String)"getInterpreterRef(...)");
        NodeJsInterpreterRef interpreterRef = nodeJsInterpreterRef;
        NodeJsInterpreter nodeJsInterpreter = interpreterRef.resolveNotNull(project);
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreter, (String)"resolveNotNull(...)");
        NodeJsInterpreter interpreter2 = nodeJsInterpreter;
        NodeTargetRun targetRun = new NodeTargetRun(interpreter2, project, null, NodeTargetRunOptions.Companion.of$default(NodeTargetRunOptions.Companion, true, null, null, 6, null), null, 16, null);
        NodePackageRef nodePackageRef = NpmManager.getInstance(project).getPackageRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodePackageRef, (String)"getPackageRef(...)");
        String string = projectDir + File.separator + "package.json";
        List list = CollectionsKt.emptyList();
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"DEFAULT");
        NpmRunProfileState.Companion.configureCommandLine$default(NpmRunProfileState.Companion, targetRun, "", nodePackageRef, string, NpmCommand.INSTALL, list, "", environmentVariablesData, null, null, 512, null);
        return targetRun.startProcess();
    }

    private final TerminalExecutionConsole findConsole(Project project, ProcessHandler processHandler) {
        RunContentDescriptor descriptor;
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        RunContentDescriptor runContentDescriptor = descriptor = RunContentManager.getInstance((Project)project).findContentDescriptor(executor, processHandler);
        ExecutionConsole executionConsole = runContentDescriptor != null ? runContentDescriptor.getExecutionConsole() : null;
        return executionConsole instanceof TerminalExecutionConsole ? (TerminalExecutionConsole)executionConsole : null;
    }

    public final void npmInstall(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull ProcessHandler generatorProcessHandler, @Nullable Function0<Unit> onDone) {
        int exitCode;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter((Object)generatorProcessHandler, (String)"generatorProcessHandler");
        Integer n = generatorProcessHandler.getExitCode();
        int n2 = exitCode = n != null ? n : -1;
        if (exitCode != 0) {
            Object[] objectArray = new Object[]{exitCode};
            throw new ExecutionException(JavaScriptBundle.message("generating.errors.in.console", objectArray));
        }
        String string = NpmManager.getInstance(project).getNpmInstallPresentableText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNpmInstallPresentableText(...)");
        String npmInstallText = string;
        ProcessHandler processHandler = (ProcessHandler)NodeProgressUtil.withBackgroundProgress(project, NodeProgressUtil.starting(npmInstallText), () -> InstallDependenciesProjectGeneratorStep.npmInstall$lambda$0(project, baseDir));
        ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeStarted(project, npmInstallText);
        Runnable installDone = PackageJsonDependenciesExternalUpdateManager.Companion.getInstance(project).updateActionStarted(null, null);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        ApplicationManager.getApplication().invokeLater(() -> InstallDependenciesProjectGeneratorStep.npmInstall$lambda$2(project, generatorProcessHandler, processHandler));
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(project, installDone, baseDir, onDone){
            final /* synthetic */ Project $project;
            final /* synthetic */ Runnable $installDone;
            final /* synthetic */ VirtualFile $baseDir;
            final /* synthetic */ Function0<Unit> $onDone;
            {
                this.$project = $project;
                this.$installDone = $installDone;
                this.$baseDir = $baseDir;
                this.$onDone = $onDone;
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeCompleted(this.$project);
                this.$installDone.run();
                VirtualFile[] virtualFileArray = new VirtualFile[]{this.$baseDir};
                RefreshQueue.getInstance().refresh(true, true, () -> npmInstall.2.processTerminated$lambda$1(this.$project, this.$onDone), virtualFileArray);
            }

            private static final void processTerminated$lambda$1$lambda$0(Function0 $onDone) {
                block0: {
                    Function0 function0 = $onDone;
                    if (function0 == null) break block0;
                    function0.invoke();
                }
            }

            private static final void processTerminated$lambda$1(Project $project, Function0 $onDone) {
                if (!$project.isDisposed()) {
                    StartupManager.getInstance((Project)$project).runWhenProjectIsInitialized(() -> npmInstall.2.processTerminated$lambda$1$lambda$0($onDone));
                }
            }
        });
    }

    private static final ProcessHandler npmInstall$lambda$0(Project $project, VirtualFile $baseDir) {
        File file = $baseDir.toNioPath().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return INSTANCE.startNpmInstallProcess($project, file);
    }

    /*
     * WARNING - void declaration
     */
    private static final void npmInstall$lambda$2(Project $project, ProcessHandler $generatorProcessHandler, ProcessHandler $processHandler) {
        void $this$npmInstall_u24lambda_u242_u24lambda_u241;
        StringBuilder stringBuilder;
        TerminalExecutionConsole console;
        TerminalExecutionConsole terminalExecutionConsole = console = INSTANCE.findConsole($project, $generatorProcessHandler);
        if (terminalExecutionConsole != null) {
            terminalExecutionConsole.attachToProcess($processHandler);
        }
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        ProcessHandler processHandler = $processHandler;
        boolean bl = false;
        $this$npmInstall_u24lambda_u242_u24lambda_u241.append("\n");
        $this$npmInstall_u24lambda_u242_u24lambda_u241.append(JavaScriptBundle.message("generating.installing.deps", new Object[0]));
        $this$npmInstall_u24lambda_u242_u24lambda_u241.append("\n\n");
        processHandler.notifyTextAvailable(stringBuilder.toString(), (Key)ProcessOutputType.SYSTEM);
        $processHandler.startNotify();
    }
}

