/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.BasicDialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSBlockStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSEmbeddedContentImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FilePropertyKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.xml.XmlElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007J\u001a\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u001a\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u0006\u0010 \u001a\u00020\u0011H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010#\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0011H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010+\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010,\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010-\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0012\u0010.\u001a\u00020\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007J\u0012\u0010/\u001a\u0004\u0018\u00010\u00102\u0006\u0010 \u001a\u000200H\u0007J\u001a\u00101\u001a\u0004\u0018\u00010\u00102\u0006\u0010 \u001a\u0002002\u0006\u00102\u001a\u000203H\u0007J\u001a\u00104\u001a\u0004\u0018\u00010\u00102\u0006\u0010 \u001a\u0002002\u0006\u00102\u001a\u000203H\u0007J\u001a\u00105\u001a\u00020\u00102\u0006\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010\u0010H\u0007J\u001a\u00109\u001a\u0002072\b\u0010 \u001a\u0004\u0018\u00010\u00112\u0006\u00102\u001a\u000203H\u0007J\u0010\u0010:\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0011H\u0007J\u001a\u00109\u001a\u0002072\b\u0010 \u001a\u0004\u0018\u0001002\u0006\u00102\u001a\u000203H\u0007J\u001a\u0010:\u001a\u00020\u00102\b\u0010 \u001a\u0004\u0018\u0001002\u0006\u00102\u001a\u000203H\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R9\u0010\r\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011 \u0012*\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000f0\u000f0\u000e\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0014\u001a\u001e\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/intellij/lang/javascript/DialectDetector;", "", "<init>", "()V", "KEY", "Lcom/intellij/psi/FilePropertyKey;", "", "JAVASCRIPT_FILE_TYPES_ARRAY", "", "Lcom/intellij/openapi/fileTypes/FileType;", "[Lcom/intellij/openapi/fileTypes/FileType;", "JAVASCRIPT_FILE_TYPES", "", "KEY_DIALECT_HOLDER", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/ParameterizedCachedValue;", "Lcom/intellij/lang/javascript/JSLanguageDialect;", "Lcom/intellij/psi/PsiFile;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "PROVIDER", "Lcom/intellij/psi/util/ParameterizedCachedValueProvider;", "dialectOfElement", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "element", "Lcom/intellij/psi/PsiElement;", "hasFeature", "", "feature", "Lcom/intellij/lang/javascript/dialects/JSLanguageFeature;", "optionHolder", "dialectOfFileNoCache", "file", "languageOfElement", "Lcom/intellij/lang/Language;", "calculateJSLanguage", "getJSDialectOfFile", "languageDialectOfElement", "isTypeScript", "isActionScript", "isJavaScript", "isJavaScriptFamily", "hasJSSyntax", "isES6", "isES6OrES6Target", "isFlow", "isJSX", "getJSLanguageFromFileType", "Lcom/intellij/openapi/vfs/VirtualFile;", "getLanguageDialect", "project", "Lcom/intellij/openapi/project/Project;", "getLanguageDialectForJSFile", "getCombinedLanguageDialect", "configuredLanguage", "Lcom/intellij/lang/javascript/dialects/JSLanguageLevel;", "fileSpecialLanguage", "getConfiguredJSLevel", "getConfiguredJSVersion", "intellij.javascript.psi.impl"})
public final class DialectDetector {
    @NotNull
    public static final DialectDetector INSTANCE = new DialectDetector();
    @JvmField
    @NotNull
    public static final FilePropertyKey<String> KEY = BasicDialectDetector.KEY;
    @JvmField
    @NotNull
    public static final FileType[] JAVASCRIPT_FILE_TYPES_ARRAY = BasicDialectDetector.JAVASCRIPT_FILE_TYPES_ARRAY;
    @JvmField
    @NotNull
    public static final Collection<FileType> JAVASCRIPT_FILE_TYPES = ArraysKt.toList((Object[])JAVASCRIPT_FILE_TYPES_ARRAY);
    @NotNull
    private static final Key<ParameterizedCachedValue<JSLanguageDialect, PsiFile>> KEY_DIALECT_HOLDER;
    @NotNull
    private static final ParameterizedCachedValueProvider<JSLanguageDialect, PsiFile> PROVIDER;

    private DialectDetector() {
    }

    @JvmStatic
    @Nullable
    public static final DialectOptionHolder dialectOfElement(@Nullable PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        Language language = DialectDetector.languageOfElement(element2);
        return language instanceof JSLanguageDialect ? ((JSLanguageDialect)language).getOptionHolder() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean hasFeature(@Nullable PsiElement element2, @NotNull JSLanguageFeature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        if (element2 == null) return false;
        if (!DialectDetector.hasFeature(DialectDetector.dialectOfElement(element2), feature)) return false;
        return true;
    }

    @JvmStatic
    public static final boolean hasFeature(@Nullable DialectOptionHolder optionHolder, @NotNull JSLanguageFeature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return optionHolder != null && optionHolder.hasFeature(feature);
    }

    private final JSLanguageDialect dialectOfFileNoCache(PsiFile file) {
        Language language = file.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Language language2 = language;
        if (language2 instanceof JSLanguageDialect) {
            return (JSLanguageDialect)language2;
        }
        if (language2 == HTMLLanguage.INSTANCE) {
            return null;
        }
        if (FlexSupportLoader.isMxmlOrFxgFile(file)) {
            return FlexSupportLoader.ECMA_SCRIPT_L4;
        }
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        if (virtualFile != null && (StringsKt.equals((String)"swf", (String)virtualFile.getExtension(), (boolean)true) || StringsKt.equals((String)"swc", (String)virtualFile.getExtension(), (boolean)true))) {
            return FlexSupportLoader.ECMA_SCRIPT_L4;
        }
        if (virtualFile != null) {
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            JSLanguageDialect dialect = DialectDetector.getLanguageDialect(virtualFile, project);
            if (dialect != null) {
                return dialect;
            }
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final Language languageOfElement(@NotNull PsiElement element2) {
        PsiFile file;
        PsiElement context2;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (element2 instanceof LeafPsiElement && (context2 = ((LeafPsiElement)element2).getContext()) instanceof JSElement) {
            Language language = ((JSElement)context2).getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
            return language;
        }
        if (element2 instanceof XmlElement && FlexSupportLoader.isMxmlOrFxgFile(file = element2.getContainingFile())) {
            JSLanguageDialect jSLanguageDialect = FlexSupportLoader.ECMA_SCRIPT_L4;
            Intrinsics.checkNotNullExpressionValue((Object)jSLanguageDialect, (String)"ECMA_SCRIPT_L4");
            return (Language)jSLanguageDialect;
        }
        Language language = element2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        return language;
    }

    @JvmStatic
    @NotNull
    public static final Language calculateJSLanguage(@NotNull PsiElement element2) {
        PsiElement parent;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (element2 instanceof XmlBackedJSClass) {
            JSLanguageDialect jSLanguageDialect = FlexSupportLoader.ECMA_SCRIPT_L4;
            Intrinsics.checkNotNullExpressionValue((Object)jSLanguageDialect, (String)"ECMA_SCRIPT_L4");
            return (Language)jSLanguageDialect;
        }
        if (element2 instanceof PsiFile) {
            return (Language)INSTANCE.getJSDialectOfFile((PsiFile)element2);
        }
        if (element2 instanceof JSEmbeddedContent && !(parent instanceof JSElement)) {
            Language language;
            PsiFile file = element2.getContainingFile();
            if (file instanceof JSFile) {
                Language language2 = ((JSFile)file).getLanguage();
                language = language2;
                Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
            } else {
                JSLanguageDialect jSLanguageDialect = JSEmbeddedContentImpl.getLanguageForParser(((JSEmbeddedContent)element2).getIElementType(), file, element2.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)jSLanguageDialect, (String)"getLanguageForParser(...)");
                language = (Language)jSLanguageDialect;
            }
            return language;
        }
        for (parent = element2.getContext(); parent != null; parent = parent.getContext()) {
            if (parent instanceof JSStubElementImpl || parent instanceof JSBlockStatementImpl || parent instanceof JSEmbeddedContent) {
                Language language = ((JSElement)parent).getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                return language;
            }
            if (!(parent instanceof PsiFile)) continue;
            return (Language)INSTANCE.getJSDialectOfFile((PsiFile)parent);
        }
        if (!element2.isValid()) {
            throw new PsiInvalidElementAccessException(element2);
        }
        return (Language)JavascriptLanguage.INSTANCE;
    }

    private final JSLanguageDialect getJSDialectOfFile(PsiFile file) {
        JSLanguageDialect jSLanguageDialect = (JSLanguageDialect)CachedValuesManager.getManager((Project)file.getProject()).getParameterizedCachedValue((UserDataHolder)file, KEY_DIALECT_HOLDER, PROVIDER, false, (Object)file);
        if (jSLanguageDialect == null) {
            jSLanguageDialect = (JSLanguageDialect)JavascriptLanguage.INSTANCE;
        }
        return jSLanguageDialect;
    }

    @JvmStatic
    @Nullable
    public static final JSLanguageDialect languageDialectOfElement(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        for (Language language = DialectDetector.languageOfElement(element2); language != null; language = language.getBaseLanguage()) {
            if (!(language instanceof JSLanguageDialect)) continue;
            return (JSLanguageDialect)language;
        }
        return null;
    }

    @JvmStatic
    public static final boolean isTypeScript(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element2);
        return dialect != null && dialect.isTypeScript;
    }

    @JvmStatic
    public static final boolean isActionScript(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element2);
        return dialect == DialectOptionHolder.ECMA_4;
    }

    @JvmStatic
    public static final boolean isJavaScript(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element2);
        return dialect == null || dialect.isJavaScript();
    }

    @JvmStatic
    public static final boolean isJavaScriptFamily(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return !DialectDetector.isActionScript(element2);
    }

    @JvmStatic
    public static final boolean hasJSSyntax(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element2);
        return dialect != null && dialect.hasJSSyntax();
    }

    @JvmStatic
    public static final boolean isES6(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element2);
        return dialect != null && dialect.isECMA6;
    }

    @JvmStatic
    public static final boolean isES6OrES6Target(@NotNull PsiElement element2) {
        TypeScriptConfig config;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element2);
        if (dialect != null && dialect.isTypeScript && (config = TypeScriptConfigService.Provider.get(element2.getProject()).getPreferableConfig(element2.getContainingFile().getVirtualFile())) != null) {
            return Intrinsics.areEqual((Object)config.getLanguageTarget(), (Object)TypeScriptConfig.LanguageTarget.ES6) || Intrinsics.areEqual((Object)config.getLanguageTarget(), (Object)TypeScriptConfig.LanguageTarget.NEXT);
        }
        return dialect != null && dialect.isECMA6;
    }

    @JvmStatic
    public static final boolean isFlow(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element2);
        return dialect != null && dialect.isFlow;
    }

    @JvmStatic
    @Contract(value="null->false")
    public static final boolean isJSX(@Nullable PsiElement element2) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element2);
        return dialect != null && dialect.isJSX();
    }

    @JvmStatic
    @Nullable
    public static final JSLanguageDialect getJSLanguageFromFileType(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return BasicDialectDetector.getJSLanguageFromFileType((VirtualFile)file);
    }

    @JvmStatic
    @Nullable
    public static final JSLanguageDialect getLanguageDialect(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return BasicDialectDetector.getLanguageDialect((VirtualFile)file, (Project)project);
    }

    @JvmStatic
    @Nullable
    public static final JSLanguageDialect getLanguageDialectForJSFile(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return BasicDialectDetector.getLanguageDialectForJSFile((VirtualFile)file, (Project)project);
    }

    @JvmStatic
    @NotNull
    public static final JSLanguageDialect getCombinedLanguageDialect(@NotNull JSLanguageLevel configuredLanguage, @Nullable JSLanguageDialect fileSpecialLanguage) {
        Intrinsics.checkNotNullParameter((Object)configuredLanguage, (String)"configuredLanguage");
        return BasicDialectDetector.getCombinedLanguageDialect((JSLanguageLevel)configuredLanguage, (JSLanguageDialect)fileSpecialLanguage);
    }

    @JvmStatic
    @NotNull
    public static final JSLanguageLevel getConfiguredJSLevel(@Nullable PsiFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return BasicDialectDetector.getConfiguredJSLevel((PsiFile)file, (Project)project);
    }

    @JvmStatic
    @NotNull
    public static final JSLanguageDialect getConfiguredJSVersion(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return BasicDialectDetector.getConfiguredJSVersion((PsiFile)file);
    }

    @JvmStatic
    @NotNull
    public static final JSLanguageLevel getConfiguredJSLevel(@Nullable VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return BasicDialectDetector.getConfiguredJSLevel((VirtualFile)file, (Project)project);
    }

    @JvmStatic
    @NotNull
    public static final JSLanguageDialect getConfiguredJSVersion(@Nullable VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return BasicDialectDetector.getConfiguredJSVersion((VirtualFile)file, (Project)project);
    }

    private static final CachedValueProvider.Result PROVIDER$lambda$0(PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object[] objectArray = new Object[]{file};
        return CachedValueProvider.Result.create((Object)INSTANCE.dialectOfFileNoCache(file), (Object[])objectArray);
    }

    static {
        Key key = Key.create((String)"JavaScript.Dialect.Holder");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY_DIALECT_HOLDER = key;
        PROVIDER = DialectDetector::PROVIDER$lambda$0;
    }
}

