/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html.refs;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.html.HtmlCompatibleFile;
import com.intellij.lang.html.refs.JSFrameworkDirectorySearchProcessor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.JSXmlAttributePathUtil;
import com.intellij.lang.javascript.frameworks.html.JSStaticDirectoriesFileReferenceHelperKt;
import com.intellij.lang.javascript.frameworks.modules.JSDirectorySearchProcessor;
import com.intellij.lang.javascript.frameworks.modules.JSModuleFileReferenceSet;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSDefaultFileReferenceContext;
import com.intellij.lang.javascript.patterns.JSLiteralExpressionPattern;
import com.intellij.lang.javascript.patterns.JSPatterns;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProviderBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J5\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0007H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/lang/html/refs/JSXmlAttributePathReferenceProvider;", "Lcom/intellij/openapi/paths/PathReferenceProviderBase;", "<init>", "()V", "createReferences", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "offset", "", "text", "", "references", "", "Lcom/intellij/psi/PsiReference;", "soft", "jsReferences", "", "isSoft", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;IZ)[Lcom/intellij/psi/PsiReference;", "getPathReference", "Lcom/intellij/openapi/paths/PathReference;", "path", "element", "intellij.javascript.impl"})
public final class JSXmlAttributePathReferenceProvider
extends PathReferenceProviderBase {
    public boolean createReferences(@NotNull PsiElement psiElement, int offset, @Nullable String text, @NotNull List<? super PsiReference> references, boolean soft) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter(references, (String)"references");
        if (text == null) {
            return true;
        }
        if (!(psiElement instanceof XmlAttributeValue) && !((JSLiteralExpressionPattern)((Object)JSPatterns.jsLiteral().inJSXEmbeddedContent())).accepts(psiElement)) {
            return true;
        }
        if (!StringsKt.startsWith$default((String)text, (String)"/", (boolean)false, (int)2, null)) {
            return true;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        FileType fileType = psiFile.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        FileType fileType2 = fileType;
        if (Intrinsics.areEqual((Object)fileType2, (Object)HtmlFileType.INSTANCE)) {
            return true;
        }
        if (!DialectDetector.isJSX(psiElement) && !(psiFile instanceof HtmlCompatibleFile)) {
            return true;
        }
        references.addAll(0, ArraysKt.toList((Object[])this.jsReferences(text, psiElement, offset, soft)));
        return true;
    }

    private final PsiReference[] jsReferences(String text, PsiElement psiElement, int offset, boolean isSoft) {
        JSDefaultFileReferenceContext context2 = new JSDefaultFileReferenceContext(text, psiElement, isSoft){
            final /* synthetic */ PsiElement $psiElement;
            final /* synthetic */ boolean $isSoft;
            {
                this.$psiElement = $psiElement;
                this.$isSoft = $isSoft;
                super($text, $psiElement, null);
            }

            public Collection<VirtualFile> getDefaultRoots(Project project, String moduleName, VirtualFile contextFile) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
                Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
                Collection<VirtualFile> collection = super.getDefaultRoots(project, moduleName, contextFile);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getDefaultRoots(...)");
                Collection<VirtualFile> defaultContexts = collection;
                PsiFile psiFile = this.myContext.getContainingFile();
                if (psiFile == null || (psiFile = psiFile.getOriginalFile()) == null) {
                    return defaultContexts;
                }
                PsiFile file = psiFile;
                Collection items = JSStaticDirectoriesFileReferenceHelperKt.getFixedVirtualFiles$default((PsiFileSystemItem)file, JSXmlAttributePathUtil.additionalRoots(this.$psiElement), false, 4, null);
                if (items.isEmpty()) {
                    return defaultContexts;
                }
                return CollectionsKt.plus((Collection)items, (Iterable)CollectionsKt.toSet((Iterable)defaultContexts));
            }

            public JSDirectorySearchProcessor getNodeModuleSearchProcessor() {
                PsiElement psiElement = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getContext(...)");
                return new JSFrameworkDirectorySearchProcessor(psiElement);
            }

            public boolean isSoft() {
                return this.$isSoft;
            }
        };
        FileReference[] fileReferenceArray = new JSModuleFileReferenceSet(text, context2, psiElement, offset).getAllReferences();
        Intrinsics.checkNotNullExpressionValue((Object)fileReferenceArray, (String)"getAllReferences(...)");
        return (PsiReference[])fileReferenceArray;
    }

    @Nullable
    public PathReference getPathReference(@NotNull String path2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (!(element2 instanceof XmlAttributeValue)) {
            return null;
        }
        PsiElement psiElement = ((XmlAttributeValue)element2).getParent();
        if (psiElement == null || (psiElement = psiElement.getParent()) == null) {
            return null;
        }
        PsiElement parent = psiElement;
        if (!(parent instanceof XmlTag) || !DialectDetector.isJSX(parent) && !(((XmlAttributeValue)element2).getContainingFile() instanceof HtmlCompatibleFile)) {
            return null;
        }
        Object[] jsReferences2 = this.jsReferences(path2, element2, 0, true);
        if (jsReferences2.length == 0) {
            return null;
        }
        PsiElement psiElement2 = ((PsiReference)ArraysKt.last((Object[])jsReferences2)).resolve();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement resolve2 = psiElement2;
        PathReference.ResolveFunction resolveFunction = new PathReference.ResolveFunction(null);
        return new PathReference(path2, resolve2, resolveFunction){
            final /* synthetic */ PsiElement $resolve;
            {
                this.$resolve = $resolve;
                super($path, (Function)$super_call_param$1);
            }

            public PsiElement resolve() {
                return this.$resolve;
            }
        };
    }
}

