/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.runConfiguration;

import com.intellij.execution.actions.CompatibleRunConfigurationProducer;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetector;
import com.intellij.javascript.testing.detection.JsTestFrameworkPackageDescriptor;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u000e*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0004J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/testing/runConfiguration/JsTestRunConfigurationProducer;", "T", "Lcom/intellij/execution/configurations/RunConfiguration;", "Lcom/intellij/execution/actions/CompatibleRunConfigurationProducer;", "<init>", "()V", "isTestRunnerAvailableFor", "", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "getTestFrameworkDetector", "Lcom/intellij/javascript/testing/detection/JsTestFrameworkDetector;", "Companion", "intellij.javascript.impl"})
public abstract class JsTestRunConfigurationProducer<T extends RunConfiguration>
extends CompatibleRunConfigurationProducer<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean isTestRunnerAvailableFor(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        JsTestFrameworkDetector detector = this.getTestFrameworkDetector();
        Object object = detector;
        if (object != null && (object = object.getPackageDescriptor()) != null) {
            Object it = object;
            boolean bl = false;
            return ((JsTestFrameworkPackageDescriptor)it).isApplicableByPackage(element2);
        }
        return false;
    }

    protected final boolean isTestRunnerAvailableFor(@NotNull PsiElement element2, @NotNull ConfigurationContext context2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        RunConfiguration contextRunConfiguration = context2.getOriginalConfiguration(this.getConfigurationType());
        return contextRunConfiguration != null && Intrinsics.areEqual((Object)contextRunConfiguration.getType(), (Object)this.getConfigurationType()) ? true : this.isTestRunnerAvailableFor(element2);
    }

    @Nullable
    public JsTestFrameworkDetector getTestFrameworkDetector() {
        return null;
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile guessWorkingDirectory(@NotNull Project project, @NotNull String contextFilePath) {
        return Companion.guessWorkingDirectory(project, contextFilePath);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/testing/runConfiguration/JsTestRunConfigurationProducer$Companion;", "", "<init>", "()V", "guessWorkingDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "contextFilePath", "", "hasTestScript", "", "packageJson", "data", "Lcom/intellij/javascript/nodejs/PackageJsonData;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final VirtualFile guessWorkingDirectory(@NotNull Project project, @NotNull String contextFilePath) {
            VirtualFile packageJson;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)contextFilePath, (String)"contextFilePath");
            String string = PathUtil.getParentPath((String)contextFilePath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParentPath(...)");
            String dirPath = string;
            if (StringsKt.isBlank((CharSequence)dirPath)) {
                return ProjectUtil.guessProjectDir((Project)project);
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(dirPath);
            if (virtualFile == null) {
                return ProjectUtil.guessProjectDir((Project)project);
            }
            VirtualFile dir = virtualFile;
            Ref ref2 = Ref.create();
            Intrinsics.checkNotNullExpressionValue((Object)ref2, (String)"create(...)");
            Ref ref3 = ref2;
            PackageJsonUtil.processUpPackageJsonFiles(project, dir, (Processor<? super VirtualFile>)((Processor)arg_0 -> Companion.guessWorkingDirectory$lambda$1(arg_0 -> Companion.guessWorkingDirectory$lambda$0(ref3, arg_0), arg_0)));
            VirtualFile virtualFile2 = packageJson = (VirtualFile)ref3.get();
            Object result2 = virtualFile2 != null ? virtualFile2.getParent() : null;
            VirtualFile virtualFile3 = result2;
            if (virtualFile3 == null) {
                virtualFile3 = dir;
            }
            return virtualFile3;
        }

        public final boolean hasTestScript(@NotNull Project project, @NotNull VirtualFile packageJson, @NotNull PackageJsonData data2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            if (!data2.getTopLevelProperties().contains("scripts")) {
                return false;
            }
            try {
                NpmScriptsStructure npmScriptsStructure = NpmScriptsService.getInstance(project).fetchBuildfileStructure(packageJson);
                Intrinsics.checkNotNullExpressionValue((Object)npmScriptsStructure, (String)"fetchBuildfileStructure(...)");
                NpmScriptsStructure structure = npmScriptsStructure;
                return structure.getTaskNames().contains("test");
            }
            catch (JsbtTaskFetchException jsbtTaskFetchException) {
                return false;
            }
        }

        private static final boolean guessWorkingDirectory$lambda$0(Ref $ref, VirtualFile packageJson) {
            $ref.set((Object)packageJson);
            return false;
        }

        private static final boolean guessWorkingDirectory$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

