/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRenderer;
import com.intellij.javascript.nodejs.util.DefaultNodePackageRefResolver;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageEditor;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.javascript.nodejs.util.NodePackageRefResolver;
import com.intellij.javascript.nodejs.util.NodePackageRenderer;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class NodePackageField
extends ComponentWithBrowseButton<ComboBox<NodePackageRef>> {
    @NonNls
    static final NodePackageRef SELECT_PACKAGE = NodePackageRef.create("##Select package");
    private final Project myProject;
    private final NodePackageDescriptor myDescriptor;
    private final KeyEventAwareComboBox<NodePackageRef> myComboBox;
    private final DefaultComboBoxModel<NodePackageRef> myModel;
    private final NodePackageEditor myEditor;
    private final List<Consumer<NodePackage>> myPackageSelectionListeners;
    private final List<Consumer<NodePackageRef>> myPackageRefSelectionListeners;
    private final NodePackageRefResolver myResolver;
    private boolean myItemSelectedListenersEnabled;

    public NodePackageField(@NotNull Project project, @NotNull String packageName, @Nullable Supplier<? extends NodeJsInterpreter> interpreterSupplier) {
        if (project == null) {
            NodePackageField.$$$reportNull$$$0(0);
        }
        if (packageName == null) {
            NodePackageField.$$$reportNull$$$0(1);
        }
        this(project, Collections.singletonList(packageName), interpreterSupplier);
    }

    public NodePackageField(@NotNull Project project, @NotNull List<String> packageNames, @Nullable Supplier<? extends NodeJsInterpreter> interpreterSupplier) {
        if (project == null) {
            NodePackageField.$$$reportNull$$$0(2);
        }
        if (packageNames == null) {
            NodePackageField.$$$reportNull$$$0(3);
        }
        this(project, new NodePackageDescriptor(packageNames), interpreterSupplier, null, null);
    }

    public NodePackageField(@NotNull NodeJsInterpreterField interpreterField, @NotNull String packageName) {
        if (interpreterField == null) {
            NodePackageField.$$$reportNull$$$0(4);
        }
        if (packageName == null) {
            NodePackageField.$$$reportNull$$$0(5);
        }
        this(interpreterField.getProject(), new NodePackageDescriptor(packageName), interpreterField::getInterpreter, interpreterField, null);
    }

    public NodePackageField(@NotNull NodeJsInterpreterField interpreterField, @NotNull NodePackageDescriptor descriptor, @Nullable Supplier<? extends VirtualFile> contextFileOrDirectorySupplier) {
        if (interpreterField == null) {
            NodePackageField.$$$reportNull$$$0(6);
        }
        if (descriptor == null) {
            NodePackageField.$$$reportNull$$$0(7);
        }
        this(interpreterField.getProject(), descriptor, interpreterField::getInterpreter, interpreterField, contextFileOrDirectorySupplier);
    }

    public NodePackageField(@NotNull NodeJsInterpreterField interpreterField, @NotNull NodePackageDescriptor descriptor, @Nullable Supplier<? extends VirtualFile> contextFileOrDirectorySupplier, @NotNull NodePackageRefResolver nodePackageRefResolver) {
        if (interpreterField == null) {
            NodePackageField.$$$reportNull$$$0(8);
        }
        if (descriptor == null) {
            NodePackageField.$$$reportNull$$$0(9);
        }
        if (nodePackageRefResolver == null) {
            NodePackageField.$$$reportNull$$$0(10);
        }
        this(interpreterField.getProject(), descriptor, interpreterField::getInterpreter, interpreterField, contextFileOrDirectorySupplier, nodePackageRefResolver);
    }

    public NodePackageField(@NotNull Project project, @NotNull NodePackageDescriptor descriptor, @Nullable Supplier<? extends NodeJsInterpreter> interpreterSupplier, @NotNull NodePackageRefResolver nodePackageRefResolver) {
        if (project == null) {
            NodePackageField.$$$reportNull$$$0(11);
        }
        if (descriptor == null) {
            NodePackageField.$$$reportNull$$$0(12);
        }
        if (nodePackageRefResolver == null) {
            NodePackageField.$$$reportNull$$$0(13);
        }
        this(project, descriptor, interpreterSupplier, null, null, nodePackageRefResolver);
    }

    private NodePackageField(@NotNull Project project, @NotNull NodePackageDescriptor descriptor, @Nullable Supplier<? extends NodeJsInterpreter> interpreterSupplier, @Nullable NodeJsInterpreterField interpreterField, @Nullable Supplier<? extends VirtualFile> contextFileOrDirectorySupplier) {
        if (project == null) {
            NodePackageField.$$$reportNull$$$0(14);
        }
        if (descriptor == null) {
            NodePackageField.$$$reportNull$$$0(15);
        }
        this(project, descriptor, interpreterSupplier, interpreterField, contextFileOrDirectorySupplier, new DefaultNodePackageRefResolver(project, descriptor, interpreterSupplier));
    }

    private NodePackageField(@NotNull Project project, @NotNull NodePackageDescriptor descriptor, @Nullable Supplier<? extends NodeJsInterpreter> interpreterSupplier, @Nullable NodeJsInterpreterField interpreterField, @Nullable Supplier<? extends VirtualFile> contextFileOrDirectorySupplier, @NotNull NodePackageRefResolver nodePackageRefResolver) {
        if (project == null) {
            NodePackageField.$$$reportNull$$$0(16);
        }
        if (descriptor == null) {
            NodePackageField.$$$reportNull$$$0(17);
        }
        if (nodePackageRefResolver == null) {
            NodePackageField.$$$reportNull$$$0(18);
        }
        super(new KeyEventAwareComboBox(), null);
        this.myPackageSelectionListeners = new ArrayList<Consumer<NodePackage>>();
        this.myPackageRefSelectionListeners = new ArrayList<Consumer<NodePackageRef>>();
        this.myItemSelectedListenersEnabled = true;
        this.myProject = project;
        this.myDescriptor = descriptor;
        this.myComboBox = (KeyEventAwareComboBox)((Object)this.getChildComponent());
        this.myModel = new DefaultComboBoxModel();
        this.myComboBox.setModel(this.myModel);
        this.myResolver = nodePackageRefResolver;
        interpreterSupplier = (Supplier)ObjectUtils.notNull(interpreterSupplier, () -> null);
        this.myComboBox.setRenderer(new DelegatingListCellRenderer(project, this.myResolver, interpreterSupplier));
        this.myComboBox.setEditable(true);
        this.myEditor = new NodePackageEditor(project, this.myModel, descriptor, this.myResolver, interpreterSupplier);
        this.myComboBox.setEditor(this.myEditor);
        if (interpreterField != null) {
            interpreterField.addChangeListener(newInterpreter -> this.myEditor.update());
        }
        this.myEditor.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                NodePackageField.this.triggerItemSelectedListeners();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/nodejs/util/NodePackageField$1", "textChanged"));
            }
        });
        this.installFileCompletionAndBrowserFolderListener(this.myEditor.getTextField());
        this.myComboBox.setMinimumAndPreferredWidth(0);
        this.installListeners(interpreterSupplier, contextFileOrDirectorySupplier);
    }

    @NotNull
    public JComponent getEditorComponent() {
        JTextField jTextField = this.myEditor.getTextField();
        if (jTextField == null) {
            NodePackageField.$$$reportNull$$$0(19);
        }
        return jTextField;
    }

    private void installListeners(final @Nullable Supplier<? extends NodeJsInterpreter> interpreterSupplier, final @Nullable Supplier<? extends VirtualFile> contextFileOrDirectorySupplier) {
        ItemListener itemListener = new ItemListener(){
            private Object myLastSelectedItem;

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object selectedItem = NodePackageField.this.myComboBox.getSelectedItem();
                    if (selectedItem == SELECT_PACKAGE) {
                        NodePackageField.this.myComboBox.setSelectedItem(this.myLastSelectedItem);
                        if (!NodePackageField.this.myComboBox.myKeyEventProcessing) {
                            ApplicationManager.getApplication().invokeLater(() -> NodePackageField.this.performSelection((NodePackage)ObjectUtils.tryCast((Object)this.myLastSelectedItem, NodePackage.class)), ModalityState.defaultModalityState());
                        }
                    } else {
                        this.myLastSelectedItem = selectedItem;
                    }
                    NodePackageField.this.triggerItemSelectedListeners();
                }
            }
        };
        this.myComboBox.addItemListener(itemListener);
        this.myComboBox.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                List<NodePackageRef> refs;
                NodeJsInterpreter interpreter2 = interpreterSupplier != null ? (NodeJsInterpreter)interpreterSupplier.get() : null;
                VirtualFile contextFileOrDirectory = contextFileOrDirectorySupplier != null ? (VirtualFile)contextFileOrDirectorySupplier.get() : null;
                try (AccessToken ignore = SlowOperations.knownIssue((String)"WEB-69427");){
                    refs = NodePackageField.this.myDescriptor.listPackageRefs(NodePackageField.this.myProject, interpreter2, contextFileOrDirectory);
                }
                NodePackageRef prevSelected = NodePackageField.this.getSelectedRef();
                NodePackageField.this.doWithItemSelectedListenersDisabled(() -> NodePackageField.this.myComboBox.doWithItemStateChangedEventsDisabled(() -> {
                    SwingHelper.updateItems(NodePackageField.this.myComboBox, (List)refs, null);
                    NodePackageField.this.myComboBox.addItem(SELECT_PACKAGE);
                    if (!refs.contains(prevSelected) || !prevSelected.equals(NodePackageField.this.myComboBox.getSelectedItem())) {
                        NodePackageField.this.myComboBox.setSelectedItem(prevSelected);
                    }
                }));
            }
        });
    }

    private void doWithItemSelectedListenersDisabled(Runnable r) {
        this.myItemSelectedListenersEnabled = false;
        try {
            r.run();
        }
        finally {
            this.myItemSelectedListenersEnabled = true;
        }
    }

    private void triggerItemSelectedListeners() {
        if (!this.myItemSelectedListenersEnabled) {
            return;
        }
        NodePackageRef ref2 = this.getSelectedRef();
        this.myPackageRefSelectionListeners.forEach(consumer -> consumer.consume((Object)ref2));
        if (!this.myPackageSelectionListeners.isEmpty()) {
            NodePackage selected = this.getSelected();
            this.myPackageSelectionListeners.forEach(consumer -> consumer.consume((Object)selected));
        }
    }

    private void performSelection(@Nullable NodePackage initial) {
        VirtualFile initialFile = initial != null ? LocalFileFinder.findFile((String)initial.getSystemIndependentPath()) : null;
        FileChooserDescriptor descriptor = this.myDescriptor.createFileChooserDescriptor();
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)this.myProject, (VirtualFile)initialFile);
        if (file != null) {
            this.addIfMissingAndSelect(this.myDescriptor.createPackageRef(file.getPath()));
        }
    }

    private void addIfMissingAndSelect(@NotNull NodePackageRef ref2) {
        int i;
        if (ref2 == null) {
            NodePackageField.$$$reportNull$$$0(20);
        }
        if ((i = this.myModel.getIndexOf(ref2)) >= 0) {
            this.myModel.setSelectedItem(this.myModel.getElementAt(i));
        } else {
            this.myModel.addElement(ref2);
            this.myModel.setSelectedItem(ref2);
        }
    }

    public void addSelectionListener(@NotNull Consumer<NodePackage> listener2) {
        if (listener2 == null) {
            NodePackageField.$$$reportNull$$$0(21);
        }
        this.myPackageSelectionListeners.add(listener2);
    }

    public void addPackageRefSelectionListener(@NotNull Consumer<NodePackageRef> listener2) {
        if (listener2 == null) {
            NodePackageField.$$$reportNull$$$0(22);
        }
        this.myPackageRefSelectionListeners.add(listener2);
    }

    public void setSelected(@NotNull NodePackage pkg) {
        if (pkg == null) {
            NodePackageField.$$$reportNull$$$0(23);
        }
        this.setSelectedRef(NodePackageRef.create(pkg));
    }

    public void setSelectedRef(@NotNull NodePackageRef pkgRef) {
        if (pkgRef == null) {
            NodePackageField.$$$reportNull$$$0(24);
        }
        this.addIfMissingAndSelect(pkgRef);
    }

    @NotNull
    public NodePackage getSelected() {
        NodePackage pkg = this.myResolver.resolve(this.myEditor.getItem());
        return pkg != null ? pkg : new NodePackage("");
    }

    @NotNull
    public NodePackageRef getSelectedRef() {
        NodePackageRef nodePackageRef = this.myEditor.getItem();
        if (nodePackageRef == null) {
            NodePackageField.$$$reportNull$$$0(25);
        }
        return nodePackageRef;
    }

    @ApiStatus.Internal
    @NotNull
    public NodePackageDescriptor getDescriptor() {
        NodePackageDescriptor nodePackageDescriptor = this.myDescriptor;
        if (nodePackageDescriptor == null) {
            NodePackageField.$$$reportNull$$$0(26);
        }
        return nodePackageDescriptor;
    }

    public void setPreferredWidthToFitText() {
        NodePackageRef ref2 = (NodePackageRef)this.myComboBox.getSelectedItem();
        if (ref2 != null) {
            this.myComboBox.setMinimumAndPreferredWidth(-1);
            NodePackageRef prevPrototype = (NodePackageRef)this.myComboBox.getPrototypeDisplayValue();
            this.myComboBox.setPrototypeDisplayValue(ref2);
            Dimension size = this.getPreferredSize();
            this.setPreferredSize(size);
            this.myComboBox.setMinimumAndPreferredWidth(0);
            this.myComboBox.setPrototypeDisplayValue(prevPrototype);
        }
    }

    private void installFileCompletionAndBrowserFolderListener(@NotNull JTextField textField) {
        if (textField == null) {
            NodePackageField.$$$reportNull$$$0(27);
        }
        FileChooserDescriptor descriptor = this.myDescriptor.createFileChooserDescriptor();
        FileChooserFactory.getInstance().installFileCompletion(textField, descriptor, true, null);
        this.addBrowseFolderListener(this.myProject, descriptor, this.myEditor.getTextComponentAccessor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 19, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNames";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterField";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 10: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackageRefResolver";
                break;
            }
            case 19: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackageField";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkgRef";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackageField";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorComponent";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRef";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 19: 
            case 25: 
            case 26: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addIfMissingAndSelect";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionListener";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addPackageRefSelectionListener";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedRef";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "installFileCompletionAndBrowserFolderListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 19, 25, 26 -> new IllegalStateException(string);
        };
    }

    private static class KeyEventAwareComboBox<T>
    extends ComboBox<T> {
        private boolean myKeyEventProcessing = false;
        private boolean myItemStateChangedEventsAllowed = true;

        private KeyEventAwareComboBox() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            try {
                this.myKeyEventProcessing = true;
                boolean bl = super.processKeyBinding(ks, e, condition, pressed);
                return bl;
            }
            finally {
                this.myKeyEventProcessing = false;
            }
        }

        protected void selectedItemChanged() {
            if (this.myItemStateChangedEventsAllowed) {
                super.selectedItemChanged();
            }
        }

        public void doWithItemStateChangedEventsDisabled(@NotNull Runnable runnable) {
            if (runnable == null) {
                KeyEventAwareComboBox.$$$reportNull$$$0(0);
            }
            this.myItemStateChangedEventsAllowed = false;
            try {
                runnable.run();
            }
            finally {
                this.myItemStateChangedEventsAllowed = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/javascript/nodejs/util/NodePackageField$KeyEventAwareComboBox", "doWithItemStateChangedEventsDisabled"));
        }
    }

    private class DelegatingListCellRenderer
    implements ListCellRenderer<NodePackageRef> {
        private final SpecialValueRenderer mySpecialValueRenderer;
        private final NodePackageRenderer myPackageRenderer;

        DelegatingListCellRenderer(@NotNull Project project, @NotNull NodePackageRefResolver refResolver, Supplier<? extends NodeJsInterpreter> interpreterSupplier) {
            if (project == null) {
                DelegatingListCellRenderer.$$$reportNull$$$0(0);
            }
            if (refResolver == null) {
                DelegatingListCellRenderer.$$$reportNull$$$0(1);
            }
            if (interpreterSupplier == null) {
                DelegatingListCellRenderer.$$$reportNull$$$0(2);
            }
            this.mySpecialValueRenderer = new SpecialValueRenderer();
            this.myPackageRenderer = new NodePackageRenderer(project, refResolver, interpreterSupplier);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends NodePackageRef> list, NodePackageRef value, int index, boolean isSelected, boolean cellHasFocus) {
            SpecialValueRenderer renderer = value == null || value == SELECT_PACKAGE ? this.mySpecialValueRenderer : this.myPackageRenderer;
            list.setEnabled(NodePackageField.this.isEnabled());
            return renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "refResolver";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "interpreterSupplier";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/util/NodePackageField$DelegatingListCellRenderer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SpecialValueRenderer
    extends ColoredListCellRenderer<NodePackageRef> {
        SpecialValueRenderer() {
            this.setIpad((Insets)JBUI.insets((int)0, (int)2, (int)0, (int)0));
            NodeJsInterpreterRenderer.adjustBorderHeight((SimpleColoredComponent)this);
        }

        protected void customizeCellRenderer(@NotNull JList<? extends NodePackageRef> list, @Nullable NodePackageRef value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                SpecialValueRenderer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                this.append(JavaScriptBundle.message("node.package.none", new Object[0]), new SimpleTextAttributes(0, (Color)JBColor.RED));
            } else if (value == SELECT_PACKAGE) {
                this.append(" " + JavaScriptBundle.message("node.package.dropDownList.select", new Object[0]), new SimpleTextAttributes(0, (Color)JBColor.darkGray));
            } else {
                this.append("Unexpected value: " + String.valueOf(value), new SimpleTextAttributes(0, (Color)JBColor.RED));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/javascript/nodejs/util/NodePackageField$SpecialValueRenderer", "customizeCellRenderer"));
        }
    }
}

