/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.utils;

import com.intellij.docker.utils.TruncatedLogger;
import com.intellij.openapi.diagnostic.Logger;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\rH\u0016J \u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\rH\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u00020\u00152\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\b\u0010\"\u001a\u00020\u0018H\u0016J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u0004H\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/docker/utils/LoggedInputStream;", "Ljava/io/InputStream;", "originalInputStream", "processId", "", "marker", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Ljava/io/InputStream;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/diagnostic/Logger;)V", "myTruncatedLogger", "Lcom/intellij/docker/utils/TruncatedLogger;", "read", "", "b", "", "off", "len", "readAllBytes", "readNBytes", "skip", "", "n", "skipNBytes", "", "available", "mark", "readlimit", "reset", "markSupported", "", "transferTo", "out", "Ljava/io/OutputStream;", "close", "log", "s", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nLoggedProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggedProcess.kt\ncom/intellij/docker/utils/LoggedInputStream\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,179:1\n68#2,4:180\n*S KotlinDebug\n*F\n+ 1 LoggedProcess.kt\ncom/intellij/docker/utils/LoggedInputStream\n*L\n103#1:180,4\n*E\n"})
final class LoggedInputStream
extends InputStream {
    @NotNull
    private final InputStream originalInputStream;
    @NotNull
    private final String processId;
    @NotNull
    private final String marker;
    @NotNull
    private final Logger logger;
    @NotNull
    private final TruncatedLogger myTruncatedLogger;

    public LoggedInputStream(@NotNull InputStream originalInputStream, @NotNull String processId, @NotNull String marker, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)originalInputStream, (String)"originalInputStream");
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.originalInputStream = originalInputStream;
        this.processId = processId;
        this.marker = marker;
        this.logger = logger;
        this.myTruncatedLogger = new TruncatedLogger((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                LoggedInputStream.access$log((LoggedInputStream)this.receiver, p0);
            }
        }));
    }

    @Override
    public int read() {
        int n;
        int it = n = this.originalInputStream.read();
        boolean bl = false;
        this.myTruncatedLogger.logSingleByteRead(it);
        return n;
    }

    @Override
    public int read(@NotNull byte[] b) {
        int n;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int it = n = this.originalInputStream.read(b);
        boolean bl = false;
        TruncatedLogger.logBytes$default(this.myTruncatedLogger, b, 0, it, 2, null);
        return n;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        int n;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int it = n = this.originalInputStream.read(b, off, len);
        boolean bl = false;
        this.myTruncatedLogger.logBytes(b, off, it);
        return n;
    }

    @Override
    @NotNull
    public byte[] readAllBytes() {
        byte[] byArray;
        byte[] it = byArray = this.originalInputStream.readAllBytes();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        TruncatedLogger.logBytes$default(this.myTruncatedLogger, it, 0, 0, 6, null);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"also(...)");
        return byArray;
    }

    @Override
    @NotNull
    public byte[] readNBytes(int len) {
        byte[] byArray;
        byte[] it = byArray = this.originalInputStream.readNBytes(len);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        TruncatedLogger.logBytes$default(this.myTruncatedLogger, it, 0, 0, 6, null);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"also(...)");
        return byArray;
    }

    @Override
    public int readNBytes(@NotNull byte[] b, int off, int len) {
        int n;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int it = n = this.originalInputStream.readNBytes(b, off, len);
        boolean bl = false;
        this.myTruncatedLogger.logBytes(b, off, it);
        return n;
    }

    @Override
    public long skip(long n) {
        return this.originalInputStream.skip(n);
    }

    @Override
    public void skipNBytes(long n) {
        this.originalInputStream.skipNBytes(n);
    }

    @Override
    public int available() {
        return this.originalInputStream.available();
    }

    @Override
    public void mark(int readlimit) {
        this.originalInputStream.mark(readlimit);
    }

    @Override
    public void reset() {
        this.originalInputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.originalInputStream.markSupported();
    }

    @Override
    public long transferTo(@Nullable OutputStream out) {
        return this.originalInputStream.transferTo(out);
    }

    @Override
    public void close() {
        this.originalInputStream.close();
    }

    private final void log(String s) {
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("[" + this.processId + "] " + this.marker + ": " + s);
        }
    }

    public static final /* synthetic */ void access$log(LoggedInputStream $this, String s) {
        $this.log(s);
    }
}

