/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.config;

import com.intellij.ide.actionsOnSave.ActionOnSaveBackedByOwnConfigurable;
import com.intellij.ide.actionsOnSave.ActionOnSaveComment;
import com.intellij.ide.actionsOnSave.ActionOnSaveContext;
import com.intellij.ide.util.scopeChooser.ScopeChooserUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.config.WatchersConfigurable;
import com.intellij.plugins.watcher.config.ui.WatcherInfo;
import com.intellij.plugins.watcher.config.ui.WatchersPanel;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.plugins.watcher.util.TaskUtils;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.DropDownLink;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.JBUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileWatcherOnSaveInfo
extends ActionOnSaveBackedByOwnConfigurable<WatchersConfigurable> {
    private static final Logger LOG = Logger.getInstance(FileWatcherOnSaveInfo.class);
    @NotNull
    private List<WatcherInfo> myAllInfos;
    @NotNull
    private WatcherInfo myInfo;

    FileWatcherOnSaveInfo(@NotNull ActionOnSaveContext context, @NotNull List<WatcherInfo> infos, @NotNull WatcherInfo watcherInfo) {
        if (context == null) {
            FileWatcherOnSaveInfo.$$$reportNull$$$0(0);
        }
        if (infos == null) {
            FileWatcherOnSaveInfo.$$$reportNull$$$0(1);
        }
        if (watcherInfo == null) {
            FileWatcherOnSaveInfo.$$$reportNull$$$0(2);
        }
        super(context, "watcher.settings", WatchersConfigurable.class);
        this.myAllInfos = new ArrayList<WatcherInfo>(infos);
        this.myInfo = watcherInfo;
    }

    @NotNull
    public String getActionOnSaveName() {
        String name = StringUtil.shortenTextWithEllipsis((String)this.myInfo.getWatcherName(), (int)30, (int)0, (boolean)true);
        String string = BackgroundTaskBundle.message("actions.on.save.page.checkbox.file.watcher.0", name);
        if (string == null) {
            FileWatcherOnSaveInfo.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected boolean isApplicableAccordingToStoredState() {
        return this.myInfo.getWatcher() != null;
    }

    protected boolean isApplicableAccordingToUiState(@NotNull WatchersConfigurable configurable) {
        if (configurable == null) {
            FileWatcherOnSaveInfo.$$$reportNull$$$0(4);
        }
        return this.myInfo.getWatcher() != null;
    }

    protected boolean isActionOnSaveEnabledAccordingToStoredState() {
        return this.myInfo.getEnabled();
    }

    protected boolean isActionOnSaveEnabledAccordingToUiState(@NotNull WatchersConfigurable configurable) {
        if (configurable == null) {
            FileWatcherOnSaveInfo.$$$reportNull$$$0(5);
        }
        return this.myInfo.getEnabled();
    }

    protected void setActionOnSaveEnabled(@NotNull WatchersConfigurable configurable, boolean enabled) {
        if (configurable == null) {
            FileWatcherOnSaveInfo.$$$reportNull$$$0(6);
        }
        this.myInfo.setEnabled(enabled);
        configurable.getPanel().reset(this.myAllInfos);
    }

    @Nullable
    protected ActionOnSaveComment getCommentAccordingToStoredState() {
        return this.getWatcherComment();
    }

    @Nullable
    protected ActionOnSaveComment getCommentAccordingToUiState(@NotNull WatchersConfigurable configurable) {
        if (configurable == null) {
            FileWatcherOnSaveInfo.$$$reportNull$$$0(7);
        }
        return this.getWatcherComment();
    }

    private ActionOnSaveComment getWatcherComment() {
        String warning = FileWatcherOnSaveInfo.getWarningComment(this.getProject(), this.myInfo.getWatcher());
        if (warning != null) {
            return this.isActionOnSaveEnabled() ? ActionOnSaveComment.warning((String)warning) : ActionOnSaveComment.info((String)warning);
        }
        FileType fileType = this.myInfo.getWatcher().getFileType();
        String fileTypeText = fileType == TaskUtils.FAKE_ANY_FILE_TYPE ? BackgroundTaskBundle.message("actions.on.save.comment.tracks.all.files", new Object[0]) : StringUtil.shortenTextWithEllipsis((String)fileType.getDescription(), (int)30, (int)0, (boolean)true);
        String program = StringUtil.shortenTextWithEllipsis((String)PathUtil.getFileName((String)this.myInfo.getWatcher().getProgram()), (int)20, (int)0, (boolean)true);
        String message = this.myInfo.getWatcher().isImmediateSync() ? BackgroundTaskBundle.message("actions.on.save.comment.auto.saves.0.files.runs.1", fileTypeText, program) : BackgroundTaskBundle.message("actions.on.save.comment.tracks.0.files.runs.1", fileTypeText, program);
        return ActionOnSaveComment.info((String)message);
    }

    @NlsContexts.Label
    @Nullable
    private static String getWarningComment(@NotNull Project project, @Nullable TaskOptions watcher) {
        if (project == null) {
            FileWatcherOnSaveInfo.$$$reportNull$$$0(8);
        }
        if (watcher == null) {
            return BackgroundTaskBundle.message("actions.on.save.comment.global.file.watcher.not.found", new Object[0]);
        }
        if (watcher.getFileType() == UnknownFileType.INSTANCE) {
            return BackgroundTaskBundle.message("actions.on.save.comment.unknown.file.type", new Object[0]);
        }
        if (project.isDefault()) {
            return null;
        }
        GlobalSearchScope scope = ScopeChooserUtils.findScopeByName((Project)project, (String)watcher.getScopeName());
        if (scope == GlobalSearchScope.EMPTY_SCOPE) {
            return BackgroundTaskBundle.message("actions.on.save.comment.unknown.scope", new Object[0]);
        }
        if (StringUtil.isEmpty((String)watcher.getProgram())) {
            return BackgroundTaskBundle.message("actions.on.save.comment.program.not.specified", new Object[0]);
        }
        return null;
    }

    @NotNull
    public List<? extends ActionLink> getActionLinks() {
        ActionLink editWatcher = new ActionLink(BackgroundTaskBundle.message("actions.on.save.link.edit", new Object[0]), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WatchersPanel.editWatcher(FileWatcherOnSaveInfo.this.getProject(), FileWatcherOnSaveInfo.this.myInfo, () -> FileWatcherOnSaveInfo.this.updateUiOnOwnPage(configurable -> configurable.getPanel().reset(FileWatcherOnSaveInfo.this.myAllInfos)));
            }
        });
        String showAllWatchers = BackgroundTaskBundle.message("actions.on.save.link.show.all.file.watchers", new Object[0]);
        List<ActionLink> list = List.of(editWatcher, this.createGoToPageInSettingsLink(showAllWatchers, "watcher.settings"));
        if (list == null) {
            FileWatcherOnSaveInfo.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    public DropDownLink<?> getActivatedOnDropDownLink() {
        if (this.myInfo.getWatcher() == null) {
            return null;
        }
        String withExternalChangeLabel = FileWatcherOnSaveInfo.getAnySaveAndExternalChangeText();
        String withExternalChangeOption = FileWatcherOnSaveInfo.getAnySaveAndExternalChangeTextForDropDownOption();
        String withoutExternalChangeLabel = FileWatcherOnSaveInfo.getAnySaveText();
        String withoutExternalChangeOption = FileWatcherOnSaveInfo.getAnySaveTextForDropDownOption();
        String current = this.myInfo.getWatcher().isRunOnExternalChanges() ? withExternalChangeLabel : withoutExternalChangeLabel;
        DropDownLink dropDownLink = new DropDownLink((Object)current, List.of(withoutExternalChangeOption, withExternalChangeOption), choice -> {
            this.myInfo.getWatcher().setRunOnExternalChanges(choice == withExternalChangeOption);
            this.updateUiOnOwnPage(configurable -> configurable.getPanel().reset(this.myAllInfos));
        });
        if (current.contains("<br/>") || current.contains("<br>")) {
            dropDownLink.setIconTextGap(JBUI.scale((int)4));
        }
        return dropDownLink;
    }

    protected void apply() {
        int index = this.myAllInfos.indexOf(this.myInfo);
        if (index < 0) {
            return;
        }
        int oldSize = this.myAllInfos.size();
        this.myAllInfos = WatchersPanel.getStoredState(this.getProject());
        if (oldSize != this.myAllInfos.size()) {
            LOG.error("old size = " + oldSize + ", new size = " + this.myAllInfos.size());
            return;
        }
        this.myInfo = this.myAllInfos.get(index);
    }

    protected void resetUiOnOwnPageThatIsMirroredOnActionsOnSavePage(@NotNull WatchersConfigurable configurable) {
        List<WatcherInfo> storedState;
        if (configurable == null) {
            FileWatcherOnSaveInfo.$$$reportNull$$$0(10);
        }
        if (this.hasALotChanged(storedState = WatchersPanel.getStoredState(this.getProject()))) {
            return;
        }
        int index = this.myAllInfos.indexOf(this.myInfo);
        if (index < 0) {
            return;
        }
        WatcherInfo storedWatcherInfo = storedState.get(index);
        if (storedWatcherInfo.getWatcher() != null && this.myInfo.getWatcher() != null) {
            this.myInfo.setEnabled(storedWatcherInfo.getEnabled());
            this.myInfo.getWatcher().setRunOnExternalChanges(storedWatcherInfo.getWatcher().isRunOnExternalChanges());
        }
    }

    private boolean hasALotChanged(@NotNull List<WatcherInfo> storedState) {
        if (storedState == null) {
            FileWatcherOnSaveInfo.$$$reportNull$$$0(11);
        }
        if (storedState.size() != this.myAllInfos.size()) {
            return true;
        }
        for (int i = 0; i < storedState.size(); ++i) {
            WatcherInfo stored = storedState.get(i);
            WatcherInfo current = this.myAllInfos.get(i);
            if (!stored.getWatcherName().equals(current.getWatcherName())) {
                return true;
            }
            if (stored.getLevel() == current.getLevel()) continue;
            return true;
        }
        return false;
    }

    protected boolean areOptionsMirroredOnActionsOnSavePageModified(@NotNull WatchersConfigurable configurable) {
        if (configurable == null) {
            FileWatcherOnSaveInfo.$$$reportNull$$$0(12);
        }
        return !this.myAllInfos.equals(WatchersPanel.getStoredState(this.getProject()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watcherInfo";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/config/FileWatcherOnSaveInfo";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storedState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/config/FileWatcherOnSaveInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionOnSaveName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionLinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableAccordingToUiState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isActionOnSaveEnabledAccordingToUiState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setActionOnSaveEnabled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCommentAccordingToUiState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getWarningComment";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resetUiOnOwnPageThatIsMirroredOnActionsOnSavePage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasALotChanged";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "areOptionsMirroredOnActionsOnSavePageModified";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9 -> new IllegalStateException(string);
        };
    }
}

