/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.snowflake;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.snowflake.SFlakeDdlParsing;
import com.intellij.sql.dialects.snowflake.SFlakeDialect;
import com.intellij.sql.dialects.snowflake.SFlakeDmlParsing;
import com.intellij.sql.dialects.snowflake.SFlakeExpressionParsing;
import com.intellij.sql.dialects.snowflake.SFlakeGeneratedParser;
import com.intellij.sql.dialects.snowflake.SFlakeTypes;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlLazyElementTypeImpl;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SFlakeParser
extends SqlParser {
    private final boolean myPlSql;
    private boolean myUnderPl;

    public SFlakeParser(boolean pl) {
        super((SqlLanguageDialectEx)SFlakeDialect.INSTANCE);
        this.myPlSql = pl;
    }

    private boolean isPlSql() {
        return this.myPlSql || this.myUnderPl;
    }

    public void parseLight(IElementType root, PsiBuilder initialBuilder) {
        PsiElement element = SqlLazyElementTypeImpl.getContextElement((PsiBuilder)initialBuilder);
        SFlakeDialect dialect = (SFlakeDialect)((Object)ObjectUtils.tryCast((Object)this.getLanguage(), SFlakeDialect.class));
        this.myUnderPl = dialect != null && element != null && SFlakeParser.isInPl(element);
        super.parseLight(root, initialBuilder);
    }

    private static boolean isInPl(@NotNull PsiElement psi) {
        if (psi == null) {
            SFlakeParser.$$$reportNull$$$0(0);
        }
        return SqlFileElementType.isInPl((PsiElement)psi) || PsiTreeUtil.getNonStrictParentOfType((PsiElement)psi, (Class[])new Class[]{SqlBlockStatement.class}) != null;
    }

    public boolean allowStringsAsIdentifiers(@Nullable SqlReferenceElementType refType) {
        return true;
    }

    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean b) {
        return false;
    }

    protected boolean allowQuestionMarkParameter(PsiBuilder builder) {
        return !this.isPl(builder) && super.allowQuestionMarkParameter(builder);
    }

    protected boolean isParameterReference(PsiBuilder builder) {
        return !this.isPl(builder) && builder.getTokenType() == SQL_COLON;
    }

    protected void consumeParameterReferenceInner(PsiBuilder builder) {
        if (builder.getTokenType() == SQL_QUESTION_MARK) {
            builder.advanceLexer();
        } else {
            super.consumeParameterReferenceInner(builder);
        }
    }

    protected boolean isVariableReference(PsiBuilder builder) {
        boolean variablePrefix;
        IElementType token = builder.getTokenType();
        if (this.isPl(builder) && token == SQL_QUESTION_MARK) {
            return true;
        }
        boolean bl = variablePrefix = token == SQL_DOLLAR || this.isPl(builder) && token == SQL_COLON;
        if (variablePrefix && this.isIdentifierToken(builder, builder.rawLookup(1), true, false)) {
            return true;
        }
        return super.isVariableReference(builder);
    }

    public boolean isPl(PsiBuilder builder) {
        return SqlGeneratedParserUtil.isOn((PsiBuilder)builder, (int)0, (String)"PL_DIALECT") || this.isPlSql();
    }

    protected boolean parseExtraRoots(IElementType root, PsiBuilder builder, int level) {
        return SFlakeGeneratedParser.parse_root_(root, builder, level);
    }

    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return SFlakeGeneratedParser.statement(builder, level);
    }

    public boolean parseOdbcSequence(PsiBuilder builder) {
        return false;
    }

    protected TokenSet[] getExtendsTokenSets() {
        return SFlakeGeneratedParser.EXTENDS_SETS_;
    }

    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return SFlakeDmlParsing.top_query_expression(builder, level);
    }

    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return ext ? SFlakeDdlParsing.type_element_ext(builder, level) : SFlakeDdlParsing.type_element(builder, level);
    }

    public boolean parseReferenceExpressionInner(PsiBuilder builder, boolean optional, boolean force, SqlReferenceElementType refType) {
        if (builder.getTokenType() == SFlakeTypes.SFLAKE_IDENTIFIER_TOKEN && builder.lookAhead(1) == SQL_LEFT_PAREN) {
            builder.advanceLexer();
            builder.advanceLexer();
            PsiBuilder.Marker m = builder.mark();
            if (!this.parseStringLiteralOrParameter(builder)) {
                m.drop();
                GeneratedParserUtilBase.report_error_((PsiBuilder)builder, (!optional ? 1 : 0) != 0);
            } else {
                m.done((IElementType)refType);
            }
            GeneratedParserUtilBase.consumeToken((PsiBuilder)builder, (IElementType)SQL_RIGHT_PAREN);
            return true;
        }
        return super.parseReferenceExpressionInner(builder, optional, force, refType);
    }

    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        boolean res2 = super.parseFunctionCallTail(builder, level);
        if (res2) {
            SFlakeGeneratedParser.within_group_clause(builder, level);
            SFlakeGeneratedParser.analytic_clause(builder, level);
        }
        return res2;
    }

    public boolean parseFunctionArgument(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        if (this.isIdentifierToken(builder, builder.getTokenType(), true, false) && builder.getTokenType() != SQL_IDENT_DELIMITED && builder.lookAhead(1) == ORA_OP_NAMED_PARAM_BINDING) {
            builder.advanceLexer();
            builder.advanceLexer();
        }
        return super.parseFunctionArgument(builder, level, optional, allowBoolean);
    }

    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference((PsiBuilder)builder, (int)level, SFlakeExpressionParsing::evaluable_expression);
    }

    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result = SFlakeExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error(DatabaseBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
        }
        return result;
    }

    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, SFlakeExpressionParsing::parenthesized_values_expr, SFlakeDmlParsing::top_query_expression, SFlakeParser::parseTopQueryExpressionTail, SFlakeExpressionParsing::row_element_list, (b, l) -> SFlakeExpressionParsing.root_expr_0(b, l, -1) && SFlakeExpressionParsing.row_element_list_separator(b, l) && SFlakeExpressionParsing.row_element_list(b, l));
    }

    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, SFlakeDmlParsing::parenthesized_aliased_join_expression, SFlakeDmlParsing::top_query_expression, SFlakeParser::parseTopQueryExpressionTail, SFlakeDmlParsing::comma_join_expression, (b, l) -> SFlakeDmlParsing.join_expression_0(b, l, -1));
    }

    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return SFlakeGeneratedParser.table_column_opt_list(builder, level);
    }

    private static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        SFlakeDmlParsing.query_expression_0(builder, level, -1);
        return SFlakeDmlParsing.left_inner_table_op_tail(builder, level);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/sql/dialects/snowflake/SFlakeParser", "isInPl"));
    }
}

