/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.clickhouse;

import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.clickhouse.CHouseDialect;
import com.intellij.sql.dialects.clickhouse.CHouseTokens;
import com.intellij.sql.dialects.clickhouse.CHouseTypes;
import com.intellij.sql.dialects.clickhouse._CHouseLexer;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;

public class CHouseLexer
extends SqlLexer {
    private int myInsertState;

    public CHouseLexer() {
        super((SqlLanguageDialectBase)CHouseDialect.INSTANCE, (FlexLexer)new _CHouseLexer());
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            CHouseLexer.$$$reportNull$$$0(0);
        }
        this.myInsertState = initialState >>> 29;
        super.start(buffer, startOffset, endOffset, 0x1FFFFFFF & initialState);
    }

    public int getState() {
        return this.myInsertState << 29 | 0x1FFFFFFF & super.getState();
    }

    public void advance() {
        if (this.myInsertState == 1 && this.getTokenType() == SqlTokens.SQL_RAW_INPUT) {
            this.myInsertState = 0;
        }
        super.advance();
    }

    protected void lookAhead(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            CHouseLexer.$$$reportNull$$$0(1);
        }
        if (!this.lookAheadQuotedIdentifierPath(baseLexer, CHouseTokens.CH_DELIMITED_TOKEN_START, CHouseTokens.CH_DELIMITED_TOKEN_END)) {
            super.lookAhead(baseLexer);
        }
    }

    protected void lookSqlKeyword(Lexer baseLexer) {
        IElementType type = this.getSqlTokenType(baseLexer);
        if (this.myInsertState == 0) {
            if (type == SqlCommonKeywords.SQL_INSERT) {
                this.advanceAs(baseLexer, type);
                type = this.skipCommentsAndGet(baseLexer);
                if (type == SqlCommonKeywords.SQL_INTO) {
                    this.advanceAs(baseLexer, type);
                    type = this.skipCommentsAndGet(baseLexer);
                    if (type == SqlCommonKeywords.SQL_TABLE) {
                        this.advanceAs(baseLexer, type);
                        type = this.skipCommentsAndGet(baseLexer);
                    }
                    if (type == SqlCommonKeywords.SQL_FUNCTION) {
                        this.advanceAs(baseLexer, type);
                        type = this.skipCommentsAndGet(baseLexer);
                    }
                    if (CHouseLexer.isIdentifier(type)) {
                        this.advanceAs(baseLexer, type);
                        type = this.skipCommentsAndGet(baseLexer);
                        while (type == SqlTokens.SQL_PERIOD) {
                            this.advanceAs(baseLexer, type);
                            type = this.skipCommentsAndGet(baseLexer);
                            if (!CHouseLexer.isIdentifier(type)) {
                                return;
                            }
                            this.advanceAs(baseLexer, type);
                            type = this.skipCommentsAndGet(baseLexer);
                        }
                        this.myInsertState = 2;
                        return;
                    }
                }
            }
        } else if (this.myInsertState > 1) {
            int b;
            int n = type == SqlTokens.SQL_LEFT_PAREN ? 1 : (b = type == SqlTokens.SQL_RIGHT_PAREN ? -1 : 0);
            if (this.myInsertState == 2 && b == 0 && type == SqlTokens.SQL_VALUES) {
                this.myInsertState = 0;
            } else if (this.myInsertState == 2 && b == 0 && type == CHouseTypes.CH_FORMAT) {
                this.advanceAs(baseLexer, type);
                type = this.skipCommentsAndGet(baseLexer);
                if (type == SqlTokens.SQL_VALUES) {
                    this.myInsertState = 0;
                } else if (CHouseLexer.isIdentifier(type)) {
                    this.advanceAs(baseLexer, type);
                    this.myInsertState = 1;
                    this.lookAheadRawEnd(baseLexer);
                    return;
                }
            } else {
                this.myInsertState = this.myInsertState == 2 && b == -1 ? 0 : (this.myInsertState += b);
            }
        }
        if (this.myInsertState != 1 && CHouseLexer.isStatementSeparator((IElementType)type)) {
            this.myInsertState = 0;
        }
        this.advanceAs(baseLexer, type);
    }

    private void lookAheadRawEnd(Lexer lexer) {
        IElementType type = lexer.getTokenType();
        CharSequence buf = lexer.getBufferSequence();
        int end = lexer.getBufferEnd();
        int start2 = lexer.getTokenStart();
        boolean oneline = true;
        if (SqlTokens.WS_TOKENS.contains(type)) {
            int e = lexer.getTokenEnd();
            int nl = StringUtil.indexOfAny((CharSequence)buf, (String)"\n\r", (int)start2, (int)e);
            boolean bl = oneline = nl == -1;
            if (nl == -1 || nl == e - 1) {
                this.advanceLexer(lexer);
                start2 = e;
            } else {
                nl = CHouseLexer.newLineEnd(buf, nl, end);
                this.addToken(nl, SqlTokens.SQL_WHITE_SPACE);
                start2 = nl;
            }
        }
        int s = start2;
        while (s < end) {
            char c2 = buf.charAt(s);
            if (CHouseLexer.isCrLf(c2)) {
                char nx;
                int ns;
                if (oneline) {
                    oneline = false;
                    if (s > start2 && buf.charAt(s - 1) == ';') {
                        --s;
                        break;
                    }
                }
                if ((ns = CHouseLexer.newLineEnd(buf, s, end)) < end && (CHouseLexer.isCrLf(nx = buf.charAt(ns)) || nx == ';' && (ns + 1 >= end || CHouseLexer.isCrLf(buf.charAt(ns + 1))))) break;
                s = ns;
                continue;
            }
            ++s;
        }
        this.addToken(s, (IElementType)SqlTokens.SQL_RAW_INPUT);
        lexer.start(buf, s, end, lexer.getState());
    }

    public static boolean isValidRawToken(@NotNull CharSequence text) {
        if (text == null) {
            CHouseLexer.$$$reportNull$$$0(2);
        }
        if (text.isEmpty()) {
            return false;
        }
        if (Character.isWhitespace(text.charAt(0))) {
            return false;
        }
        return !StringUtil.endsWithChar((CharSequence)text, (char)';') && !StringUtil.endsWithChar((CharSequence)text, (char)'\n') && !StringUtil.endsWithChar((CharSequence)text, (char)'\r');
    }

    private static int newLineEnd(CharSequence buf, int start2, int end) {
        if (start2 + 1 >= end) {
            return start2 + 1;
        }
        char p2 = buf.charAt(start2);
        char n = buf.charAt(start2 + 1);
        return CHouseLexer.isCrLf(n) && n != p2 ? start2 + 2 : start2 + 1;
    }

    private static boolean isCrLf(char c2) {
        return c2 == '\n' || c2 == '\r';
    }

    private static boolean isIdentifier(IElementType type) {
        return type instanceof SqlKeywordTokenType || type == SqlTokens.SQL_IDENT || type == SqlTokens.SQL_IDENT_DELIMITED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLexer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/clickhouse/CHouseLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lookAhead";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidRawToken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

