/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.ConnDatabaseNotifications;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsoleUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbUIUtil {
    private static final Logger LOG = Logger.getInstance(DbUIUtil.class);
    public static final JBColor WARNING = new JBColor(15111424, 10322434);

    private DbUIUtil() {
    }

    public static <DS extends DasDataSource> void configureDataSourceComboBox(@NotNull Project project, JComboBox<DS> comboBox, Iterable<DS> dataSources, @Nullable DS selection, boolean allowNull) {
        if (project == null) {
            DbUIUtil.$$$reportNull$$$0(0);
        }
        ArrayList copy = ContainerUtil.newArrayList(dataSources);
        copy.sort((o1, o2) -> Comparing.compare((Comparable)((Object)StringUtil.toLowerCase((String)o1.getName())), (Comparable)((Object)StringUtil.toLowerCase((String)o2.getName()))));
        if (allowNull) {
            copy.add(0, null);
        }
        comboBox.setModel((ComboBoxModel<DS>)new CollectionComboBoxModel((List)copy, selection));
        if (comboBox instanceof ComboBox) {
            int width = comboBox.getFontMetrics(comboBox.getFont()).stringWidth("long enough data source name with icon123");
            ((ComboBox)comboBox).setMinimumAndPreferredWidth(width);
        }
        comboBox.setRenderer((ListCellRenderer<DS>)SimpleListCellRenderer.create((label, element, index) -> {
            Color color;
            boolean valid = !(element instanceof PsiElement) || ((PsiElement)element).isValid();
            label.setIcon(element != null ? element.getIcon(0) : null);
            String name2 = element == null ? DatabaseBundle.message((String)"label.none", (Object[])new Object[0]) : element.getName();
            label.setText(StringUtil.notNullize((String)name2));
            if (!valid) {
                label.setForeground((Color)JBColor.RED);
            }
            if ((color = DatabaseColorManager.getColor(project, element)) != null) {
                label.setBackground(color);
            }
        }));
        comboBox.setEditable(false);
    }

    @Nullable
    public static VirtualFile openInConsole(@Nullable DbElement o, @NotNull String text) {
        if (text == null) {
            DbUIUtil.$$$reportNull$$$0(1);
        }
        return o == null ? null : DbUIUtil.openInConsole(o.getDataSource(), o, text, false);
    }

    @Nullable
    public static VirtualFile openInConsole(@NotNull DbDataSource dataSource, @Nullable DbElement o, @NotNull String text, boolean existing2) {
        LocalDataSource localDataSource;
        if (dataSource == null) {
            DbUIUtil.$$$reportNull$$$0(2);
        }
        if (text == null) {
            DbUIUtil.$$$reportNull$$$0(3);
        }
        if ((localDataSource = (LocalDataSource)ObjectUtils.tryCast((Object)dataSource.getDelegate(), LocalDataSource.class)) == null) {
            return null;
        }
        return DbUIUtil.openInConsole(dataSource.getProject(), localDataSource, (DasObject)o, text, existing2);
    }

    @Nullable
    public static VirtualFile openInConsole(Project project, @NotNull LocalDataSource dataSource, @Nullable DasObject o, @NotNull String text, boolean existing2) {
        VirtualFile file;
        if (dataSource == null) {
            DbUIUtil.$$$reportNull$$$0(4);
        }
        if (text == null) {
            DbUIUtil.$$$reportNull$$$0(5);
        }
        VirtualFile virtualFile = file = existing2 ? DatabaseEditorHelper.getConsoleVirtualFile((DasDataSource)dataSource) : DatabaseEditorHelper.createNewConsoleVirtualFile((DasDataSource)dataSource);
        if (file == null) {
            return null;
        }
        DbUIUtil.openInConsole(project, (DasDataSource)dataSource, file, text, o);
        return file;
    }

    public static void openInConsole(@NotNull Project project, @NotNull DasDataSource dataSource, @NotNull VirtualFile file, @NotNull String text, @Nullable DasObject o) {
        Document doc;
        if (project == null) {
            DbUIUtil.$$$reportNull$$$0(6);
        }
        if (dataSource == null) {
            DbUIUtil.$$$reportNull$$$0(7);
        }
        if (file == null) {
            DbUIUtil.$$$reportNull$$$0(8);
        }
        if (text == null) {
            DbUIUtil.$$$reportNull$$$0(9);
        }
        if ((doc = FileDocumentManager.getInstance().getDocument(file)) != null) {
            ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(project, () -> {
                int length;
                doc.insertString(length, (CharSequence)((length = doc.getTextLength()) == 0 ? text : "\n" + text));
            }, DatabaseBundle.message((String)"command.name.open.query.in.console", (Object[])new Object[0]), null));
            FileEditorManager.getInstance((Project)project).openFile(file, true);
            DatabaseEditorHelper.openConsoleForFile(project, dataSource, (DasNamespace)DasUtil.getParentOfClass((DasObject)o, DasNamespace.class, (boolean)false), file);
        }
    }

    @NotNull
    public static Notification createNotification(@NotNull DasDataSource system, @NlsContexts.NotificationContent @NotNull String content, @NotNull NotificationType type, @NotNull String displayId) {
        if (system == null) {
            DbUIUtil.$$$reportNull$$$0(10);
        }
        if (content == null) {
            DbUIUtil.$$$reportNull$$$0(11);
        }
        if (type == null) {
            DbUIUtil.$$$reportNull$$$0(12);
        }
        if (displayId == null) {
            DbUIUtil.$$$reportNull$$$0(13);
        }
        Notification notification = ConnDatabaseNotifications.DATABASE_VIEW_GROUP().createNotification(system.getName(), content, type).setDisplayId(displayId);
        if (notification == null) {
            DbUIUtil.$$$reportNull$$$0(14);
        }
        return notification;
    }

    @NotNull
    public static Notification createFileLinkNotification(@NotNull Project project, @NotNull DasDataSource system, @NlsContexts.NotificationContent @NotNull String content, @NotNull NotificationType type, @NotNull String path, @NotNull String displayId) {
        if (project == null) {
            DbUIUtil.$$$reportNull$$$0(15);
        }
        if (system == null) {
            DbUIUtil.$$$reportNull$$$0(16);
        }
        if (content == null) {
            DbUIUtil.$$$reportNull$$$0(17);
        }
        if (type == null) {
            DbUIUtil.$$$reportNull$$$0(18);
        }
        if (path == null) {
            DbUIUtil.$$$reportNull$$$0(19);
        }
        if (displayId == null) {
            DbUIUtil.$$$reportNull$$$0(20);
        }
        return DbUIUtil.createFileLinkNotification(project, system.getName(), content, type, path, displayId);
    }

    @NotNull
    public static Notification createFileLinkNotification(@NotNull Project project, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String content, @NotNull NotificationType type, @NotNull String path, @NotNull String displayId) {
        if (project == null) {
            DbUIUtil.$$$reportNull$$$0(21);
        }
        if (title == null) {
            DbUIUtil.$$$reportNull$$$0(22);
        }
        if (content == null) {
            DbUIUtil.$$$reportNull$$$0(23);
        }
        if (type == null) {
            DbUIUtil.$$$reportNull$$$0(24);
        }
        if (path == null) {
            DbUIUtil.$$$reportNull$$$0(25);
        }
        if (displayId == null) {
            DbUIUtil.$$$reportNull$$$0(26);
        }
        Notification notification = ConnDatabaseNotifications.DATABASE_VIEW_GROUP().createNotification(title, GridUtil.getContent((String)content, (String)path), type).setDisplayId(displayId).setListener((NotificationListener)new GridUtil.FileNotificationListener(project, path));
        if (notification == null) {
            DbUIUtil.$$$reportNull$$$0(27);
        }
        return notification;
    }

    @NotNull
    public static ConsoleView addConsole(@NotNull Project project, @NlsContexts.TabTitle @NotNull String taskName, final @NotNull BooleanGetter canRerun, final @NotNull Runnable rerunRunnable, final @NotNull AtomicReference<ProgressIndicator> indicatorRef) {
        if (project == null) {
            DbUIUtil.$$$reportNull$$$0(28);
        }
        if (taskName == null) {
            DbUIUtil.$$$reportNull$$$0(29);
        }
        if (canRerun == null) {
            DbUIUtil.$$$reportNull$$$0(30);
        }
        if (rerunRunnable == null) {
            DbUIUtil.$$$reportNull$$$0(31);
        }
        if (indicatorRef == null) {
            DbUIUtil.$$$reportNull$$$0(32);
        }
        final ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        JPanel consoleComponent = new JPanel(new BorderLayout());
        consoleComponent.add((Component)consoleView.getComponent(), "Center");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("RunnerToolbar", (ActionGroup)toolbarActions, false);
        toolbar.setTargetComponent(consoleView.getComponent());
        consoleComponent.add((Component)toolbar.getComponent(), "West");
        RunContentDescriptor descriptor2 = new RunContentDescriptor((ExecutionConsole)consoleView, null, consoleComponent, taskName){

            public boolean isContentReuseProhibited() {
                ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                return indicator != null && indicator.isRunning();
            }
        };
        Disposer.register((Disposable)consoleView, (Disposable)new Disposable(){

            public void dispose() {
                ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                if (indicator != null && indicator.isRunning()) {
                    indicator.cancel();
                }
            }
        });
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        toolbarActions.add((AnAction)new DumbAwareAction(DatabaseBundle.messagePointer((String)"action.DbUIUtil.run.dashboard.rerun.action.name.text", (Object[])new Object[0]), AllIcons.Actions.Rerun){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    3.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                ProgressIndicator indicator;
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                boolean enabled = ((indicator = (ProgressIndicator)indicatorRef.get()) == null || !indicator.isRunning()) && canRerun.get();
                e.getPresentation().setEnabled(enabled);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(2);
                }
                consoleView.clear();
                rerunRunnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/util/DbUIUtil$3";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/util/DbUIUtil$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        });
        toolbarActions.add((AnAction)new DumbAwareAction(DatabaseBundle.messagePointer((String)"action.DbUIUtil.stop.text", (Object[])new Object[0]), AllIcons.Actions.Suspend){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    4.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                e.getPresentation().setEnabled(indicator != null && indicator.isRunning());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                ProgressIndicator indicator;
                if (e == null) {
                    4.$$$reportNull$$$0(2);
                }
                if ((indicator = (ProgressIndicator)indicatorRef.get()) != null && indicator.isRunning()) {
                    indicator.cancel();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/util/DbUIUtil$4";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/util/DbUIUtil$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        });
        toolbarActions.addSeparator();
        JdbcConsoleUtil.addLeftToolbarConsoleActions(toolbarActions, consoleView);
        toolbarActions.addSeparator();
        toolbarActions.add(ActionManager.getInstance().getAction("PinActiveTab"));
        toolbarActions.add((AnAction)new CloseAction(executor, descriptor2, project));
        RunContentManager.getInstance((Project)project).showRunContent(executor, descriptor2);
        ConsoleView consoleView2 = consoleView;
        if (consoleView2 == null) {
            DbUIUtil.$$$reportNull$$$0(33);
        }
        return consoleView2;
    }

    public static void showPopup(@NotNull JBPopup popup2, @Nullable Editor editor2, @Nullable AnActionEvent event) {
        Object eventSource;
        if (popup2 == null) {
            DbUIUtil.$$$reportNull$$$0(34);
        }
        InputEvent inputEvent = event == null ? null : event.getInputEvent();
        Object object = eventSource = inputEvent == null ? null : inputEvent.getSource();
        if (editor2 != null && editor2.getComponent().isShowing()) {
            popup2.showInBestPositionFor(editor2);
        } else if (event != null) {
            if (eventSource instanceof InplaceButton || eventSource instanceof ActionButton) {
                popup2.setMinimumSize(((JComponent)eventSource).getSize());
                popup2.showUnderneathOf((Component)eventSource);
            } else {
                popup2.showInBestPositionFor(event.getDataContext());
            }
        }
    }

    @NotNull
    public static JComponent createActionComponent(AnAction action, JComponent target) {
        return DbUIUtil.createToolbar(new DefaultActionGroup(new AnAction[]{action}), target);
    }

    @NotNull
    public static JComponent createToolbar(DefaultActionGroup group, JComponent target) {
        ActionManager manager = ActionManager.getInstance();
        ActionToolbar toolbar = manager.createActionToolbar("toolbar", (ActionGroup)group, true);
        toolbar.setTargetComponent(target);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
        toolbar.getComponent().setBorder((Border)JBUI.Borders.empty());
        JComponent jComponent = toolbar.getComponent();
        if (jComponent == null) {
            DbUIUtil.$$$reportNull$$$0(35);
        }
        return jComponent;
    }

    public static void initLanguageComboBox(JComboBox<Language> comboBox, boolean allowNull) {
        ArrayList<Language> languages = new ArrayList<Language>();
        if (allowNull) {
            languages.add(null);
        }
        languages.addAll(SqlDialects.getTopLevelSqlDialects());
        Language mongo = DbSqlUtil.getLanguage(Dbms.MONGO);
        if (DbSqlUtilCore.getDbms((Language)mongo) == Dbms.MONGO) {
            languages.add(mongo);
        }
        comboBox.setModel((ComboBoxModel<Language>)new CollectionComboBoxModel(languages));
        comboBox.setEditable(false);
        comboBox.setRenderer((ListCellRenderer<Language>)SimpleListCellRenderer.create((label, language, index) -> {
            if (language == null) {
                label.setText(DatabaseBundle.message((String)"label.default", (Object[])new Object[0]));
                label.setIcon(null);
            } else {
                if (language instanceof SqlLanguageDialect) {
                    label.setIcon(((SqlLanguageDialect)language).getIcon());
                } else {
                    LanguageFileType fileType = language.getAssociatedFileType();
                    label.setIcon(fileType == null ? null : fileType.getIcon());
                }
                label.setText(language.getDisplayName());
            }
        }));
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            DbUIUtil.$$$reportNull$$$0(36);
        }
        AppUIUtil.invokeOnEdt((Runnable)runnable);
    }

    public static void invokeLater(@NotNull Runnable runnable) {
        if (runnable == null) {
            DbUIUtil.$$$reportNull$$$0(37);
        }
        SwingUtilities.invokeLater(runnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 27, 33, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 11: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 12: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayId";
                break;
            }
            case 14: 
            case 27: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbUIUtil";
                break;
            }
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canRerun";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rerunRunnable";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicatorRef";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbUIUtil";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileLinkNotification";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "addConsole";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configureDataSourceComboBox";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "openInConsole";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 14: 
            case 27: 
            case 33: 
            case 35: {
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createFileLinkNotification";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addConsole";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 27, 33, 35 -> new IllegalStateException(string);
        };
    }
}

