/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.DatabaseVirtualFileSystem;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.AbstractPsiBasedNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbFavoriteNodeProvider
extends FavoriteNodeProvider {
    private final Project myProject;

    public DbFavoriteNodeProvider(Project project) {
        this.myProject = project;
    }

    @Nullable
    public Collection<AbstractTreeNode<?>> getFavoriteNodes(DataContext context, @NotNull ViewSettings viewSettings) {
        Project project;
        PsiElement[] psiElements;
        if (viewSettings == null) {
            DbFavoriteNodeProvider.$$$reportNull$$$0(0);
        }
        PsiElement[] psiElementArray = psiElements = (project = (Project)CommonDataKeys.PROJECT.getData(context)) == null ? null : (PsiElement[])PlatformCoreDataKeys.PSI_ELEMENT_ARRAY.getData(context);
        if (psiElements == null) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        for (PsiElement psi : psiElements) {
            AbstractTreeNode<?> node = this.createNode(project, psi, viewSettings);
            if (node == null) continue;
            result.add(node);
        }
        return result;
    }

    @Nullable
    public AbstractTreeNode<?> createNode(Project project, Object element, @NotNull ViewSettings viewSettings) {
        NodeDesc desc;
        if (viewSettings == null) {
            DbFavoriteNodeProvider.$$$reportNull$$$0(1);
        }
        return (desc = this.getNodeDesc(element)) == null ? null : new DbElementNode(project, desc, viewSettings);
    }

    @Nullable
    private DbElement getDbElement(Object element) {
        if (element instanceof NodeDesc) {
            return DbFavoriteNodeProvider.getDbElement(this.myProject, (NodeDesc)element);
        }
        return DbNavigationUtils.extractDbElement((Navigatable)ObjectUtils.tryCast((Object)element, Navigatable.class));
    }

    @Nullable
    private NodeDesc getNodeDesc(Object element) {
        if (element instanceof NodeDesc) {
            return (NodeDesc)element;
        }
        DbElement dbElement = this.getDbElement(element);
        if (dbElement == null) {
            return null;
        }
        DbDataSource dataSource = dbElement.getDataSource();
        DasObject o = (DasObject)ObjectUtils.tryCast((Object)dbElement.getDelegate(), DasObject.class);
        if (dbElement != dataSource && o == null) {
            return null;
        }
        ObjectPath path = ObjectPaths.of((DasObject)o);
        return new NodeDesc(dataSource.getUniqueId(), path);
    }

    public boolean elementContainsFile(Object element, VirtualFile vFile) {
        return false;
    }

    public int getElementWeight(Object element, boolean isSortByType) {
        return 0;
    }

    @Nullable
    public String getElementLocation(Object element) {
        DbElement dbElement = this.getDbElement(element);
        ItemPresentation presentation = dbElement == null ? null : dbElement.getPresentation();
        return presentation == null ? null : presentation.getLocationString();
    }

    public boolean isInvalidElement(Object element) {
        DbElement dbElement = this.getDbElement(element);
        return dbElement != null && !dbElement.isValid();
    }

    @NotNull
    public String getFavoriteTypeId() {
        return "database";
    }

    @Nullable
    public String getElementUrl(Object element) {
        NodeDesc desc = this.getNodeDesc(element);
        return desc == null ? null : DatabaseElementVirtualFileImpl.getUrl((String)desc.dataSourceId, (ObjectPath)desc.path, null, (boolean)true);
    }

    @Nullable
    public String getElementModuleName(Object element) {
        DbElement dbElement = this.getDbElement(element);
        SqlElement sql = dbElement != null ? (SqlElement)ObjectUtils.tryCast((Object)DbSqlUtil.getSqlSourceElement(dbElement), SqlElement.class) : null;
        Module module = sql == null ? null : ModuleUtilCore.findModuleForPsiElement((PsiElement)sql);
        return module != null && !ModuleType.isInternal((Module)module) ? module.getName() : null;
    }

    public Object @Nullable [] createPathFromUrl(Project project, String url, String moduleName) {
        Object[] objectArray;
        DatabaseVirtualFileSystem.FileDesc parsed = DatabaseVirtualFileSystem.parseUrl((String)url);
        if (parsed != null && parsed.family == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = new NodeDesc(parsed.dataSourceId, parsed.path);
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    @Nullable
    public PsiElement getPsiElement(Object element) {
        return this.getDbElement(element);
    }

    @Nullable
    private static DbElement getDbElement(@NotNull Project project, @Nullable NodeDesc value) {
        if (project == null) {
            DbFavoriteNodeProvider.$$$reportNull$$$0(2);
        }
        if (value == null) {
            return null;
        }
        DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(value.dataSourceId);
        if (dataSource == null) {
            return null;
        }
        return value.path == null ? dataSource : dataSource.findElement(value.path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/psi/DbFavoriteNodeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFavoriteNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDbElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class NodeDesc {
        @NotNull
        final String dataSourceId;
        @Nullable
        final ObjectPath path;

        private NodeDesc(@NotNull String dataSourceId, @Nullable ObjectPath path) {
            if (dataSourceId == null) {
                NodeDesc.$$$reportNull$$$0(0);
            }
            this.dataSourceId = dataSourceId;
            this.path = path;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/psi/DbFavoriteNodeProvider$NodeDesc", "<init>"));
        }
    }

    public static class DbElementNode
    extends AbstractPsiBasedNode<NodeDesc> {
        public DbElementNode(@NotNull Project project, @NotNull NodeDesc value, ViewSettings settings) {
            if (project == null) {
                DbElementNode.$$$reportNull$$$0(0);
            }
            if (value == null) {
                DbElementNode.$$$reportNull$$$0(1);
            }
            super(project, (Object)value, settings);
        }

        @Nullable
        protected PsiElement extractPsiFromValue() {
            return this.getDbElement();
        }

        @Nullable
        private DbElement getDbElement() {
            return DbFavoriteNodeProvider.getDbElement(Objects.requireNonNull(this.getProject()), (NodeDesc)this.getValue());
        }

        @Nullable
        public NavigationItem getNavigationItem() {
            DbElement element = this.getDbElement();
            return element == null ? null : DbNavigationUtils.createFromTreeNavigatable(element);
        }

        public void navigate(boolean requestFocus, boolean preserveState) {
            NavigationItem item = this.getNavigationItem();
            if (item != null && item.canNavigate()) {
                item.navigate(requestFocus);
            }
        }

        @Nullable
        protected Collection<AbstractTreeNode<?>> getChildrenImpl() {
            return null;
        }

        protected void updateImpl(@NotNull PresentationData presentation) {
            DbElement element;
            if (presentation == null) {
                DbElementNode.$$$reportNull$$$0(2);
            }
            if ((element = this.getDbElement()) == null) {
                return;
            }
            ItemPresentation dbPresentation = element.getPresentation();
            if (dbPresentation == null) {
                return;
            }
            presentation.setPresentableText(dbPresentation.getPresentableText());
            presentation.setIcon(dbPresentation.getIcon(false));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/psi/DbFavoriteNodeProvider$DbElementNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

