/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.migration;

import com.intellij.database.model.migration.DbMigrationDialog;
import com.intellij.database.model.migration.DbMigrationTreeModel;
import com.intellij.database.model.migration.DiffStatus;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fJ\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0018\u00010\u0010R\u00020\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/model/migration/DbDdlDiffPanel;", "", "project", "Lcom/intellij/openapi/project/Project;", "migrationDialog", "Lcom/intellij/database/model/migration/DbMigrationDialog;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/migration/DbMigrationDialog;)V", "processor", "Lcom/intellij/database/model/migration/DbDdlDiffPanel$DdlRequestProcessor;", "getComponent", "Ljavax/swing/JComponent;", "Lorg/jetbrains/annotations/NotNull;", "updateRequest", "", "node", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "DdlRequestProcessor", "intellij.database.impl"})
public final class DbDdlDiffPanel {
    @NotNull
    private final DdlRequestProcessor processor;

    public DbDdlDiffPanel(@NotNull Project project, @NotNull DbMigrationDialog migrationDialog) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)migrationDialog), (String)"migrationDialog");
        this.processor = new DdlRequestProcessor(project);
        Disposer.register((Disposable)migrationDialog.getDisposable(), (Disposable)((Disposable)this.processor));
        this.processor.updateRequest();
    }

    @NotNull
    public final JComponent getComponent() {
        JComponent jComponent = this.processor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"<get-component>(...)");
        return jComponent;
    }

    public final void updateRequest(@Nullable DbMigrationTreeModel.Node node) {
        this.processor.setCurrentRequest(node != null && node.isBasicElementNode() ? node : null);
        this.processor.updateRequest(true);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\u0010\u000f\u001a\u00060\u0002R\u00020\u0003H\u0014J\u000e\u0010\u0010\u001a\b\u0018\u00010\u0002R\u00020\u0003H\u0014J\u001c\u0010\u0011\u001a\u00020\u00122\n\u0010\u000f\u001a\u00060\u0002R\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\"\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\n\u0010\u000f\u001a\u00060\u0002R\u00020\u0003H\u0002R \u0010\b\u001a\b\u0018\u00010\u0002R\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/model/migration/DbDdlDiffPanel$DdlRequestProcessor;", "Lcom/intellij/diff/impl/CacheDiffRequestProcessor;", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "currentRequest", "getCurrentRequest", "()Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "setCurrentRequest", "(Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;)V", "getRequestName", "", "provider", "getCurrentRequestProvider", "loadRequest", "Lcom/intellij/diff/requests/DiffRequest;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getDiffContents", "Lkotlin/Pair;", "Lcom/intellij/diff/contents/DiffContent;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbDdlDiffPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbDdlDiffPanel.kt\ncom/intellij/database/model/migration/DbDdlDiffPanel$DdlRequestProcessor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,61:1\n24#2:62\n*S KotlinDebug\n*F\n+ 1 DbDdlDiffPanel.kt\ncom/intellij/database/model/migration/DbDdlDiffPanel$DdlRequestProcessor\n*L\n43#1:62\n*E\n"})
    public static final class DdlRequestProcessor
    extends CacheDiffRequestProcessor<DbMigrationTreeModel.Node> {
        @Nullable
        private DbMigrationTreeModel.Node currentRequest;

        public DdlRequestProcessor(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project, "External");
        }

        @Nullable
        public final DbMigrationTreeModel.Node getCurrentRequest() {
            return this.currentRequest;
        }

        public final void setCurrentRequest(@Nullable DbMigrationTreeModel.Node node) {
            this.currentRequest = node;
        }

        @Nullable
        protected String getRequestName(@NotNull DbMigrationTreeModel.Node provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            return null;
        }

        @Nullable
        protected DbMigrationTreeModel.Node getCurrentRequestProvider() {
            return this.currentRequest;
        }

        @NotNull
        protected DiffRequest loadRequest(@NotNull DbMigrationTreeModel.Node provider, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Pair<DiffContent, DiffContent> contents = this.getDiffContents(provider);
            if (contents == null) {
                DdlRequestProcessor $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(DdlRequestProcessor.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Requesting DDL diff for node with no content");
                return (DiffRequest)new NoDiffRequest();
            }
            return (DiffRequest)new SimpleDiffRequest(null, (DiffContent)contents.getFirst(), (DiffContent)contents.getSecond(), null, null);
        }

        private final Pair<DiffContent, DiffContent> getDiffContents(DbMigrationTreeModel.Node provider) {
            Project project = this.getProject();
            Intrinsics.checkNotNull((Object)project);
            DiffContent origin = provider.getContent(project, DbMigrationTreeModel.Side.ORIGIN);
            Project project2 = this.getProject();
            Intrinsics.checkNotNull((Object)project2);
            DiffContent target = provider.getContent(project2, DbMigrationTreeModel.Side.TARGET);
            DiffStatus diffStatus = provider.getStatus();
            return switch (diffStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[diffStatus.ordinal()]) {
                case 1, 2 -> new Pair((Object)target, (Object)origin);
                case 3, 4 -> new Pair((Object)origin, (Object)target);
                case -1 -> null;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DiffStatus.values().length];
                try {
                    nArray[DiffStatus.ADDED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DiffStatus.DELETED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DiffStatus.SAME.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DiffStatus.MODIFIED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

