/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.vfs.DbStorageFileType;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.SelectInDatabaseView;
import com.intellij.ide.SelectInContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbElementSelectInProvider
implements SelectInDatabaseView.Extension {
    @Override
    @Nullable
    public PsiElement findTarget(@NotNull SelectInContext context, boolean strict, boolean fast) {
        VirtualFile file;
        if (context == null) {
            DbElementSelectInProvider.$$$reportNull$$$0(0);
        }
        if (DbImplUtil.isDatabaseVirtualFile(file = context.getVirtualFile())) {
            DbElement dbElement = DbImplUtilCore.findElement((Project)context.getProject(), (VirtualFile)file);
            Object selector = context.getSelectorInFile();
            JBIterable<DasObject> objects = selector instanceof PsiElement ? DbNavigationUtils.unwrapElements((PsiElement)selector) : null;
            PsiElement element = objects == null ? null : (PsiElement)objects.filter(PsiElement.class).first();
            return strict ? element : (PsiElement)ObjectUtils.chooseNotNull((Object)element, (Object)dbElement);
        }
        if (DbVFSUtils.isConsoleFile((VirtualFile)file)) {
            return strict ? null : DbVFSUtils.getDataSource((Project)context.getProject(), (VirtualFile)file);
        }
        if (file.getFileType() instanceof DbStorageFileType) {
            DbDataSource existing2 = DbImplUtil.findDataSourceByFile(context.getProject(), file);
            return existing2 != null ? existing2 : PsiUtilCore.NULL_PSI_ELEMENT;
        }
        if (!strict) {
            Project project = context.getProject();
            JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, file);
            return console != null ? DbPsiFacade.getInstance((Project)project).findDataSource(console.getDataSource().getUniqueId()) : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/editor/DbElementSelectInProvider", "findTarget"));
    }
}

