/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2.types;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.types.DasTypeSystemImpl;
import com.intellij.database.dialects.h2.types.H2TypeSystemKt;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/h2/types/H2TypeSystem;", "Lcom/intellij/database/dialects/base/types/DasTypeSystemImpl;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getNormalizedTypeName", "", "name", "getDefaultTypeName", "cat", "Lcom/intellij/database/types/DasTypeCategory;", "getDasType", "Lcom/intellij/database/types/DasType;", "ref", "Lcom/intellij/sql/psi/SqlReference;", "resolved", "Lcom/intellij/psi/PsiElement;", "symbol", "Lcom/intellij/database/symbols/DasSymbol;", "intellij.database.dialects.h2"})
public final class H2TypeSystem
extends DasTypeSystemImpl {
    public H2TypeSystem(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return switch (super.getNormalizedTypeName(name2)) {
            case "INT2" -> "SMALLINT";
            case "MEDIUMINT" -> "INTEGER";
            case "INT4" -> "INTEGER";
            case "SIGNED" -> "INTEGER";
            case "BIT" -> "BOOLEAN";
            case "BOOL" -> "BOOLEAN";
            case "INT8" -> "BIGINT";
            case "YEAR" -> "SMALLINT";
            case "INT" -> "INTEGER";
            case "IDENTITY" -> "BIGINT";
            case "DEC" -> "DECIMAL";
            case "NUMERIC" -> "DECIMAL";
            case "NUMBER" -> "DECIMAL";
            case "DOUBLE PRECISION" -> "DOUBLE";
            case "FLOAT4" -> "REAL";
            case "FLOAT8" -> "DOUBLE";
            case "FLOAT" -> "DOUBLE";
            case "DATETIME" -> "TIMESTAMP";
            case "SMALLDATETIME" -> "TIMESTAMP";
            case "BINARY" -> "VARBINARY";
            case "LONGVARBINARY" -> "VARBINARY";
            case "RAW" -> "VARBINARY";
            case "BYTEA" -> "VARBINARY";
            case "VARCHAR2" -> "VARCHAR";
            case "LONGVARCHAR" -> "VARCHAR";
            case "VARCHAR_CASESENSITIVE" -> "VARCHAR";
            case "NVARCHAR2" -> "VARCHAR";
            case "NVARCHAR" -> "VARCHAR";
            case "CHARACTER" -> "CHAR";
            case "NCHAR" -> "CHAR";
            case "TINYBLOB" -> "BLOB";
            case "MEDIUMBLOB" -> "BLOB";
            case "LONGBLOB" -> "BLOB";
            case "IMAGE" -> "BLOB";
            case "OID" -> "BLOB";
            case "TINYTEXT" -> "CLOB";
            case "TEXT" -> "CLOB";
            case "MEDIUMTEXT" -> "CLOB";
            case "LONGTEXT" -> "CLOB";
            case "NTEXT" -> "CLOB";
            case "NCLOB" -> "CLOB";
            default -> {
                void var2_2;
                yield var2_2;
            }
        };
    }

    @Nullable
    public String getDefaultTypeName(@NotNull DasTypeCategory cat) {
        Intrinsics.checkNotNullParameter((Object)cat, (String)"cat");
        return switch (WhenMappings.$EnumSwitchMapping$0[cat.ordinal()]) {
            case 1 -> "integer";
            case 2 -> "decimal";
            case 3 -> "varchar";
            case 4 -> "boolean";
            case 5 -> "datetime";
            case 6 -> "date";
            case 7 -> "time";
            case 8 -> "timestamp";
            case 9 -> "interval";
            case 10 -> "blob";
            default -> null;
        };
    }

    @NotNull
    public DasType getDasType(@Nullable SqlReference ref2, @Nullable PsiElement resolved, @Nullable DasSymbol symbol) {
        DasType qualifierType;
        SqlReference sqlReference = ref2;
        PsiElement psiElement = sqlReference != null ? sqlReference.getQualifier() : null;
        SqlExpression sqlExpression = psiElement instanceof SqlExpression ? (SqlExpression)psiElement : null;
        Object object = qualifierType = sqlExpression != null ? sqlExpression.getDasType() : null;
        if (qualifierType != null && H2TypeSystemKt.isJson(qualifierType)) {
            return qualifierType;
        }
        return super.getDasType(ref2, resolved, symbol);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DasTypeCategory.values().length];
            try {
                nArray[DasTypeCategory.INTEGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.REAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BOOLEAN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE_TIME.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIME.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIMESTAMP.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.INTERVAL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BYTES.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

