/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.exasol;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.EitherKt;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactory;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.AbstractDefinitionProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.util.PairConsumer;
import org.jetbrains.annotations.NotNull;

public final class ExaDefinitionProvider
extends AbstractDefinitionProvider {
    private static final String VIEW_STMT = "SELECT VIEW_TEXT FROM SYS.EXA_ALL_VIEWS WHERE VIEW_NAME = ? AND VIEW_SCHEMA = ?";
    private static final String FUNCTION_STMT = "SELECT 'CREATE ' || FUNCTION_TEXT FROM SYS.EXA_ALL_FUNCTIONS WHERE FUNCTION_NAME = ? AND FUNCTION_SCHEMA = ?";
    private static final String SCRIPT_STMT = "SELECT SCRIPT_TEXT FROM SYS.EXA_ALL_SCRIPTS WHERE SCRIPT_NAME = ? AND SCRIPT_SCHEMA = ?";

    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            ExaDefinitionProvider.$$$reportNull$$$0(0);
        }
        return (kind = object.getKind()) == ObjectKind.VIEW || kind == ObjectKind.ROUTINE || kind == ObjectKind.SCRIPT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnectionCore connection2, @NotNull PairConsumer<DasObject, Object> consumer) {
        if (objects == null) {
            ExaDefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection2 == null) {
            ExaDefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            ExaDefinitionProvider.$$$reportNull$$$0(3);
        }
        ReusableSmartStatement viewStmt = null;
        ReusableSmartStatement functionStmt = null;
        ReusableSmartStatement scriptStmt = null;
        try {
            SmartStatementFactory statements2 = SmartStatementFactoryService.getInstance().poweredBy(connection2);
            viewStmt = statements2.parameterized().reuse(VIEW_STMT);
            functionStmt = statements2.parameterized().reuse(FUNCTION_STMT);
            scriptStmt = statements2.parameterized().reuse(SCRIPT_STMT);
            for (DasObject dasObject : objects) {
                ReusableSmartStatement statement2;
                ObjectKind kind = dasObject.getKind();
                if (kind == ObjectKind.VIEW) {
                    ReusableSmartStatement statement22 = viewStmt;
                } else if (kind == ObjectKind.ROUTINE) {
                    statement2 = functionStmt;
                } else {
                    if (kind != ObjectKind.SCRIPT) continue;
                    statement2 = scriptStmt;
                }
                consumer.consume((Object)dasObject, EitherKt.any((Either)statement2.execute((Object)new StatementParameters().text(DasUtil.getName((DasObject)dasObject)).text(DasUtil.getSchema((DasObject)dasObject)).asDecoration(), StandardResultsProcessors.FIRST_STRING)));
            }
        }
        catch (Throwable throwable) {
            DbImplUtilCore.closeSafe(viewStmt);
            DbImplUtilCore.closeSafe(functionStmt);
            DbImplUtilCore.closeSafe(scriptStmt);
            throw throwable;
        }
        DbImplUtilCore.closeSafe((AutoCloseable)viewStmt);
        DbImplUtilCore.closeSafe((AutoCloseable)functionStmt);
        DbImplUtilCore.closeSafe((AutoCloseable)scriptStmt);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/exasol/ExaDefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

