/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.util.Version;
import com.intellij.database.util.VersionRange;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class CassDomains
extends BaseDomainRegistry {
    private static final VersionRange CASS_2_2 = VersionRange.after((Version)Version.of((int[])new int[]{2, 2}));
    private static final VersionRange CASS_3_10 = VersionRange.after((Version)Version.of((int[])new int[]{3, 10}));

    public CassDomains() {
        this.add((Domain)new TextDomain("ascii", ConversionPoint.TEXT, Integer.MAX_VALUE){

            @NotNull
            public Compatibility getCompatibility(@NotNull Domain domain) {
                if (domain == null) {
                    1.$$$reportNull$$$0(0);
                }
                Compatibility compatibility = StringUtil.equalsIgnoreCase((CharSequence)this.simpleName(), (CharSequence)domain.simpleName()) ? super.getCompatibility(domain) : Compatibility.incompatible();
                if (compatibility == null) {
                    1.$$$reportNull$$$0(1);
                }
                return compatibility;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "domain";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/cassandra/CassDomains$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/cassandra/CassDomains$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCompatibility";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getCompatibility";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        this.add((Domain)new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new BinaryDomain("blob", ConversionPoint.BLOB, Integer.MAX_VALUE, Integer.MAX_VALUE, false, true));
        this.add((Domain)new BooleanDomain("boolean", ConversionPoint.BOOLEAN));
        this.add((Domain)new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, Integer.MAX_VALUE, Integer.MAX_VALUE, false));
        this.add((Domain)new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add((Domain)new IntegerDomain("counter", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add((Domain)new SimpleDomain("inet", ConversionPoint.INET));
        this.add((Domain)new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new TextDomain("text", ConversionPoint.TEXT, Integer.MAX_VALUE).withAliases(new String[]{"varchar"}));
        this.add((Domain)new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, 6));
        this.add((Domain)new SimpleDomain("uuid", ConversionPoint.UUID_TEXT));
        this.add((Domain)new SimpleDomain("timeuuid", ConversionPoint.UUID_TEXT));
        this.add((Domain)new IntegerDomain("varint", ConversionPoint.BIG_DECIMAL, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new SimpleDomain("date", ConversionPoint.DATE).withVersionRange(CASS_2_2));
        this.add(new FractionDomain("time", ConversionPoint.TIME, 0, -1, false).withVersionRange(CASS_2_2));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0).withVersionRange(CASS_2_2));
        this.add(new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0).withVersionRange(CASS_2_2));
        this.add(new SimpleDomain("duration", ConversionPoint.INTERVAL).withVersionRange(CASS_3_10));
    }
}

