/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.DatabaseDriverUtils;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactLoader;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.FixWithProgress;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.Version;
import com.intellij.database.view.ui.ActualConfigInfoProvider;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.net.IOExceptionDialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseDriverValidator
extends DatabaseConfigValidator<DatabaseDriverImpl> {
    private static final Logger LOG = Logger.getInstance(DatabaseDriverValidator.class);
    public static final String INVALID_FILES = "INVALID_FILES";

    @Override
    public Class<DatabaseDriverImpl> getTargetClass() {
        return DatabaseDriverImpl.class;
    }

    @Override
    public void collectProblems(@NotNull Project project, @NotNull DatabaseDriverImpl driver, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable ActualConfigInfoProvider configInfoProvider) {
        if (project == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(0);
        }
        if (driver == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(1);
        }
        if (problems == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(2);
        }
        if (!driver.getTemplatesErrors().isEmpty()) {
            StringBuilder msg = new StringBuilder();
            for (Pair<UrlTemplate, String> pair : driver.getTemplatesErrors()) {
                msg.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;");
                msg.append(StringUtil.escapeXmlEntities((String)((UrlTemplate)pair.getFirst()).getName())).append(" &mdash; ").append(StringUtil.escapeXmlEntities((String)((String)pair.getSecond())));
            }
            @NlsSafe String shortDesc = msg.toString();
            String longDesc = DatabaseBundle.message((String)"driver.a.href.action0.0.a.has.invalid.templates.1", (Object[])new Object[]{StringUtil.escapeXmlEntities((String)driver.getFullName()), shortDesc});
            problems.consume((Object)new DataSourceProblem((Object)driver, null, DataSourceProblem.Level.WARNING, new DataSourceProblem.HyperText(DatabaseBundle.message((String)"notification.title.invalid.template", (Object[])new Object[0]), shortDesc, longDesc, new DataSourceProblem.Navigate((Object)driver)), null));
        }
    }

    public static void findDriverLanguageProblem(final @Nullable DatabaseDriver driver, @NotNull Consumer<? super DataSourceProblem> problems, @NotNull LocalDataSource dataSource) {
        if (problems == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(3);
        }
        if (dataSource == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(4);
        }
        if (driver == null) {
            return;
        }
        Language current = DbSqlUtilCore.getLanguage((LocalDataSource)dataSource);
        final Language best = DbSqlUtil.getLanguage(dataSource.getDbms());
        if (best instanceof SqlLanguageDialect) {
            Dbms bestDbms = ((SqlLanguageDialect)best).getDbms();
            if (bestDbms == Dbms.UNKNOWN) {
                return;
            }
            if (current instanceof SqlLanguageDialect && ((SqlLanguageDialect)current).getDbms() == bestDbms) {
                return;
            }
        }
        if (current == best) {
            return;
        }
        FixWithProgress fix = new FixWithProgress(DatabaseBundle.message((String)"progress.title.use.language", (Object[])new Object[]{best.getDisplayName()})){

            @Override
            public void run(@NotNull ProgressIndicator indicator, @Nullable DatabaseConfigEditor editor2) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (editor2 == null) {
                    this.fix((DatabaseDriverImpl)driver);
                } else {
                    ApplicationManager.getApplication().invokeAndWait(() -> {
                        DatabaseDriverConfigurable configurable = editor2.getConfigurable(driver, true, DatabaseDriverConfigurable.class);
                        if (configurable != null) {
                            DataSourceUiUtil.modify((Consumer<? super DatabaseDriverImpl>)((Consumer)this::fix), configurable);
                        }
                    });
                }
            }

            void fix(DatabaseDriverImpl dr) {
                dr.setSqlDialect(best.getID());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/validation/DatabaseDriverValidator$1", "run"));
            }
        };
        String desc = DatabaseBundle.message((String)"notification.content.it.recommended.to.use.dialect.instead", (Object[])new Object[]{best.getDisplayName(), current.getDisplayName()});
        DataSourceProblem.HyperText text = new DataSourceProblem.HyperText(DatabaseBundle.message((String)"notification.title.inconsistent.language", (Object[])new Object[0]), desc + " " + String.valueOf(HtmlChunk.link((String)"$ACTION0", (String)fix.getName())), desc, fix);
        problems.consume((Object)new DataSourceProblem(dataSource, null, DataSourceProblem.Level.WARNING, text, fix));
    }

    public static void findDriverFilesProblems(@Nullable DatabaseDriver driver, @NotNull Consumer<? super DataSourceProblem> problems, @NotNull LocalDataSource dataSource) {
        if (problems == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(5);
        }
        if (dataSource == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(6);
        }
        if (driver == null) {
            return;
        }
        List artifacts = driver.getArtifacts();
        ArrayList<DataSourceProblem> tmpProblems = new ArrayList<DataSourceProblem>();
        for (DatabaseDriver.ArtifactRef artifact : artifacts) {
            DatabaseDriverValidator.findArtifactProblems(driver, (Consumer<? super DataSourceProblem>)((Consumer)tmpProblems::add), dataSource, artifact);
        }
        if (tmpProblems.size() > 1) {
            final ArrayList<FixWithProgress> tasks = new ArrayList<FixWithProgress>();
            Iterator it = tmpProblems.iterator();
            while (it.hasNext()) {
                DataSourceProblem problem = (DataSourceProblem)it.next();
                if (problem.getId() != INVALID_FILES) continue;
                tasks.add(problem.getFix());
                it.remove();
            }
            if (!tasks.isEmpty()) {
                FixWithProgress fix = new FixWithProgress(((FixWithProgress)tasks.get(0)).getName()){

                    @Override
                    public void run(@NotNull ProgressIndicator indicator, @Nullable DatabaseConfigEditor editor2) {
                        if (indicator == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        for (FixWithProgress task : tasks) {
                            task.run(indicator, editor2);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/validation/DatabaseDriverValidator$2", "run"));
                    }
                };
                String desc = DatabaseBundle.message((String)"notification.content.href.action0.download.missing.driver.files", (Object[])new Object[0]);
                tmpProblems.add(new DataSourceProblem(driver, INVALID_FILES, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText("", desc, desc, fix), fix));
            }
        }
        for (DataSourceProblem problem : tmpProblems) {
            problems.consume((Object)problem);
        }
    }

    private static void findArtifactProblems(final @NotNull DatabaseDriver driver, @NotNull Consumer<? super DataSourceProblem> problems, @NotNull LocalDataSource dataSource, DatabaseDriver.ArtifactRef artifact) {
        if (driver == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(7);
        }
        if (problems == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(8);
        }
        if (dataSource == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(9);
        }
        @NlsSafe String driverName = StringUtil.escapeXmlEntities((String)driver.getName());
        List curClassPath = ContainerUtil.concat(DatabaseDriverImpl.getLegacyElements(artifact), (List)driver.getAdditionalClasspathElements());
        DatabaseArtifactList artifactList = DatabaseArtifactManager.getArtifacts();
        boolean needDownload = !DatabaseDriverUtils.isDriverFilesValid((DatabaseArtifactList)artifactList, (String)artifact.getId(), (Version)artifact.getArtifactVersion(), (Collection)curClassPath);
        DataSourceProblem.Navigate navigate = new DataSourceProblem.Navigate(driver);
        final DatabaseArtifactList.ArtifactVersion actualVersion = DatabaseArtifactManager.resolveVersion((DatabaseDriver)driver, (DatabaseDriver.ArtifactRef)artifact);
        String actualVersionStr = actualVersion == null ? null : actualVersion.version.toString();
        boolean currentUpToDate = DatabaseDriverUtils.isDriverFilesUpToDate((DatabaseArtifactList)artifactList, (DatabaseDriver)driver, (String)artifact.getId(), (Version)artifact.getArtifactVersion(), (String)artifact.getChannel());
        if (DatabaseDriverValidator.findIncompatibilities(driver, problems, dataSource)) {
            return;
        }
        if (needDownload) {
            if (actualVersion == null) {
                String description = DatabaseBundle.message((String)"no.provided.files.for.a.href.action0.0.a", (Object[])new Object[]{driverName});
                problems.consume((Object)new DataSourceProblem(driver, null, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText("", description, description, navigate), null));
            } else if (DatabaseDriverUtils.hasMissingLocalFiles((DatabaseArtifactList.ArtifactVersion)actualVersion)) {
                String shortDescription = DatabaseBundle.message((String)"notification.content.essential.driver.files.missing", (Object[])new Object[]{driverName});
                String description = DatabaseBundle.message((String)"notification.content.essential.driver.files.missing.extended", (Object[])new Object[]{driverName});
                problems.consume((Object)new DataSourceProblem(driver, null, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText("", shortDescription, description, navigate), null));
            } else {
                boolean download = !DatabaseDriverUtils.isDriverFilesUpToDate((DatabaseArtifactList)artifactList, (DatabaseDriver)driver, (String)artifact.getId(), (Version)actualVersion.version, (String)artifact.getChannel());
                FixWithProgress fix = new FixWithProgress(DatabaseBundle.message((String)"DataSourceConfigurable.download.driver", (Object[])new Object[0])){

                    @Override
                    public void run(@NotNull ProgressIndicator indicator, @Nullable DatabaseConfigEditor editor2) {
                        if (indicator == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        NamedProgressive downloader = DatabaseDriverValidator.createDownloadTask(actualVersion, driver, editor2);
                        downloader.run(indicator);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/validation/DatabaseDriverValidator$3", "run"));
                    }
                };
                String shortDescription = download ? DatabaseBundle.message((String)"notification.content.href.action0.download.missing.driver.files", (Object[])new Object[0]) : DatabaseBundle.message((String)"notification.content.no.driver.files.configured", (Object[])new Object[]{curClassPath.isEmpty() ? 0 : 1, actualVersionStr});
                String description = download ? DatabaseBundle.message((String)"download.missing.a.href.action1", (Object[])new Object[]{driverName}) : DatabaseBundle.message((String)"switch.to.existing.a.href.action1", (Object[])new Object[]{driverName});
                problems.consume((Object)new DataSourceProblem(driver, INVALID_FILES, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText("", shortDescription, description, fix, navigate), fix));
            }
        } else if (!currentUpToDate && actualVersion != null) {
            if (DatabaseDriverUtils.hasMissingLocalFiles((DatabaseArtifactList.ArtifactVersion)actualVersion)) {
                return;
            }
            FixWithProgress fix = new FixWithProgress(DatabaseBundle.message((String)"DataSourceConfigurable.download.driver", (Object[])new Object[0])){

                @Override
                public void run(@NotNull ProgressIndicator indicator, @Nullable DatabaseConfigEditor editor2) {
                    if (indicator == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    NamedProgressive downloader = DatabaseDriverValidator.createDownloadTask(actualVersion, driver, editor2);
                    downloader.run(indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/validation/DatabaseDriverValidator$4", "run"));
                }
            };
            boolean download = !DatabaseDriverUtils.isDriverFilesUpToDate((DatabaseArtifactList)artifactList, (DatabaseDriver)driver, (String)artifact.getId(), (Version)actualVersion.version, (String)artifact.getChannel());
            String actualVersionText = "ver. " + actualVersionStr;
            String shortDescription = download ? DatabaseBundle.message((String)"notification.content.href.action0.update.to.driver", (Object[])new Object[]{actualVersionText}) : DatabaseBundle.message((String)"notification.content.href.action0.switch.to.driver", (Object[])new Object[]{actualVersionText});
            String description = download ? DatabaseBundle.message((String)"notification.content.update.href.action1", (Object[])new Object[]{driverName, actualVersionText}) : DatabaseBundle.message((String)"notification.content.switch.to.existing.href.action1", (Object[])new Object[]{driverName, actualVersionStr});
            problems.consume((Object)new DataSourceProblem(driver, INVALID_FILES, DataSourceProblem.Level.HINT, new DataSourceProblem.HyperText("", shortDescription, description, fix, navigate), fix));
        }
    }

    public static boolean findIncompatibilities(@NotNull DatabaseDriver driver, @NotNull Consumer<? super DataSourceProblem> problems, final @NotNull LocalDataSource dataSource) {
        String msg;
        if (driver == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(10);
        }
        if (problems == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(11);
        }
        if (dataSource == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(12);
        }
        String driverName = StringUtil.escapeXmlEntities((String)driver.getName());
        boolean passed = DatabaseDriverUtils.passesConstraints((DatabaseDriver)driver, (LocalDataSource)dataSource);
        if (passed || dataSource.getVersion().eqCoarse(new int[]{0})) {
            return false;
        }
        final DatabaseDriver suitable = DatabaseDriverValidator.findSuitableDriver(dataSource, driver);
        DatabaseDriver.Constraint constraint = DatabaseDriverUtils.getConstraint((DatabaseDriver)driver, (LocalDataSource)dataSource);
        if (constraint == null) {
            msg = DatabaseBundle.message((String)"notification.content.driver.does.not.support", (Object[])new Object[]{driverName, dataSource.getDbms().getDisplayName()});
        } else {
            String range = (String)(constraint.from == null ? "up" : "from " + String.valueOf(constraint.from)) + (String)(constraint.to == null ? "" : " to " + String.valueOf(constraint.to));
            msg = DatabaseBundle.message((String)"notification.content.driver.does.not.support.version.expected", (Object[])new Object[]{driverName, dataSource.getVersion(), range});
        }
        FixWithProgress fix = suitable == null ? null : new FixWithProgress(DatabaseBundle.message((String)"progress.title.switch.to", (Object[])new Object[]{suitable.getName()})){

            @Override
            public void run(@NotNull ProgressIndicator indicator, @Nullable DatabaseConfigEditor editor2) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    DataSourceConfigurable configurable;
                    DataSourceConfigurable dataSourceConfigurable = configurable = editor2 == null ? null : editor2.getConfigurable(dataSource, true, DataSourceConfigurable.class);
                    if (configurable != null) {
                        configurable.setDriver(suitable);
                    }
                });
            }

            @Override
            public boolean canBeExecutedWithoutUI() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/validation/DatabaseDriverValidator$5", "run"));
            }
        };
        String extra = fix == null ? "" : " " + DatabaseBundle.message((String)"switch.to.a.href.action0", (Object[])new Object[]{suitable.getName()});
        Object[] actions = fix == null ? ArrayUtil.EMPTY_OBJECT_ARRAY : ContainerUtil.ar((Object[])new FixWithProgress[]{fix});
        problems.consume((Object)new DataSourceProblem(dataSource, null, DataSourceProblem.Level.WARNING, new DataSourceProblem.HyperText(DatabaseBundle.message((String)"notification.title.incompatible.driver", (Object[])new Object[0]), msg + extra, msg, actions), fix));
        return true;
    }

    private static DatabaseDriver findSuitableDriver(@NotNull LocalDataSource ds, @NotNull DatabaseDriver driver) {
        if (ds == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(13);
        }
        if (driver == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(14);
        }
        Dbms drDbms = DbImplUtilCore.getDbms((DatabaseDriver)driver);
        int error = DatabaseDriverUtils.getFirstErrorPos((LocalDataSource)ds, (DatabaseDriver)driver);
        for (DatabaseDriver d : DatabaseDriverManager.getInstance().getDrivers()) {
            if (d.getId().equals(driver.getId()) || DbImplUtilCore.getDbms((DatabaseDriver)d) != drDbms || !DatabaseDriverUtils.passesConstraints((DatabaseDriver)d, (LocalDataSource)ds) || DatabaseDriverUtils.getFirstErrorPos((LocalDataSource)ds, (DatabaseDriver)d) < error) continue;
            return d;
        }
        return null;
    }

    @NotNull
    public static NamedProgressive createDownloaderTask(@NotNull LocalDataSource dataSource, final @Nullable DatabaseConfigEditor editor2) {
        if (dataSource == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(15);
        }
        final DatabaseDriver driver = Objects.requireNonNull(dataSource.getDatabaseDriver());
        final List versions = JBIterable.from((Iterable)driver.getArtifacts()).filterMap(a -> DatabaseArtifactManager.resolveVersion((DatabaseDriver)driver, (DatabaseDriver.ArtifactRef)a)).toList();
        return new NamedProgressive(IdeCoreBundle.message((String)"progress.download.0.title", (Object[])new Object[]{"Driver Files"})){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    6.$$$reportNull$$$0(0);
                }
                for (DatabaseArtifactList.ArtifactVersion version : versions) {
                    DatabaseDriverValidator.createDownloadTask(version, driver, editor2).run(indicator);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/validation/DatabaseDriverValidator$6", "run"));
            }
        };
    }

    @NotNull
    public static NamedProgressive createDownloadTask(DatabaseArtifactList.ArtifactVersion version, DatabaseDriver driver, @Nullable DatabaseConfigEditor editor2) {
        return new MyDriverDownloader(driver, version, editor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/validation/DatabaseDriverValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectProblems";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findDriverLanguageProblem";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findDriverFilesProblems";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findArtifactProblems";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "findIncompatibilities";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "findSuitableDriver";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createDownloaderTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyDriverDownloader
    extends NamedProgressive {
        private final DatabaseDriver myDriver;
        private final DatabaseArtifactList.ArtifactVersion myVersion;
        private final DatabaseConfigEditor myEditor;

        MyDriverDownloader(@NotNull DatabaseDriver driver, @Nullable DatabaseArtifactList.ArtifactVersion version, @Nullable DatabaseConfigEditor editor2) {
            if (driver == null) {
                MyDriverDownloader.$$$reportNull$$$0(0);
            }
            super(DatabaseBundle.message((String)"DataSourceConfigurable.download.driver", (Object[])new Object[0]));
            this.myDriver = driver;
            this.myVersion = version;
            this.myEditor = editor2;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyDriverDownloader.$$$reportNull$$$0(1);
            }
            if (this.myVersion == null) {
                LOG.warn("No version to download provided");
                return;
            }
            Condition isMy = a -> this.myVersion.artifact.isId(a.getId());
            DatabaseDriver.ArtifactRef artifact = (DatabaseDriver.ArtifactRef)ContainerUtil.find((Iterable)this.myDriver.getArtifacts(), (Condition)isMy);
            if (artifact == null) {
                LOG.warn("No artifact " + this.myVersion.artifact.id + " is found in: " + StringUtil.join((Collection)this.myDriver.getArtifacts(), a -> a.getId(), (String)", "));
                return;
            }
            indicator.setText(IdeCoreBundle.message((String)"progress.download.0.title", (Object[])new Object[]{this.myVersion.artifact.name + " files"}));
            boolean ok2 = DatabaseArtifactLoader.getInstance().isValid(this.myVersion);
            ApplicationManager.getApplication().invokeLater(() -> {
                DatabaseDriverConfigurable configurable = this.myEditor == null ? null : this.myEditor.getConfigurable(this.myDriver, true, DatabaseDriverConfigurable.class);
                DatabaseDriverImpl tempDriver = configurable == null ? (DatabaseDriverImpl)this.myDriver : configurable.getTempDriver();
                ArrayList<DatabaseDriver.ArtifactRef> artifacts = new ArrayList<DatabaseDriver.ArtifactRef>(tempDriver.getArtifacts());
                int idx = ContainerUtil.indexOf(artifacts, (Condition)isMy);
                if (idx != -1) {
                    artifacts.subList(idx + 1, artifacts.size()).removeIf(arg_0 -> ((Condition)isMy).value(arg_0));
                    artifacts.set(idx, DatabaseDriverImpl.createArtifactRef(this.myVersion.artifact.id, this.myVersion.version, ((DatabaseDriver.ArtifactRef)artifacts.get(idx)).getChannel()));
                    tempDriver.setArtifacts(artifacts);
                } else {
                    LOG.warn("No artifact " + this.myVersion.artifact.id + " is found in TEMP: " + StringUtil.join(artifacts, a -> a.getId(), (String)", "));
                }
                if (configurable != null) {
                    configurable.resetFromTemp();
                }
                if (ok2 && this.myEditor != null) {
                    this.myEditor.onDriverDownloaded(this.myDriver);
                }
            });
            if (ok2) {
                LOG.info("Driver is up to date, just switched");
                return;
            }
            while (!indicator.isCanceled()) {
                try {
                    DatabaseArtifactManager.getInstance().downloadArtifact(this.myVersion, o -> {
                        if (this.myEditor != null) {
                            this.myEditor.onDriverDownloaded(this.myDriver);
                        }
                    });
                }
                catch (IOException e) {
                    if (ExceptionUtil.causedBy((Throwable)e, TransferCancelledException.class)) break;
                    String msg = IdeCoreBundle.message((String)"progress.download.0.title", (Object[])new Object[]{this.myVersion.artifact.name + " files"});
                    boolean retry = IOExceptionDialog.showErrorDialog((String)msg, (String)e.getMessage());
                    if (retry) continue;
                }
                break;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyDriverDownloader that = (MyDriverDownloader)o;
            if (!this.myDriver.equals(that.myDriver)) {
                return false;
            }
            if (!this.myVersion.equals(that.myVersion)) {
                return false;
            }
            return Objects.equals(this.myEditor, that.myEditor);
        }

        public int hashCode() {
            int result = this.myDriver.hashCode();
            result = 31 * result + this.myVersion.hashCode();
            result = 31 * result + (this.myEditor != null ? this.myEditor.hashCode() : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driver";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/validation/DatabaseDriverValidator$MyDriverDownloader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

