/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.bcp;

import com.intellij.database.cli.CliArgumentGroup;
import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliConfigurationBase;
import com.intellij.database.cli.DatabaseObjectsPreparer;
import com.intellij.database.cli.bcp.MssqlBcpArguments;
import com.intellij.database.cli.bcp.MssqlBcpCliArguments;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class MssqlBcpConfigurationBase
extends CliConfigurationBase {
    protected MssqlBcpConfigurationBase(@NotNull List<CliArgumentGroup<?>> groups, @NotNull String propertyKey) {
        if (groups == null) {
            MssqlBcpConfigurationBase.$$$reportNull$$$0(0);
        }
        if (propertyKey == null) {
            MssqlBcpConfigurationBase.$$$reportNull$$$0(1);
        }
        super(groups, MssqlBcpArguments.SERVER_NAME, ArrayUtil.EMPTY_STRING_ARRAY, MssqlBcpArguments.LOGIN_ID, MssqlBcpArguments.PASSWORD, MssqlBcpArguments.TARGET_FILE, "", propertyKey, "bcp");
    }

    @Override
    @NotNull
    public Map<String, String> getInfoMap() {
        HashMap<String, String> map2 = new HashMap<String, String>();
        MssqlBcpConfigurationBase.put(map2, "File to load table or view data from", MssqlBcpArguments.SOURCE_FILE);
        MssqlBcpConfigurationBase.put(map2, "File to dump table or view data to", MssqlBcpArguments.TARGET_FILE);
        MssqlBcpConfigurationBase.put(map2, "File to dump query result to", MssqlBcpArguments.QUERY_TARGET_FILE);
        MssqlBcpConfigurationBase.put(map2, "Specifies the number of bytes, per network packet, sent to and from the server", MssqlBcpArguments.PACKET_SIZE);
        MssqlBcpConfigurationBase.put(map2, "Specifies the number of rows per batch of imported data", MssqlBcpArguments.BATCH_SIZE);
        MssqlBcpConfigurationBase.put(map2, "Performs the operation using a character data type", MssqlBcpArguments.CHAR);
        MssqlBcpConfigurationBase.put(map2, "Specifies the code page of the data in the data file", MssqlBcpArguments.CODEPAGE);
        MssqlBcpConfigurationBase.put(map2, "Specifies the database to connect to", MssqlBcpArguments.DATABASE_NAME);
        MssqlBcpConfigurationBase.put(map2, "Causes the instance name to be interpreted as a data source name (DSN)", MssqlBcpArguments.DSN);
        MssqlBcpConfigurationBase.put(map2, "Specifies the full path of an error file used to store any rows that the bcp utility can't transfer from the file to the database", MssqlBcpArguments.ERROR_FILE);
        MssqlBcpConfigurationBase.put(map2, "Specifies that identity value or values in the imported data file are to be used for the identity column", MssqlBcpArguments.IMPORT_IDENTITIES);
        MssqlBcpConfigurationBase.put(map2, "Specifies the full path of a format file", MssqlBcpArguments.FORMAT_FILE);
        MssqlBcpConfigurationBase.put(map2, "Specifies the number of the first row to export from a table or import from a data file", MssqlBcpArguments.FIRST_ROW);
        MssqlBcpConfigurationBase.put(map2, "Specifies that the user be authenticated using Azure Active Directory authentication", MssqlBcpArguments.AZURE_AD_AUTHENTICATION);
        MssqlBcpConfigurationBase.put(map2, "Specifies the hint or hints to be used during a bulk import of data into a table or view", MssqlBcpArguments.HINTS);
        MssqlBcpConfigurationBase.put(map2, "Specifies that empty columns should retain a null value during the operation, rather than have any default values for the columns inserted", MssqlBcpArguments.RETAIN_NULL_FOR_EMPTY_COLUMN);
        MssqlBcpConfigurationBase.put(map2, "Declares the application workload type when connecting to a server", MssqlBcpArguments.APPLICATION_INTENT);
        MssqlBcpConfigurationBase.put(map2, "Specifies a login timeout in seconds", MssqlBcpArguments.LOGIN_TIMEOUT);
        MssqlBcpConfigurationBase.put(map2, "Specifies the number of the last row to export from a table or import from a data file", MssqlBcpArguments.LAST_ROW);
        MssqlBcpConfigurationBase.put(map2, "Specifies the maximum number of syntax errors that can occur before the bcp operation is canceled", MssqlBcpArguments.MAX_ERRORS);
        MssqlBcpConfigurationBase.put(map2, "Performs the bulk-copy operation using the native (database) data types of the data", MssqlBcpArguments.USE_NATIVE_TYPES);
        MssqlBcpConfigurationBase.put(map2, "Performs the bulk-copy operation using the native (database) data types of the data for noncharacter data, and Unicode characters for character data", MssqlBcpArguments.USE_NATIVE_TYPES_AND_UNICODE);
        MssqlBcpConfigurationBase.put(map2, "Specifies the name of a file that receives output redirected from the command prompt", MssqlBcpArguments.OUTPUT_FILE);
        MssqlBcpConfigurationBase.put(map2, "Specifies the password for the login ID", MssqlBcpArguments.PASSWORD);
        MssqlBcpConfigurationBase.put(map2, "Specifies the row terminator", MssqlBcpArguments.ROW_TERMINATOR);
        MssqlBcpConfigurationBase.put(map2, "Specifies that currency, date, and time data is bulk copied into SQL Server using the regional format defined for the locale setting of the client computer", MssqlBcpArguments.REGIONAL);
        MssqlBcpConfigurationBase.put(map2, "Specifies the instance of SQL Server to which to connect", MssqlBcpArguments.SERVER_NAME);
        MssqlBcpConfigurationBase.put(map2, "Specifies the field terminator", MssqlBcpArguments.FIELD_TERMINATOR);
        MssqlBcpConfigurationBase.put(map2, "Specifies that the bcp utility connects to SQL Server with a trusted connection using integrated security", MssqlBcpArguments.TRUSTED_CONNECTION);
        MssqlBcpConfigurationBase.put(map2, "Specifies the login ID used to connect to SQL Server", MssqlBcpArguments.LOGIN_ID);
        MssqlBcpConfigurationBase.put(map2, "Performs the bulk-copy operation using data types from an earlier version of SQL Server", MssqlBcpArguments.LEGACY_TYPES);
        MssqlBcpConfigurationBase.put(map2, "Performs the bulk copy operation using Unicode characters", MssqlBcpArguments.NCHAR);
        HashMap<String, String> hashMap = map2;
        if (hashMap == null) {
            MssqlBcpConfigurationBase.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    @Override
    @NotNull
    public String getPartOfValidationOut() {
        return "bcp";
    }

    @Override
    @NotNull
    public CliConfiguration.CliSubstitutor getSubstitutor() {
        return new CliConfigurationBase.CliSubstitutorBase(this, List.of(TIMESTAMP_PLACEHOLDER, DATA_SOURCE_PLACEHOLDER, new CliConfigurationBase.TablePlaceholder(MssqlBcpCliArguments.TABLE))){

            @Override
            @NotNull
            public Collection<String> getDefaultPatterns() {
                List list = ContainerUtil.map((Collection)this.mySupportedPlaceholders, p2 -> p2.text);
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/bcp/MssqlBcpConfigurationBase$1", "getDefaultPatterns"));
            }
        };
    }

    @Override
    @NotNull
    public DatabaseObjectsPreparer getObjectsPreparer() {
        DatabaseObjectsPreparer databaseObjectsPreparer = DatabaseObjectsPreparer.idle().filter((Condition<DbElement>)((Condition)e -> DbImplUtilCore.isDataTable((DasTable)((DasTable)ObjectUtils.tryCast((Object)e, DasTable.class))))).requireSingle();
        if (databaseObjectsPreparer == null) {
            MssqlBcpConfigurationBase.$$$reportNull$$$0(3);
        }
        return databaseObjectsPreparer;
    }

    @Override
    @NotNull
    public String getCommand(@NotNull String command, @NotNull CliConfiguration.Parameters parameters) {
        if (command == null) {
            MssqlBcpConfigurationBase.$$$reportNull$$$0(4);
        }
        if (parameters == null) {
            MssqlBcpConfigurationBase.$$$reportNull$$$0(5);
        }
        String string = super.getCommand(command, MssqlBcpConfigurationBase.adjustParams(parameters)) + " -N";
        if (string == null) {
            MssqlBcpConfigurationBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static CliConfiguration.Parameters adjustParams(@NotNull CliConfiguration.Parameters parameters) {
        if (parameters == null) {
            MssqlBcpConfigurationBase.$$$reportNull$$$0(7);
        }
        if (parameters.port != null) {
            CliConfiguration.Parameters parameters2 = parameters.withHost(StringUtil.notNullize((String)parameters.host) + "," + parameters.port);
            if (parameters2 == null) {
                MssqlBcpConfigurationBase.$$$reportNull$$$0(8);
            }
            return parameters2;
        }
        CliConfiguration.Parameters parameters3 = parameters;
        if (parameters3 == null) {
            MssqlBcpConfigurationBase.$$$reportNull$$$0(9);
        }
        return parameters3;
    }

    @Override
    @NotNull
    public CliConfiguration.CliBuilder getCliBuilder(@NotNull Project project) {
        if (project == null) {
            MssqlBcpConfigurationBase.$$$reportNull$$$0(10);
        }
        return new CliConfigurationBase.CliBuilderBase(this.getParameterProcessor(), project, this.getOperation(), this.getName(), this.getEnvironmentVarName(), this.getSubstitutor()){

            @Override
            public void primeProcess(@NotNull OSProcessHandler handler2, @NotNull GeneralCommandLine commandLine, @NotNull CliConfiguration.CliBuilderContext context) {
                if (handler2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (commandLine == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(2);
                }
                OutputStream input = handler2.getProcessInput();
                try (PrintWriter pw = new PrintWriter(input, false, commandLine.getCharset());){
                    pw.println(context.password());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "handler";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "commandLine";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/cli/bcp/MssqlBcpConfigurationBase$2";
                objectArray[2] = "primeProcess";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyKey";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/bcp/MssqlBcpConfigurationBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/bcp/MssqlBcpConfigurationBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsPreparer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "adjustParams";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCliBuilder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 8, 9 -> new IllegalStateException(string);
        };
    }
}

