/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.html.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.ParsingDiagnostics;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.ILightLazyParseableElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.lang.LangMode;
import org.jetbrains.vuejs.lang.VueScriptLangs;
import org.jetbrains.vuejs.lang.html.VueFileElementType;
import org.jetbrains.vuejs.lang.html.VueFileTypeKt;
import org.jetbrains.vuejs.lang.html.VueLanguage;
import org.jetbrains.vuejs.lang.html.parser.VueParser;
import org.jetbrains.vuejs.lang.html.parser.VueParserDefinition;
import org.jetbrains.vuejs.lang.html.parser.VueParsing;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/vuejs/lang/html/parser/VueElementTypes;", "", "<init>", "()V", "VUE_EMBEDDED_CONTENT", "Lcom/intellij/psi/tree/IElementType;", "getVUE_EMBEDDED_CONTENT", "()Lcom/intellij/psi/tree/IElementType;", "EmbeddedVueContentElementType", "intellij.vuejs"})
public final class VueElementTypes {
    @NotNull
    public static final VueElementTypes INSTANCE = new VueElementTypes();
    @NotNull
    private static final IElementType VUE_EMBEDDED_CONTENT = (IElementType)new EmbeddedVueContentElementType();

    private VueElementTypes() {
    }

    @NotNull
    public final IElementType getVUE_EMBEDDED_CONTENT() {
        return VUE_EMBEDDED_CONTENT;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/vuejs/lang/html/parser/VueElementTypes$EmbeddedVueContentElementType;", "Lcom/intellij/psi/tree/ILazyParseableElementType;", "Lcom/intellij/psi/tree/ILightLazyParseableElementType;", "<init>", "()V", "parseContents", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/lang/LighterASTNode;", "chameleon", "Lcom/intellij/lang/LighterLazyParseableNode;", "doParseContents", "Lcom/intellij/lang/ASTNode;", "psi", "Lcom/intellij/psi/PsiElement;", "intellij.vuejs"})
    public static final class EmbeddedVueContentElementType
    extends ILazyParseableElementType
    implements ILightLazyParseableElementType {
        public EmbeddedVueContentElementType() {
            super("VUE_EMBEDDED_CONTENT", (Language)VueLanguage.Companion.getINSTANCE());
        }

        @NotNull
        public FlyweightCapableTreeStructure<LighterASTNode> parseContents(@NotNull LighterLazyParseableNode chameleon) {
            Intrinsics.checkNotNullParameter((Object)chameleon, (String)"chameleon");
            PsiFile psiFile = chameleon.getContainingFile();
            if (psiFile == null) {
                throw new IllegalStateException(chameleon.toString());
            }
            PsiFile file = psiFile;
            boolean htmlCompatMode = !VueFileTypeKt.isVueFile(file);
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Lexer lexer = VueParserDefinition.Util.INSTANCE.createLexer(project, null, htmlCompatMode, (LangMode)((Object)file.getUserData(VueScriptLangs.INSTANCE.getLANG_MODE$intellij_vuejs())));
            PsiBuilder psiBuilder = PsiBuilderFactory.getInstance().createBuilder(file.getProject(), chameleon, lexer, this.getLanguage(), chameleon.getText());
            Intrinsics.checkNotNullExpressionValue((Object)psiBuilder, (String)"createBuilder(...)");
            PsiBuilder builder2 = psiBuilder;
            builder2.putUserData(VueScriptLangs.INSTANCE.getLANG_MODE$intellij_vuejs(), file.getUserData(VueScriptLangs.INSTANCE.getLANG_MODE$intellij_vuejs()));
            builder2.putUserData((Key)VueParsing.Companion.getHTML_COMPAT_MODE(), (Object)htmlCompatMode);
            new VueParser().parseWithoutBuildingTree((IElementType)VueFileElementType.Companion.getINSTANCE(), builder2);
            FlyweightCapableTreeStructure flyweightCapableTreeStructure = builder2.getLightTree();
            Intrinsics.checkNotNullExpressionValue((Object)flyweightCapableTreeStructure, (String)"getLightTree(...)");
            return flyweightCapableTreeStructure;
        }

        @NotNull
        protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement psi) {
            Intrinsics.checkNotNullParameter((Object)chameleon, (String)"chameleon");
            Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
            PsiFile psiFile = psi.getContainingFile();
            if (psiFile == null) {
                throw new IllegalStateException(chameleon.toString());
            }
            PsiFile file = psiFile;
            boolean htmlCompatMode = !VueFileTypeKt.isVueFile(file);
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Lexer lexer = VueParserDefinition.Util.INSTANCE.createLexer(project, null, htmlCompatMode, (LangMode)((Object)file.getUserData(VueScriptLangs.INSTANCE.getLANG_MODE$intellij_vuejs())));
            PsiBuilder psiBuilder = PsiBuilderFactory.getInstance().createBuilder(file.getProject(), chameleon, lexer, this.getLanguage(), chameleon.getChars());
            Intrinsics.checkNotNullExpressionValue((Object)psiBuilder, (String)"createBuilder(...)");
            PsiBuilder builder2 = psiBuilder;
            long startTime = System.nanoTime();
            builder2.putUserData(VueScriptLangs.INSTANCE.getLANG_MODE$intellij_vuejs(), file.getUserData(VueScriptLangs.INSTANCE.getLANG_MODE$intellij_vuejs()));
            builder2.putUserData((Key)VueParsing.Companion.getHTML_COMPAT_MODE(), (Object)htmlCompatMode);
            ASTNode node = new VueParser().parse((IElementType)VueFileElementType.Companion.getINSTANCE(), builder2);
            ASTNode result = node.getFirstChildNode();
            ParsingDiagnostics.registerParse((PsiBuilder)builder2, (Language)this.getLanguage(), (long)(System.nanoTime() - startTime));
            Intrinsics.checkNotNull((Object)result);
            return result;
        }
    }
}

