/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.intentions.extractComponent;

import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.polySymbols.completion.PolySymbolCodeCompletionItem;
import com.intellij.polySymbols.query.PolySymbolQueryExecutorFactory;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.XmlExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.intentions.extractComponent.VueComponentInplaceIntroducer;
import org.jetbrains.vuejs.intentions.extractComponent.VueExtractComponentDataBuilder;
import org.jetbrains.vuejs.web.VueSymbolQueryConfiguratorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0012B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentRefactoring;", "", "project", "Lcom/intellij/openapi/project/Project;", "list", "", "Lcom/intellij/psi/xml/XmlTag;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/editor/Editor;)V", "perform", "", "defaultName", "", "fireRefactoringEvents", "", "getSelectedText", "TagNameValidator", "intellij.vuejs"})
public final class VueExtractComponentRefactoring {
    @NotNull
    private final Project project;
    @NotNull
    private final List<XmlTag> list;
    @NotNull
    private final Editor editor;

    public VueExtractComponentRefactoring(@NotNull Project project, @NotNull List<? extends XmlTag> list, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.project = project;
        this.list = list;
        this.editor = editor;
    }

    public final void perform(@Nullable String defaultName, boolean fireRefactoringEvents) {
        if (this.list.isEmpty() || this.list.get(0).getContainingFile() == null || this.list.get(0).getContainingFile().getParent() == null || !CommonRefactoringUtil.checkReadOnlyStatus((Project)this.project, (PsiElement)((PsiElement)this.list.get(0).getContainingFile()))) {
            return;
        }
        String oldText = this.getSelectedText();
        VueExtractComponentDataBuilder data = new VueExtractComponentDataBuilder(this.list);
        String refactoringName = VueBundle.message("vue.template.intention.extract.component.command.name", new Object[0]);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.project, () -> VueExtractComponentRefactoring.perform$lambda$1(fireRefactoringEvents, this, data, oldText, refactoringName, defaultName), refactoringName, (Object)"VueExtractComponent");
    }

    public static /* synthetic */ void perform$default(VueExtractComponentRefactoring vueExtractComponentRefactoring, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        vueExtractComponentRefactoring.perform(string, bl);
    }

    private final String getSelectedText() {
        String string = this.editor.getDocument().getText(new TextRange(this.list.get(0).getTextRange().getStartOffset(), this.list.get(this.list.size() - 1).getTextRange().getEndOffset()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final void perform$lambda$1$lambda$0(Ref.ObjectRef $startMarkAction, VueExtractComponentRefactoring this$0, String $refactoringName, Ref.ObjectRef $newlyAdded, VueExtractComponentDataBuilder $data, String $defaultName) {
        PsiElement psiElement;
        Object object = $startMarkAction.element = StartMarkAction.start((Editor)this$0.editor, (Project)this$0.project, (String)$refactoringName);
        Intrinsics.checkNotNull((Object)object);
        ((StartMarkAction)object).setGlobal(true);
        String string = $defaultName;
        if (string == null) {
            string = "NewComponent";
        }
        $newlyAdded.element = (psiElement = $data.replaceWithNewTag(string)) instanceof XmlTag ? (XmlTag)psiElement : null;
    }

    private static final void perform$lambda$1(boolean $fireRefactoringEvents, VueExtractComponentRefactoring this$0, VueExtractComponentDataBuilder $data, String $oldText, String $refactoringName, String $defaultName) {
        if ($fireRefactoringEvents) {
            JSRefactoringUtil.registerRefactoringUndo((Project)this$0.project, (String)"refactoring.javascript.vue.extractComponent");
        }
        Ref.ObjectRef newlyAdded = new Ref.ObjectRef();
        TagNameValidator validator = new TagNameValidator(this$0.list.get(0));
        Ref.ObjectRef startMarkAction = new Ref.ObjectRef();
        WriteAction.run(() -> VueExtractComponentRefactoring.perform$lambda$1$lambda$0(startMarkAction, this$0, $refactoringName, newlyAdded, $data, $defaultName));
        Object object = newlyAdded.element;
        Intrinsics.checkNotNull((Object)object);
        XmlTag xmlTag = (XmlTag)object;
        Editor editor = this$0.editor;
        Function1 function1 = (Function1)new Function1<String, String>((Object)validator){

            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((TagNameValidator)this.receiver).validate(p0);
            }
        };
        Object object2 = startMarkAction.element;
        Intrinsics.checkNotNull((Object)object2);
        new VueComponentInplaceIntroducer(xmlTag, editor, $data, $oldText, (Function1<? super String, String>)function1, (StartMarkAction)object2, $fireRefactoringEvents).performInplaceRefactoring(new LinkedHashSet<String>());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\f\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\r2\b\b\u0001\u0010\u000e\u001a\u00020\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentRefactoring$TagNameValidator;", "", "context", "Lcom/intellij/psi/xml/XmlTag;", "<init>", "(Lcom/intellij/psi/xml/XmlTag;)V", "folder", "Lcom/intellij/psi/PsiDirectory;", "forbidden", "", "", "alreadyExisting", "validate", "Lorg/jetbrains/annotations/Nls;", "text", "intellij.vuejs"})
    @SourceDebugExtension(value={"SMAP\nVueExtractComponentRefactoring.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueExtractComponentRefactoring.kt\norg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentRefactoring$TagNameValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1563#2:99\n1634#2,3:100\n1563#2:103\n1634#2,3:104\n*S KotlinDebug\n*F\n+ 1 VueExtractComponentRefactoring.kt\norg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentRefactoring$TagNameValidator\n*L\n73#1:99\n73#1:100,3\n77#1:103\n77#1:104,3\n*E\n"})
    private static final class TagNameValidator {
        @NotNull
        private final PsiDirectory folder;
        @NotNull
        private final Set<String> forbidden;
        @NotNull
        private final Set<String> alreadyExisting;

        public TagNameValidator(@NotNull XmlTag context) {
            PolySymbolCodeCompletionItem it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            PsiDirectory psiDirectory = context.getContainingFile().getParent();
            Intrinsics.checkNotNull((Object)psiDirectory);
            this.folder = psiDirectory;
            PsiFile psiFile = context.getContainingFile();
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
            List list = DefaultXmlExtension.DEFAULT_EXTENSION.getAvailableTagNames((XmlFile)psiFile, context);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAvailableTagNames(...)");
            Iterable iterable = list;
            TagNameValidator tagNameValidator = this;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                XmlExtension.TagInfo tagInfo = (XmlExtension.TagInfo)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.name);
            }
            tagNameValidator.forbidden = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            $this$map$iv = PolySymbolQueryExecutorFactory.Companion.create$default((PolySymbolQueryExecutorFactory.Companion)PolySymbolQueryExecutorFactory.Companion, (PsiElement)((PsiElement)context), (boolean)false, (int)2, null).codeCompletionQuery(VueSymbolQueryConfiguratorKt.getVUE_COMPONENTS(), "", 0).run();
            tagNameValidator = this;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (PolySymbolCodeCompletionItem)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(VueUtilKt.fromAsset$default(it.getName(), false, 2, null));
            }
            tagNameValidator.alreadyExisting = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        @Nullable
        public final String validate(@NonNls @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            String normalized = VueUtilKt.fromAsset$default(((Object)StringsKt.trim((CharSequence)text)).toString(), false, 2, null);
            String fileName = VueUtilKt.toAsset(((Object)StringsKt.trim((CharSequence)text)).toString(), true) + ".vue";
            if (((CharSequence)normalized).length() == 0 || !PathUtilRt.isValidFileName((String)fileName, (boolean)false) || StringsKt.contains$default((CharSequence)normalized, (char)' ', (boolean)false, (int)2, null) || this.forbidden.contains(normalized)) {
                Object[] objectArray = new Object[]{normalized};
                return VueBundle.message("vue.template.intention.extract.component.error.component.name", objectArray);
            }
            if (this.alreadyExisting.contains(normalized)) {
                Object[] objectArray = new Object[]{normalized};
                return VueBundle.message("vue.template.intention.extract.component.error.component.exists", objectArray);
            }
            if (this.folder.findFile(fileName) != null) {
                Object[] objectArray = new Object[]{fileName};
                return VueBundle.message("vue.template.intention.extract.component.error.file.exists", objectArray);
            }
            return null;
        }
    }
}

