/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.math;

import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.full.KTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.api.DefaultsKt;
import org.jetbrains.kotlinx.dataframe.math.BasicStats;
import org.jetbrains.kotlinx.dataframe.math.StdMeanKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u001a:\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0001\u001a!\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u000b0\u00042\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b\f\u001a+\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u00042\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b\r\u001a+\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u000e0\u00042\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b\u000f\u001a!\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\n0\u00042\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b\u0010\u001a!\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00110\u00042\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"std", "", "T", "", "", "type", "Lkotlin/reflect/KType;", "skipNA", "", "ddof", "", "Ljava/math/BigDecimal;", "bigDecimalStd", "doubleStd", "", "floatStd", "intStd", "", "longStd", "core"})
public final class StdKt {
    @PublishedApi
    public static final <T extends Number> double std(@NotNull Iterable<? extends T> $this$std, @NotNull KType type, boolean skipNA, int ddof) {
        double d;
        Intrinsics.checkNotNullParameter($this$std, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type.isMarkedNullable()) {
            if (skipNA) {
                return StdKt.std(CollectionsKt.filterNotNull($this$std), KTypes.withNullability((KType)type, (boolean)false), true, ddof);
            }
            if (CollectionsKt.contains($this$std, null)) {
                return Double.NaN;
            }
            return StdKt.std($this$std, KTypes.withNullability((KType)type, (boolean)false), skipNA, ddof);
        }
        KClassifier kClassifier = type.getClassifier();
        if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            d = StdKt.doubleStd($this$std, skipNA, ddof);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            d = StdKt.floatStd($this$std, skipNA, ddof);
        } else if ((Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)) ? true : Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) ? true : Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            d = StdKt.intStd($this$std, ddof);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            d = StdKt.longStd($this$std, ddof);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            d = StdKt.bigDecimalStd($this$std, ddof);
        } else {
            throw new IllegalArgumentException("Unsupported type " + type.getClassifier());
        }
        return d;
    }

    public static /* synthetic */ double std$default(Iterable iterable, KType kType, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = DefaultsKt.getSkipNA_default();
        }
        if ((n2 & 4) != 0) {
            n = DefaultsKt.getDdof_default();
        }
        return StdKt.std(iterable, kType, bl, n);
    }

    @JvmName(name="doubleStd")
    public static final double doubleStd(@NotNull Iterable<Double> $this$std, boolean skipNA, int ddof) {
        Intrinsics.checkNotNullParameter($this$std, (String)"<this>");
        BasicStats basicStats = StdMeanKt.doubleVarianceAndMean($this$std, skipNA);
        return basicStats != null ? basicStats.std(ddof) : Double.NaN;
    }

    public static /* synthetic */ double doubleStd$default(Iterable iterable, boolean bl, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = DefaultsKt.getSkipNA_default();
        }
        if ((n2 & 2) != 0) {
            n = DefaultsKt.getDdof_default();
        }
        return StdKt.doubleStd(iterable, bl, n);
    }

    @JvmName(name="floatStd")
    public static final double floatStd(@NotNull Iterable<Float> $this$std, boolean skipNA, int ddof) {
        Intrinsics.checkNotNullParameter($this$std, (String)"<this>");
        BasicStats basicStats = StdMeanKt.floatVarianceAndMean($this$std, skipNA);
        return basicStats != null ? basicStats.std(ddof) : Double.NaN;
    }

    public static /* synthetic */ double floatStd$default(Iterable iterable, boolean bl, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = DefaultsKt.getSkipNA_default();
        }
        if ((n2 & 2) != 0) {
            n = DefaultsKt.getDdof_default();
        }
        return StdKt.floatStd(iterable, bl, n);
    }

    @JvmName(name="intStd")
    public static final double intStd(@NotNull Iterable<Integer> $this$std, int ddof) {
        Intrinsics.checkNotNullParameter($this$std, (String)"<this>");
        return StdMeanKt.intVarianceAndMean($this$std).std(ddof);
    }

    public static /* synthetic */ double intStd$default(Iterable iterable, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = DefaultsKt.getDdof_default();
        }
        return StdKt.intStd(iterable, n);
    }

    @JvmName(name="longStd")
    public static final double longStd(@NotNull Iterable<Long> $this$std, int ddof) {
        Intrinsics.checkNotNullParameter($this$std, (String)"<this>");
        return StdMeanKt.longVarianceAndMean($this$std).std(ddof);
    }

    public static /* synthetic */ double longStd$default(Iterable iterable, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = DefaultsKt.getDdof_default();
        }
        return StdKt.longStd(iterable, n);
    }

    @JvmName(name="bigDecimalStd")
    public static final double bigDecimalStd(@NotNull Iterable<? extends BigDecimal> $this$std, int ddof) {
        Intrinsics.checkNotNullParameter($this$std, (String)"<this>");
        return StdMeanKt.bigDecimalVarianceAndMean($this$std).std(ddof);
    }

    public static /* synthetic */ double bigDecimalStd$default(Iterable iterable, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = DefaultsKt.getDdof_default();
        }
        return StdKt.bigDecimalStd(iterable, n);
    }
}

