/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.data.DataFrameUtil;
import org.jetbrains.letsPlot.core.spec.Option;
import org.jetbrains.letsPlot.core.spec.config.DataMetaUtil;
import org.jetbrains.letsPlot.core.spec.config.OptionsAccessor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u0002J7\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\u00042\u0006\u0010\u0007\u001a\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b\rJ\u0017\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0000\u00a2\u0006\u0002\b\u0010J\u0016\u0010\u0011\u001a\u00020\u00052\u000e\u0010\u0012\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004J/\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00040\u00062\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u001d\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0012\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004H\u0000\u00a2\u0006\u0002\b\u0018J.\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u001c\u001a\u00020\u000b2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0006J\u0014\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u001f\u001a\u00020\u0001H\u0002J\u0012\u0010 \u001a\u00020!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u0006J(\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000b2\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004H\u0002\u00a8\u0006%"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/ConfigUtil;", "", "()V", "asVarNameMap", "", "", "", "data", "createAesMapping", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "mapping", "createAesMapping$plot_stem", "createDataFrame", "rawData", "createDataFrame$plot_stem", "featureName", "options", "featuresInFeatureList", "", "featuresInFeatureList$plot_stem", "isFeatureList", "", "isFeatureList$plot_stem", "join", "left", "leftKeyVariableNames", "right", "rightKeyVariableNames", "toList", "o", "toNumericPair", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "twoValueList", "updateDataFrame", "df", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nConfigUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigUtil.kt\norg/jetbrains/letsPlot/core/spec/config/ConfigUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1549#2:211\n1620#2,3:212\n1855#2,2:215\n1855#2,2:217\n1864#2,2:219\n1855#2:221\n1855#2,2:222\n1855#2,2:224\n1856#2:226\n1866#2:227\n1855#2:228\n1855#2:229\n1855#2,2:230\n1855#2,2:232\n1856#2:234\n1856#2:235\n1789#2,3:236\n1549#2:239\n1620#2,3:240\n1549#2:243\n1620#2,2:244\n1549#2:246\n1620#2,3:247\n1559#2:250\n1590#2,3:251\n1593#2:255\n1#3:254\n*S KotlinDebug\n*F\n+ 1 ConfigUtil.kt\norg/jetbrains/letsPlot/core/spec/config/ConfigUtil\n*L\n30#1:211\n30#1:212,3\n61#1:215,2\n62#1:217,2\n71#1:219,2\n72#1:221\n75#1:222,2\n76#1:224,2\n72#1:226\n71#1:227\n81#1:228\n83#1:229\n84#1:230,2\n85#1:232,2\n83#1:234\n81#1:235\n89#1:236,3\n49#1:239\n49#1:240,3\n50#1:243\n50#1:244,2\n50#1:246\n50#1:247,3\n67#1:250\n67#1:251,3\n67#1:255\n*E\n"})
public final class ConfigUtil {
    @NotNull
    public static final ConfigUtil INSTANCE = new ConfigUtil();

    private ConfigUtil() {
    }

    @NotNull
    public final String featureName(@NotNull Map<?, ?> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return String.valueOf(options.get("name"));
    }

    public final boolean isFeatureList$plot_stem(@NotNull Map<?, ?> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return options.containsKey("feature-list");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Map<?, ?>> featuresInFeatureList$plot_stem(@NotNull Map<String, Object> options) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(options, (String)"options");
        List<?> list2 = OptionsAccessor.Companion.over(options).getList("feature-list");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void o;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)o, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
            Map featureOptionsByKind = (Map)o;
            Object v = featureOptionsByKind.values().iterator().next();
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
            collection.add((Map)v);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final DataFrame createDataFrame$plot_stem(@Nullable Object rawData) {
        Map<String, List<?>> varNameMap = this.asVarNameMap(rawData);
        return this.updateDataFrame(DataFrame.Builder.Companion.emptyFrame(), varNameMap);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataFrame join(@NotNull DataFrame left, @NotNull List<?> leftKeyVariableNames, @NotNull DataFrame right, @NotNull List<?> rightKeyVariableNames) {
        void $this$fold$iv;
        Object object;
        Object variable;
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter(leftKeyVariableNames, (String)"leftKeyVariableNames");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter(rightKeyVariableNames, (String)"rightKeyVariableNames");
        if (!(rightKeyVariableNames.size() == leftKeyVariableNames.size())) {
            boolean $i$a$-require-ConfigUtil$join$22 = false;
            String $i$a$-require-ConfigUtil$join$22 = "Keys count for merging should be equal, but was " + leftKeyVariableNames.size() + " and " + rightKeyVariableNames.size();
            throw new IllegalArgumentException($i$a$-require-ConfigUtil$join$22.toString());
        }
        List<List<Object>> leftMultiKeys = ConfigUtil.join$computeMultiKeys(left, leftKeyVariableNames);
        List<List<Object>> rightMultiKeys = ConfigUtil.join$computeMultiKeys(right, rightKeyVariableNames);
        boolean restrictRightDuplicates = ConfigUtil.join$containsDuplicates(leftMultiKeys) && ConfigUtil.join$containsDuplicates(rightMultiKeys);
        HashMap jointMap = new HashMap();
        Iterable $this$forEach$iv = right.variables();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            variable = (DataFrame.Variable)element$iv;
            boolean bl = false;
            ((Map)jointMap).put(variable, (List)new ArrayList());
        }
        $this$forEach$iv = left.variables();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            variable = (DataFrame.Variable)element$iv;
            boolean bl = false;
            ((Map)jointMap).put(variable, (List)new ArrayList());
        }
        Set notMatchedRightMultiKeys = CollectionsKt.toMutableSet((Iterable)rightMultiKeys);
        Iterable $this$forEachIndexed$iv = leftMultiKeys;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void leftMultiKey;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            object = (List)item$iv;
            int leftRowIndex = n;
            boolean bl = false;
            Iterable $this$forEach$iv2 = ConfigUtil.join$indicesOf(rightMultiKeys, restrictRightDuplicates, leftMultiKey);
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                DataFrame.Variable it;
                Object element$iv = iterator2.next();
                int rightRowIndex = ((Number)element$iv).intValue();
                boolean bl2 = false;
                if (rightRowIndex < 0) continue;
                notMatchedRightMultiKeys.remove(leftMultiKey);
                Iterable $this$forEach$iv3 = right.variables();
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv3) {
                    it = (DataFrame.Variable)element$iv2;
                    boolean bl3 = false;
                    Object v = jointMap.get(it);
                    Intrinsics.checkNotNull(v);
                    ((List)v).add(right.get(it).get(rightRowIndex));
                }
                $this$forEach$iv3 = left.variables();
                $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv3) {
                    it = (DataFrame.Variable)element$iv2;
                    boolean bl4 = false;
                    Object v = jointMap.get(it);
                    Intrinsics.checkNotNull(v);
                    ((List)v).add(left.get(it).get(leftRowIndex));
                }
            }
        }
        Iterable $this$forEach$iv4 = notMatchedRightMultiKeys;
        boolean $i$f$forEach4 = false;
        for (Object element$iv : $this$forEach$iv4) {
            List notMatchedRightKey = (List)element$iv;
            boolean bl = false;
            List<Integer> rightRowIndices = ConfigUtil.join$indicesOf(rightMultiKeys, restrictRightDuplicates, notMatchedRightKey);
            Iterable $this$forEach$iv5 = rightRowIndices;
            boolean $i$f$forEach5 = false;
            for (Object element$iv3 : $this$forEach$iv5) {
                DataFrame.Variable it;
                int rightRowIndex = ((Number)element$iv3).intValue();
                boolean bl5 = false;
                Iterable $this$forEach$iv6 = right.variables();
                boolean $i$f$forEach6 = false;
                for (Object element$iv4 : $this$forEach$iv6) {
                    it = (DataFrame.Variable)element$iv4;
                    boolean bl6 = false;
                    Object v = jointMap.get(it);
                    Intrinsics.checkNotNull(v);
                    ((List)v).add(right.get(it).get(rightRowIndex));
                }
                $this$forEach$iv6 = left.variables();
                $i$f$forEach6 = false;
                for (Object element$iv4 : $this$forEach$iv6) {
                    it = (DataFrame.Variable)element$iv4;
                    boolean bl7 = false;
                    Object v = jointMap.get(it);
                    Intrinsics.checkNotNull(v);
                    ((List)v).add(null);
                }
            }
        }
        Set set2 = jointMap.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-entries>(...)");
        $this$forEach$iv4 = set2;
        DataFrame.Builder initial$iv = new DataFrame.Builder();
        boolean $i$f$fold = false;
        DataFrame.Builder accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            object = (Map.Entry)element$iv;
            DataFrame.Builder b2 = accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)object);
            DataFrame.Variable variable2 = (DataFrame.Variable)object.getKey();
            List values2 = (List)object.getValue();
            Intrinsics.checkNotNull((Object)variable2);
            Intrinsics.checkNotNull((Object)values2);
            accumulator$iv = b2.put(variable2, values2);
        }
        return accumulator$iv.build();
    }

    private final Map<String, List<?>> asVarNameMap(Object data2) {
        if (data2 == null) {
            return MapsKt.emptyMap();
        }
        HashMap varNameMap = new HashMap();
        if (data2 instanceof Map) {
            for (Object k : ((Map)data2).keySet()) {
                Object v = ((Map)data2).get(k);
                if (!(v instanceof List)) continue;
                ((Map)varNameMap).put(String.valueOf(k), v);
            }
        } else {
            throw new IllegalArgumentException("Unsupported data structure: " + Reflection.getOrCreateKotlinClass(data2.getClass()).getSimpleName());
        }
        return varNameMap;
    }

    private final DataFrame updateDataFrame(DataFrame df, Map<String, ? extends List<?>> data2) {
        Map<String, DataFrame.Variable> dfVars = DataFrameUtil.INSTANCE.variables(df);
        DataFrame.Builder b2 = df.builder();
        for (Map.Entry<String, List<?>> entry : data2.entrySet()) {
            String varName = entry.getKey();
            List<?> values2 = entry.getValue();
            DataFrame.Variable variable = dfVars.get(varName);
            if (variable == null) {
                variable = DataFrameUtil.createVariable$default(DataFrameUtil.INSTANCE, varName, null, 2, null);
            }
            DataFrame.Variable variable2 = variable;
            b2.put(variable2, values2);
        }
        return b2.build();
    }

    private final List<?> toList(Object o) {
        List list2;
        Object object = o;
        if (object instanceof List) {
            list2 = (List)o;
        } else if (object instanceof Number) {
            list2 = CollectionsKt.listOf((Object)((Number)o).doubleValue());
        } else {
            if (object instanceof Iterable) {
                throw new IllegalArgumentException("Can't cast/transform to list: " + Reflection.getOrCreateKotlinClass(o.getClass()).getSimpleName());
            }
            list2 = CollectionsKt.listOf((Object)o.toString());
        }
        return list2;
    }

    @NotNull
    public final Map<Aes<?>, DataFrame.Variable> createAesMapping$plot_stem(@NotNull DataFrame data2, @Nullable Map<?, ?> mapping2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (mapping2 == null) {
            return MapsKt.emptyMap();
        }
        Map<String, DataFrame.Variable> dfVariables = DataFrameUtil.INSTANCE.variables(data2);
        HashMap result2 = new HashMap();
        Iterable<String> options = Option.Mapping.INSTANCE.getREAL_AES_OPTION_NAMES();
        for (String option : options) {
            Object value = mapping2.get(option);
            if (!(value instanceof String)) continue;
            String asDiscreteVarName = DataMetaUtil.INSTANCE.asDiscreteName$plot_stem(option, (String)value);
            DataFrame.Variable variable = dfVariables.containsKey(asDiscreteVarName) ? (DataFrame.Variable)MapsKt.getValue(dfVariables, (Object)asDiscreteVarName) : (dfVariables.containsKey(value) ? (DataFrame.Variable)MapsKt.getValue(dfVariables, value) : DataFrameUtil.createVariable$default(DataFrameUtil.INSTANCE, (String)value, null, 2, null));
            Aes<?> aes2 = Option.Mapping.INSTANCE.toAes(option);
            ((Map)result2).put(aes2, variable);
        }
        return result2;
    }

    @NotNull
    public final DoubleVector toNumericPair(@NotNull List<?> twoValueList) {
        Intrinsics.checkNotNullParameter(twoValueList, (String)"twoValueList");
        double x2 = 0.0;
        double y2 = 0.0;
        Iterator<?> it = twoValueList.iterator();
        if (it.hasNext()) {
            try {
                x2 = Double.parseDouble("" + it.next());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (it.hasNext()) {
            try {
                y2 = Double.parseDouble("" + it.next());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new DoubleVector(x2, y2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<List<Object>> join$computeMultiKeys(DataFrame dataFrame, List<?> keyVarNames) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = keyVarNames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void keyVarName;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)keyVarName, (String)"null cannot be cast to non-null type kotlin.String");
            collection.add(DataFrameUtil.INSTANCE.findVariableOrFail(dataFrame, (String)keyVarName));
        }
        List keyVars = (List)destination$iv$iv;
        $this$map$iv = (Iterable)RangesKt.until((int)0, (int)dataFrame.rowCount());
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv2;
            int item$iv$iv;
            int keyVarName = item$iv$iv = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = keyVars;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void rowIndex;
                void it;
                DataFrame.Variable variable = (DataFrame.Variable)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(dataFrame.get((DataFrame.Variable)it).get((int)rowIndex));
            }
            collection.add((List)destination$iv$iv2);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean join$containsDuplicates(List<?> $this$join_u24containsDuplicates) {
        return CollectionsKt.toSet((Iterable)$this$join_u24containsDuplicates).size() < $this$join_u24containsDuplicates.size();
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Integer> join$indicesOf(List<?> $this$join_u24indicesOf, boolean restrictRightDuplicates, Object obj) {
        List list2;
        if (restrictRightDuplicates) {
            list2 = CollectionsKt.listOf((Object)$this$join_u24indicesOf.indexOf(obj));
        } else {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = $this$join_u24indicesOf;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void v;
                void i;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Integer n3 = (int)i;
                int it = ((Number)n3).intValue();
                boolean bl2 = false;
                collection.add(Intrinsics.areEqual((Object)v, (Object)obj) ? n3 : null);
            }
            list2 = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        }
        return list2;
    }
}

