/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout.axis.label;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.AxisBreaksProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.BreakLabelsLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.HorizontalFixedBreaksLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.HorizontalFlexBreaksLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.VerticalFixedBreaksLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.VerticalFlexBreaksLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.util.Insets;
import org.jetbrains.letsPlot.core.plot.builder.presentation.LabelSpec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b \u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0004J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0004J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH&J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019H&R\u0014\u0010\u0007\u001a\u00020\b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayout;", "", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "(Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;)V", "isHorizontal", "", "()Z", "labelSpec", "Lorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;", "getLabelSpec", "()Lorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;", "getOrientation", "()Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "getTheme", "()Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "alignToLabelMargin", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "bounds", "applyLabelMargins", "doLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayoutInfo;", "axisDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "axisLength", "", "filterBreaks", "Companion", "plot-builder"})
public abstract class AxisLabelsLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Orientation orientation;
    @NotNull
    private final AxisTheme theme;
    @NotNull
    private final LabelSpec labelSpec;
    @NotNull
    public static final String INITIAL_TICK_LABEL = "0000";
    public static final double MIN_TICK_LABEL_DISTANCE_AUTO = 20.0;
    public static final double MIN_TICK_LABEL_DISTANCE = 8.0;

    protected AxisLabelsLayout(@NotNull Orientation orientation, @NotNull AxisTheme theme2) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        this.orientation = orientation;
        this.theme = theme2;
        this.labelSpec = PlotLabelSpecFactory.INSTANCE.axisTick(this.theme);
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    @NotNull
    public final AxisTheme getTheme() {
        return this.theme;
    }

    @NotNull
    protected final LabelSpec getLabelSpec() {
        return this.labelSpec;
    }

    protected final boolean isHorizontal() {
        return this.orientation.isHorizontal();
    }

    @NotNull
    public abstract AxisLabelsLayoutInfo doLayout(@NotNull DoubleSpan var1, double var2);

    @NotNull
    protected final DoubleRectangle applyLabelMargins(@NotNull DoubleRectangle bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return BreakLabelsLayoutUtil.INSTANCE.applyLabelMargins(bounds, this.theme.showTickMarks() ? this.theme.tickMarkLength() : 0.0, this.theme.tickLabelMargins(), this.orientation);
    }

    @NotNull
    protected final DoubleRectangle alignToLabelMargin(@NotNull DoubleRectangle bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return BreakLabelsLayoutUtil.INSTANCE.alignToLabelMargin(bounds, this.theme.showTickMarks() ? this.theme.tickMarkLength() : 0.0, this.theme.tickLabelMargins(), this.orientation);
    }

    @NotNull
    public abstract AxisLabelsLayout filterBreaks(@NotNull DoubleSpan var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayout$Companion;", "", "()V", "INITIAL_TICK_LABEL", "", "MIN_TICK_LABEL_DISTANCE", "", "MIN_TICK_LABEL_DISTANCE_AUTO", "horizontalFixedBreaks", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayout;", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "breaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "geomAreaInsets", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/util/Insets;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "polar", "", "horizontalFlexBreaks", "breaksProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/AxisBreaksProvider;", "verticalFixedBreaks", "verticalFlexBreaks", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nAxisLabelsLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AxisLabelsLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayout$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AxisLabelsLayout horizontalFlexBreaks(@NotNull Orientation orientation, @NotNull AxisBreaksProvider breaksProvider, @NotNull AxisTheme theme2) {
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            Intrinsics.checkNotNullParameter((Object)breaksProvider, (String)"breaksProvider");
            Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
            if (!orientation.isHorizontal()) {
                boolean $i$a$-require-AxisLabelsLayout$Companion$horizontalFlexBreaks$32 = false;
                String $i$a$-require-AxisLabelsLayout$Companion$horizontalFlexBreaks$32 = orientation.toString();
                throw new IllegalArgumentException($i$a$-require-AxisLabelsLayout$Companion$horizontalFlexBreaks$32.toString());
            }
            if (!(!breaksProvider.isFixedBreaks())) {
                boolean bl = false;
                String string = "fixed breaks";
                throw new IllegalArgumentException(string.toString());
            }
            return new HorizontalFlexBreaksLabelsLayout(orientation, breaksProvider, theme2);
        }

        @NotNull
        public final AxisLabelsLayout horizontalFixedBreaks(@NotNull Orientation orientation, @NotNull ScaleBreaks breaks, @NotNull Insets geomAreaInsets, @NotNull AxisTheme theme2, boolean polar) {
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)geomAreaInsets, (String)"geomAreaInsets");
            Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
            if (!orientation.isHorizontal()) {
                boolean bl = false;
                String string = orientation.toString();
                throw new IllegalArgumentException(string.toString());
            }
            return new HorizontalFixedBreaksLabelsLayout(orientation, breaks, geomAreaInsets, theme2, polar);
        }

        @NotNull
        public final AxisLabelsLayout verticalFlexBreaks(@NotNull Orientation orientation, @NotNull AxisBreaksProvider breaksProvider, @NotNull AxisTheme theme2) {
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            Intrinsics.checkNotNullParameter((Object)breaksProvider, (String)"breaksProvider");
            Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
            if (!(!orientation.isHorizontal())) {
                boolean $i$a$-require-AxisLabelsLayout$Companion$verticalFlexBreaks$32 = false;
                String $i$a$-require-AxisLabelsLayout$Companion$verticalFlexBreaks$32 = orientation.toString();
                throw new IllegalArgumentException($i$a$-require-AxisLabelsLayout$Companion$verticalFlexBreaks$32.toString());
            }
            if (!(!breaksProvider.isFixedBreaks())) {
                boolean bl = false;
                String string = "fixed breaks";
                throw new IllegalArgumentException(string.toString());
            }
            return new VerticalFlexBreaksLabelsLayout(orientation, breaksProvider, theme2);
        }

        @NotNull
        public final AxisLabelsLayout verticalFixedBreaks(@NotNull Orientation orientation, @NotNull ScaleBreaks breaks, @NotNull AxisTheme theme2) {
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
            if (!(!orientation.isHorizontal())) {
                boolean bl = false;
                String string = orientation.toString();
                throw new IllegalArgumentException(string.toString());
            }
            return new VerticalFixedBreaksLabelsLayout(orientation, breaks, theme2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

