/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.StatContext;
import org.jetbrains.letsPlot.core.plot.base.data.TransformVar;
import org.jetbrains.letsPlot.core.plot.base.stat.AbstractDensity2dStat;
import org.jetbrains.letsPlot.core.plot.base.stat.BinStatUtil;
import org.jetbrains.letsPlot.core.plot.base.stat.Contour;
import org.jetbrains.letsPlot.core.plot.base.stat.ContourFillHelper;
import org.jetbrains.letsPlot.core.plot.base.stat.ContourStatUtil;
import org.jetbrains.letsPlot.core.plot.base.stat.DensityStat;
import org.jetbrains.letsPlot.core.plot.base.stat.DensityStatUtil;
import org.jetbrains.letsPlot.core.plot.base.stat.Stats;
import org.jetbrains.letsPlot.core.plot.base.stat.math3.BlockRealMatrix;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001BY\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0011J;\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162!\u0010\u0017\u001a\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u001d0\u0018H\u0016\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/Density2dfStat;", "Lorg/jetbrains/letsPlot/core/plot/base/stat/AbstractDensity2dStat;", "bandWidthX", "", "bandWidthY", "bandWidthMethod", "Lorg/jetbrains/letsPlot/core/plot/base/stat/DensityStat$BandWidthMethod;", "adjust", "kernel", "Lorg/jetbrains/letsPlot/core/plot/base/stat/DensityStat$Kernel;", "nX", "", "nY", "isContour", "", "binCount", "binWidth", "(Ljava/lang/Double;Ljava/lang/Double;Lorg/jetbrains/letsPlot/core/plot/base/stat/DensityStat$BandWidthMethod;DLorg/jetbrains/letsPlot/core/plot/base/stat/DensityStat$Kernel;IIZID)V", "apply", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "data", "statCtx", "Lorg/jetbrains/letsPlot/core/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "plot-base"})
@SourceDebugExtension(value={"SMAP\nDensity2dfStat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Density2dfStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/Density2dfStat\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n766#2:153\n857#2,2:154\n*S KotlinDebug\n*F\n+ 1 Density2dfStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/Density2dfStat\n*L\n48#1:153\n48#1:154,2\n*E\n"})
public final class Density2dfStat
extends AbstractDensity2dStat {
    public Density2dfStat(@Nullable Double bandWidthX, @Nullable Double bandWidthY, @NotNull DensityStat.BandWidthMethod bandWidthMethod, double adjust, @NotNull DensityStat.Kernel kernel2, int nX, int nY, boolean isContour, int binCount, double binWidth) {
        Intrinsics.checkNotNullParameter((Object)((Object)bandWidthMethod), (String)"bandWidthMethod");
        Intrinsics.checkNotNullParameter((Object)((Object)kernel2), (String)"kernel");
        super(bandWidthX, bandWidthY, bandWidthMethod, adjust, kernel2, nX, nY, isContour, binCount, binWidth);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data2, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Aes[] aesArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY()};
        if (!this.hasRequiredValues(data2, aesArray)) {
            return this.withEmptyStatValues();
        }
        List<Double> xs = data2.getNumeric(TransformVar.INSTANCE.getX());
        List<Double> ys = data2.getNumeric(TransformVar.INSTANCE.getY());
        Iterable iterable = CollectionsKt.zip((Iterable)xs, (Iterable)ys);
        boolean $i$f$filter = false;
        void var9_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!SeriesUtil.INSTANCE.allFinite((Double)it.getFirst(), (Double)it.getSecond())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Pair pair2 = CollectionsKt.unzip((Iterable)((List)destination$iv$iv));
        List xVector = (List)pair2.component1();
        List yVector = (List)pair2.component2();
        if (xVector.isEmpty()) {
            return this.withEmptyStatValues();
        }
        if (xVector.size() != yVector.size()) {
            throw new RuntimeException("len(x)= " + xVector.size() + " and len(y)= " + yVector.size() + " doesn't match!");
        }
        DoubleSpan xRange = statCtx.overallXRange();
        DoubleSpan yRange = statCtx.overallYRange();
        ArrayList<Double> statX = new ArrayList<Double>();
        ArrayList<Double> statY = new ArrayList<Double>();
        ArrayList<Double> statDensity2 = new ArrayList<Double>();
        double[] bandWidth = new double[]{this.getBandWidthX(xVector), this.getBandWidthY(yVector)};
        DoubleSpan doubleSpan = xRange;
        Intrinsics.checkNotNull((Object)doubleSpan);
        List<Double> stepsX = DensityStatUtil.INSTANCE.createStepValues(doubleSpan, this.getNX());
        DoubleSpan doubleSpan2 = yRange;
        Intrinsics.checkNotNull((Object)doubleSpan2);
        List<Double> stepsY = DensityStatUtil.INSTANCE.createStepValues(doubleSpan2, this.getNY());
        List<Double> groupWeight = BinStatUtil.INSTANCE.weightVector(xVector.size(), data2);
        BlockRealMatrix matrixX = new BlockRealMatrix(DensityStatUtil.INSTANCE.createRawMatrix(xVector, stepsX, this.getKernelFun(), bandWidth[0], this.getAdjust(), groupWeight));
        BlockRealMatrix matrixY = new BlockRealMatrix(DensityStatUtil.INSTANCE.createRawMatrix(yVector, stepsY, this.getKernelFun(), bandWidth[1], this.getAdjust(), groupWeight));
        BlockRealMatrix matrixFinal = matrixY.multiply(matrixX.transpose());
        int n = this.getNY();
        for (int row = 0; row < n; ++row) {
            int n2 = this.getNX();
            for (int col = 0; col < n2; ++col) {
                statX.add(stepsX.get(col));
                statY.add(stepsY.get(row));
                statDensity2.add(matrixFinal.getEntry(row, col) / SeriesUtil.INSTANCE.sum(groupWeight));
            }
        }
        if (this.isContour()) {
            DoubleSpan zRange = SeriesUtil.INSTANCE.range((Iterable<Double>)statDensity2);
            List<Double> list2 = ContourStatUtil.INSTANCE.computeLevels(zRange, this.getBinOptions());
            if (list2 == null) {
                return DataFrame.Builder.Companion.emptyFrame();
            }
            List<Double> levels = list2;
            Map<Double, List<List<DoubleVector>>> pathListByLevel = ContourStatUtil.INSTANCE.computeContours(xRange, yRange, this.getNX(), this.getNY(), (List<Double>)statDensity2, levels);
            ContourFillHelper helper2 = new ContourFillHelper(xRange, yRange);
            DoubleSpan doubleSpan3 = zRange;
            Intrinsics.checkNotNull((Object)doubleSpan3);
            List<Double> fillLevels = ContourFillHelper.Companion.computeFillLevels(doubleSpan3, levels);
            Map<Double, List<DoubleVector>> polygonListByFillLevel = helper2.createPolygons(pathListByLevel, levels, fillLevels);
            return Contour.Companion.getPolygonDataFrame(fillLevels.subList(1, fillLevels.size()), polygonListByFillLevel);
        }
        return new DataFrame.Builder().putNumeric(Stats.INSTANCE.getX(), (List<Double>)statX).putNumeric(Stats.INSTANCE.getY(), (List<Double>)statY).putNumeric(Stats.INSTANCE.getDENSITY(), (List<Double>)statDensity2).build();
    }
}

