/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.ui;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.aiplayground.models.chat.Chat;
import com.intellij.aiplayground.models.statistic.PlaygroundCollector;
import com.intellij.aiplayground.ui.AIPlaygroundIcons;
import com.intellij.aiplayground.ui.AIPlaygroundUIBundle;
import com.intellij.aiplayground.ui.actions.RemoveChat;
import com.intellij.aiplayground.ui.actions.RenameChat;
import com.intellij.aiplayground.ui.actions.RenameChatKt;
import com.intellij.aiplayground.ui.chat.ChatUiProvider;
import com.intellij.aiplayground.ui.chat.ChatViewModel;
import com.intellij.aiplayground.ui.chat.actions.CreateNewChatAction;
import com.intellij.aiplayground.ui.chat.view.PanelBuilder;
import com.intellij.aiplayground.ui.chat.view.PropertiesViewKt;
import com.intellij.aiplayground.ui.chat.view.RowBuilder;
import com.intellij.aiplayground.ui.history.ChatsHistoryViewModel;
import com.intellij.aiplayground.ui.utils.AiPlaygroundCoroutine;
import com.intellij.aiplayground.ui.utils.GetChatNameKt;
import com.intellij.aiplayground.ui.utils.RegionUtilsKt;
import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.dsl.listCellRenderer.LcrInitParams;
import com.intellij.ui.dsl.listCellRenderer.LcrRow;
import com.intellij.ui.dsl.listCellRenderer.LcrTextInitParams;
import com.intellij.ui.dsl.listCellRenderer.LcrTextSpeedSearchParams;
import com.intellij.util.IconUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/aiplayground/ui/AIPlaygroundToolWindowFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "<init>", "()V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "isDumbAware", "", "isApplicableAsync", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createToolWindowContent", "", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "intellij.aiplayground.ui"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nAIPlaygroundToolWindowFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIPlaygroundToolWindowFactory.kt\ncom/intellij/aiplayground/ui/AIPlaygroundToolWindowFactory\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,215:1\n40#2,3:216\n*S KotlinDebug\n*F\n+ 1 AIPlaygroundToolWindowFactory.kt\ncom/intellij/aiplayground/ui/AIPlaygroundToolWindowFactory\n*L\n69#1:216,3\n*E\n"})
public final class AIPlaygroundToolWindowFactory
implements ToolWindowFactory {
    public static final int $stable;

    @NotNull
    public Icon getIcon() {
        Icon icon = AIPlaygroundIcons.ToolWindowAIPlayground_20x20;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ToolWindowAIPlayground_20x20");
        return icon;
    }

    public boolean isDumbAware() {
        return true;
    }

    @Nullable
    public Object isApplicableAsync(@NotNull Project project, @NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((!RegionUtilsKt.isChinaRegion() ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        void it;
        JComponent jComponent;
        void $this$createToolWindowContent_u24lambda_u2428_u24lambda_u2427;
        JPanel jPanel;
        JBScrollPane jBScrollPane;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        ContentFactory contentFactory = ContentFactory.getInstance();
        boolean $i$f$service = false;
        Class<AiPlaygroundCoroutine> serviceClass$iv = AiPlaygroundCoroutine.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        CoroutineScope coroutineScope = ((AiPlaygroundCoroutine)object).getCoroutineScope();
        ChatsHistoryViewModel chatHistoryViewModel = new ChatsHistoryViewModel(project, coroutineScope);
        CoroutineScope viewScope = CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)"AIPlaygroundToolWindowFactory", null, (boolean)false, (int)6, null);
        JBList list2 = new JBList();
        list2.setCellRenderer(BuilderKt.listCellRenderer(AIPlaygroundToolWindowFactory::createToolWindowContent$lambda$3));
        list2.addMouseListener((MouseListener)new MouseAdapter((JBList<Chat>)list2, project){
            final /* synthetic */ JBList<Chat> $list;
            final /* synthetic */ Project $project;
            {
                this.$list = $list;
                this.$project = $project;
            }

            public void mouseClicked(MouseEvent e) {
                int selectedIndex;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getClickCount() == 2 && (selectedIndex = this.$list.locationToIndex(e.getPoint())) >= 0) {
                    Chat selectedChat = (Chat)this.$list.getModel().getElementAt(selectedIndex);
                    boolean $i$f$service = false;
                    Class<AiPlaygroundCoroutine> serviceClass$iv = AiPlaygroundCoroutine.class;
                    Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                    }
                    BuildersKt.launch$default((CoroutineScope)((AiPlaygroundCoroutine)object).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project, selectedChat, null){
                        int label;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ Chat $selectedChat;
                        {
                            this.$project = $project;
                            this.$selectedChat = $selectedChat;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    ComponentManager $this$service$iv = (ComponentManager)this.$project;
                                    boolean $i$f$service = false;
                                    Class<ChatUiProvider> serviceClass$iv = ChatUiProvider.class;
                                    Object object2 = $this$service$iv.getService(serviceClass$iv);
                                    if (object2 == null) {
                                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                                    }
                                    ChatUiProvider chatUiProvider = (ChatUiProvider)object2;
                                    Chat chat = this.$selectedChat;
                                    Intrinsics.checkNotNull((Object)chat);
                                    this.label = 1;
                                    Object object3 = chatUiProvider.openChat(chat, (Continuation<? super ChatViewModel>)((Continuation)this));
                                    if (object3 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            }
        });
        list2.addMouseListener((MouseListener)new MouseAdapter((JBList<Chat>)list2){
            final /* synthetic */ JBList<Chat> $list;
            {
                this.$list = $list;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SwingUtilities.isRightMouseButton(e)) {
                    Object[] objectArray = new DumbAwareAction[]{new RenameChat(), new RemoveChat()};
                    ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new DefaultActionGroup(CollectionsKt.listOf((Object[])objectArray)), DataManager.getInstance().getDataContext((Component)this.$list), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
                    Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
                    ListPopup popup = listPopup;
                    popup.show(new RelativePoint((Component)this.$list, e.getPoint()));
                }
            }
        });
        JPanel panel = new JPanel(new CardLayout());
        JBScrollPane $this$createToolWindowContent_u24lambda_u245 = jBScrollPane = new JBScrollPane((Component)UiDataProvider.Companion.wrapComponent((JComponent)list2, arg_0 -> AIPlaygroundToolWindowFactory.createToolWindowContent$lambda$4(list2, arg_0)));
        boolean bl = false;
        $this$createToolWindowContent_u24lambda_u245.setBorder((Border)JBUI.Borders.empty());
        JBScrollPane listRoot = jBScrollPane;
        JBColor iconColor = new JBColor(-13273872, -11236617);
        JPanel $this$createToolWindowContent_u24lambda_u2428 = bl = new JPanel(new BorderLayout());
        boolean bl2 = false;
        JPanel jPanel2 = jPanel = new JPanel();
        JPanel jPanel3 = $this$createToolWindowContent_u24lambda_u2428;
        boolean bl3 = false;
        $this$createToolWindowContent_u24lambda_u2428_u24lambda_u2427.setLayout(new BoxLayout((Container)$this$createToolWindowContent_u24lambda_u2428_u24lambda_u2427, 0));
        $this$createToolWindowContent_u24lambda_u2428_u24lambda_u2427.setBorder(JBUI.Borders.empty((int)32));
        JComponent jComponent2 = jComponent = PropertiesViewKt.panel((Function1<? super PanelBuilder, Unit>)((Function1)arg_0 -> AIPlaygroundToolWindowFactory.createToolWindowContent$lambda$28$lambda$27$lambda$25((JPanel)$this$createToolWindowContent_u24lambda_u2428_u24lambda_u2427, iconColor, chatHistoryViewModel, arg_0)));
        void var21_23 = $this$createToolWindowContent_u24lambda_u2428_u24lambda_u2427;
        boolean bl4 = false;
        it.setAlignmentY(0.5f);
        var21_23.add(jComponent);
        jPanel3.add((Component)jPanel, "Center");
        JPanel emptyRoot = bl;
        panel.add((Component)emptyRoot, "empty");
        panel.add((Component)listRoot, "list");
        Content content = contentFactory.createContent((JComponent)panel, "", false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        toolWindow.getContentManager().addContent(content2);
        toolWindow.setTitleActions(CollectionsKt.listOf((Object)((Object)new CreateNewChatAction())));
        toolWindow.getComponent().putClientProperty(ToolWindowContentUi.DONT_HIDE_TOOLBAR_IN_HEADER, true);
        PlaygroundCollector.INSTANCE.logToolWindowOpened();
        BuildersKt.launch$default((CoroutineScope)viewScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(chatHistoryViewModel, (JBList<Chat>)list2, panel, null){
            int label;
            final /* synthetic */ ChatsHistoryViewModel $chatHistoryViewModel;
            final /* synthetic */ JBList<Chat> $list;
            final /* synthetic */ JPanel $panel;
            {
                this.$chatHistoryViewModel = $chatHistoryViewModel;
                this.$list = $list;
                this.$panel = $panel;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$chatHistoryViewModel.getAvailableChats().collect(new FlowCollector(this.$list, this.$panel){
                            final /* synthetic */ JBList<Chat> $list;
                            final /* synthetic */ JPanel $panel;
                            {
                                this.$list = $list;
                                this.$panel = $panel;
                            }

                            public final Object emit(List<Chat> chats, Continuation<? super Unit> $completion) {
                                Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$list, chats, this.$panel, null){
                                    int label;
                                    final /* synthetic */ JBList<Chat> $list;
                                    final /* synthetic */ List<Chat> $chats;
                                    final /* synthetic */ JPanel $panel;
                                    {
                                        this.$list = $list;
                                        this.$chats = $chats;
                                        this.$panel = $panel;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                Collection $this$toTypedArray$iv = this.$chats;
                                                boolean $i$f$toTypedArray = false;
                                                Collection thisCollection$iv = $this$toTypedArray$iv;
                                                this.$list.setListData((Object[])thisCollection$iv.toArray(new Chat[0]));
                                                if (this.$chats.isEmpty()) {
                                                    LayoutManager layoutManager = this.$panel.getLayout();
                                                    Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.CardLayout");
                                                    ((CardLayout)layoutManager).show(this.$panel, "empty");
                                                } else {
                                                    LayoutManager layoutManager = this.$panel.getLayout();
                                                    Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.CardLayout");
                                                    ((CardLayout)layoutManager).show(this.$panel, "list");
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final Unit createToolWindowContent$lambda$3$lambda$1$lambda$0(LcrTextSpeedSearchParams $this$speedSearch) {
        Intrinsics.checkNotNullParameter((Object)$this$speedSearch, (String)"$this$speedSearch");
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$3$lambda$1(LcrTextInitParams $this$text) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
        $this$text.setAlign(LcrInitParams.Align.LEFT);
        $this$text.speedSearch(AIPlaygroundToolWindowFactory::createToolWindowContent$lambda$3$lambda$1$lambda$0);
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$3$lambda$2(LcrTextInitParams $this$text) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
        $this$text.setForeground($this$text.getGreyForeground());
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$3(LcrRow $this$listCellRenderer) {
        Intrinsics.checkNotNullParameter((Object)$this$listCellRenderer, (String)"$this$listCellRenderer");
        $this$listCellRenderer.text(GetChatNameKt.getChatName(((Chat)$this$listCellRenderer.getValue()).getTitle()), AIPlaygroundToolWindowFactory::createToolWindowContent$lambda$3$lambda$1);
        String string = DateFormatUtil.formatPrettyDateTime((long)((Chat)$this$listCellRenderer.getValue()).getUpdatedAt());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatPrettyDateTime(...)");
        $this$listCellRenderer.text(string, AIPlaygroundToolWindowFactory::createToolWindowContent$lambda$3$lambda$2);
        return Unit.INSTANCE;
    }

    private static final void createToolWindowContent$lambda$4(JBList $list, DataSink it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set(RenameChatKt.getCHAT(), $list.getSelectedValue());
    }

    private static final Unit createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$7$lambda$6(JPanel $this_apply, JLabel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setFont($this_apply.getFont().deriveFont((float)JBUI.scale((int)16)));
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$7(JPanel $this_apply, RowBuilder $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(AIPlaygroundUIBundle.message("label.welcome.to.ai.playground", new Object[0]), (Function1<? super JLabel, Unit>)((Function1)arg_0 -> AIPlaygroundToolWindowFactory.createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$7$lambda$6($this_apply, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$8(JBColor $iconColor, RowBuilder $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon = AllIcons.Nodes.Plugin;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Plugin");
        $this$row.icon(IconUtil.colorize$default((Icon)icon, (Color)((Color)$iconColor), (boolean)false, (boolean)false, (int)12, null));
        RowBuilder.text$default($this$row, AIPlaygroundUIBundle.message("label.create.new.playground", new Object[0]), null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$10$lambda$9(JLabel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$10(RowBuilder $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.placeholder();
        $this$row.text(AIPlaygroundUIBundle.message("label.connect.your.own.openai.anthropic.or.mistral.api.tokens", new Object[0]), (Function1<? super JLabel, Unit>)((Function1)AIPlaygroundToolWindowFactory::createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$10$lambda$9));
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$11(JBColor $iconColor, RowBuilder $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon = AllIcons.Actions.OfflineMode;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"OfflineMode");
        $this$row.icon(IconUtil.colorize$default((Icon)icon, (Color)((Color)$iconColor), (boolean)false, (boolean)false, (int)12, null));
        RowBuilder.text$default($this$row, AIPlaygroundUIBundle.message("label.run.local.models.with.ollama", new Object[0]), null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$13$lambda$12(JLabel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$13(RowBuilder $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.placeholder();
        $this$row.text(AIPlaygroundUIBundle.message("label.use.offline.llms.locally.for.secure.or.private.workflows", new Object[0]), (Function1<? super JLabel, Unit>)((Function1)AIPlaygroundToolWindowFactory::createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$13$lambda$12));
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$14(JBColor $iconColor, RowBuilder $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon = AllIcons.Actions.Diff;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Diff");
        $this$row.icon(IconUtil.colorize$default((Icon)icon, (Color)((Color)$iconColor), (boolean)false, (boolean)false, (int)12, null));
        RowBuilder.text$default($this$row, AIPlaygroundUIBundle.message("label.compare.multiple.models", new Object[0]), null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$16$lambda$15(JLabel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$16(RowBuilder $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.placeholder();
        $this$row.text(AIPlaygroundUIBundle.message("label.prompt.up.to.five.models.at.once.compare.responses.side.by.side", new Object[0]), (Function1<? super JLabel, Unit>)((Function1)AIPlaygroundToolWindowFactory::createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$16$lambda$15));
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$17(JBColor $iconColor, RowBuilder $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon = AIPlaygroundIcons.AudioToAudio;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AudioToAudio");
        $this$row.icon(IconUtil.colorize$default((Icon)icon, (Color)((Color)$iconColor), (boolean)false, (boolean)false, (int)12, null));
        RowBuilder.text$default($this$row, AIPlaygroundUIBundle.message("label.tune.your.prompts", new Object[0]), null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$19$lambda$18(JLabel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$19(RowBuilder $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.placeholder();
        $this$row.text(AIPlaygroundUIBundle.message("label.customize.temperature.max.tokens.top.p.system.prompts", new Object[0]), (Function1<? super JLabel, Unit>)((Function1)AIPlaygroundToolWindowFactory::createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$19$lambda$18));
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20(JBColor $iconColor, PanelBuilder $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row((Function1<? super RowBuilder, Unit>)((Function1)arg_0 -> AIPlaygroundToolWindowFactory.createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$8($iconColor, arg_0)));
        $this$panel.row((Function1<? super RowBuilder, Unit>)((Function1)AIPlaygroundToolWindowFactory::createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$10));
        $this$panel.row((Function1<? super RowBuilder, Unit>)((Function1)arg_0 -> AIPlaygroundToolWindowFactory.createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$11($iconColor, arg_0)));
        $this$panel.row((Function1<? super RowBuilder, Unit>)((Function1)AIPlaygroundToolWindowFactory::createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$13));
        $this$panel.row((Function1<? super RowBuilder, Unit>)((Function1)arg_0 -> AIPlaygroundToolWindowFactory.createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$14($iconColor, arg_0)));
        $this$panel.row((Function1<? super RowBuilder, Unit>)((Function1)AIPlaygroundToolWindowFactory::createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$16));
        $this$panel.row((Function1<? super RowBuilder, Unit>)((Function1)arg_0 -> AIPlaygroundToolWindowFactory.createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$17($iconColor, arg_0)));
        $this$panel.row((Function1<? super RowBuilder, Unit>)((Function1)AIPlaygroundToolWindowFactory::createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20$lambda$19));
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21(JBColor $iconColor, RowBuilder $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell(PropertiesViewKt.panel((Function1<? super PanelBuilder, Unit>)((Function1)arg_0 -> AIPlaygroundToolWindowFactory.createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21$lambda$20($iconColor, arg_0))));
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$24$lambda$22(JButton it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.putClientProperty(DarculaButtonUI.DEFAULT_STYLE_KEY, true);
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$24$lambda$23(ChatsHistoryViewModel $chatHistoryViewModel, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $chatHistoryViewModel.newChat();
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$24(ChatsHistoryViewModel $chatHistoryViewModel, RowBuilder $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.button(AIPlaygroundUIBundle.message("button.create.playground", new Object[0]), (Function1<? super JButton, Unit>)((Function1)AIPlaygroundToolWindowFactory::createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$24$lambda$22), (Function1<? super ActionEvent, Unit>)((Function1)arg_0 -> AIPlaygroundToolWindowFactory.createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$24$lambda$23($chatHistoryViewModel, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit createToolWindowContent$lambda$28$lambda$27$lambda$25(JPanel $this_apply, JBColor $iconColor, ChatsHistoryViewModel $chatHistoryViewModel, PanelBuilder $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row((Function1<? super RowBuilder, Unit>)((Function1)arg_0 -> AIPlaygroundToolWindowFactory.createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$7($this_apply, arg_0)));
        $this$panel.row((Function1<? super RowBuilder, Unit>)((Function1)arg_0 -> AIPlaygroundToolWindowFactory.createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$21($iconColor, arg_0)));
        $this$panel.row((Function1<? super RowBuilder, Unit>)((Function1)arg_0 -> AIPlaygroundToolWindowFactory.createToolWindowContent$lambda$28$lambda$27$lambda$25$lambda$24($chatHistoryViewModel, arg_0)));
        return Unit.INSTANCE;
    }
}

