/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.profiler.AbstractProfilerToolWindowPanel;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.PerformanceHintsManager;
import com.intellij.profiler.ProfilerDumpPanel;
import com.intellij.profiler.ProfilerProcessPanel;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.ProfilerToolWindowManagerKt;
import com.intellij.profiler.ShowProfilerNotificationAction;
import com.intellij.profiler.TabNameFormatToggleAction;
import com.intellij.profiler.ToolWindowActivationProperties;
import com.intellij.profiler.api.Attached;
import com.intellij.profiler.api.DataReady;
import com.intellij.profiler.api.ProfilerError;
import com.intellij.profiler.api.ProfilerErrorWithContext;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ContentsUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a9\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0016\b\u0007\u0018\u0000 M2\u00020\u0001:\u0001MB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019J\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020!J\u001c\u0010\"\u001a\u00020\u001b2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\b\b\u0002\u0010%\u001a\u00020!J\u001a\u0010\"\u001a\u00020\u001b2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020!H\u0002J\u0014\u0010*\u001a\u00020+2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0003J\u0014\u0010,\u001a\u00020+2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0003J\u0018\u0010-\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020.2\b\b\u0002\u0010 \u001a\u00020!J\u0018\u0010-\u001a\u00020/2\u0006\u00100\u001a\u0002012\b\b\u0001\u0010*\u001a\u00020+J\u0013\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020/03\u00a2\u0006\u0002\u00104J\b\u00105\u001a\u0004\u0018\u00010/J\u0010\u00106\u001a\u00020\u001b2\b\b\u0001\u00107\u001a\u00020+J\u0010\u00108\u001a\u00020\u001b2\b\b\u0001\u00107\u001a\u00020+J\u0010\u00109\u001a\u00020\u001b2\b\b\u0001\u00107\u001a\u00020+J.\u0010:\u001a\u00020\u001b2\b\b\u0001\u00107\u001a\u00020+2\u0006\u0010;\u001a\u00020<2\u0014\b\u0002\u0010=\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020\u001b0>J8\u0010:\u001a\u00020\u001b2\b\b\u0001\u0010@\u001a\u00020+2\b\b\u0001\u00107\u001a\u00020+2\u0006\u0010;\u001a\u00020A2\u0014\b\u0002\u0010=\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020\u001b0>JK\u0010B\u001a\u00020\u001b2\n\b\u0001\u0010@\u001a\u0004\u0018\u00010+2\b\b\u0001\u0010C\u001a\u00020+2\u0006\u0010;\u001a\u00020A2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0012\u0010D\u001a\n\u0012\u0006\b\u0001\u0012\u00020E03\"\u00020EH\u0002\u00a2\u0006\u0002\u0010FJ\u001c\u0010G\u001a\u00020!2\u0006\u0010H\u001a\u00020\u00192\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0002J\u001c\u0010I\u001a\u0004\u0018\u00010/2\u0006\u0010H\u001a\u00020\u00192\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$J\u0010\u0010I\u001a\u0004\u0018\u00010/2\u0006\u0010J\u001a\u00020KJ\u000e\u0010L\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020/R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR#\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017\u00a8\u0006N"}, d2={"Lcom/intellij/profiler/ProfilerToolWindowManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "baseIcon", "Ljavax/swing/Icon;", "getBaseIcon", "()Ljavax/swing/Icon;", "toolWindowGroup", "Lcom/intellij/notification/NotificationGroup;", "kotlin.jvm.PlatformType", "getToolWindowGroup", "()Lcom/intellij/notification/NotificationGroup;", "toolWindowGroup$delegate", "Lkotlin/Lazy;", "myActiveSessionsCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "myListenerAdded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "myListener", "com/intellij/profiler/ProfilerToolWindowManager$myListener$1", "Lcom/intellij/profiler/ProfilerToolWindowManager$myListener$1;", "getToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "initToolWindow", "", "toolWindow", "addProfilerDumpTab", "panel", "Lcom/intellij/profiler/ProfilerDumpPanel;", "activate", "", "addProfilerProcessTab", "profilerProcess", "Lcom/intellij/profiler/api/ProfilerProcess;", "activateToolWindow", "properties", "Lcom/intellij/profiler/ToolWindowActivationProperties;", "updateToolWindowIcon", "hasRunningSessions", "tabName", "", "tabDescription", "addTab", "Lcom/intellij/profiler/AbstractProfilerToolWindowPanel;", "Lcom/intellij/ui/content/Content;", "component", "Ljavax/swing/JComponent;", "getAllTabs", "", "()[Lcom/intellij/ui/content/Content;", "getCurrentTab", "showWarningBalloon", "message", "showInfoBalloon", "showErrorBalloon", "showBalloon", "type", "Lcom/intellij/openapi/ui/MessageType;", "beforeNotify", "Lkotlin/Function1;", "Lcom/intellij/notification/Notification;", "title", "Lcom/intellij/notification/NotificationType;", "showOpenProfilerTabBalloon", "content", "additionalActions", "Lcom/intellij/notification/NotificationAction;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/notification/NotificationType;Lcom/intellij/profiler/api/ProfilerProcess;[Lcom/intellij/notification/NotificationAction;)V", "twIsVisibleAndThisProcessTabSelected", "tw", "findToolWindowContent", "file", "Ljava/io/File;", "openExistingTab", "Companion", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nProfilerToolWindowManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerToolWindowManager.kt\ncom/intellij/profiler/ProfilerToolWindowManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,340:1\n11228#2:341\n11563#2,3:342\n1163#3,3:345\n*S KotlinDebug\n*F\n+ 1 ProfilerToolWindowManager.kt\ncom/intellij/profiler/ProfilerToolWindowManager\n*L\n84#1:341\n84#1:342,3\n162#1:345,3\n*E\n"})
public final class ProfilerToolWindowManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy toolWindowGroup$delegate;
    @NotNull
    private AtomicInteger myActiveSessionsCounter;
    @NotNull
    private final AtomicBoolean myListenerAdded;
    @NotNull
    private final myListener.1 myListener;
    @NotNull
    public static final String TOOLWINDOW_ID = "Profiler";

    public ProfilerToolWindowManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.toolWindowGroup$delegate = LazyKt.lazy(ProfilerToolWindowManager::toolWindowGroup_delegate$lambda$0);
        this.myActiveSessionsCounter = new AtomicInteger(0);
        this.myListenerAdded = new AtomicBoolean(false);
        this.myListener = new ContentManagerListener(this){
            final /* synthetic */ ProfilerToolWindowManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                PerformanceHintsManager performanceHintsManager = PerformanceHintsManager.Companion.getInstance(ProfilerToolWindowManager.access$getProject$p(this.this$0));
                JComponent jComponent = event.getContent().getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                ContentManagerEvent.ContentOperation contentOperation = event.getOperation();
                Intrinsics.checkNotNullExpressionValue((Object)contentOperation, (String)"getOperation(...)");
                performanceHintsManager.onProfilerDumpSelectionChange(jComponent, contentOperation);
            }
        };
    }

    private final Icon getBaseIcon() {
        Icon icon = AllIcons.Toolwindows.ToolWindowProfiler;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ToolWindowProfiler");
        return icon;
    }

    private final NotificationGroup getToolWindowGroup() {
        Lazy lazy = this.toolWindowGroup$delegate;
        return (NotificationGroup)lazy.getValue();
    }

    private final ToolWindow getToolWindow() {
        ToolWindow toolWindow;
        ToolWindowManager manager = ToolWindowManager.Companion.getInstance(this.project);
        ToolWindow toolWindow2 = manager.getToolWindow(TOOLWINDOW_ID);
        if (toolWindow2 == null) {
            ToolWindow toolWindow3;
            ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"BOTTOM");
            ToolWindow it = toolWindow3 = manager.registerToolWindow(new RegisterToolWindowTask(TOOLWINDOW_ID, toolWindowAnchor, null, false, false, false, false, null, null, CommonProfilerBundleKt.profilerMessagePointer("profiler.configurable.name", new Object[0]), 508, null));
            boolean bl = false;
            this.initToolWindow(it);
            ContentManagerWatcher.watchContentManager((ToolWindow)it, (ContentManager)it.getContentManager());
            toolWindow2 = toolWindow3;
        }
        ToolWindow it = toolWindow = toolWindow2;
        boolean bl = false;
        if (this.myListenerAdded.compareAndSet(false, true)) {
            it.getContentManager().addContentManagerListener((ContentManagerListener)this.myListener);
        }
        return toolWindow;
    }

    /*
     * WARNING - void declaration
     */
    public final void initToolWindow(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        toolWindow.setIcon(this.getBaseIcon());
        toolWindow.setToHideOnEmptyContent(false);
        if (toolWindow instanceof ToolWindowEx) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            DefaultActionGroup defaultActionGroup;
            DefaultActionGroup $this$initToolWindow_u24lambda_u244 = defaultActionGroup = new DefaultActionGroup(CommonProfilerBundleKt.profilerMessage("ui.tabs.format.name", new Object[0]), true);
            boolean bl = false;
            CommonProfilerUiOptions.TabNameFormat[] tabNameFormatArray = CommonProfilerUiOptions.TabNameFormat.values();
            DefaultActionGroup defaultActionGroup2 = $this$initToolWindow_u24lambda_u244;
            boolean $i$f$map = false;
            void var9_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var15_14 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                ContentManager contentManager = ((ToolWindowEx)toolWindow).getContentManager();
                Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
                collection.add(new TabNameFormatToggleAction((CommonProfilerUiOptions.TabNameFormat)it, contentManager));
            }
            defaultActionGroup2.addAll((Collection)((List)destination$iv$iv));
            DefaultActionGroup tabFormatGroup = defaultActionGroup;
            toolWindow.setAdditionalGearActions((ActionGroup)tabFormatGroup);
        }
    }

    public final void addProfilerDumpTab(@NotNull ProfilerDumpPanel panel2, boolean activate) {
        Intrinsics.checkNotNullParameter((Object)((Object)panel2), (String)"panel");
        this.addTab(panel2, activate);
    }

    public static /* synthetic */ void addProfilerDumpTab$default(ProfilerToolWindowManager profilerToolWindowManager, ProfilerDumpPanel profilerDumpPanel, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        profilerToolWindowManager.addProfilerDumpTab(profilerDumpPanel, bl);
    }

    public final void addProfilerProcessTab(@NotNull ProfilerProcess<?> profilerProcess, boolean activateToolWindow) {
        Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
        this.addProfilerProcessTab(profilerProcess, new ToolWindowActivationProperties(activateToolWindow, false, null, 6, null));
    }

    public static /* synthetic */ void addProfilerProcessTab$default(ProfilerToolWindowManager profilerToolWindowManager, ProfilerProcess profilerProcess, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        profilerToolWindowManager.addProfilerProcessTab(profilerProcess, bl);
    }

    public final void addProfilerProcessTab(@NotNull ProfilerProcess<?> profilerProcess, @NotNull ToolWindowActivationProperties properties) {
        Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        profilerProcess.addStateChangedListener((Function2<ProfilerState, ProfilerState, Unit>)((Function2)(arg_0, arg_1) -> ProfilerToolWindowManager.addProfilerProcessTab$lambda$5(this, profilerProcess, properties, arg_0, arg_1)));
        String tabName = this.tabName(profilerProcess);
        String tabDescription = this.tabDescription(profilerProcess);
        UIUtil.invokeLaterIfNeeded(() -> ProfilerToolWindowManager.addProfilerProcessTab$lambda$7(this, profilerProcess, tabName, properties, tabDescription));
        profilerProcess.startNotify();
    }

    private final void updateToolWindowIcon(boolean hasRunningSessions) {
        Icon newIcon = hasRunningSessions ? RunContentManagerImpl.Companion.getLiveIndicator(this.getBaseIcon()) : this.getBaseIcon();
        UIUtil.invokeLaterIfNeeded(() -> ProfilerToolWindowManager.updateToolWindowIcon$lambda$8(this, newIcon));
    }

    @NlsSafe
    private final String tabName(ProfilerProcess<?> profilerProcess) {
        String string = DateFormatUtil.formatDateTime((long)profilerProcess.getAttachedTimestamp());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDateTime(...)");
        String suffix = string;
        return profilerProcess.getTargetProcess().getShortName() + " " + suffix;
    }

    @Nls
    private final String tabDescription(ProfilerProcess<?> profilerProcess) {
        String string;
        String profilerConfigurationName = profilerProcess.getProfilerConfiguration().getDisplayName();
        String target = profilerProcess.getTargetProcess().getFullName();
        Object[] objectArray = (Object[])profilerConfigurationName;
        if (objectArray == null || objectArray.length() == 0) {
            string = target;
        } else {
            objectArray = new Object[]{target, profilerConfigurationName};
            string = CommonProfilerBundleKt.profilerMessage("profiler.with.configuration.tab.title", objectArray);
        }
        String oldTabNameFormat = string;
        String string2 = new HtmlBuilder().append((HtmlChunk)HtmlChunk.div((String)"white-space: nowrap").addText(oldTabNameFormat)).wrapWithHtmlBody().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public final void addTab(@NotNull AbstractProfilerToolWindowPanel panel2, boolean activate) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)panel2), (String)"panel");
        Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])this.getAllTabs()), ProfilerToolWindowManager::addTab$lambda$9);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Content content = (Content)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getDisplayName());
        }
        HashSet existingNames = (HashSet)destination$iv;
        ToolWindow toolWindow = this.getToolWindow();
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        ContentsUtil.addContent((ContentManager)contentManager2, (Content)panel2.getContent(), (boolean)true);
        panel2.onPanelAdd();
        if (activate) {
            toolWindow.activate(null);
        }
        panel2.getContent().setDisplayName(ProfilerToolWindowManagerKt.access$formatTabName(((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getTabNameFormat(), panel2.getTabName(), panel2.getTime(), existingNames));
    }

    public static /* synthetic */ void addTab$default(ProfilerToolWindowManager profilerToolWindowManager, AbstractProfilerToolWindowPanel abstractProfilerToolWindowPanel, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        profilerToolWindowManager.addTab(abstractProfilerToolWindowPanel, bl);
    }

    @NotNull
    public final Content addTab(@NotNull JComponent component, @NlsContexts.TabTitle @NotNull String tabName) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        ContentManager contentManager = this.getToolWindow().getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager cm = contentManager;
        Content content = ContentFactory.getInstance().createContent(component, tabName, true);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        ContentsUtil.addContent((ContentManager)cm, (Content)content2, (boolean)true);
        return content2;
    }

    @NotNull
    public final Content[] getAllTabs() {
        Content[] contentArray = this.getToolWindow().getContentManager().getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        return contentArray;
    }

    @Nullable
    public final Content getCurrentTab() {
        return this.getToolWindow().getContentManager().getSelectedContent();
    }

    public final void showWarningBalloon(@NlsContexts.NotificationContent @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        NotificationGroup notificationGroup = this.getToolWindowGroup();
        MessageType messageType = MessageType.WARNING;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"WARNING");
        notificationGroup.createNotification(message, messageType).notify(this.project);
    }

    public final void showInfoBalloon(@NlsContexts.NotificationContent @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        NotificationGroup notificationGroup = this.getToolWindowGroup();
        MessageType messageType = MessageType.INFO;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
        notificationGroup.createNotification(message, messageType).notify(this.project);
    }

    public final void showErrorBalloon(@NlsContexts.NotificationContent @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        NotificationGroup notificationGroup = this.getToolWindowGroup();
        MessageType messageType = MessageType.ERROR;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"ERROR");
        notificationGroup.createNotification(message, messageType).notify(this.project);
    }

    public final void showBalloon(@NlsContexts.NotificationContent @NotNull String message, @NotNull MessageType type, @NotNull Function1<? super Notification, Unit> beforeNotify) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(beforeNotify, (String)"beforeNotify");
        Notification notification = this.getToolWindowGroup().createNotification(message, type);
        beforeNotify.invoke((Object)notification);
        notification.notify(this.project);
    }

    public static /* synthetic */ void showBalloon$default(ProfilerToolWindowManager profilerToolWindowManager, String string, MessageType messageType, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = ProfilerToolWindowManager::showBalloon$lambda$11;
        }
        profilerToolWindowManager.showBalloon(string, messageType, (Function1<? super Notification, Unit>)function1);
    }

    public final void showBalloon(@NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message, @NotNull NotificationType type, @NotNull Function1<? super Notification, Unit> beforeNotify) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(beforeNotify, (String)"beforeNotify");
        Notification notification = this.getToolWindowGroup().createNotification(title, message, type);
        beforeNotify.invoke((Object)notification);
        notification.notify(this.project);
    }

    public static /* synthetic */ void showBalloon$default(ProfilerToolWindowManager profilerToolWindowManager, String string, String string2, NotificationType notificationType, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = ProfilerToolWindowManager::showBalloon$lambda$12;
        }
        profilerToolWindowManager.showBalloon(string, string2, notificationType, (Function1<? super Notification, Unit>)function1);
    }

    private final void showOpenProfilerTabBalloon(@NlsContexts.NotificationTitle String title, @NlsContexts.NotificationContent String content, NotificationType type, ProfilerProcess<?> profilerProcess, NotificationAction ... additionalActions) {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow(TOOLWINDOW_ID);
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        if (this.twIsVisibleAndThisProcessTabSelected(toolWindow2, profilerProcess)) {
            return;
        }
        ShowProfilerNotificationAction openAction = new ShowProfilerNotificationAction(this.project, profilerProcess);
        Notification notification = title != null ? this.getToolWindowGroup().createNotification(title, content, type) : this.getToolWindowGroup().createNotification(content, type);
        notification.addAction((AnAction)openAction);
        for (NotificationAction action : additionalActions) {
            notification.addAction((AnAction)action);
        }
        notification.notify(this.project);
    }

    private final boolean twIsVisibleAndThisProcessTabSelected(ToolWindow tw, ProfilerProcess<?> profilerProcess) {
        if (!tw.isVisible()) {
            return false;
        }
        Content content = this.findToolWindowContent(tw, profilerProcess);
        if (content == null) {
            return false;
        }
        Content tab = content;
        return Intrinsics.areEqual((Object)tw.getContentManager().getSelectedContent(), (Object)tab);
    }

    @Nullable
    public final Content findToolWindowContent(@NotNull ToolWindow tw, @NotNull ProfilerProcess<?> profilerProcess) {
        Intrinsics.checkNotNullParameter((Object)tw, (String)"tw");
        Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
        return ProfilerToolWindowManagerKt.findToolWindowContent(tw, profilerProcess);
    }

    @Nullable
    public final Content findToolWindowContent(@NotNull File file) {
        Object object;
        block1: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Content[] contentArray = this.getToolWindow().getContentManager().getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            for (Object object2 : (Object[])contentArray) {
                File snapshotFile;
                JComponent comp;
                Content it = (Content)object2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getComponent(), (String)"getComponent(...)");
                if (!(!(comp instanceof ProfilerDumpPanel) ? false : (((ProfilerDumpPanel)((Object)comp)).getSnapshotFile() == null ? false : snapshotFile.exists() && Files.isSameFile(snapshotFile.toPath(), file.toPath())))) continue;
                object = object2;
                break block1;
            }
            object = null;
        }
        return (Content)object;
    }

    public final void openExistingTab(@NotNull Content content) {
        ToolWindow toolWindow;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ToolWindow $this$openExistingTab_u24lambda_u2414 = toolWindow = this.getToolWindow();
        boolean bl = false;
        $this$openExistingTab_u24lambda_u2414.show();
        $this$openExistingTab_u24lambda_u2414.getContentManager().setSelectedContent(content);
    }

    private static final NotificationGroup toolWindowGroup_delegate$lambda$0() {
        return NotificationGroupManager.getInstance().getNotificationGroup("ProfilerBalloon");
    }

    private static final Unit addProfilerProcessTab$lambda$5(ProfilerToolWindowManager this$0, ProfilerProcess $profilerProcess, ToolWindowActivationProperties $properties, ProfilerState oldState, ProfilerState newState) {
        ProfilerState profilerState;
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (oldState == Attached.INSTANCE && this$0.myActiveSessionsCounter.decrementAndGet() == 0) {
            this$0.updateToolWindowIcon(false);
        }
        if ((profilerState = newState) instanceof ProfilerErrorWithContext) {
            NotificationAction[] notificationActionArray = ((ProfilerErrorWithContext)newState).getActions();
            this$0.showOpenProfilerTabBalloon(CommonProfilerBundleKt.profilerMessage("profiler.state.error", new Object[0]), ((ProfilerErrorWithContext)newState).getReasonHtml(), NotificationType.ERROR, $profilerProcess, Arrays.copyOf(notificationActionArray, notificationActionArray.length));
        } else if (profilerState instanceof ProfilerError) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.escapeXmlEntities((String)((ProfilerError)newState).getReason()), (String)"escapeXmlEntities(...)");
            this$0.showOpenProfilerTabBalloon(null, CommonProfilerBundleKt.profilerMessage("profiler.state.error.0", objectArray) + "<br>", NotificationType.ERROR, $profilerProcess, new NotificationAction[0]);
        } else if (profilerState instanceof DataReady && ((Boolean)$properties.getShowProfilerDataReadyBalloon().invoke()).booleanValue()) {
            this$0.showOpenProfilerTabBalloon(null, CommonProfilerBundleKt.profilerMessage("run.profiler.data.ready", new Object[0]), NotificationType.INFORMATION, $profilerProcess, new NotificationAction[0]);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void addProfilerProcessTab$lambda$7(ProfilerToolWindowManager this$0, ProfilerProcess $profilerProcess, String $tabName, ToolWindowActivationProperties $properties, String $tabDescription) {
        void it;
        ProfilerProcessPanel profilerProcessPanel;
        ProfilerProcessPanel profilerProcessPanel2 = profilerProcessPanel = new ProfilerProcessPanel($profilerProcess, $tabName);
        ProfilerToolWindowManager profilerToolWindowManager = this$0;
        boolean bl = false;
        it.getContent().setDescription($tabDescription);
        profilerToolWindowManager.addTab(profilerProcessPanel, $properties.getActivateToolWindow());
        if ($profilerProcess.getState() == Attached.INSTANCE && this$0.myActiveSessionsCounter.getAndIncrement() == 0) {
            this$0.updateToolWindowIcon(true);
        }
        if ($properties.getShowProfilerAttachedBalloon()) {
            this$0.showOpenProfilerTabBalloon(null, CommonProfilerBundleKt.profilerMessage("run.profiler.attached", new Object[0]), NotificationType.INFORMATION, $profilerProcess, new NotificationAction[0]);
        }
    }

    private static final void updateToolWindowIcon$lambda$8(ProfilerToolWindowManager this$0, Icon $newIcon) {
        this$0.getToolWindow().setIcon($newIcon);
    }

    private static final boolean addTab$lambda$9(Content it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getComponent() instanceof AbstractProfilerToolWindowPanel;
    }

    private static final Unit showBalloon$lambda$11(Notification it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit showBalloon$lambda$12(Notification it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final ProfilerToolWindowManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Project access$getProject$p(ProfilerToolWindowManager $this) {
        return $this.project;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/profiler/ProfilerToolWindowManager$Companion;", "", "<init>", "()V", "TOOLWINDOW_ID", "", "getInstance", "Lcom/intellij/profiler/ProfilerToolWindowManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nProfilerToolWindowManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerToolWindowManager.kt\ncom/intellij/profiler/ProfilerToolWindowManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,340:1\n30#2,2:341\n*S KotlinDebug\n*F\n+ 1 ProfilerToolWindowManager.kt\ncom/intellij/profiler/ProfilerToolWindowManager$Companion\n*L\n261#1:341,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ProfilerToolWindowManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ProfilerToolWindowManager> serviceClass$iv = ProfilerToolWindowManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ProfilerToolWindowManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

