/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextManagerBase;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.EvaluateHack;
import org.jetbrains.wip.NodeWipVm;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipSuspendContext;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.WipWorkerVm;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.WipRequest;
import org.jetbrains.wip.protocol.debugger.CallFrameValue;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.PausedEventData;
import org.jetbrains.wip.protocol.debugger.RestartFrameResult;
import org.jetbrains.wip.protocol.debugger.ResumedEventData;
import org.jetbrains.wip.protocol.overlay.OverlayKt;
import org.jetbrains.wip.protocol.runtime.StackTraceValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0002H\u0014J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001fH\u0016J\u001e\u0010 \u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\b\u0010$\u001a\u0004\u0018\u00010%J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00160\u001bH\u0014J\u0012\u0010'\u001a\u00020\u00162\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\b\u0010*\u001a\u00020\u0016H\u0002J\u001c\u0010+\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u0016012\u0006\u0010,\u001a\u00020-H\u0002J\b\u00102\u001a\u000203H\u0002J\u0014\u00104\u001a\u00020\u00162\n\u00105\u001a\u0006\u0012\u0002\b\u000306H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00067"}, d2={"Lorg/jetbrains/wip/WipSuspendContextManager;", "Lorg/jetbrains/debugger/SuspendContextManagerBase;", "Lorg/jetbrains/wip/WipSuspendContext;", "Lorg/jetbrains/wip/WipCallFrame;", "vm", "Lorg/jetbrains/wip/WipVm;", "<init>", "(Lorg/jetbrains/wip/WipVm;)V", "hasOverlay", "Ljava/util/concurrent/atomic/AtomicBoolean;", "evaluateHack", "Lorg/jetbrains/wip/EvaluateHack;", "getEvaluateHack$intellij_javascript_wip_backend", "()Lorg/jetbrains/wip/EvaluateHack;", "isRestartFrameSupported", "", "()Z", "debugListener", "Lorg/jetbrains/debugger/DebugEventListener;", "getDebugListener", "()Lorg/jetbrains/debugger/DebugEventListener;", "pausedEventDataReceived", "", "it", "Lorg/jetbrains/wip/protocol/debugger/PausedEventData;", "resumedEventDataReceived", "restartFrame", "Lorg/jetbrains/concurrency/Promise;", "callFrame", "currentContext", "canRestartFrame", "Lorg/jetbrains/debugger/CallFrame;", "updateStackTrace", "callFrames", "", "Lorg/jetbrains/wip/protocol/debugger/CallFrameValue;", "asyncStackTrace", "Lorg/jetbrains/wip/protocol/runtime/StackTraceValue;", "doSuspend", "setOverlayMessage", "message", "", "removeOverlay", "continueVm", "stepAction", "Lorg/jetbrains/debugger/StepAction;", "stepCount", "", "sdkStepToProtocolStep", "Lorg/jetbrains/wip/protocol/WipRequest;", "currentContextCommandProcessor", "Lorg/jetbrains/wip/WipCommandProcessor;", "updateContext", "newContext", "Lorg/jetbrains/debugger/SuspendContext;", "intellij.javascript.wip.backend"})
@SourceDebugExtension(value={"SMAP\nWipSuspendContextManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WipSuspendContextManager.kt\norg/jetbrains/wip/WipSuspendContextManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
public class WipSuspendContextManager
extends SuspendContextManagerBase<WipSuspendContext, WipCallFrame> {
    @NotNull
    private final WipVm vm;
    @NotNull
    private final AtomicBoolean hasOverlay;
    @NotNull
    private final EvaluateHack evaluateHack;
    private final boolean isRestartFrameSupported;
    @NotNull
    private final DebugEventListener debugListener;

    public WipSuspendContextManager(@NotNull WipVm vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.hasOverlay = new AtomicBoolean();
        this.evaluateHack = new EvaluateHack(this.vm);
        this.isRestartFrameSupported = true;
        this.debugListener = this.vm.getDebugListener();
        EventMap<ProtocolResponseReader> eventMap = this.vm.getCommandProcessor().getEventMap();
        eventMap.add((EventType)PausedEventData.TYPE, arg_0 -> WipSuspendContextManager._init_$lambda$0(this, arg_0));
        eventMap.add((EventType)ResumedEventData.TYPE, arg_0 -> WipSuspendContextManager._init_$lambda$1(this, arg_0));
    }

    @NotNull
    public final EvaluateHack getEvaluateHack$intellij_javascript_wip_backend() {
        return this.evaluateHack;
    }

    public boolean isRestartFrameSupported() {
        return this.isRestartFrameSupported;
    }

    @NotNull
    protected DebugEventListener getDebugListener() {
        return this.debugListener;
    }

    protected void pausedEventDataReceived(@NotNull PausedEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        WipSuspendContext context = new WipSuspendContext(this.vm, it);
        this.setContext((SuspendContext)context);
        this.vm.getDebugListener().suspended((SuspendContext)context);
    }

    private final void resumedEventDataReceived() {
        if (!(this.vm instanceof WipWorkerVm)) {
            this.removeOverlay();
        }
        SuspendContext suspendContext = this.getContext();
        if (suspendContext != null) {
            SuspendContext it = suspendContext;
            boolean bl = false;
            ValueManager valueManager = it.getValueManager();
            Intrinsics.checkNotNull((Object)valueManager, (String)"null cannot be cast to non-null type org.jetbrains.wip.WipValueManager");
            ((WipValueManager)valueManager).releaseObjects();
        }
        this.dismissContext();
    }

    @NotNull
    protected Promise<Boolean> restartFrame(@NotNull WipCallFrame callFrame, @NotNull WipSuspendContext currentContext) {
        Intrinsics.checkNotNullParameter((Object)callFrame, (String)"callFrame");
        Intrinsics.checkNotNullParameter((Object)((Object)currentContext), (String)"currentContext");
        Promise promise2 = currentContext.getValueManager().getCommandProcessor().send((Request)DebuggerKt.RestartFrame$default(callFrame.getId(), null, 2, null)).thenAsync(arg_0 -> WipSuspendContextManager.restartFrame$lambda$6(arg_0 -> WipSuspendContextManager.restartFrame$lambda$5(currentContext, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"thenAsync(...)");
        return promise2;
    }

    public boolean canRestartFrame(@NotNull CallFrame callFrame) {
        Intrinsics.checkNotNullParameter((Object)callFrame, (String)"callFrame");
        if (!(callFrame instanceof WipCallFrame) || this.vm.getScriptManager().getScript(callFrame) == null) {
            return false;
        }
        Promise<CallFrame[]> framesPromise = ((WipSuspendContext)this.getContextOrFail()).getFrames();
        if (framesPromise.isSucceeded()) {
            Object[] frames = (CallFrame[])framesPromise.blockingGet(0);
            if (frames != null) {
                if (Intrinsics.areEqual((Object)callFrame, (Object)ArraysKt.last((Object[])frames))) {
                    return false;
                }
                int indexOfFrame = ArraysKt.indexOf((Object[])frames, (Object)callFrame);
                if (indexOfFrame + 1 < frames.length && !(frames[indexOfFrame + 1] instanceof WipCallFrame)) {
                    return false;
                }
            }
            if (Intrinsics.areEqual((Object)callFrame, (Object)(frames != null ? (CallFrame)ArraysKt.last((Object[])frames) : null))) {
                return false;
            }
        }
        return true;
    }

    public final void updateStackTrace(@NotNull List<? extends CallFrameValue> callFrames, @Nullable StackTraceValue asyncStackTrace) {
        block0: {
            Intrinsics.checkNotNullParameter(callFrames, (String)"callFrames");
            WipSuspendContext wipSuspendContext = (WipSuspendContext)((Object)this.getContextRef().get());
            if (wipSuspendContext == null) break block0;
            wipSuspendContext.setFrames(callFrames, asyncStackTrace);
        }
    }

    @NotNull
    protected Promise<Unit> doSuspend() {
        return this.currentContextCommandProcessor().send((Request)DebuggerKt.Pause());
    }

    public void setOverlayMessage(@Nullable String message) {
        if (!(this.vm instanceof NodeWipVm) && !(this.vm instanceof WipWorkerVm) && this.hasOverlay.compareAndSet(false, true)) {
            this.vm.getCommandProcessor().send((Request)OverlayKt.SetPausedInDebuggerMessage(message));
        }
    }

    private final void removeOverlay() {
        if (!(this.vm instanceof NodeWipVm) && this.hasOverlay.compareAndSet(true, false)) {
            this.vm.getCommandProcessor().send((Request)OverlayKt.SetPausedInDebuggerMessage(null));
        }
    }

    @NotNull
    public Promise<?> continueVm(@NotNull StepAction stepAction, int stepCount) {
        Intrinsics.checkNotNullParameter((Object)stepAction, (String)"stepAction");
        ((WipSuspendContext)this.getContextOrFail()).getValueManager().markObsolete();
        this.removeOverlay();
        return this.currentContextCommandProcessor().send((Request)this.sdkStepToProtocolStep(stepAction));
    }

    private final WipRequest<Unit> sdkStepToProtocolStep(StepAction stepAction) {
        return switch (WhenMappings.$EnumSwitchMapping$0[stepAction.ordinal()]) {
            case 1 -> DebuggerKt.Resume$default(null, 1, null);
            case 2 -> DebuggerKt.StepInto$default(null, null, 3, null);
            case 3 -> DebuggerKt.StepOut();
            case 4 -> DebuggerKt.StepOver$default(null, 1, null);
            default -> throw new RuntimeException();
        };
    }

    private final WipCommandProcessor currentContextCommandProcessor() {
        Object object = (WipSuspendContext)((Object)this.getContextRef().get());
        if (object == null || (object = object.getValueManager()) == null || (object = ((WipValueManager)((Object)object)).getCommandProcessor()) == null) {
            object = this.vm.getCommandProcessor();
        }
        return object;
    }

    public void updateContext(@NotNull SuspendContext<?> newContext) {
        Intrinsics.checkNotNullParameter(newContext, (String)"newContext");
        if (newContext instanceof WipSuspendContext) {
            this.getContextRef().set(newContext);
        }
    }

    private static final Unit _init_$lambda$0(WipSuspendContextManager this$0, PausedEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.pausedEventDataReceived(it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(WipSuspendContextManager this$0, ResumedEventData it) {
        this$0.resumedEventDataReceived();
        return Unit.INSTANCE;
    }

    private static final Boolean restartFrame$lambda$5$lambda$3(Unit it) {
        return false;
    }

    private static final Boolean restartFrame$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Promise restartFrame$lambda$5(WipSuspendContext $currentContext, RestartFrameResult it) {
        return $currentContext.getValueManager().getCommandProcessor().send((Request)DebuggerKt.StepInto$default(null, null, 3, null)).then(arg_0 -> WipSuspendContextManager.restartFrame$lambda$5$lambda$4(WipSuspendContextManager::restartFrame$lambda$5$lambda$3, arg_0));
    }

    private static final Promise restartFrame$lambda$6(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StepAction.values().length];
            try {
                nArray[StepAction.CONTINUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StepAction.IN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StepAction.OUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StepAction.OVER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

