/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindUtil;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.StatusTextAction;
import com.intellij.find.editorHeaderActions.ToggleMatchCase;
import com.intellij.javascript.debugger.console.HistoryViewNavigator;
import com.intellij.javascript.debugger.console.WebConsoleView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0018\u001a\u00020\u0015H\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u001c\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u001d\u001a\u00020\u001bH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\b\u0010!\u001a\u00020\u001bH\u0016J\b\u0010\"\u001a\u00020\u001bH\u0016J\b\u0010#\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleSearchSession;", "Lcom/intellij/find/SearchSession;", "Lcom/intellij/find/FindModel$FindModelObserver;", "Lcom/intellij/find/SearchReplaceComponent$Listener;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "webConsoleView", "Lcom/intellij/javascript/debugger/console/WebConsoleView;", "historyNavigator", "Lcom/intellij/javascript/debugger/console/HistoryViewNavigator;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/javascript/debugger/console/WebConsoleView;Lcom/intellij/javascript/debugger/console/HistoryViewNavigator;Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "searchComponent", "Lcom/intellij/find/SearchReplaceComponent;", "previousHeaderComponent", "Ljava/awt/Component;", "findModel", "Lcom/intellij/find/FindModel;", "hasMatches", "", "createFindModel", "getFindModel", "findModelChanged", "", "getComponent", "searchForward", "searchBackward", "searchFieldDocumentChanged", "replaceFieldDocumentChanged", "multilineStateChanged", "close", "createSearchComponent", "intellij.javascript.debugger"})
public final class WebConsoleSearchSession
implements SearchSession,
FindModel.FindModelObserver,
SearchReplaceComponent.Listener {
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final WebConsoleView webConsoleView;
    @NotNull
    private final HistoryViewNavigator historyNavigator;
    @NotNull
    private final Project project;
    @NotNull
    private final SearchReplaceComponent searchComponent;
    @Nullable
    private final Component previousHeaderComponent;
    @NotNull
    private final FindModel findModel;
    private boolean hasMatches;

    public WebConsoleSearchSession(@NotNull CoroutineScope coroutineScope, @NotNull WebConsoleView webConsoleView, @NotNull HistoryViewNavigator historyNavigator, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)webConsoleView, (String)"webConsoleView");
        Intrinsics.checkNotNullParameter((Object)historyNavigator, (String)"historyNavigator");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.coroutineScope = coroutineScope;
        this.webConsoleView = webConsoleView;
        this.historyNavigator = historyNavigator;
        this.project = project;
        this.searchComponent = this.createSearchComponent();
        this.previousHeaderComponent = this.webConsoleView.getHeaderComponent$intellij_javascript_debugger();
        this.findModel = this.createFindModel();
        this.webConsoleView.setHeaderComponent$intellij_javascript_debugger((Component)this.searchComponent);
        IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)this.searchComponent.getSearchTextComponent(), false);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final FindModel createFindModel() {
        FindModel findModel = new FindModel();
        FindModel findModel2 = FindManager.getInstance((Project)this.project).getFindInFileModel();
        Intrinsics.checkNotNullExpressionValue((Object)findModel2, (String)"getFindInFileModel(...)");
        findModel.copyFrom(findModel2);
        findModel.addObserver((FindModel.FindModelObserver)this);
        return findModel;
    }

    @NotNull
    public FindModel getFindModel() {
        return this.findModel;
    }

    public void findModelChanged(@NotNull FindModel findModel) {
        Intrinsics.checkNotNullParameter((Object)findModel, (String)"findModel");
        String stringToFind = findModel.getStringToFind();
        boolean incorrectRegex = findModel.isRegularExpressions() && findModel.compileRegExp() == null;
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, findModel, stringToFind, incorrectRegex, null){
            int label;
            final /* synthetic */ WebConsoleSearchSession this$0;
            final /* synthetic */ FindModel $findModel;
            final /* synthetic */ String $stringToFind;
            final /* synthetic */ boolean $incorrectRegex;
            {
                this.this$0 = $receiver;
                this.$findModel = $findModel;
                this.$stringToFind = $stringToFind;
                this.$incorrectRegex = $incorrectRegex;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = WebConsoleSearchSession.access$getHistoryNavigator$p(this.this$0).findText(this.$findModel.getStringToFind(), this.$findModel.isCaseSensitive(), (Continuation<? super Boolean>)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        hasMatches = (Boolean)v0;
                        if (!Intrinsics.areEqual((Object)WebConsoleSearchSession.access$getFindModel$p(this.this$0).getStringToFind(), (Object)this.$stringToFind)) {
                            return Unit.INSTANCE;
                        }
                        WebConsoleSearchSession.access$setHasMatches$p(this.this$0, hasMatches != false);
                        if (this.$incorrectRegex || StringUtil.isNotEmpty((String)this.$stringToFind) && !hasMatches) {
                            WebConsoleSearchSession.access$getSearchComponent$p(this.this$0).setNotFoundBackground();
                        } else {
                            WebConsoleSearchSession.access$getSearchComponent$p(this.this$0).setRegularBackground();
                        }
                        WebConsoleSearchSession.access$getSearchComponent$p(this.this$0).setStatusText(this.$incorrectRegex != false ? FindBundle.message((String)"find.incorrect.regexp", (Object[])new Object[0]) : "");
                        WebConsoleSearchSession.access$getSearchComponent$p(this.this$0).update(this.$stringToFind, "", false, this.$findModel.isMultiline());
                        FindUtil.updateFindInFileModel((Project)this.this$0.getProject(), (FindModel)this.$findModel, (boolean)false);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public SearchReplaceComponent getComponent() {
        return this.searchComponent;
    }

    public boolean hasMatches() {
        return this.hasMatches;
    }

    public void searchForward() {
        ThreadingAssertions.assertEventDispatchThread();
        this.historyNavigator.selectNextFindItem();
    }

    public void searchBackward() {
        ThreadingAssertions.assertEventDispatchThread();
        this.historyNavigator.selectPrevFindItem();
    }

    public void searchFieldDocumentChanged() {
        String textToFind = this.searchComponent.getSearchTextComponent().getText();
        Intrinsics.checkNotNull((Object)textToFind);
        this.findModel.setStringToFind(textToFind);
        this.findModel.setMultiline(StringsKt.contains$default((CharSequence)textToFind, (CharSequence)"\n", (boolean)false, (int)2, null));
    }

    public void replaceFieldDocumentChanged() {
    }

    public void multilineStateChanged() {
    }

    public void close() {
        this.webConsoleView.setHeaderComponent$intellij_javascript_debugger(this.previousHeaderComponent);
        this.webConsoleView.searchSessionStopped$intellij_javascript_debugger();
        IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)this.webConsoleView.getConsoleEditor().getContentComponent(), false);
    }

    private final SearchReplaceComponent createSearchComponent() {
        AnAction[] anActionArray = new AnAction[]{new PrevOccurrenceAction(), new NextOccurrenceAction()};
        SearchReplaceComponent.Builder builder = SearchReplaceComponent.buildFor((Project)this.project, (JComponent)this.webConsoleView.getComponent(), (SearchSession)this).addPrimarySearchActions(anActionArray);
        anActionArray = new AnAction[]{new ToggleMatchCase(), new StatusTextAction()};
        SearchReplaceComponent searchReplaceComponent = builder.addExtraSearchActions(anActionArray).withCloseAction(() -> WebConsoleSearchSession.createSearchComponent$lambda$0(this)).build();
        Intrinsics.checkNotNullExpressionValue((Object)searchReplaceComponent, (String)"build(...)");
        SearchReplaceComponent searchReplaceComponent2 = searchReplaceComponent;
        searchReplaceComponent2.addListener((SearchReplaceComponent.Listener)this);
        return searchReplaceComponent2;
    }

    private static final void createSearchComponent$lambda$0(WebConsoleSearchSession this$0) {
        this$0.close();
    }

    public static final /* synthetic */ HistoryViewNavigator access$getHistoryNavigator$p(WebConsoleSearchSession $this) {
        return $this.historyNavigator;
    }

    public static final /* synthetic */ FindModel access$getFindModel$p(WebConsoleSearchSession $this) {
        return $this.findModel;
    }

    public static final /* synthetic */ void access$setHasMatches$p(WebConsoleSearchSession $this, boolean bl) {
        $this.hasMatches = bl;
    }

    public static final /* synthetic */ SearchReplaceComponent access$getSearchComponent$p(WebConsoleSearchSession $this) {
        return $this.searchComponent;
    }
}

