/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.object;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import java.util.Comparator;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0017J\u0012\u0010\b\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0017J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u001f\u0010\u0015\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001f\u001a\u00020\u0017H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\"H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001f\u001a\u00020$H\u0002J\u0014\u0010%\u001a\u0004\u0018\u00010\u00052\b\u0010&\u001a\u0004\u0018\u00010'H\u0002\u00a8\u0006)"}, d2={"Lorg/intellij/idea/lang/javascript/intention/object/JSSortPropertiesIntention;", "Lorg/intellij/idea/lang/javascript/intention/JSIntention;", "<init>", "()V", "getText", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getFamilyName", "processIntention", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "getSelectionRequirement", "Lorg/intellij/idea/lang/javascript/intention/JSIntention$SelectionRequirement;", "getElementPredicate", "Lcom/intellij/lang/javascript/psi/impl/JSElementPredicate;", "getSortableMembers", "", "Lcom/intellij/lang/javascript/psi/JSElement;", "el", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/lang/javascript/psi/JSElement;", "canSort", "", "members", "([Lcom/intellij/lang/javascript/psi/JSElement;)Z", "getMemberName", "member", "getJsPropName", "prop", "Lcom/intellij/lang/javascript/psi/JSProperty;", "getTsTypeMemberName", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptTypeMember;", "getComputedName", "computedName", "Lcom/intellij/lang/ecmascript6/psi/ES6ComputedName;", "Companion", "intellij.javascript.intentions"})
@SourceDebugExtension(value={"SMAP\nJSSortPropertiesIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSSortPropertiesIntention.kt\norg/intellij/idea/lang/javascript/intention/object/JSSortPropertiesIntention\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,112:1\n6181#2,2:113\n1232#3,2:115\n1255#3,2:117\n1#4:119\n1869#5,2:120\n14#6:122\n*S KotlinDebug\n*F\n+ 1 JSSortPropertiesIntention.kt\norg/intellij/idea/lang/javascript/intention/object/JSSortPropertiesIntention\n*L\n41#1:113,2\n72#1:115,2\n73#1:117,2\n45#1:120,2\n24#1:122\n*E\n"})
public final class JSSortPropertiesIntention
extends JSIntention {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @IntentionName
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = JSIntentionBundle.message("object.sort-properties.display-name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @IntentionFamilyName
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JSIntentionBundle.message("object.sort-properties.family-name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    protected void processIntention(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Object[] sortedProps;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        JSElement[] jSElementArray = this.getSortableMembers(element);
        Intrinsics.checkNotNull((Object)jSElementArray);
        JSElement[] origProps = jSElementArray;
        Object[] objectArray = this.getSortableMembers(element);
        Intrinsics.checkNotNull((Object)objectArray);
        Object[] $this$sortBy$iv = sortedProps = objectArray;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.length > 1) {
            ArraysKt.sortWith((Object[])$this$sortBy$iv, (Comparator)new Comparator(this){
                final /* synthetic */ JSSortPropertiesIntention this$0;
                {
                    this.this$0 = jSSortPropertiesIntention;
                }

                public final int compare(T a, T b) {
                    JSElement it = (JSElement)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)JSSortPropertiesIntention.access$getMemberName(this.this$0, it));
                    it = (JSElement)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)JSSortPropertiesIntention.access$getMemberName(this.this$0, it))));
                }
            });
        }
        PostprocessReformattingAspect.getInstance((Project)project).disablePostprocessFormattingInside(() -> JSSortPropertiesIntention.processIntention$lambda$2(origProps, (JSElement[])sortedProps));
        FormatFixer.create((PsiElement)element, (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat();
    }

    @Override
    @NotNull
    protected JSIntention.SelectionRequirement getSelectionRequirement() {
        return JSIntention.SelectionRequirement.ELEMENT_COVERS_SELECTION;
    }

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        return arg_0 -> JSSortPropertiesIntention.getElementPredicate$lambda$4(this, arg_0);
    }

    private final JSElement[] getSortableMembers(PsiElement el) {
        PsiElement psiElement = el;
        return psiElement instanceof JSObjectLiteralExpression ? (JSElement[])((JSObjectLiteralExpression)el).getProperties() : (psiElement instanceof TypeScriptObjectType ? (JSElement[])((TypeScriptObjectType)el).getTypeMembers() : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canSort(JSElement[] members) {
        boolean bl;
        if (members.length < 2) return false;
        Sequence names = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])members), arg_0 -> JSSortPropertiesIntention.canSort$lambda$5(this, arg_0));
        boolean bl2 = false;
        Sequence $this$all$iv = names;
        boolean $i$f$all = false;
        for (Object element$iv : $this$all$iv) {
            String it = (String)element$iv;
            boolean bl3 = false;
            if (it == null) return false;
            boolean bl4 = true;
            if (bl4) continue;
            return false;
        }
        boolean bl5 = true;
        if (!bl5) return false;
        Sequence $this$any$iv = SequencesKt.zipWithNext((Sequence)names);
        boolean $i$f$any = false;
        Iterator iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            Pair pair = (Pair)element$iv;
            boolean bl6 = false;
            String l = (String)pair.component1();
            String r = (String)pair.component2();
            String string = l;
            Intrinsics.checkNotNull((Object)string);
            String string2 = r;
            Intrinsics.checkNotNull((Object)string2);
            if (string.compareTo(string2) > 0) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final String getMemberName(JSElement member) {
        String string;
        JSElement jSElement = member;
        if (jSElement instanceof JSProperty) {
            string = this.getJsPropName((JSProperty)member);
        } else if (jSElement instanceof TypeScriptTypeMember) {
            string = this.getTsTypeMemberName((TypeScriptTypeMember)member);
        } else {
            LOG.error("Unexpected member: " + member);
            string = null;
        }
        return string;
    }

    private final String getJsPropName(JSProperty prop) {
        return prop.getComputedPropertyName() != null && !(prop instanceof JSFunctionProperty) && !prop.isShorthanded() ? this.getComputedName(prop.getComputedPropertyName()) : prop.getName();
    }

    private final String getTsTypeMemberName(TypeScriptTypeMember member) {
        String string = member.getName();
        if (string == null) {
            JSComputedPropertyNameOwner jSComputedPropertyNameOwner = member instanceof JSComputedPropertyNameOwner ? (JSComputedPropertyNameOwner)member : null;
            if (jSComputedPropertyNameOwner != null) {
                JSComputedPropertyNameOwner it = jSComputedPropertyNameOwner;
                boolean bl = false;
                string = this.getComputedName(it.getComputedPropertyName());
            } else {
                string = null;
            }
        }
        return string;
    }

    private final String getComputedName(ES6ComputedName computedName) {
        if (computedName == null) {
            return null;
        }
        JSExpression expr = computedName.getExpression();
        if (expr instanceof JSLiteralExpression) {
            return ((JSLiteralExpression)expr).getStringValue();
        }
        JSExpression jSExpression = expr;
        return jSExpression != null ? jSExpression.getText() : null;
    }

    private static final void processIntention$lambda$2(JSElement[] $origProps, JSElement[] $sortedProps) {
        Iterable $this$forEach$iv = ArraysKt.zip((Object[])$origProps, (Object[])$sortedProps);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JSElement sortedIt;
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            JSElement origIt = (JSElement)pair.component1();
            if (Intrinsics.areEqual((Object)origIt, (Object)(sortedIt = (JSElement)pair.component2()))) continue;
            origIt.replace((PsiElement)sortedIt);
        }
    }

    private static final boolean getElementPredicate$lambda$4(JSSortPropertiesIntention this$0, PsiElement el) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)el, (String)"el");
        JSElement[] jSElementArray = this$0.getSortableMembers(el);
        if (jSElementArray != null) {
            JSElement[] it = jSElementArray;
            boolean bl2 = false;
            bl = this$0.canSort(it);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final String canSort$lambda$5(JSSortPropertiesIntention this$0, JSElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getMemberName(it);
    }

    public static final /* synthetic */ String access$getMemberName(JSSortPropertiesIntention $this, JSElement member) {
        return $this.getMemberName(member);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JSSortPropertiesIntention.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/intellij/idea/lang/javascript/intention/object/JSSortPropertiesIntention$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.javascript.intentions"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

